/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.botp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseUpAppQfilterUtil;
import kd.fi.er.business.utils.RelatApplyBillFilterUtil;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class ErDailyReimUpBillMobPlugin
extends AbstractMobFormPlugin
implements MobileSearchTextChangeListener {
    private static Log log = LogFactory.getLog(ErDailyReimUpBillMobPlugin.class);
    private static final String ENTRY = "entryentity";

    public void initialize() {
        super.initialize();
        MobileSearch mobileSearch = (MobileSearch)this.getView().getControl("mobilesearchap");
        mobileSearch.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("writeofftype", map.get("writeofftype"));
        this.search(null);
    }

    private void search(String search) {
        String[] parentView;
        Long costCompanyId;
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String sourceEntitys = (String)map.get("drawSourceEntity");
        if (StringUtils.isEmpty((CharSequence)sourceEntitys)) {
            return;
        }
        Long start = System.currentTimeMillis();
        ArrayList bills = Lists.newArrayListWithExpectedSize((int)8);
        Long l = costCompanyId = map.get("costCompanyId") == null ? null : Long.valueOf(Long.parseLong(map.get("costCompanyId").toString()));
        if (costCompanyId == null && (parentView = this.getView().getParentView()) != null && parentView.getModel().getProperty("costcompany") != null) {
            DynamicObject costcompany = (DynamicObject)parentView.getModel().getValue("costcompany");
            costCompanyId = costcompany == null ? null : (Long)costcompany.getPkValue();
        }
        for (String sourceEntity : sourceEntitys.split(",")) {
            bills.addAll(this.listExpense(map.get("applierId") == null ? null : Long.valueOf(Long.parseLong(map.get("applierId").toString())), map.get("orgId") == null ? null : Long.valueOf(Long.parseLong(map.get("orgId").toString())), map.get("companyId") == null ? null : Long.valueOf(Long.parseLong(map.get("companyId").toString())), costCompanyId, (List)map.get("ids"), search, map.get("currency") == null ? null : Long.valueOf(Long.parseLong(map.get("currency").toString())), sourceEntity));
        }
        int size = this.getModel().getEntryEntity(ENTRY).size();
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            list.add(i);
        }
        if (list.size() > 0) {
            this.getModel().deleteEntryRows(ENTRY, list.stream().mapToInt(Integer::intValue).toArray());
        }
        if (bills == null || bills.isEmpty()) {
            return;
        }
        int[] rowIndexs = this.getModel().batchCreateNewEntryRow(ENTRY, bills.size());
        for (int i = 0; i < rowIndexs.length; ++i) {
            Map row = (Map)bills.get(i);
            for (Map.Entry entry : row.entrySet()) {
                if (this.getModel().getProperty((String)entry.getKey()) == null) continue;
                this.getModel().setValue((String)entry.getKey(), entry.getValue(), i);
            }
        }
        log.info("listExpense\u67e5\u8be2\u8017\u65f6\uff1a " + (System.currentTimeMillis() - start));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"cancel", "confrim", "cardentryflex_content", "cardentryflex_description"});
    }

    protected void selectedSameBill(EventObject evt) {
        Map map = this.getView().getFormShowParameter().getCustomParams();
        String sourceEntitys = (String)map.get("drawSourceEntity");
        if (StringUtils.isNotBlank((CharSequence)sourceEntitys) && sourceEntitys.contains("er_dailyapplybill")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == this.getModel().getEntryRowCount(ENTRY) || selectRows.length == 0) {
                return;
            }
            HashSet<Integer> selectedList = new HashSet<Integer>(selectRows.length);
            for (int i : selectRows) {
                selectedList.add(i);
            }
            int entryRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            Object billid = this.getModel().getValue("billid", entryRow);
            if (billid != null) {
                Boolean selected = Boolean.FALSE;
                for (int index : selectRows) {
                    if (entryRow != index) continue;
                    selected = Boolean.TRUE;
                    break;
                }
                DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY);
                for (int i = 0; i < entryEntity.size(); ++i) {
                    if (!StringUtils.equals((CharSequence)billid.toString(), (CharSequence)((DynamicObject)entryEntity.get(i)).getString("billid"))) continue;
                    if (selected.booleanValue()) {
                        selectedList.add(i);
                        continue;
                    }
                    selectedList.remove(i);
                }
            }
            entryGrid.selectRows(selectedList.stream().mapToInt(Integer::intValue).toArray(), entryRow);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control menuItem = (Control)evt.getSource();
        switch (key = menuItem.getKey()) {
            case "confrim": {
                Map map = this.getView().getFormShowParameter().getCustomParams();
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY);
                DynamicObjectCollection collection = this.getModel().getEntryEntity(ENTRY);
                int[] rowIndexs = entryGrid.getSelectRows();
                ListSelectedRowCollection listSelectedRowCollection = new ListSelectedRowCollection();
                int index = 0;
                String sourceEntitys = (String)map.get("drawSourceEntity");
                boolean multiSource = false;
                HashMap resultMap = Maps.newHashMapWithExpectedSize((int)0);
                if (sourceEntitys.contains(",")) {
                    multiSource = true;
                    resultMap = Maps.newHashMapWithExpectedSize((int)sourceEntitys.split(",").length);
                }
                for (int i : rowIndexs) {
                    ListSelectedRow listSelectedRow = new ListSelectedRow(((DynamicObject)collection.get(i)).get("billid"), Boolean.TRUE);
                    listSelectedRow.setBillNo((String)((DynamicObject)collection.get(i)).get("billno"));
                    listSelectedRow.setEntryPrimaryKeyValue(((DynamicObject)collection.get(i)).get("entryid"));
                    listSelectedRow.setEntryEntityKey(((DynamicObject)collection.get(i)).getString("entrykey"));
                    listSelectedRow.setPageIndex(0);
                    listSelectedRow.setRowKey(index++);
                    listSelectedRow.setFormID(sourceEntitys);
                    listSelectedRowCollection.add((Object)listSelectedRow);
                    if (!multiSource) continue;
                    String formid = (String)((DynamicObject)collection.get(i)).get("srcbilltype");
                    ListSelectedRowCollection coll = (ListSelectedRowCollection)resultMap.get(formid);
                    if (coll == null) {
                        coll = new ListSelectedRowCollection();
                        resultMap.put(formid, coll);
                    }
                    coll.add((Object)listSelectedRow);
                }
                Map<Long, List<ListSelectedRow>> showDataMapSource = listSelectedRowCollection.stream().collect(Collectors.groupingBy(e -> ErCommonUtils.getPk((Object)e.getPrimaryKeyValue())));
                Set billNos = BotpDrawServiceUtil.removeExistDownLoanBill(showDataMapSource, (boolean)true);
                if (billNos.size() > 0) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5173\u8054\u6709\u501f\u6b3e\uff0c\u8bf7\u4ece\u5bf9\u5e94\u501f\u6b3e\u5355\u4e0b\u63a8\u3002", (String)"ErDailyReimUpBillMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), billNos.toString()));
                    return;
                }
                if (multiSource) {
                    this.getView().returnDataToParent((Object)resultMap);
                } else {
                    this.getView().returnDataToParent((Object)listSelectedRowCollection);
                }
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
                break;
            }
            case "cardentryflex_content": 
            case "cardentryflex_description": {
                break;
            }
        }
    }

    private List<Map<String, Object>> listExpense(Long applierId, Long orgId, Long companyId, Long costcompanyId, List existIds, String search, Long currency, String sourceEntity) {
        DynamicObjectCollection dynamicObjects;
        QueryDataService queryData = new QueryDataService(sourceEntity);
        String sql = queryData.getSql();
        List<QFilter> drawCustQFilters = queryData.getDrawFilters(this.getView(), applierId, orgId, companyId, costcompanyId, sourceEntity);
        if (currency != null) {
            drawCustQFilters.add(new QFilter("currency", "=", (Object)currency));
        }
        if (StringUtils.isNotEmpty((CharSequence)search)) {
            ArrayList searchQFilterList = Lists.newArrayListWithExpectedSize((int)2);
            String sea = '%' + search + '%';
            searchQFilterList.add(new QFilter("company.name", "like", (Object)sea));
            searchQFilterList.add(new QFilter("applier.name", "like", (Object)sea));
            searchQFilterList.add(new QFilter("billno", "like", (Object)sea));
            searchQFilterList.add(new QFilter("description", "like", (Object)sea));
            QFilter searchQFilter = (QFilter)searchQFilterList.get(0);
            searchQFilterList.remove(searchQFilter);
            for (int i = 0; i < searchQFilterList.size(); ++i) {
                searchQFilter.or((QFilter)searchQFilterList.get(i));
            }
            drawCustQFilters.add(searchQFilter);
        }
        if (ErEntityTypeUtils.isDailyApplyBill((String)sourceEntity)) {
            String reimbursetype = this.getView().getParentView().getModel().getProperty("reimbursetype") != null ? (String)this.getView().getParentView().getModel().getValue("reimbursetype") : " ";
            QFilter reimbursetypeQfilter = null;
            reimbursetypeQfilter = "expense".equals(reimbursetype) || " ".equals(reimbursetype) || "asset".equals(reimbursetype) || reimbursetype == null ? new QFilter("reimbursetype", "=", (Object)"expense").or("reimbursetype", "=", (Object)" ").or("reimbursetype", "=", (Object)"otherexpenses").or("reimbursetype", "=", null) : new QFilter("reimbursetype", "=", (Object)reimbursetype);
            ReimburseUpAppQfilterUtil.setBizitemFilter((IDataModel)this.getModel(), null, (QFilter)reimbursetypeQfilter);
            drawCustQFilters.add(reimbursetypeQfilter);
        }
        if ((dynamicObjects = QueryServiceHelper.query((String)sourceEntity, (String)sql, (QFilter[])drawCustQFilters.toArray(new QFilter[0]), null, (int)1000)).isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        Map<Long, List<DynamicObject>> mapList = dynamicObjects.stream().collect(Collectors.groupingBy(e -> e.getLong("id")));
        BotpDrawServiceUtil.removeExistDownLoanBill(mapList, (boolean)false);
        ArrayList dynamicObjectList = new ArrayList();
        mapList.values().forEach(e -> dynamicObjectList.addAll(e));
        return queryData.mapValueFromData(dynamicObjectList, existIds, sourceEntity);
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        this.search(mobileSearchTextChangeEvent.getText());
    }

    private static class QueryDataService {
        private String sourceEntity;

        public QueryDataService(String sourceEntity) {
            this.sourceEntity = sourceEntity;
        }

        public List<QFilter> getDrawFilters(IFormView view, Long applierId, Long orgId, Long companyId, Long costcompanyId, String sourceEntity) {
            ArrayList drawCustQFilters = Lists.newArrayListWithExpectedSize((int)4);
            if (sourceEntity.equalsIgnoreCase("er_tripreqbill")) {
                drawCustQFilters.add(new QFilter("billstatus", "=", (Object)"G"));
                drawCustQFilters.add(new QFilter("tripentry.oriaccbalanceamount", "<>", (Object)0));
                drawCustQFilters.add(this.getParamFilter(applierId, companyId, costcompanyId, orgId));
            }
            if (sourceEntity.equalsIgnoreCase("er_dailyloanbill")) {
                String detailtype;
                IDataModel pModel;
                IFormView parentView;
                drawCustQFilters.add(new QFilter("billstatus", "=", (Object)"G"));
                drawCustQFilters.add(new QFilter("expenseentryentity.orgiexpebalanceamount", "<>", (Object)0));
                drawCustQFilters.add(this.getParamFilter(applierId, companyId, costcompanyId, orgId));
                String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
                if ("2".equals(applyprojectbillRelated) && (parentView = view.getParentView()) != null && (pModel = parentView.getModel()) != null && ErEntityTypeUtils.isPublicReimburseBill((String)parentView.getEntityId()) && "biztype_project".equals(detailtype = (String)pModel.getValue("detailtype"))) {
                    DynamicObjectCollection expenseEntrys = pModel.getEntryEntity("expenseentryentity");
                    Set projectNoList = expenseEntrys.stream().map(exp -> exp.getString("entryprojectno")).collect(Collectors.toSet());
                    drawCustQFilters.add(new QFilter("expenseentryentity.applyprojectno", "in", projectNoList));
                }
            }
            if (sourceEntity.equalsIgnoreCase("er_dailyapplybill")) {
                drawCustQFilters.add(RelatApplyBillFilterUtil.getCondition((Long)applierId, (Long)orgId, (Long)companyId));
            }
            return drawCustQFilters;
        }

        private QFilter getParamFilter(Object companyID, Object costCompany) {
            Long comId = companyID instanceof Integer ? Long.valueOf(((Integer)companyID).longValue()) : (Long)companyID;
            String range = SystemParamterUtil.getLoanDrawRange((Long)comId);
            if (range.equals("0")) {
                return new QFilter("company", "=", (Object)comId);
            }
            return new QFilter("costcompany", "=", costCompany);
        }

        private QFilter getParamFilter(Object applierId, Object companyID, Object costCompany, Object orgID) {
            Long comId = companyID instanceof Integer ? Long.valueOf(((Integer)companyID).longValue()) : (Long)companyID;
            String range = SystemParamterUtil.getLoanDrawRange((Long)comId);
            if (range.equals("0")) {
                return new QFilter("company", "=", (Object)comId).and(new QFilter("applier", "=", applierId).or(new QFilter("projectower.FBASEDATAID_id", "in", applierId)));
            }
            if (range.equals("1")) {
                return new QFilter("costcompany", "=", costCompany).and(new QFilter("applier", "=", applierId).or(new QFilter("projectower.FBASEDATAID_id", "in", applierId)));
            }
            return new QFilter("org", "=", orgID);
        }

        public String getSql() {
            if (this.isTripLoanBill()) {
                return "id,billno,applier.name,currency,description,'tripentry' as  entrykey,tripentry.id,tripentry.tripexpenseitem.fullname,tripentry.tripcurrency,tripentry.tripexchangerate,tripentry.oriaccbalanceamount,tripentry.accbalanceamount,tripentry.entrycostcompany.name,tripentry.entrycostdept.name,tripentry.startdate";
            }
            return "id,bizdate, billno, applier.name, currency, description, 'expenseentryentity' as entrykey,expenseentryentity.id, expenseentryentity.expenseitem.fullname,expenseentryentity.entrycurrency, expenseentryentity.exchangerate, expenseentryentity.orgiexpebalanceamount, expenseentryentity.expebalanceamount, expenseentryentity.entrycostcompany.name, expenseentryentity.entrycostdept.name, expenseentryentity.happendate,expenseentryentity.entrycostcompany, expenseentryentity.entrycostdept, expenseentryentity.std_entrycostcenter";
        }

        private boolean isTripLoanBill() {
            return ErEntityTypeUtils.isTripReqBill((String)this.sourceEntity);
        }

        private List<Map<String, Object>> mapValueFromData(List<DynamicObject> dynamicObjectList, List existIds, String sourceEntity) {
            char split = '/';
            ArrayList list = Lists.newArrayListWithExpectedSize((int)dynamicObjectList.size());
            boolean isTripLoan = this.isTripLoanBill();
            for (DynamicObject d : dynamicObjectList) {
                String entryKey = d.getString("entrykey");
                Object pkValue = this.getEntryValue(entryKey, d, "id");
                if (existIds != null && existIds.size() > 0 && new HashSet(existIds).contains(pkValue)) continue;
                HashMap map = Maps.newHashMapWithExpectedSize((int)16);
                map.put("billid", d.get("id"));
                map.put("billno", d.get("billno"));
                map.put("description", d.get("description"));
                map.put("currency", d.get("currency"));
                map.put("entryid", pkValue);
                map.put("entrykey", entryKey);
                map.put("appliername", d.get("applier.name"));
                map.put("orgname", this.getEntryValue(entryKey, d, "entrycostdept.name"));
                map.put("companyname", this.getEntryValue(entryKey, d, "entrycostcompany.name"));
                map.put("srcbilltype", sourceEntity);
                if (isTripLoan) {
                    map.put("expebalanceamount", this.getEntryValue(entryKey, d, "accbalanceamount"));
                    map.put("orgiexpebalanceamount", this.getEntryValue(entryKey, d, "oriaccbalanceamount"));
                    map.put("entrycurrency", this.getEntryValue(entryKey, d, "tripcurrency"));
                    map.put("happendate", this.getEntryValue(entryKey, d, "startdate"));
                    map.put("expenseitemname", this.getEntryValue(entryKey, d, "tripexpenseitem.fullname"));
                } else {
                    map.put("expebalanceamount", this.getEntryValue(entryKey, d, "expebalanceamount"));
                    map.put("orgiexpebalanceamount", this.getEntryValue(entryKey, d, "orgiexpebalanceamount"));
                    map.put("entrycurrency", this.getEntryValue(entryKey, d, "entrycurrency"));
                    map.put("happendate", this.getEntryValue(entryKey, d, "happendate") == null ? d.get("bizdate") : this.getEntryValue(entryKey, d, "happendate"));
                    map.put("expenseitemname", this.getEntryValue(entryKey, d, "expenseitem.fullname"));
                    map.put("entrycostcompany", this.getEntryValue(entryKey, d, "entrycostcompany"));
                    map.put("entrycostdept", this.getEntryValue(entryKey, d, "entrycostdept"));
                    map.put("std_entrycostcenter", this.getEntryValue(entryKey, d, "std_entrycostcenter"));
                }
                String a = d.getString("applier.name");
                String b = (String)this.getEntryValue(entryKey, d, "entrycostdept.name");
                String c = (String)this.getEntryValue(entryKey, d, "entrycostcompany.name");
                StringBuilder sb = new StringBuilder();
                if (StringUtils.isNotEmpty((CharSequence)a)) {
                    sb.append(a).append(split);
                }
                if (StringUtils.isNotEmpty((CharSequence)b)) {
                    sb.append(b).append(split);
                }
                sb.append(c);
                if (sb.charAt(sb.length() - 1) == split) {
                    map.put("applierinfo", sb.substring(0, sb.length() - 1));
                } else {
                    map.put("applierinfo", sb.toString());
                }
                list.add(map);
            }
            return list;
        }

        private Object getEntryValue(String entryKey, DynamicObject d, String field) {
            return d.get(String.format("%1s.%2s", entryKey, field));
        }
    }
}

