/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mob;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.web.tripstandard.util.TripStandardUtils;

public class ErMyTripStdDetailMobPlugin
extends AbstractMobFormPlugin {
    public void afterCreateNewData(EventObject e) {
        Long tripAreaId = (Long)this.getView().getFormShowParameter().getCustomParam("tripareaid");
        if (tripAreaId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u63a5\u6536\u5230\u7236\u9875\u9762\u7684\u51fa\u5dee\u5730\u57dfID\u3002", (String)"ErMyTripStdDetailMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        Long companyId = TripStandardUtils.getCurrentUserCompanyId();
        if (companyId == null) {
            return;
        }
        List tripStdEntrys = tripStdService.getTripStdEntryByUserIdAndCompanyId(userId, companyId);
        boolean isOpenHighSeason = SystemParamterUtil.isEnableHighSeasonTripStandard((Long)companyId);
        tripStdEntrys.stream().filter(tripStdEntry -> Objects.equals(tripStdEntry.getDynamicObject("triparea").getPkValue(), tripAreaId)).forEach(tripStdEntry -> {
            this.createEntry((DynamicObject)tripStdEntry, false);
            if (isOpenHighSeason) {
                this.createEntry((DynamicObject)tripStdEntry, true);
            }
        });
    }

    private void createEntry(DynamicObject tripStdEntry, boolean highSeason) {
        if (highSeason && tripStdEntry.getBigDecimal("highseasonstandardamount").compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        int rowIndex = this.getModel().createNewEntryRow("entryentity");
        this.getModel().setValue("tripstandardtype", (Object)tripStdEntry.getDynamicObject("tripstandardtype"), rowIndex);
        this.getModel().setValue("standardamount", tripStdEntry.get("standardamount"), rowIndex);
        DynamicObject currency = tripStdEntry.getDynamicObject("currency");
        this.getModel().setValue("currency", currency == null ? null : currency.getPkValue(), rowIndex);
        if (highSeason) {
            this.getModel().setValue("standardamount", tripStdEntry.get("highseasonstandardamount"), rowIndex);
            this.getModel().setValue("checkboxfield", (Object)"1", rowIndex);
        }
    }
}

