/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mob;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import org.apache.commons.lang3.StringUtils;

public class PublicReimBankAccountSelectPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static String ACCOUNTENTRYENTITY = "accountentryentity";
    private static String DEFAULTFLEXPANELAP = "defaultflexpanelap";
    private static String VIEW_BANK = "bebank";
    private static String VIEW_ACCOUNT = "account";
    private static String VIEW_BANKNAME = "accountname";
    private static String VIEW_CURRENCY = "currency";
    private static String VIEW_ISDEFAULT = "isdefault";
    private static String BANKNAME_LABEL = "bankname_label";
    private static String ACCOUNT_LABEL = "account_label";

    public void registerListener(EventObject e) {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ACCOUNTENTRYENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String payerType = (String)formShowParameter.getCustomParam("payerType");
        Object payerId = formShowParameter.getCustomParam("payerId");
        this.setThisViweAmountInfo(payerType, payerId);
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(ACCOUNTENTRYENTITY)) {
            AccountInfo accountInfo = this.loadAccountInfo(rowIndex);
            Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.accountInfoRowClick", "accountInfoRowClick", new Object[]{rowIndex, this.getModel()}, new Class[]{Integer.class, IDataModel.class});
            if (accountInfo != null && invokeExtService != null && !"-1".equals(invokeExtService)) {
                accountInfo.setExtMap((Map)invokeExtService);
            }
            this.getView().returnDataToParent((Object)accountInfo);
            this.getView().close();
        }
    }

    private void setThisViweAmountInfo(String payerType, Object payerId) {
        if (payerId == null || StringUtils.isEmpty((CharSequence)payerType)) {
            return;
        }
        Object invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.accountSelectMob", "accountSelectMob", new Object[]{this.getView(), payerType, Long.valueOf(String.valueOf(payerId))}, new Class[]{IFormView.class, String.class, Long.class});
        if (invokeExtService != null && !"-1".equals(invokeExtService)) {
            return;
        }
        List<AccountInfo> accountInfos = this.getAmountInfo(payerType, payerId);
        if (accountInfos == null || accountInfos.size() == 0) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEFAULTFLEXPANELAP});
        this.getModel().batchCreateNewEntryRow(ACCOUNTENTRYENTITY, accountInfos.size());
        for (int i = 0; i < accountInfos.size(); ++i) {
            this.fillAccountInfo(accountInfos.get(i), i);
        }
    }

    protected List<AccountInfo> getAmountInfo(String payerType, Object payerId) {
        return PublicReimbursePayerAcctUtils.getAccountInfoByPayerId((String)payerType, (Long)Long.valueOf(String.valueOf(payerId)));
    }

    private void fillAccountInfo(AccountInfo accountInfo, Integer rowIndex) {
        IDataModel model = this.getModel();
        String accountName = accountInfo.getAccountName();
        String account = accountInfo.getAccount();
        model.setValue(VIEW_BANK, accountInfo.getBeBank(), rowIndex.intValue());
        model.setValue(VIEW_BANKNAME, (Object)accountName, rowIndex.intValue());
        model.setValue(VIEW_ACCOUNT, (Object)account, rowIndex.intValue());
        model.setValue(VIEW_ISDEFAULT, (Object)accountInfo.isDefault(), rowIndex.intValue());
        model.setValue(VIEW_BANK, accountInfo.getBeBank(), rowIndex.intValue());
        model.setValue(VIEW_CURRENCY, accountInfo.getCurrency(), rowIndex.intValue());
        model.setValue(BANKNAME_LABEL, (Object)accountName, rowIndex.intValue());
        model.setValue(ACCOUNT_LABEL, (Object)PublicReimbursePayerAcctUtils.getHideMidPayerAccount((String)account), rowIndex.intValue());
    }

    private AccountInfo loadAccountInfo(int rowIndex) {
        if (rowIndex < 0) {
            return null;
        }
        AccountInfo accountInfo = new AccountInfo();
        IDataModel model = this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long payerId = (Long)formShowParameter.getCustomParam("payeraccount");
        accountInfo.setPayerId((Object)payerId);
        accountInfo.setAccount((String)model.getValue(VIEW_ACCOUNT, rowIndex));
        accountInfo.setAccountName((String)model.getValue(VIEW_BANKNAME, rowIndex));
        accountInfo.setBeBank(model.getValue(VIEW_BANK, rowIndex));
        accountInfo.setCurrency(model.getValue(VIEW_CURRENCY, rowIndex));
        accountInfo.setDefault(((Boolean)model.getValue(VIEW_ISDEFAULT, rowIndex)).booleanValue());
        return accountInfo;
    }
}

