/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.daily.web.DailyReimburseBillSetReimCtlDeptPlugin;

public class DailyReimburseBillSetReimCtlDeptSecondMobPlugin
extends DailyReimburseBillSetReimCtlDeptPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit control = (BasedataEdit)this.getControl("reimburser");
        if (control != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((control = (BasedataEdit)this.getControl("pubreimburser")) != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter qFilter;
        if (("reimburser".equals(beforeF7SelectEvent.getProperty().getName()) || "pubreimburser".equals(beforeF7SelectEvent.getProperty().getName())) && (qFilter = this.getReimburserRang()) != null) {
            ListShowParameter listShowParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParam.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private QFilter getSubOrgWithExcludePatternFilter(Long orgId) {
        if (orgId == null || orgId == 0L) {
            return null;
        }
        List<String> excludePattren = Arrays.asList("1", "2");
        List allOrgList = OrgUnitServiceHelper.getSubOrgLimitLevel(Collections.singletonList(orgId), (int)1, (boolean)true);
        Map allOrgMap = BusinessDataServiceHelper.loadFromCache((Object[])allOrgList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
        Set allOrgNotInexcludePattern = allOrgMap.values().stream().filter(org -> !excludePattren.contains(org.getDynamicObject("orgpattern").getString("patterntype"))).map(ErCommonUtils::getPk).collect(Collectors.toSet());
        allOrgNotInexcludePattern.add(orgId);
        return new QFilter("entryentity.dpt.masterid", "in", allOrgNotInexcludePattern);
    }

    private QFilter getReimburserRang() {
        QFilter filter = null;
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        int multiReimburser = 0;
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company != null) {
            multiReimburser = SystemParamterUtil.getScopeOfMultiReimburserNew((Long)ErCommonUtils.getPk((Object)company));
        }
        switch (multiReimburser) {
            case 1: {
                company = (DynamicObject)parentView.getModel().getValue("company");
                if (company == null) {
                    return null;
                }
                List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(Long.valueOf(company.get("masterid").toString())), (boolean)true);
                filter = new QFilter("entryentity.dpt.masterid", "in", (Object)allOrgList);
                break;
            }
            case 3: {
                company = (DynamicObject)parentView.getModel().getValue("company");
                if (company == null) {
                    return null;
                }
                filter = this.getSubOrgWithExcludePatternFilter(ErCommonUtils.getPk((Object)company));
                break;
            }
            case 2: {
                List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(OrgUnitServiceHelper.getRootOrgId()), (boolean)true);
                filter = new QFilter("entryentity.dpt.masterid", "in", (Object)allOrgList);
                break;
            }
            case 4: {
                DynamicObject dept = (DynamicObject)parentView.getModel().getValue("org");
                if (dept == null) {
                    return null;
                }
                filter = this.getSubOrgWithExcludePatternFilter(ErCommonUtils.getPk((Object)dept));
                break;
            }
            default: {
                DynamicObject dept = (DynamicObject)parentView.getModel().getValue("org");
                if (dept == null) {
                    return null;
                }
                filter = QFilter.of((String)"entryentity.dpt.masterid=?", (Object[])new Object[]{dept.get("masterid")});
            }
        }
        return filter;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("company", (Object)this.getCompanyId());
        super.afterCreateNewData(e);
    }

    @Override
    public void afterBindData(EventObject e) {
        this.getModel().setValue("company", (Object)this.getCompanyId());
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object isMultiReimburser = formShowParameter.getCustomParam("ismultireimburser");
        if (isMultiReimburser != null) {
            this.getModel().setValue("ismultireimburser", isMultiReimburser);
        }
        super.afterBindData(e);
    }

    private Long getCompanyId() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && parentView.getModel().getProperty("company") != null) {
            Object companyDO = parentView.getModel().getValue("company");
            return ErCommonUtils.getPk((Object)companyDO);
        }
        return null;
    }
}

