/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.common;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.orm.ORM;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.field.writeoffmoney.PrePayContractWriteOffFields;
import kd.fi.er.common.field.writeoffmoney.PublicContractWriteOffFields;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.common.ReceiveEntryMobPlugin;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.util.TempEncashAmountUtils;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.daily.web.workflow.ErMobWorkFlowOtherViewEditUtils;
import kd.fi.er.formplugin.mobile.ErReimburseUpRequestMobPlugin;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseEntryMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static Log logger = LogFactory.getLog(ExpenseEntryMobPlugin.class);
    private static final String LOAN_EXPENSE_FORM = "er_loan_expense_entry";
    private static final String APPLY_EXPENSE_FORM = "er_apply_expense_entry";
    private static final String REIMBURSE_EXPENSE_FORM = "er_reimburse_expense_mb";
    private static final String PREPAY_EXPENSE_FORM = "er_prepay_expense_entry";
    private static final String APPLY_PROJECT_FORM = "er_apply_project_entry";
    private static final String ER_PUB_REIM_ASSETENTRY_MB = "er_pub_reim_assetentry_mb";
    private static final List<String> EXPENSE_FORM = Lists.newArrayList((Object[])new String[]{"er_loan_expense_entry", "er_apply_expense_entry", "er_reimburse_expense_mb", "er_pub_reim_expense_mb", "er_prepay_expense_entry", "er_apply_project_entry"});
    private static final List<String> EXPENSE_ADD_BTN = Lists.newArrayList((Object[])new String[]{"btn_expense_add", "btn_next_add_expense"});
    private static boolean showExpenseInfo = true;
    private boolean showAssetEntry = true;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_expense_add", "btn_next_add_expense", "label_expense_delete", "label_expense_done", "btn_add_invoice"});
        this.addClickListeners(new String[]{"expenseflex", "flex_arow", "btn_asset_add", "label_asset_delete", "label_asset_done"});
        AbstractGrid expenseGrid = (AbstractGrid)this.getView().getControl("expenseentryentity");
        expenseGrid.addRowClickListener((RowClickEventListener)this);
        AbstractGrid assetentry = (AbstractGrid)this.getView().getControl("assetentry");
        if (assetentry != null) {
            assetentry.addRowClickListener((RowClickEventListener)this);
        }
        BasedataEdit expItem = (BasedataEdit)this.getControl("expenseitem");
        expItem.addBeforeF7SelectListener(args -> args.setCancel(true));
    }

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        if (this.getModel().getEntryRowCount("expenseentryentity") > 0) {
            this.getModel().deleteEntryRow("expenseentryentity", 0);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
        String delete = this.getPageCache().get("label_asset_delete");
        if (StringUtils.isEmpty((CharSequence)delete)) {
            this.assetEntrySetVisible(true, false);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (this.getModel().getValue("company") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ExpenseEntryMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!ErEntityTypeUtils.isReimCtlApplyBill((String)this.getView().getEntityId()) && this.getModel().getValue("costcompany") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ExpenseEntryMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
        if (EXPENSE_ADD_BTN.contains(key)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            if (currency == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExpenseEntryMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String formid = "";
            if (ErEntityTypeUtils.isDailyApplyBill((String)entityName)) {
                formid = APPLY_EXPENSE_FORM;
            } else if (ErEntityTypeUtils.isDailyLoanBill((String)entityName)) {
                formid = LOAN_EXPENSE_FORM;
            } else if (ErEntityTypeUtils.isDailyReimburseBill((String)entityName)) {
                formid = REIMBURSE_EXPENSE_FORM;
            } else if (ErEntityTypeUtils.isPublicReimburseBill((String)entityName)) {
                formid = "er_pub_reim_expense_mb";
            } else if (ErEntityTypeUtils.isPrePayBill((String)entityName)) {
                formid = PREPAY_EXPENSE_FORM;
            } else if (ErEntityTypeUtils.isReimCtlApplyBill((String)entityName)) {
                formid = "er_reimctl_apply_entry";
            } else if (ErEntityTypeUtils.isApplyProjectBill((String)entityName)) {
                formid = APPLY_PROJECT_FORM;
            }
            this.addExpenseByHand(formid);
        } else if ("label_expense_delete".equals(key)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"label_expense_delete"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"label_expense_done"});
            for (int rowIndex = 0; rowIndex < this.getModel().getEntryRowCount("expenseentryentity"); ++rowIndex) {
                this.getModel().setValue("mobiledeldoneflag", (Object)1, rowIndex);
            }
        } else if ("label_expense_done".equals(key)) {
            this.doneVisible();
        } else if (StringUtils.equals((CharSequence)"expenseflex", (CharSequence)key) || StringUtils.equals((CharSequence)"flex_arow", (CharSequence)key)) {
            showExpenseInfo = !showExpenseInfo;
            this.getView().setVisible(Boolean.valueOf(showExpenseInfo), new String[]{"expenseentryentity"});
        } else if (StringUtils.equals((CharSequence)"btn_asset_add", (CharSequence)key)) {
            this.addExpenseByHand(ER_PUB_REIM_ASSETENTRY_MB);
        } else if ("label_asset_delete".equals(key)) {
            this.assetEntrySetVisible(false, true);
        } else if ("label_asset_done".equals(key)) {
            this.getPageCache().remove("label_asset_delete");
            this.assetEntrySetVisible(true, false);
        } else if ("flex_arow_asset".equals(key)) {
            this.showAssetEntry = !this.showAssetEntry;
            this.getView().setVisible(Boolean.valueOf(this.showAssetEntry), new String[]{"assetentry"});
        }
    }

    protected void addExpenseByHand(String formid) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u672c\u4f4d\u5e01\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExpenseEntryMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("iscurrency", this.getModel().getValue("iscurrency"));
        param.put("currency", currency.getPkValue().toString());
        DynamicObject costCompany = (DynamicObject)this.getModel().getValue("costcompany");
        if (costCompany != null) {
            param.put("costcompany", ErCommonUtils.getPk((Object)costCompany));
        }
        param.put("isquerybudget", (Boolean)this.getModel().getValue("isquerybudget"));
        if (ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
            param.put("ismultireimburser", (Boolean)this.getModel().getValue("ismultireimburser"));
        }
        String formName = "";
        formName = APPLY_PROJECT_FORM.equals(formid) ? ResManager.loadKDString((String)"\u7acb\u9879\u660e\u7ec6", (String)"ExpenseEntryMobPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]) : (ER_PUB_REIM_ASSETENTRY_MB.equals(formid) ? ResManager.loadKDString((String)"\u8d44\u4ea7\u4fe1\u606f", (String)"ExpenseEntryMobPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6", (String)"ExpenseEntryMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("formType", "6");
        paramMap.put("formId", formid);
        paramMap.put("customParam", param);
        paramMap.put("needCallBack", Boolean.TRUE);
        paramMap.put("formName", formName);
        this.doParamMap(paramMap);
        Object[] parma = new Object[]{this.getView(), this.getModel(), param, paramMap};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_SUPERBEFORESHOWFORM, (Object[])new Object[]{ExpenseEntryMobPlugin.class, formid, Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if (boo.booleanValue()) {
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }

    private void doneVisible() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"label_expense_delete"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"label_expense_done"});
        for (int rowIndex = 0; rowIndex < this.getModel().getEntryRowCount("expenseentryentity"); ++rowIndex) {
            this.getModel().setValue("mobiledeldoneflag", (Object)0, rowIndex);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        IDataModel model = this.getModel();
        Object[] parma = new Object[]{this.getView(), event.getReturnData()};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_BEFORECLOSEDCALLBACK, (Object[])new Object[]{ExpenseEntryMobPlugin.class, event.getActionId(), Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if (EXPENSE_FORM.contains(event.getActionId()) && boo.booleanValue()) {
            String entityId = this.getView().getEntityId();
            if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                ExpenseEntryMobPlugin.refreshAmount(model, this.getView());
                if (this.getView() instanceof MobileBillView && ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
                    ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), false);
                }
                int entryRowCount = this.getModel().getEntryRowCount("writeoffmoney");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getView().updateView("curraccloanamount", i);
                }
                if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                    int count = model.getEntryRowCount("expenseentryentity");
                    String billPayerType = (String)model.getValue("billpayertype");
                    if (count == 1 && StringUtils.equals((CharSequence)billPayerType, (CharSequence)"bos_user")) {
                        PublicBillUtil.refreshAccountEntry((IDataModel)model);
                    }
                    PublicBillUtil.writeOffContract((IDataModel)model, (PublicContractWriteOffFields)PublicContractWriteOffFields.getInstance());
                    String writeOffType = (String)model.getValue("writeofftype");
                    if ("1".equals(writeOffType) && model.getEntryRowCount("contractentry") > 0) {
                        DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
                        for (int i = 0; i < contracts.size(); ++i) {
                            PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)model, (BigDecimal)((DynamicObject)contracts.get(i)).getBigDecimal("contractwriteoff"), (int)i);
                        }
                    }
                    PublicBillUtil.updateContractWriteoffView((IDataModel)model, (IFormView)this.getView());
                }
                InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
            } else if (ErEntityTypeUtils.isDailyLoanBill((String)entityId)) {
                TempEncashAmountUtils.loan_refreshReceiveAmount((IDataModel)this.getModel());
                TempEncashAmountUtils.loan_getEncashedAmount((IDataModel)this.getModel());
            } else if (ErEntityTypeUtils.isPrePayBill((String)entityId)) {
                int count = model.getEntryRowCount("accountentry");
                if (count == 0) {
                    model.createNewEntryRow("accountentry");
                }
                TempEncashAmountUtils.loan_refreshReceiveAmount((IDataModel)this.getModel());
                TempEncashAmountUtils.loan_getEncashedAmount((IDataModel)this.getModel());
                DynamicObjectCollection expenseList = model.getEntryEntity("expenseentryentity");
                if (expenseList != null && !expenseList.isEmpty()) {
                    for (int i = 0; i < expenseList.size(); ++i) {
                        BigDecimal expeapprovecurramount = ((DynamicObject)expenseList.get(i)).getBigDecimal("expeapprovecurramount");
                        model.setValue("expnonpayamount", (Object)expeapprovecurramount, i);
                    }
                }
                PublicBillUtil.calPreContractMoney((IDataModel)model, (PrePayContractWriteOffFields)PrePayContractWriteOffFields.getInstance());
                String writeOffType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)model.getValue("company")), (String)"er010");
                if ("1".equals(writeOffType) && model.getEntryRowCount("contractentry") > 0) {
                    DynamicObjectCollection contracts = model.getEntryEntity("contractentry");
                    for (int i = 0; i < contracts.size(); ++i) {
                        PublicBillUtil.refreshContractCurrWriteAmount((IDataModel)model, (BigDecimal)((DynamicObject)contracts.get(i)).getBigDecimal("contractwriteoff"), (int)i);
                    }
                }
                PublicBillUtil.updateContractWriteoffView((IDataModel)model, (IFormView)this.getView());
            } else if (ErEntityTypeUtils.isApplyProjectBill((String)entityId) && this.getModel().getEntryRowCount("expenseentryentity") > 0) {
                Object newWltype = this.getModel().getValue("entrywltype", 0);
                Object newWlunit = this.getModel().getValue("entrywlunit", 0);
                this.getModel().setValue("wltype", newWltype);
                this.getModel().setValue("wlunit", newWlunit);
            }
            CommonViewControlUtil.expensePageRules(model, this.getView());
            CommonViewControlUtil.setExpenseAmount(model, this.getView());
        } else if (ER_PUB_REIM_ASSETENTRY_MB.equals(event.getActionId()) && boo.booleanValue() && this.getModel().getProperty("assetentry") != null) {
            if (this.getModel().getEntryRowCount("assetentry") > 0) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"assetflex"});
                this.hiddenOrShowFee(this.getPageCache().get("label_asset_delete") != null);
            }
            if (this.getControl("label_asset_amount") != null) {
                CommonViewControlUtil.setAmountToLabel(this.getModel(), this.getView(), "assetentry", "assetcurrexpenseamount", "label_asset_amount", (DynamicObject)this.getModel().getValue("currency"));
            }
        }
        ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_AFTERCLOSEDCALLBACK, (Object[])new Object[]{ExpenseEntryMobPlugin.class, event.getActionId(), Boolean.FALSE, parma});
    }

    private void hiddenOrShowFee(boolean show) {
        int accountEntrySize = this.getModel().getEntryRowCount("assetentry");
        CardEntry accountCard = (CardEntry)this.getControl("assetentry");
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            accountCard.setChildVisible(show, rowIndex, new String[]{"image_asset_delete"});
        }
    }

    public static void refreshAmount(IDataModel model, IFormView view) {
        model.beginInit();
        String writeOffType = (String)model.getValue("writeofftype");
        WriteOffMoneyUtils.sortWriteOffEntry((IFormView)view);
        WriteOffMoneyUtils.writeOffMoney((IDataModel)model, (String)writeOffType, (IFormView)view);
        if (WriteOffTypeEnum.ORGI_WO.getValue().equalsIgnoreCase(writeOffType)) {
            int i;
            if (model.getEntryRowCount("writeoffmoney") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffmoney"); ++i) {
                    BigDecimal woAmount = (BigDecimal)model.getValue("accloanamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woAmount, (String)"curraccloanamount", (String)"loanexchangerate", (String)"writeoffquotetype", (int)i);
                }
            }
            if (model.getEntryRowCount("writeoffapply") > 0) {
                for (i = 0; i < model.getEntryRowCount("writeoffapply"); ++i) {
                    BigDecimal woApplyAmount = (BigDecimal)model.getValue("reimbursedamount", i);
                    AmountUtils.refreshCurrAmount((IDataModel)model, (BigDecimal)woApplyAmount, (String)"reimbursedcurramount", (String)"applyexchangerate", (String)"writeoffapplyquotetype", (int)i);
                }
            }
        }
        model.endInit();
        OffsetUtils.setHeadSumOffsetAmount((IDataModel)model);
        CommonUtilHelper.setWriteOffAmountLable(model, view, new boolean[0]);
        BigDecimal totalOffsetAmount = ReimburseUtils.sumOffsetAmount((IDataModel)model, (IFormView)view);
        model.setValue("totaloffsetamount", (Object)totalOffsetAmount);
        WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)model, (String)writeOffType, (IFormView)view);
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        CommonViewControlUtil.setAmountToLabel(model, view, "accountentry", "receiveamount", "label_account_amount", currency);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        DynamicObjectCollection assetentry;
        super.afterDeleteRow(e);
        if ("expenseentryentity".equalsIgnoreCase(e.getEntryProp().getName())) {
            int entryRowCount = this.getModel().getEntryRowCount("expenseentryentity");
            if (entryRowCount <= 0) {
                this.getView().updateView();
            }
            CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
            this.refreshEncashedAmount();
        } else if ("assetentry".equals(e.getEntryProp().getName()) && (assetentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("assetentry")).isEmpty()) {
            this.assetEntrySetVisible(true, false);
            this.getPageCache().remove("label_asset_delete");
        }
    }

    protected void refreshEncashedAmount() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            String writeOffType = (String)this.getModel().getValue("writeofftype");
            WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)this.getModel(), (String)writeOffType, (IFormView)this.getView());
        } else if (ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            TempEncashAmountUtils.loan_refreshReceiveAmount((IDataModel)this.getModel());
            TempEncashAmountUtils.loan_getEncashedAmount((IDataModel)this.getModel());
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        if ("expenseentryentity".equals(source.getEntryKey()) && !ErEntityTypeUtils.isApplyPayBill((String)this.getView().getEntityId()) || "assetentry".equals(source.getEntryKey())) {
            DynamicObject company;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            HashMap<String, Object> param = new HashMap<String, Object>();
            String formName = ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6", (String)"ExpenseEntryMobPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
            if (!"assetentry".equals(source.getEntryKey())) {
                this.setAndGetSelectedRowEntryId();
                this.doneVisible();
                String entityId = this.getView().getEntityId();
                if (ErEntityTypeUtils.isDailyApplyBill((String)entityId)) {
                    paramMap.put("formId", APPLY_EXPENSE_FORM);
                } else if (ErEntityTypeUtils.isDailyLoanBill((String)entityId)) {
                    paramMap.put("formId", LOAN_EXPENSE_FORM);
                    int i = this.getModel().getEntryCurrentRowIndex("expenseentryentity");
                    String sourceBillId = this.getModel().getValue("sourcebillid", i).toString();
                    if (!sourceBillId.isEmpty() && !"0".equals(sourceBillId)) {
                        param.put("sourcebillid", sourceBillId);
                        param.put("rowindex", i);
                    }
                } else if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
                    paramMap.put("formId", REIMBURSE_EXPENSE_FORM);
                    param.put("ismultireimburser", (Boolean)this.getModel().getValue("ismultireimburser"));
                } else if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                    paramMap.put("formId", "er_pub_reim_expense_mb");
                    param.put("ismultireimburser", this.getModel().getValue("ismultireimburser"));
                } else if (ErEntityTypeUtils.isPrePayBill((String)entityId)) {
                    paramMap.put("formId", PREPAY_EXPENSE_FORM);
                } else if (ErEntityTypeUtils.isReimCtlApplyBill((String)entityId)) {
                    paramMap.put("formId", "er_reimctl_apply_entry");
                } else if (ErEntityTypeUtils.isApplyProjectBill((String)entityId)) {
                    paramMap.put("formId", APPLY_PROJECT_FORM);
                    formName = ResManager.loadKDString((String)"\u7acb\u9879\u660e\u7ec6", (String)"ExpenseEntryMobPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]);
                }
            } else {
                paramMap.put("formId", ER_PUB_REIM_ASSETENTRY_MB);
                formName = ResManager.loadKDString((String)"\u8d44\u4ea7\u4fe1\u606f", (String)"ExpenseEntryMobPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]);
            }
            paramMap.put("formName", formName);
            paramMap.put("formType", "6");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            param.put("currency", currency.getPkValue());
            DynamicObject costCompany = (DynamicObject)this.getModel().getValue("costcompany");
            if (costCompany != null) {
                param.put("costcompany", ErCommonUtils.getPk((Object)costCompany));
            }
            if ((company = (DynamicObject)this.getModel().getValue("company")) != null) {
                param.put("company", company.getPkValue().toString());
            }
            param.put("index", evt.getRow());
            param.put("entryedit", true);
            param.put("iscurrency", this.getModel().getValue("iscurrency"));
            param.put("billstatus", this.getModel().getValue("billstatus"));
            param.put("isquerybudget", (Boolean)this.getModel().getValue("isquerybudget"));
            ErMobWorkFlowOtherViewEditUtils.setWorkFlowParams(param, (IFormView)this.getView());
            ShowPageUtils.setFormStatusToCustomParam(param, (IFormView)this.getView());
            paramMap.put("customParam", param);
            paramMap.put("needCallBack", Boolean.TRUE);
            this.doParamMap(paramMap);
            Object[] parma = new Object[]{this.getView(), this.getModel(), param, paramMap};
            Boolean boo = Boolean.TRUE;
            List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_SUPERBEFORESHOWFORM, (Object[])new Object[]{ReceiveEntryMobPlugin.class, paramMap.get("formId"), Boolean.FALSE, parma});
            if (!result.isEmpty() && result.get(0) != null) {
                boo = (Boolean)result.get(0);
            }
            if (boo.booleanValue()) {
                ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
            }
        }
    }

    protected void doParamMap(Map<String, Object> paramMap) {
    }

    protected void setAndGetSelectedRowEntryId() {
        DynamicObjectCollection expenceEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        long[] ids = ORM.create().genLongIds(this.getView().getEntityId(), expenceEntry.size());
        for (int i = 0; i < expenceEntry.size(); ++i) {
            DynamicObject entryEntity = (DynamicObject)expenceEntry.get(i);
            Long entryId = (Long)entryEntity.getPkValue();
            if (!Objects.equals(entryId, 0L)) continue;
            entryEntity.set("id", (Object)ids[i]);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
    }

    private void assetEntrySetVisible(boolean delVisible, boolean doneVisible) {
        if (!delVisible) {
            this.getPageCache().put("label_asset_delete", "true");
        }
        String entry = "assetentry";
        if (this.getModel().getProperty(entry) == null) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection assetentry = model.getDataEntity(true).getDynamicObjectCollection(entry);
        if (assetentry.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"label_asset_delete"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"label_asset_done"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"assetflex"});
            this.hiddenOrShowFee(!delVisible);
            return;
        }
        this.getView().setVisible(Boolean.valueOf(delVisible), new String[]{"label_asset_delete"});
        this.getView().setVisible(Boolean.valueOf(doneVisible), new String[]{"label_asset_done"});
        this.assetEntrySetVisible(!delVisible, 0, assetentry.size());
        this.hiddenOrShowFee(!delVisible);
    }

    private void assetEntrySetVisible(boolean visible, int start, int end) {
        for (int rowIndex = start; rowIndex < end; ++rowIndex) {
            this.getModel().setValue("assetmobiledeldoneflag", (Object)(visible ? 1 : 0), rowIndex);
        }
    }
}

