/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.common;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.factory.MultiAccFactory;
import kd.fi.er.business.handler.MultiAccountEntryHandler;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.AbstractReceiveEntryPlugin;
import org.apache.commons.lang3.ObjectUtils;

public class ReceiveEntryMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String IS_DELETING = "is_deleting";
    private static final String BTN_ACCOUNT_ADD = "btn_account_add";
    private static final String ACCOUNTFLEXHEAD = "accountflexhead";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ACCOUNT_ADD, "lab_delete", "lab_done", "mulaccountbtn"});
        AbstractGrid accountGrid = (AbstractGrid)this.getView().getControl("accountentry");
        accountGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_account_add": {
                if (this.getModel().getEntryRowCount("accountentry") == 0) {
                    this.getModel().createNewEntryRow("accountentry");
                    this.openSecondView(0);
                    break;
                }
                this.openSecondView(-1);
                break;
            }
            case "lab_delete": {
                this.accountDeletePageRule(true);
                break;
            }
            case "lab_done": {
                this.accountDeletePageRule(false);
                break;
            }
            case "mulaccountbtn": {
                MultiAccountEntryHandler handler = MultiAccFactory.getMultiAccHandler((String)this.getView().getFormShowParameter().getFormId());
                if (handler == null) {
                    return;
                }
                handler.generateAccountEntry(this.getView());
                break;
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String billType = this.getModel().getDataEntity().getDynamicObjectType().getName();
        if ("accountentry".equalsIgnoreCase(e.getEntryProp().getName())) {
            RowDataEntity[] newRowDataEntities;
            if (!ErEntityTypeUtils.isPrePayBill((String)billType)) {
                PayeeServiceHelper.defualtCurrencySetting((AfterAddRowEventArgs)e, (IDataModel)this.getModel(), (IFormView)this.getView());
            }
            if ((newRowDataEntities = e.getRowDataEntities()) != null && this.getModel().getProperty("acccostcompany") != null) {
                Object cotCompany = this.getModel().getValue("costcompany");
                IntStream.range(0, newRowDataEntities.length).forEach(idx -> this.getModel().setValue("acccostcompany", cotCompany, newRowDataEntities[idx].getRowIndex()));
            }
            this.accountPageRules();
            this.accountDeletePageRule(false);
        }
    }

    private void accountDeletePageRule(boolean delete) {
        if (delete) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lab_done"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lab_delete"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lab_done"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lab_delete"});
        }
        if ((ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) && this.getModel().getEntryRowCount("withholdingentry") > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lab_done"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lab_delete"});
            delete = Boolean.FALSE;
        }
        this.changeDeteleAcctStatus(delete);
        CardEntry accountCard = (CardEntry)this.getControl("accountentry");
        int accountEntrySize = this.getModel().getEntryRowCount("accountentry");
        for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
            accountCard.setChildVisible(delete, rowIndex, new String[]{"imageaccount_delete"});
        }
    }

    private boolean isDeleting() {
        IPageCache pageCache = this.getPageCache();
        String status = pageCache.get(IS_DELETING);
        return Boolean.parseBoolean(status);
    }

    private void changeDeteleAcctStatus(boolean status) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put(IS_DELETING, String.valueOf(status));
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        if ("accountentry".equals(source.getEntryKey())) {
            this.openSecondView(evt.getRow());
        }
    }

    protected String getReceiveEntryFormId() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            return "er_dailyreimrecentry_mb";
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            return "er_pubreimrecentry_mb";
        }
        if (ErEntityTypeUtils.isDailyLoanBill((String)entityId)) {
            return "er_dailyloanrecentry_mb";
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return "er_tripreimrecentry_mb";
        }
        if (ErEntityTypeUtils.isTripReqBill((String)entityId)) {
            return "er_triploanrecentry_mb";
        }
        if (ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            return "er_prepayrecentry_mb";
        }
        if (ErEntityTypeUtils.isApplyPayBill((String)entityId)) {
            return "er_applypayrecentry_mb";
        }
        return "er_dailyreimrecentry_mb";
    }

    protected void openSecondView(int rowIndex) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("index", rowIndex);
        paramMap.put("formId", this.getReceiveEntryFormId());
        paramMap.put("formType", "5");
        ShowPageUtils.setFormStatusToCustomParam(param, (IFormView)this.getView());
        paramMap.put("customParam", param);
        paramMap.put("needCallBack", Boolean.TRUE);
        Object[] parma = new Object[]{this.getView(), this.getModel(), param, paramMap};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_SUPERBEFORESHOWFORM, (Object[])new Object[]{ReceiveEntryMobPlugin.class, this.getReceiveEntryFormId(), Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if (boo.booleanValue()) {
            ShowPageUtils.showPage(paramMap, (AbstractFormPlugin)this);
        }
    }

    protected void doParamMap(Map<String, Object> paramMap) {
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object[] parma = new Object[]{this.getView(), event.getReturnData()};
        Boolean boo = Boolean.TRUE;
        List result = ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_BEFORECLOSEDCALLBACK, (Object[])new Object[]{ReceiveEntryMobPlugin.class, event.getActionId(), Boolean.FALSE, parma});
        if (!result.isEmpty() && result.get(0) != null) {
            boo = (Boolean)result.get(0);
        }
        if (this.getReceiveEntryFormId().equalsIgnoreCase(event.getActionId()) && boo.booleanValue()) {
            AmountChangeUtil.handleDiiff((IDataModel)this.getModel(), (String)"accountentry", (String)"receiveamount", (String)"orireceiveamount", (String)"accexchangerate", (String)"currency");
            this.setReceiveAmtLabel();
            if ("er_applypayrecentry_mb".equals(event.getActionId())) {
                IDataModel model = this.getModel();
                DynamicObjectCollection accountentrys = model.getDataEntity(true).getDynamicObjectCollection("accountentry");
                BigDecimal accapprovecurramountTotal = AmountChangeUtil.sumAmountBy((Collection)accountentrys, (String)"accapprovecurramount");
                model.setValue("approveamount", (Object)accapprovecurramountTotal);
                this.getModel().setValue("approveamount", (Object)accapprovecurramountTotal);
                BigDecimal receiveamountTotal = AmountChangeUtil.sumAmountBy((Collection)accountentrys, (String)"receiveamount");
                model.setValue("loanamount", (Object)receiveamountTotal);
            }
            this.getView().updateView("accountentry");
            this.accountDeletePageRule(false);
            if ("er_pubreimrecentry_mb".equals(event.getActionId())) {
                this.setIsOnAccount();
            }
        }
        ErExtHelper.invokeMutiParamsExpandPlugin((ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_AFTERCLOSEDCALLBACK, (Object[])new Object[]{ReceiveEntryMobPlugin.class, event.getActionId(), Boolean.FALSE, parma});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.accountPageRules();
        this.accountDeletePageRule(this.isDeleting());
        this.setReceiveAmtLabel();
        PayeeServiceHelper.viewStorageLimits((IFormView)this.getView());
    }

    private void accountPageRules() {
        if ((ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) && this.getModel().getEntryRowCount("withholdingentry") > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_ACCOUNT_ADD});
            return;
        }
        int accountEntrySize = this.getModel().getEntryRowCount("accountentry");
        int expenseEntrySize = this.getExpenseEntrySize();
        if (expenseEntrySize == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ACCOUNTFLEXHEAD, "accountentry", BTN_ACCOUNT_ADD});
        } else if (accountEntrySize > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ACCOUNTFLEXHEAD, "accountentry", BTN_ACCOUNT_ADD});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_ACCOUNT_ADD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ACCOUNTFLEXHEAD, "accountentry"});
            this.accountDeletePageRule(false);
        }
    }

    protected int getExpenseEntrySize() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId) || ErEntityTypeUtils.isTripReqBill((String)entityId) || this.getModel().getProperty("tripentry") != null) {
            return this.getModel().getEntryRowCount("tripentry");
        }
        return this.getModel().getEntryRowCount("expenseentryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object propValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "applier": {
                CoreBaseBillServiceHelper.changeAccountEntry((IDataModel)this.getModel(), (Long)((Long)((DynamicObject)propValue).getPkValue()));
                Object checkType = this.getModel().getProperty("writeofftype") != null ? this.getModel().getValue("writeofftype") : null;
                String loanType = checkType == null ? "1" : checkType.toString();
                BigDecimal encashAmount = this.getEncashedAmount(this.getModel().getDataEntity());
                AmountChangeUtil.refreshReceiveAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (BigDecimal)encashAmount, (String)loanType);
                this.accountPageRules();
                break;
            }
            case "receiveamount": {
                this.setReceiveAmtLabel();
                break;
            }
            case "payer": {
                AbstractReceiveEntryPlugin.payerChange(this.getView(), e.getChangeSet()[0].getRowIndex(), (DynamicObject)propValue);
                break;
            }
            case "accountcurrency": {
                Map exchangeRateMap = AmountChangeUtil.refreshEnrtyExchangeRate((IDataModel)this.getModel(), (IFormView)this.getView(), (DynamicObject)((DynamicObject)propValue));
                String accQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateMap.get("quoteType")), (Object)"0");
                if (this.getModel().getProperty("accquotetype") == null) break;
                this.getModel().setValue("accquotetype", (Object)accQuoteType, e.getChangeSet()[0].getRowIndex());
                break;
            }
        }
    }

    private BigDecimal getEncashedAmount(DynamicObject elem) {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            return elem.getBigDecimal("payamount");
        }
        if (ErEntityTypeUtils.isDailyLoanBill((String)entityId)) {
            return elem.getBigDecimal("approveamount");
        }
        if (ErEntityTypeUtils.isTripReqBill((String)entityId) || ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return elem.getBigDecimal("encashamount");
        }
        return BigDecimal.ZERO;
    }

    protected void setReceiveAmtLabel() {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        CommonViewControlUtil.setAmountToLabel(this.getModel(), this.getView(), "accountentry", "receiveamount", "label_account_amount", currency);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        if ("accountentry".equals(e.getEntryProp().getName())) {
            this.accountPageRules();
            AmountChangeUtil.handleDiiff((IDataModel)this.getModel(), (String)"accountentry", (String)"receiveamount", (String)"orireceiveamount", (String)"accexchangerate", (String)"currency");
            this.setReceiveAmtLabel();
            String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
            if (ErEntityTypeUtils.isPublicReimburseBill((String)entityName)) {
                this.setIsOnAccount();
            }
        }
        if ("expenseentryentity".equalsIgnoreCase(e.getEntryProp().getName())) {
            this.setReceiveAmtLabel();
        }
    }

    private void setIsOnAccount() {
        DynamicObjectCollection accountEntry = this.getModel().getEntryEntity("accountentry");
        double receiveAmountSum = accountEntry.stream().mapToDouble(account -> account.getBigDecimal("orireceiveamount").doubleValue()).sum();
        boolean isOnAccount = receiveAmountSum == 0.0 ? false : accountEntry.stream().anyMatch(r -> !r.getBoolean("ispaynow"));
        this.getModel().setValue("isonaccount", (Object)isOnAccount);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("unsubmit".equals(afterDoOperationEventArgs.getOperateKey())) {
            this.accountPageRules();
            this.accountDeletePageRule(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Submit || args.getSource() instanceof Audit) {
            PayeeServiceHelper.clearLimitInfo((IDataModel)this.getModel());
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        PayeeServiceHelper.clearLimitInfo((IDataModel)this.getModel());
    }
}

