/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.common;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ShowPageUtils;

public class SharedDetailEntryMobPlugIn
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog(SharedDetailEntryMobPlugIn.class);
    private static final String PUBIC_SHARE_DETAIL_FORM_ID = "er_public_shareddetail_mb";
    private static final String DAILY_SHARE_DETAIL_FORM_ID = "er_daily_shareddetail_mb";
    private static final String TRIP_SHARE_DETAIL_FORM_ID = "er_trip_shareddetail_mb";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String entryIdentifier = "sharedetailentry";
        AbstractGrid expenseGrid = (AbstractGrid)this.getView().getControl(entryIdentifier);
        if (expenseGrid != null) {
            expenseGrid.addRowClickListener((RowClickEventListener)this);
        } else {
            logger.info("Grid {} doesn't exist.", (Object)entryIdentifier);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String identifier = "sharedetailentry";
        CardEntry source = (CardEntry)evt.getSource();
        String clickKey = source.getEntryKey();
        if (StringUtils.equals((CharSequence)identifier, (CharSequence)clickKey)) {
            HashMap<String, Object> showParams = new HashMap<String, Object>();
            HashMap<String, Integer> customParams = new HashMap<String, Integer>();
            int rowIndex = evt.getRow();
            customParams.put("index", rowIndex);
            ShowPageUtils.setFormStatusToCustomParam(customParams, (IFormView)this.getView());
            showParams.put("customParam", customParams);
            showParams.put("appId", "exp");
            showParams.put("formId", this.getShowFormId());
            showParams.put("formType", "6");
            showParams.put("needCallBack", Boolean.FALSE);
            ShowPageUtils.showPage(showParams, (AbstractFormPlugin)this);
        }
    }

    private Object getShowFormId() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            return PUBIC_SHARE_DETAIL_FORM_ID;
        }
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            return DAILY_SHARE_DETAIL_FORM_ID;
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return TRIP_SHARE_DETAIL_FORM_ID;
        }
        throw new IllegalStateException(String.format("Invalid entity id : %s", entityId));
    }
}

