/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.common;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.reimburse.propertychange.DailyReimbursePropChange;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.mobile.ErReimburseUpRequestMobPlugin;
import org.apache.commons.lang3.StringUtils;

public class WriteOffEntryMobPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final String TRIP_REIM_WRITEOFF_FORM_ID = "er_tripreim_writeoff_mb";
    private static final String PUBIC_REIM_WRITEOFF_FORM_ID = "er_pubreim_writeoff_mb";
    private static final String DAILY_REIM_WRITEOFF_FORM_ID = "er_dailyreim_writeoff_mb";
    private static final String WRITE_OFF_MONEY_FLEX_HEAD = "writeoffmoneyflexhead";
    private static boolean SHOW_WRITE_OFF_ENTRY = false;
    private static final Log logger = LogFactory.getLog(WriteOffEntryMobPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        String entryIdentifier = this.getEntryIdentifier();
        AbstractGrid expenseGrid = (AbstractGrid)this.getView().getControl(entryIdentifier);
        if (expenseGrid != null) {
            expenseGrid.addRowClickListener((RowClickEventListener)this);
        } else {
            logger.info("Grid {} doesn't exist.", (Object)entryIdentifier);
        }
        this.addClickListeners(new String[]{WRITE_OFF_MONEY_FLEX_HEAD});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)WRITE_OFF_MONEY_FLEX_HEAD, (CharSequence)key)) {
            SHOW_WRITE_OFF_ENTRY = !SHOW_WRITE_OFF_ENTRY;
            this.getView().setVisible(Boolean.valueOf(SHOW_WRITE_OFF_ENTRY), new String[]{this.getEntryIdentifier()});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.writeOffPageRules();
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        this.writeOffPageRules();
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("writeoffmoney".equals(entryName)) {
            DailyReimbursePropChange.refreshWriteOffAmount(this.getModel());
            WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)this.getModel(), (String)this.getWriteOffType(), (IFormView)this.getView());
            BigDecimal totalWriteOffAmount = AmountUtils.getEntryAmount((IDataModel)this.getModel(), (String)"writeoffmoney", (String)"curraccloanamount");
            this.getModel().setValue("totalaccloanamount", (Object)totalWriteOffAmount);
            CommonUtilHelper.setWriteOffAmountLable(this.getModel(), this.getView(), false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.writeOffPageRules();
    }

    private void writeOffPageRules() {
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry source = (CardEntry)evt.getSource();
        String identifier = this.getEntryIdentifier();
        if (identifier.equals(source.getEntryKey())) {
            HashMap<String, Object> showParams = new HashMap<String, Object>();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            int rowIndex = evt.getRow();
            customParams.put("index", rowIndex);
            customParams.put("entryIdentifier", identifier);
            ShowPageUtils.setFormStatusToCustomParam(customParams, (IFormView)this.getView());
            showParams.put("customParam", customParams);
            Set licenseModules = LicenseServiceHelper.getLicenseModules();
            String appid = "exp";
            if (CollectionUtils.isNotEmpty((Collection)licenseModules)) {
                if (licenseModules.stream().anyMatch("exp"::equalsIgnoreCase)) {
                    appid = "exp";
                }
                if (licenseModules.stream().anyMatch("cexp"::equalsIgnoreCase)) {
                    appid = "cexp";
                }
            }
            showParams.put("appId", appid);
            showParams.put("formId", this.getShowFormId());
            showParams.put("formType", "6");
            showParams.put("needCallBack", Boolean.TRUE);
            this.doParamMap(showParams);
            ShowPageUtils.showPage(showParams, (AbstractFormPlugin)this);
        }
    }

    private String getEntryIdentifier() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            return "writeoffmoney";
        }
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            return "writeoffmoney";
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return "clearloanentry";
        }
        throw new IllegalStateException(String.format("Invalid entity id : %s", entityId));
    }

    protected void doParamMap(Map<String, Object> paramMap) {
    }

    private String getShowFormId() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            return PUBIC_REIM_WRITEOFF_FORM_ID;
        }
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            return DAILY_REIM_WRITEOFF_FORM_ID;
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return TRIP_REIM_WRITEOFF_FORM_ID;
        }
        throw new IllegalStateException(String.format("Invalid entity id : %s", entityId));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        DynamicObjectCollection data;
        Integer rowIndex;
        Map returnMap;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (DAILY_REIM_WRITEOFF_FORM_ID.equals(actionId) || PUBIC_REIM_WRITEOFF_FORM_ID.equals(actionId)) {
            returnMap = (Map)returnData;
            rowIndex = (Integer)returnMap.get("rowIndex");
            data = (DynamicObjectCollection)returnMap.get("data");
            if (rowIndex != null && rowIndex != -1 && data != null && !data.isEmpty()) {
                String writeOffType = this.getWriteOffType();
                if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
                    this.getModel().setValue("accloanamount", ((DynamicObject)data.get(0)).get("accloanamount"), rowIndex.intValue());
                }
                Object curLoanAmount = ((DynamicObject)data.get(0)).get("curraccloanamount");
                this.getModel().setValue("curraccloanamount", curLoanAmount, rowIndex.intValue());
                WriteOffMoneyUtils.curCheckLoanAmountChange((Object)curLoanAmount, (int)rowIndex, (String)writeOffType, (IDataModel)this.getModel(), (IFormView)this.getView());
                CommonUtilHelper.setWriteOffAmountLable(this.getModel(), this.getView(), new boolean[0]);
            }
            ErReimburseUpRequestMobPlugin.hiddenOrShowWriteOff(this.getModel(), this.getView(), false);
        }
        if (TRIP_REIM_WRITEOFF_FORM_ID.equals(actionId)) {
            returnMap = (Map)returnData;
            rowIndex = (Integer)returnMap.get("rowIndex");
            data = (DynamicObjectCollection)returnMap.get("data");
            if (rowIndex != null && rowIndex != -1 && data != null && !data.isEmpty()) {
                this.getModel().setValue("loanclearoriamount", ((DynamicObject)data.get(0)).get("loanclearoriamount"), rowIndex.intValue());
                this.getModel().setValue("loanclearamount", ((DynamicObject)data.get(0)).get("loanclearamount"), rowIndex.intValue());
            }
            BigDecimal totalClearLoanAmount = AmountUtils.getEntryAmount((IDataModel)this.getModel(), (String)"clearloanentry", (String)"loanclearamount");
            AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
            this.getModel().setValue("checkloanamount", (Object)totalClearLoanAmount);
            ErReimburseUpRequestMobPlugin.hiddenOrShow(this.getModel(), this.getView(), false, "clearloanentry", "lab_done_writeoff", "lab_delete_writeoff", "image_delete_writeoff");
        }
    }

    private String getWriteOffType() {
        long companyid;
        String woType = WriteOffTypeEnum.CURR_WO.getValue();
        Object company = this.getModel().getValue("company");
        if (company instanceof DynamicObject && ((woType = (String)ErCommonUtils.getLoanCheckType((long)(companyid = Long.parseLong(((DynamicObject)company).getPkValue().toString())))) == null || woType.isEmpty())) {
            logger.warn(String.format("\u516c\u53f8 {%s}\uff1a\u672a\u8bbe\u7f6e\u6838\u9500\u65b9\u5f0f", ((DynamicObject)company).getPkValue()));
            woType = WriteOffTypeEnum.CURR_WO.getValue();
        }
        return woType;
    }
}

