/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.loan;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.util.TempEncashAmountUtils;
import org.apache.commons.lang3.StringUtils;

public class ERDailyloanMobileBillPlugin
extends AbstractMobBillPlugIn
implements ClickListener,
RowClickEventListener {
    private static final Log logger = LogFactory.getLog((String)ERDailyloanMobileBillPlugin.class.getName());
    private static final String isDownBill1Flag = "isDownBill1Flag";
    private static final String deleteExpenseEntry = "deleteExpenseEntry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"bar_toreimburse", "bar_topubreimburse"});
    }

    public void afterCreateNewData(EventObject arg0) {
        super.afterCreateNewData(arg0);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save", "btn_submit"});
        if (this.getModel().getProperty("ismultireimburser") != null) {
            DynamicObject[] personalSettingInfos = CommonServiceHelper.getTripPersonalSetting((long)Long.parseLong(RequestContext.get().getUserId()));
            boolean ismultireimburser = personalSettingInfos != null && personalSettingInfos.length > 0 ? personalSettingInfos[0].getBoolean("ismultireimburser") : false;
            this.getModel().setValue("ismultireimburser", (Object)ismultireimburser);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        CommonViewControlUtil.initViewUserInfo(this.getModel(), this.getView());
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("currency".equals(propName)) {
            CommonViewControlUtil.expensePageRules(this.getModel(), this.getView());
            CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
        } else if ("bizdate".equals(propName)) {
            this.refreshRepaymentDate();
        }
    }

    public void afterBindData(EventObject e) {
        IFormView view;
        super.afterBindData(e);
        CommonViewControlUtil.expensePageRules(this.getModel(), this.getView());
        if (ErEntityTypeUtils.isPrePayBill((String)this.getView().getEntityId())) {
            CommonViewControlUtil.contractPageRule(this.getModel(), this.getView(), Boolean.FALSE);
        }
        if ((view = this.getView()).getParentView() != null) {
            String billPageId = view.getPageId();
            IPageCache parentPageCache = (IPageCache)view.getParentView().getService(IPageCache.class);
            parentPageCache.put("billPageId", billPageId);
            logger.info("pageId:" + billPageId + ",view :" + view.getEntityId());
        }
        if (ErEntityTypeUtils.isPrePayBill((String)view.getEntityId()) || ErEntityTypeUtils.isApplyPayBill((String)view.getEntityId())) {
            return;
        }
        Boolean isDownBill = false;
        int rowCount = this.getModel().getEntryRowCount("expenseentryentity");
        if (rowCount > 0) {
            DynamicObjectCollection expenseEntryColl = this.getModel().getEntryEntity("expenseentryentity");
            for (int i = 0; i < rowCount; ++i) {
                DynamicObject expenseEntry = (DynamicObject)expenseEntryColl.get(i);
                String sourceBillId = expenseEntry.getString("sourcebillid");
                if (sourceBillId.isEmpty() || "0".equals(sourceBillId)) continue;
                isDownBill = true;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_expense_add"});
            }
        }
        this.getPageCache().put(isDownBill1Flag, String.valueOf(isDownBill));
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (isDownBill.booleanValue() && StringUtils.equals((CharSequence)"A", (CharSequence)billStatus)) {
            CommonViewControlUtil.initViewUserInfo(this.getModel(), this.getView());
        }
        if (this.getModel().getValue("repaymentdate") == null && isDownBill.booleanValue()) {
            this.refreshRepaymentDate();
        }
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged()) {
            String isgetaccountcurrency = "0";
            if (this.getModel().getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
            if ("1".equals(isgetaccountcurrency)) {
                this.getModel().setValue("iscurrency", (Object)Boolean.TRUE);
            }
            TempEncashAmountUtils.loan_refreshReceiveAmount((IDataModel)this.getModel());
            TempEncashAmountUtils.loan_getEncashedAmount((IDataModel)this.getModel());
        }
    }

    private void refreshRepaymentDate() {
        this.getModel().setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate((IDataModel)this.getModel()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "deleteexpeentry": {
                String isDownBill;
                RefObject afterConfirm = new RefObject();
                if (((DeleteEntry)args.getSource()).getOption().tryGetVariableValue(deleteExpenseEntry, afterConfirm) || !StringUtils.isNotBlank((CharSequence)(isDownBill = this.getPageCache().get(isDownBill1Flag))) || !"true".equalsIgnoreCase(isDownBill)) break;
                if (this.getModel().getEntryRowCount("expenseentryentity") > 1) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8d39\u7528\u7533\u8bf7\u4e0b\u63a8\u7684\u501f\u6b3e\u5355\uff0c\u5220\u9664\u5206\u5f55\u540e\u4e0d\u80fd\u518d\u65b0\u589e\u5206\u5f55\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u5220\u9664\uff1f", (String)"ERDailyloanMobileBillPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(deleteExpenseEntry));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210\u7684\u501f\u6b3e\u5355\u6700\u540e\u4e00\u6761\u5206\u5f55\u4e0d\u53ef\u5220\u9664\u3002", (String)"ERDailyloanMobileBillPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (deleteExpenseEntry.equalsIgnoreCase(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(deleteExpenseEntry, "true");
            this.getView().invokeOperation("deleteexpeentry", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        IFormView view = this.getView();
        switch (key) {
            case "submit": {
                BillShowParameter billShowParameter;
                if (!result.isSuccess() || ErEntityTypeUtils.isPrePayBill((String)view.getEntityId()) || ErEntityTypeUtils.isApplyPayBill((String)view.getEntityId())) break;
                IFormView parentView = view.getParentView();
                if (parentView != null) {
                    parentView.close();
                    view.sendFormAction(parentView);
                }
                if ((billShowParameter = (BillShowParameter)view.getFormShowParameter()).getBillStatus().getValue() != BillOperationStatus.ADDNEW.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.SUBMIT.getValue() && billShowParameter.getBillStatus().getValue() != BillOperationStatus.EDIT.getValue()) break;
                HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
                paramMap.put("formId", this.getView().getEntityId());
                paramMap.put("templateId", "er_dlbill_mobtemplate");
                HashMap<String, String> customParam = new HashMap<String, String>(1);
                customParam.put("need_refresh", "Y");
                paramMap.put("customParam", customParam);
                ShowPageUtils.showMobileBillList(paramMap, (AbstractFormPlugin)this);
            }
        }
    }
}

