/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.loan;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.ContextMenuClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.formplugin.mobile.CoreBaseBillListNew;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import kd.fi.er.formplugin.mobile.MultiLang;
import org.apache.commons.lang.ObjectUtils;

public class ERDailyloanMobileListPlugin
extends CoreBaseBillListNew {
    private static Log log = LogFactory.getLog(ERDailyloanMobileListPlugin.class);
    private static final List<String> todoStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E", "F"}));
    private static final List<String> doingStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"G"}));
    private static final List<String> didStateList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"H", "I"}));
    private static final MobileListStateInfo todoStateInfo = new MobileListStateInfo("todotab", todoStateList, new MultiLang(ERDailyloanMobileListPlugin.getApplyMsg(), "ERDailyloanMobileListPlugin_0", "fi-er-formplugin"));
    private static final MobileListStateInfo doingStateInfo = new MobileListStateInfo("doingtab", doingStateList, new MultiLang(ERDailyloanMobileListPlugin.getLoanMsg(), "ERDailyloanMobileListPlugin_1", "fi-er-formplugin"));
    private static final MobileListStateInfo didStateInfo = new MobileListStateInfo("didtab", didStateList, new MultiLang(ERDailyloanMobileListPlugin.getCompleteMsg(), "ERDailyloanMobileListPlugin_2", "fi-er-formplugin"));
    private static final List<MobileListStateInfo> stateInfoList = Lists.newArrayListWithExpectedSize((int)3);

    public ERDailyloanMobileListPlugin() {
        super(stateInfoList);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_reimburse", "btn_pub_reimburse"});
    }

    public void contextMenuClick(ContextMenuClickEvent e) {
        super.contextMenuClick(e);
        log.info("new:log\u4e91\u4e4b\u5bb6ItemKey\uff1a" + e.getItemKey());
        if (e.getItemKey().toLowerCase().equals("new_dailyloan")) {
            log.info("contextMenuClick:new_dailyloan");
            String formId = "er_dailyloanbill_mob";
            MobileBillShowParameter showParameter = new MobileBillShowParameter();
            showParameter.setFormId(formId);
            showParameter.setCaption(ResManager.loadKDString((String)"\u501f\u6b3e\u5355", (String)"ERDailyloanMobileListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, formId));
            ShowType showType = (ShowType)ObjectUtils.defaultIfNull((Object)ShowType.Floating, (Object)ShowType.Floating);
            showParameter.getOpenStyle().setShowType(showType);
            showParameter.setAppId("18X6P1ZSXS44");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        MobileListShowParameter mobparameter = (MobileListShowParameter)this.getView().getFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_dlbill_tabap");
        formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private static String getApplyMsg() {
        return ResManager.loadKDString((String)"\u7533\u8bf7\u4e2d", (String)"ERDailyloanMobileListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getLoanMsg() {
        return ResManager.loadKDString((String)"\u5df2\u501f\u6b3e", (String)"ERDailyloanMobileListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getCompleteMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ERDailyloanMobileListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    static {
        stateInfoList.add(todoStateInfo);
        stateInfoList.add(doingStateInfo);
        stateInfoList.add(didStateInfo);
    }
}

