/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.reimburse;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.model.CurrencyBO;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.daily.web.ReimburseAmountControlFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class ErDailyReimExpAmountControlPluginMob
extends AbstractMobBillPlugIn {
    private static final Log log = LogFactory.getLog(ReimburseAmountControlFormPlugin.class);
    protected static final String[] reimburseControlRelativeFields = new String[]{"expenseitem", "happendate", "entrycurrency", "reimburser", "entrycostdept", "reimctldept", "pubreimburser"};
    private String quotaDateField = ErStdConfig.get((String)"quotaDateField");

    public void registerListener(EventObject e) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getParentView() == null) {
            return;
        }
        this.setHapendDateSelectedRange();
    }

    private void setHapendDateSelectedRange() {
        QuotaCtrlUtil.setHappenDateSelectedRange((IDataModel)this.getView().getParentView().getModel(), (DateEdit[])new DateEdit[]{(DateEdit)this.getControl("happendate")});
        QuotaCtrlUtil.setHappenDateSelectedRange((IDataModel)this.getModel(), (DateEdit[])new DateEdit[]{(DateEdit)this.getControl("happendate")});
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            LocalDate minLocalDate = LocalDate.of(1990, 1, 1);
            DateEdit happenDE = (DateEdit)this.getControl("happendate");
            happenDE.setMinDate(ErCommonUtils.getDateFromLocalDate((LocalDate)minLocalDate));
        } else {
            String special = (String)this.getView().getParentView().getModel().getValue("specialbill");
            if (StringUtils.isBlank((CharSequence)special)) {
                LocalDate minLocalDate = LocalDate.of(1990, 1, 1);
                DateEdit happenDE = (DateEdit)this.getControl("happendate");
                happenDE.setMinDate(ErCommonUtils.getDateFromLocalDate((LocalDate)minLocalDate));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (this.getView().getParentView() == null) {
            return;
        }
        String propName = e.getProperty().getName();
        IDataModel dataModel = this.getModel();
        String entityId = dataModel.getDataEntityType().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if ((entityId.equals("er_dailyreimbursebil_ssc") || ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || entityId.equals("er_publicreimburse_ssc")) && Arrays.asList(reimburseControlRelativeFields).contains(propName)) {
            if (rowIndex < 0) {
                int count = dataModel.getEntryRowCount("expenseentryentity");
                for (int i = 0; i < count; ++i) {
                    this.showExpenseBalanceAmount(i);
                }
            } else {
                this.showExpenseBalanceAmount(rowIndex);
            }
        }
    }

    private void showExpenseBalanceAmount(int index) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expenseEntries = dataEntity.getDynamicObjectCollection("expenseentryentity");
        if (expenseEntries.size() == 0) {
            return;
        }
        boolean ischanged = model.getDataChanged();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            model.setValue("amount_balanceamount", (Object)"--", index);
            return;
        }
        String billStatus = (String)model.getValue("billstatus");
        if (billStatus != null && !Arrays.asList("A", "D", "B", "C").contains(billStatus)) {
            model.setValue("amount_balanceamount", (Object)"--", index);
            return;
        }
        DynamicObject expenseEntry = (DynamicObject)expenseEntries.get(index);
        if (!this.validRow(expenseEntry)) {
            model.setValue("amount_balanceamount", (Object)"--", index);
            return;
        }
        Long companyId = ErCommonUtils.getPk((Object)company);
        boolean isEnable = SystemParamterUtil.isEnableReimburseControlByCompany((Long)companyId);
        if (!isEnable) {
            model.setValue("amount_balanceamount", (Object)"--", index);
            return;
        }
        DynamicObject amountControlCompanyDO = ReimburseControlUtils.getReimburseControlCompany((DynamicObject)this.getView().getParentView().getModel().getDataEntity(true));
        if (amountControlCompanyDO == null) {
            model.setValue("amount_balanceamount", (Object)"--", index);
            return;
        }
        List empCltList = SystemParamterUtil.getEmpCltBillList((Long)companyId);
        List deptCltList = SystemParamterUtil.getDeptCltBillList((Long)companyId);
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
            if (!empCltList.contains("3") && !deptCltList.contains("3")) {
                model.setValue("amount_balanceamount", (Object)"--", index);
                return;
            }
        } else if (!empCltList.contains("1") && !deptCltList.contains("1")) {
            model.setValue("amount_balanceamount", (Object)"--", index);
            return;
        }
        String personCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"personctlcurrency");
        String deptCtrlCurrency = (String)ErCommonUtils.getEMParameter((long)companyId, (String)"deptctlcurrency");
        DynamicObject currency = (DynamicObject)this.getView().getParentView().getModel().getValue("currency");
        Long currencyId = currency == null ? Long.valueOf(0L) : (Long)currency.getPkValue();
        QuotaAmountBO reimAmountBO = new QuotaAmountBO();
        reimAmountBO.setCompanyId((Long)amountControlCompanyDO.getPkValue());
        reimAmountBO.setEmpCtlBill(empCltList);
        reimAmountBO.setDeptCtlBill(deptCltList);
        DynamicObject expenseitem = expenseEntry.getDynamicObject("expenseitem");
        reimAmountBO.setExpenseItemId((Long)expenseitem.getPkValue());
        reimAmountBO.setCtrlCount(Integer.valueOf(expenseitem.getInt("reimburseamountctlcount")));
        reimAmountBO.setCtrlMethod(expenseitem.getString("reimburseamountctlmethod"));
        reimAmountBO.setCtrlType(expenseitem.getString("reimctltype"));
        String isreimburseamountctl = expenseitem.getString("isreimburseamountctl");
        reimAmountBO.setCtrlMode(isreimburseamountctl);
        Long oriCurrencyId = (Long)expenseEntry.getDynamicObject("entrycurrency").getPkValue();
        if ("1".equals(isreimburseamountctl)) {
            if (ErEntityTypeUtils.isPublicReimburseBill((String)model.getDataEntity().getDynamicObjectType().getName())) {
                if (expenseEntry.containsProperty("pubreimburser") && expenseEntry.get("pubreimburser") != null) {
                    reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("pubreimburser").getPkValue());
                } else {
                    reimAmountBO.setUserOrDeptId((Long)dataEntity.getDynamicObject("applier").getPkValue());
                }
            } else {
                reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("reimburser").getPkValue());
            }
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
        } else if ("2".equals(isreimburseamountctl)) {
            reimAmountBO.setUserOrDeptId((Long)expenseEntry.getDynamicObject("reimctldept").getPkValue());
            QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)oriCurrencyId, (Long)currencyId);
        }
        Date date = expenseEntry.getDate("happendate");
        if (this.quotaDateField.equals("2")) {
            date = (Date)model.getValue("bizdate");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        reimAmountBO.setHappenDate(YearMonth.of(calendar.get(1), calendar.get(2) + 1));
        boolean isAduit = false;
        if (Arrays.asList("B", "C").contains((String)model.getValue("billstatus"))) {
            isAduit = true;
        }
        ArrayList<Long> excludeReimbureBillIds = new ArrayList<Long>();
        if (isAduit) {
            excludeReimbureBillIds.add((Long)model.getDataEntity().getPkValue());
            log.info("\u662f\u5ba1\u6838\u72b6\u6001, \u6392\u9664\u7684\u5355\u636e\u4e3a: " + excludeReimbureBillIds);
        }
        reimAmountBO.setNotInIds(excludeReimbureBillIds);
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
        BigDecimal balanceAmount = quotaCtrlMode.getBalanceAmount(reimAmountBO);
        if ("2".equals(reimAmountBO.getCtrlType()) && balanceAmount == null) {
            model.setValue("amount_balanceamount", (Object)"--", index);
            return;
        }
        if (balanceAmount == null) {
            balanceAmount = BigDecimal.ZERO;
        }
        String balanceAmountStr = ErCommonUtils.getMoneyStringWithSymbol((BigDecimal)balanceAmount, (CurrencyBO)new CurrencyBO(reimAmountBO.getCurrencyId()));
        model.setValue("amount_balanceamount", (Object)balanceAmountStr, index);
        model.setDataChanged(ischanged);
    }

    private boolean validRow(DynamicObject entry) {
        boolean on;
        DynamicObject expenseitem = entry.getDynamicObject("expenseitem");
        boolean bl = on = expenseitem != null && entry.getDynamicObject("entrycurrency") != null && entry.getDate("happendate") != null;
        if (!on) {
            return false;
        }
        String isreimburseamountctl = expenseitem.getString("isreimburseamountctl");
        if ("1".equals(isreimburseamountctl)) {
            DynamicObject reimburser = ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName()) ? (entry.containsProperty("pubreimburser") ? entry.getDynamicObject("pubreimburser") : this.getModel().getDataEntity().getDynamicObject("applier")) : entry.getDynamicObject("reimburser");
            if (reimburser == null) {
                return false;
            }
        } else if ("2".equals(isreimburseamountctl)) {
            DynamicObject reimctldept = entry.getDynamicObject("reimctldept");
            if (reimctldept == null) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

