/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.reimburse;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.UserProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.util.MobileEntryUtil;
import kd.fi.er.formplugin.daily.web.workflow.ErMobWorkFlowOtherViewEditUtils;
import kd.fi.er.formplugin.util.EntryCopyUtil;
import kd.fi.er.formplugin.util.OffsetUtils;
import kd.fi.er.formplugin.web.ErTripReimAutoWriteDescription;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ErDailyReimburseExpenseAddEdit
extends AbstractMobBillPlugIn
implements ClickListener {
    private static Log logger = LogFactory.getLog(ErDailyReimburseExpenseAddEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_save", "buttonap"});
        this.costCenterF7Filter();
        this.reimburserControl();
    }

    private void reimburserControl() {
        IDataEntityProperty reimburserProp = this.getModel().getProperty("reimburser");
        if (reimburserProp instanceof UserProp) {
            ((UserProp)reimburserProp).setF7Style(2);
        }
        if ((reimburserProp = this.getModel().getProperty("pubreimburser")) instanceof UserProp) {
            ((UserProp)reimburserProp).setF7Style(2);
        }
    }

    private void costCenterF7Filter() {
        BasedataEdit costCenterF7 = (BasedataEdit)this.getControl("std_costcenter");
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (costCenterF7 != null) {
            costCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldPropValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        int parentRowIndex = valueSet[0].getParentRowIndex();
        IDataModel dataModel = this.getModel();
        IDataModel parentModel = this.getView().getParentView().getModel();
        String entityId = dataModel.getDataEntityType().getName();
        switch (propName) {
            case "entrycurrency": {
                if (propValue == null) {
                    propValue = valueSet[0].getOldValue();
                    this.getModel().setValue("entrycurrency", ((DynamicObject)propValue).getPkValue(), rowIndex);
                    break;
                }
                this.refreshExchangeRate(dataModel, (DynamicObject)propValue, "exchangerate", rowIndex);
                break;
            }
            case "exchangerate": {
                BigDecimal orgReimAmount = (BigDecimal)dataModel.getValue("expenseamount", rowIndex);
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)orgReimAmount, (String)"currexpenseamount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                if (dataModel.getProperty("price") == null || dataModel.getProperty("curprice") == null) break;
                BigDecimal price = (BigDecimal)dataModel.getValue("price", rowIndex);
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)price, (String)"curprice", (String)"exchangerate", (String)"entrycurrency", (String)"expquotetype", (int)rowIndex);
                break;
            }
            case "taxamount": {
                if (dataModel.getProperty("taxrate") != null && (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isApplyProjectBill((String)entityId) || ErEntityTypeUtils.isWithholdingBill((String)entityId) || ErEntityTypeUtils.isCostEstimateBill((String)entityId))) {
                    AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false);
                }
                this.setDefaultApproveTax(rowIndex);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false, (String)propName);
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) break;
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.TAX_AMOUNT);
                break;
            }
            case "expenseamount": {
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propValue), (String)"currexpenseamount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                if (dataModel.getProperty("taxrate") != null) {
                    BigDecimal taxRate = (BigDecimal)dataModel.getValue("taxrate", rowIndex);
                    if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isWithholdingBill((String)entityId) || ErEntityTypeUtils.isApplyProjectBill((String)entityId) || ErEntityTypeUtils.isCostEstimateBill((String)entityId)) {
                        AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                    }
                }
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) break;
                Object expenseAmountOri = dataModel.getValue("expenseamount", rowIndex);
                this.getModel().setValue("expeapproveamount", expenseAmountOri, rowIndex);
                break;
            }
            case "currexpenseamount": {
                BigDecimal approveAmountOld = (BigDecimal)dataModel.getValue("expeapproveamount", rowIndex);
                dataModel.setValue("expeapproveamount", dataModel.getValue("expenseamount", rowIndex), rowIndex);
                BigDecimal approveAmountNew = (BigDecimal)dataModel.getValue("expeapproveamount", rowIndex);
                if (approveAmountOld.compareTo(approveAmountNew) != 0) break;
                this.approveAmountChanged(approveAmountNew, entityId, rowIndex);
                break;
            }
            case "expeapproveamount": {
                this.approveAmountChanged((BigDecimal)propValue, entityId, rowIndex);
                if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
                    this.recountWriteBackAmount(dataModel, parentModel, rowIndex);
                }
                if (dataModel.getProperty("taxrate") != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    AmountChangeUtil.updateApproveInfo((IDataModel)this.getModel(), (int)rowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                    OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)propName);
                }
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)this.getView(), (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"currency", (ChangeField)ChangeField.EXPEAPPROVE_AMOUNT);
                break;
            }
            case "expenseitem": {
                if (BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) && propValue != null) {
                    BudgetCommonUtil.buildBudgetAmountField(this.getView(), rowIndex);
                }
                DynamicObject newExpenseItem = (DynamicObject)propValue;
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBill((String)entityId) && !ErEntityTypeUtils.isApplyProjectBill((String)entityId) && !ErEntityTypeUtils.isWithholdingBill((String)entityId) && !ErEntityTypeUtils.isCostEstimateBill((String)entityId) && !ErEntityTypeUtils.isDailyReimburseBillShare((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBillShare((String)entityId) || newExpenseItem == null) break;
                if (newExpenseItem.containsProperty("taxrate")) {
                    BigDecimal taxRateFromExpenseItem = newExpenseItem.getBigDecimal("taxrate");
                    InvoiceUtils.updateTaxWhenItemChange((IFormView)this.getView(), (IDataModel)dataModel, (BigDecimal)taxRateFromExpenseItem, (int)rowIndex, (int)parentRowIndex);
                }
                if (!newExpenseItem.containsProperty("offset")) break;
                Boolean itemOffset = newExpenseItem.getBoolean("offset");
                InvoiceUtils.updateOffsetWhenItemChange((IFormView)this.getView(), (IDataModel)dataModel, (Boolean)itemOffset, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "offset": {
                if (ErEntityTypeUtils.isWithholdingBill((String)entityId)) {
                    OffsetUtils.setWithholdingOffset((IDataModel)this.getModel(), (ChangeData[])valueSet);
                    break;
                }
                if (dataModel.getProperty("taxrate") != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)propName);
                }
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "taxrate": 
            case "airportconstructionfee": {
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBill((String)entityId) && !ErEntityTypeUtils.isDailyReimburseBillShare((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBillShare((String)entityId) && !ErEntityTypeUtils.isApplyProjectBill((String)entityId) && !ErEntityTypeUtils.isWithholdingBill((String)entityId) && !ErEntityTypeUtils.isCostEstimateBill((String)entityId)) break;
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)true);
                break;
            }
            case "std_project": {
                if (!BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache())) break;
                BudgetCommonUtil.buildBudgetAmountField(this.getView(), rowIndex);
                break;
            }
            case "approvetax": {
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)this.getView(), (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency", (ChangeField)ChangeField.APPROVE_TAX);
                if (!ErEntityTypeUtils.isDailyOrPubReimBill((String)entityId)) break;
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.APPROVE_TAX);
                break;
            }
            case "deductibletax": {
                if (ErEntityTypeUtils.isWithholdingBill((String)entityId)) break;
                BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex, parentRowIndex);
                if (!OffsetUtils.checkDeductibletax((BigDecimal)taxAmount, (BigDecimal)((BigDecimal)propValue))) {
                    dataModel.setValue("deductibletax", oldPropValue, rowIndex, parentRowIndex);
                    return;
                }
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)this.getView(), (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency", (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "std_entrycostcenter": {
                if (propValue == null || propValue == "" || !ErCostCenterUtil.isLeafCostCenter((Object)propValue)) break;
                ErCostCenterUtil.costEntryCenterChangeForMob((IFormView)this.getView(), (Object)propValue, (int)rowIndex);
            }
        }
    }

    private void approveAmountChanged(BigDecimal approveAmount, String entityId, int rowIndex) {
        IDataModel dataModel = this.getModel();
        AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)approveAmount, (String)"expeapprovecurramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
        if (ErEntityTypeUtils.isDailyApplyBill((String)entityId)) {
            this.modifyExpeBalanceRelAmount(dataModel, rowIndex);
            this.modifyExpeCanLoanAmount(dataModel, rowIndex);
        }
        if (ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            this.modifyExpeBalanceRelAmount(dataModel, rowIndex);
        }
    }

    private void modifyExpeCanLoanAmount(IDataModel dataModel, int rowIndex) {
        dataModel.beginInit();
        dataModel.setValue("canloanamount", dataModel.getValue("expeapproveamount", rowIndex), rowIndex);
        dataModel.setValue("canloancurramount", dataModel.getValue("expeapprovecurramount", rowIndex), rowIndex);
        dataModel.endInit();
    }

    private void modifyExpeBalanceRelAmount(IDataModel dataModel, int rowIndex) {
        dataModel.beginInit();
        dataModel.setValue("expebalanceamount", dataModel.getValue("expeapprovecurramount", rowIndex), rowIndex);
        dataModel.setValue("orgiexpebalanceamount", dataModel.getValue("expeapproveamount", rowIndex), rowIndex);
        dataModel.endInit();
    }

    private void refreshExchangeRate(IDataModel dataModel, DynamicObject entryCurrency, String exchangeRateProp, int rowIndex) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        String quoteType = "0";
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        Object costcompany = this.getView().getParentView().getModel().getValue("costcompany");
        Long currencyId = null;
        if (currency != null) {
            currencyId = (Long)((DynamicObject)this.getModel().getValue("currency")).getPkValue();
        } else if (currency == null && company != null) {
            currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)company, (Object)costcompany);
        }
        if (entryCurrency != null && currencyId != null && company != null) {
            Long srcCurrencyId = (Long)entryCurrency.getPkValue();
            Long targetCurrencyId = currencyId;
            Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costcompany, (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)dataModel);
            quoteType = (String)ObjectUtils.defaultIfNull(exchangeRateAndQuoteType.get("quoteType"), (Object)"0");
            exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull(exchangeRateAndQuoteType.get("exchangeRate"), (Object)BigDecimal.ONE);
        }
        if (dataModel.getProperty("expquotetype") != null) {
            dataModel.setValue("expquotetype", (Object)quoteType, rowIndex);
        }
        dataModel.setValue(exchangeRateProp, (Object)exchangeRate, rowIndex);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterBindData(EventObject e) {
        int entryRowCount;
        Object index;
        Object isMultiReimburser;
        String entityId;
        super.afterBindData(e);
        String bindDataKey = "ErDailyReimburseExpenseAddEdit-" + this.getView().getEntityId();
        this.getPageCache().put(bindDataKey, "bindData");
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map mapCustomParam = showParameter.getCustomParams();
        if (mapCustomParam != null && mapCustomParam.size() > 0 && mapCustomParam.get("isquerybudget") != null) {
            boolean isQueryBudget = (Boolean)mapCustomParam.get("isquerybudget");
            BudgetCommonUtil.setIsQueryBudgetFlag(this.getPageCache(), isQueryBudget);
            this.setBudgetShow(0);
        }
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object billStatus = formShowParameter.getCustomParam("billstatus");
        CoreBaseBillServiceHelper.setFromStatus((AbstractFormPlugin)this);
        ShowPageUtils.setMobilePageFormStatus((IFormView)this.getView());
        String costCompanyshowType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView().getParentView());
        model.setValue("expensesassumeshowtypes", (Object)costCompanyshowType);
        if (Objects.nonNull(model.getProperty("costorgusemode"))) {
            model.setValue("costorgusemode", this.getView().getParentView().getModel().getValue("costorgusemode"));
        }
        IDataModel parentModel = this.getView().getParentView().getModel();
        Object costCompanyId = formShowParameter.getCustomParam("costcompany");
        model.setValue("costcompany", costCompanyId);
        model.setValue("org", parentModel.getValue("org"));
        model.setValue("company", parentModel.getValue("company"));
        model.setValue("applier", parentModel.getValue("applier"));
        model.setValue("billstatus", parentModel.getValue("billstatus"));
        model.setValue("bizdate", parentModel.getValue("bizdate"));
        Object currency = this.getCurrency();
        if (currency != null) {
            model.setValue("currency", ErCommonUtils.getObjectValue((Object)currency));
        }
        Object iscurrency = formShowParameter.getCustomParam("iscurrency");
        if (model.getProperty("iscurrency") != null) {
            model.setValue("iscurrency", iscurrency);
        }
        if (mapCustomParam != null && mapCustomParam.containsKey("company") && model.getProperty("itemamountedit") != null) {
            boolean itemAmountEdit = SystemParamterUtil.isEnableItemAmountEdit((Long)Long.valueOf((String)mapCustomParam.get("company")));
            model.setValue("itemamountedit", (Object)itemAmountEdit);
        }
        if (!(ErEntityTypeUtils.isPrePayBill((String)(entityId = this.getView().getEntityId())) || ErEntityTypeUtils.isApplyPayBill((String)entityId) || ErEntityTypeUtils.isReimCtlApplyBill((String)entityId))) {
            this.pageRules(iscurrency);
        }
        if ((isMultiReimburser = formShowParameter.getCustomParam("ismultireimburser")) != null) {
            model.setValue("ismultireimburser", isMultiReimburser);
        }
        if ((index = formShowParameter.getCustomParam("index")) != null) {
            DynamicObjectCollection invoiceEntry;
            DynamicObjectCollection expenseColl = parentModel.getEntryEntity("expenseentryentity");
            model.beginInit();
            int newRowIndex = -1;
            if (!CollectionUtils.isEmpty((Collection)expenseColl)) {
                newRowIndex = MobileEntryUtil.addEntryToModel(this.getModel(), "expenseentryentity", (DynamicObject)expenseColl.get(((Integer)index).intValue()), true);
            }
            if (parentModel.getProperty("invoiceentry") != null && this.getModel().getProperty("invoiceentry") != null) {
                invoiceEntry = parentModel.getEntryEntity("invoiceentry");
                MobileEntryUtil.addCollectionToModel(this.getModel(), "invoiceentry", invoiceEntry);
            }
            if (parentModel.getProperty("invoiceitementry") != null && this.getModel().getProperty("invoiceitementry") != null) {
                invoiceEntry = parentModel.getEntryEntity("invoiceitementry");
                MobileEntryUtil.addCollectionToModel(this.getModel(), "invoiceitementry", invoiceEntry);
            }
            if (parentModel.getProperty("invoiceandexpense") != null && this.getModel().getProperty("invoiceandexpense") != null) {
                invoiceEntry = parentModel.getEntryEntity("invoiceandexpense");
                MobileEntryUtil.addCollectionToModel(this.getModel(), "invoiceandexpense", invoiceEntry);
            }
            model.endInit();
            this.getView().updateView("expenseentryentity", newRowIndex);
            if (newRowIndex > -1) {
                DynamicObject expenseItemEntryDO = (DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(newRowIndex);
                DynamicObject expenseItemEntryParentDO = (DynamicObject)expenseColl.get(Integer.parseInt(index.toString()));
                expenseItemEntryDO.set("id", expenseItemEntryParentDO.getPkValue());
                model.setValue("expenseitem", (Object)ErCommonUtils.getPk((Object)parentModel.getValue("expenseitem", Integer.parseInt(index.toString()))), newRowIndex);
            }
        }
        if (ErEntityTypeUtils.isPrePayBill((String)entityId)) {
            model.setValue("relationcontract", parentModel.getValue("relationcontract"));
        }
        if ((entryRowCount = this.getModel().getEntryRowCount("expenseentryentity")) > 0) {
            IDataModel pModel = this.getView().getParentView().getModel();
            DynamicObject costDept = (DynamicObject)pModel.getValue("costdept");
            DynamicObject costCompany = (DynamicObject)pModel.getValue("costcompany");
            DynamicObject costCenter = (DynamicObject)pModel.getValue("std_costcenter");
            for (int i = 0; i < entryRowCount; ++i) {
                FormShowParameter param = this.getView().getFormShowParameter();
                if (param.getCustomParam("entryedit") != null) continue;
                model.setValue("entrycurrency", ErCommonUtils.getObjectValue((Object)currency), i);
                model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), i);
                model.setValue("std_entrycostcenter", costCenter == null ? null : costCenter.getPkValue(), i);
                model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), i);
            }
        }
        Object sourcebillid = formShowParameter.getCustomParam("sourcebillid");
        if (ErEntityTypeUtils.isDailyLoanBill((String)formShowParameter.getParentFormId()) && sourcebillid != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"buttonap"});
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"entrycurrency", "exchangerate"});
            if (!"EDIT".equalsIgnoreCase(billStatus.toString()) && !"ADDNEW".equalsIgnoreCase(billStatus.toString())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mtoolbarap", "btn_save"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"expenseitem", "expenseamount", "remark"});
            }
        }
        if (ErEntityTypeUtils.isDailyApplyBill((String)formShowParameter.getParentFormId()) || ErEntityTypeUtils.isDailyReimburseBill((String)formShowParameter.getParentFormId())) {
            Object projecttype = parentModel.getValue("projecttype");
            this.getModel().setValue("projecttype", projecttype);
        }
        ShowPageUtils.setMobilePageFormStatus((IFormView)this.getView());
        if (mapCustomParam != null) {
            ErMobWorkFlowOtherViewEditUtils.setWorkFlowEditView((IFormView)this.getView(), (Map)mapCustomParam, (IDataModel)model, (int)1);
        }
        this.getPageCache().remove(bindDataKey);
    }

    private void pageRules(Object iscurrency) {
        if (iscurrency == null || Boolean.FALSE.equals(iscurrency)) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put("vi", false);
            this.getView().updateControlMetadata("exchangerate", map);
            this.getView().updateControlMetadata("currexpenseamount", map);
            this.getView().updateControlMetadata("entrycurrency", map);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btn_save": {
                DynamicObjectCollection orderEntity;
                DynamicObject dataEntity = this.getModel().getDataEntity(true);
                DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("expenseentryentity");
                DynamicObject currecncy = (DynamicObject)this.getModel().getValue("entrycurrency", 0);
                String requireds = "entrycurrency";
                for (DynamicObject expenseEntry : entryEntity) {
                    if (!CommonServiceHelper.requireValidate((DynamicObject)expenseEntry, (String[])requireds.split(","), (AbstractFormPlugin)this)) {
                        return;
                    }
                    if (expenseEntry.getDynamicObject("entrycurrency") != null) continue;
                    expenseEntry.set("entrycurrency", currecncy == null ? null : currecncy.getPkValue());
                }
                IFormView parentView = this.getView().getParentView();
                DynamicObject parentDataEntity = parentView.getModel().getDataEntity(true);
                DynamicObjectCollection parentExpenseEntry = parentDataEntity.getDynamicObjectCollection("expenseentryentity");
                FormShowParameter param = this.getView().getFormShowParameter();
                ArrayList entryList = Lists.newArrayList((Object[])new String[]{"invoiceitementry", "invoiceentry", "invoiceandexpense"});
                for (String entryName : entryList) {
                    DynamicObjectCollection invoiceEntity;
                    if (this.getModel().getProperty(entryName) == null && !parentDataEntity.containsProperty(entryName) || (invoiceEntity = dataEntity.getDynamicObjectCollection(entryName)) == null || invoiceEntity.size() <= 0) continue;
                    DynamicObjectCollection pInvoiceEntity = parentDataEntity.getDynamicObjectCollection(entryName);
                    EntryCopyUtil.copyDifColl2TargetColl((DynamicObjectCollection)pInvoiceEntity, (DynamicObjectCollection)invoiceEntity, (int)pInvoiceEntity.size());
                }
                if (this.getModel().getProperty("orderentry") != null && parentDataEntity.containsProperty("orderentry") && (orderEntity = dataEntity.getDynamicObjectCollection("orderentry")) != null && orderEntity.size() > 0) {
                    DynamicObjectCollection porderEntity = parentDataEntity.getDynamicObjectCollection("orderentry");
                    EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)porderEntity, (DynamicObjectCollection)orderEntity);
                }
                if (parentDataEntity.containsProperty("monthsettleamount") && dataEntity.containsProperty("monthsettleamount")) {
                    parentDataEntity.set("monthsettleamount", (Object)dataEntity.getBigDecimal("monthsettleamount"));
                }
                if (param.getCustomParam("entryedit") != null) {
                    int index = (Integer)param.getCustomParam("index");
                    EntryCopyUtil.updateColl2TargetColl((DynamicObjectCollection)parentExpenseEntry, (DynamicObjectCollection)entryEntity, (int)index);
                    if (parentExpenseEntry.getDynamicObjectType().getProperty("offset") != null) {
                        DynamicObject entryItem;
                        Boolean offset = (entryItem = (DynamicObject)parentExpenseEntry.get(index)).getBoolean("offset");
                        ChangeData changeData = new ChangeData(index, entryItem, (Object)(offset == false ? 1 : 0), (Object)offset);
                        ChangeData[] valueSet = new ChangeData[]{changeData};
                        InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)parentView, (int)valueSet[0].getRowIndex(), (int)valueSet[0].getParentRowIndex());
                    }
                } else {
                    EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)parentExpenseEntry, (DynamicObjectCollection)entryEntity);
                }
                for (int i = 0; i < parentExpenseEntry.size(); ++i) {
                    ((DynamicObject)parentExpenseEntry.get(i)).set("seq", (Object)(i + 1));
                }
                Object description = parentView.getModel().getValue("description");
                if (description == null || ((String)description).isEmpty()) {
                    ErTripReimAutoWriteDescription.setDiscription(parentView);
                }
                parentView.updateView();
                this.getView().sendFormAction(parentView);
                this.getView().close();
                break;
            }
            case "buttonap": {
                int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("expenseentryentity");
                this.setBudgetShow(entryCurrentRowIndex);
            }
        }
    }

    private void setBudgetShow(int rowIndex) {
        CardEntry cardEntry = (CardEntry)this.getControl("expenseentryentity");
        if (cardEntry != null) {
            if (BudgetCommonUtil.getIsQueryBudgetFlag(this.getPageCache()) || BudgetCommonUtil.getIsQueryEASBudgetFlag(this.getPageCache())) {
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    String budgeMsgValue = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)parentView.getModel().getValue("company")), (String)"budgeMsgControl");
                    if (StringUtils.isNotEmpty((String)budgeMsgValue)) {
                        if ("0".equals(budgeMsgValue)) {
                            cardEntry.setChildVisible(true, rowIndex, new String[]{"budgetamount"});
                            cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
                        } else if ("1".equals(budgeMsgValue)) {
                            cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                            cardEntry.setChildVisible(true, rowIndex, new String[]{"budgetmsg"});
                        }
                    } else {
                        cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                        cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
                    }
                } else {
                    cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                    cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
                }
            } else {
                cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetamount"});
                cardEntry.setChildVisible(false, rowIndex, new String[]{"budgetmsg"});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        int entryRowCount;
        super.afterCreateNewData(e);
        String entityId = this.getView().getEntityId();
        IFormView parentView = this.getView().getParentView();
        IDataModel model = this.getModel();
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            int entryRowCount2 = model.getEntryRowCount("expenseentryentity");
            if (entryRowCount2 == 0) {
                model.createNewEntryRow("expenseentryentity");
            }
            model.setValue("is_special_invoice", (Object)0, 0);
            if (model.getProperty("automapinvoice") != null && parentView != null && parentView.getModel().getProperty("automapinvoice") != null) {
                model.setValue("automapinvoice", parentView.getModel().getValue("automapinvoice"));
            }
        } else if (ErEntityTypeUtils.isPrePayBill((String)entityId) && parentView != null) {
            Boolean bo = (Boolean)parentView.getModel().getValue("iscurrency");
            model.setValue("iscurrency", (Object)bo);
            model.setValue("detailtype", parentView.getModel().getValue("detailtype"));
        } else if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId) && (entryRowCount = model.getEntryRowCount("expenseentryentity")) == 0) {
            model.createNewEntryRow("expenseentryentity");
        }
    }

    private Object getCurrency() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object currency = formShowParameter.getCustomParam("currency");
        return currency;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if ("expenseentryentity".equals(entryName) && (rowDataEntities = e.getRowDataEntities()).length > 0) {
            Object currency = this.getCurrency();
            IFormView pView = this.getView().getParentView();
            IDataModel pModel = pView.getModel();
            DynamicObject costDept = (DynamicObject)pModel.getValue("costdept");
            DynamicObject costCompany = (DynamicObject)pModel.getValue("costcompany");
            String contractcode = "";
            String contractname = "";
            if (ErEntityTypeUtils.isPrePayBill((String)pView.getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)pView.getEntityId())) {
                String relationcontract = (String)pModel.getValue("relationcontract");
                boolean ispush = Boolean.FALSE;
                if (ErEntityTypeUtils.isPrePayBill((String)pView.getEntityId())) {
                    ispush = (Boolean)pModel.getValue("ispush");
                    if ("1".equals(relationcontract) && !ispush && pModel.getEntryEntity("contractentry").size() > 0) {
                        contractcode = (String)pModel.getValue("contractcode", 0);
                        contractname = (String)pModel.getValue("contractname", 0);
                    }
                } else {
                    if ("true".equals(pModel.getValue("ispush"))) {
                        ispush = Boolean.TRUE;
                    }
                    Boolean frameworkcontract = (Boolean)pModel.getValue("frameworkcontract");
                    if ("1".equals(relationcontract) && pModel.getEntryEntity("contractentry").size() > 0 && (Boolean.FALSE.equals(frameworkcontract) || Boolean.TRUE.equals(frameworkcontract) && Boolean.FALSE.equals(ispush))) {
                        contractcode = (String)pModel.getValue("contractcode", 0);
                        contractname = (String)pModel.getValue("contractname", 0);
                    }
                }
            }
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                model.setValue("entrycurrency", ErCommonUtils.getObjectValue((Object)currency), rowIndex);
                model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), rowIndex);
                model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), rowIndex);
                ErCostCenterUtil.initEntryCostCenter((IDataModel)this.getModel(), (String)"expenseentryentity", (int)rowIndex, (int)-1);
                if (!ErEntityTypeUtils.isPrePayBill((String)pView.getEntityId()) && !ErEntityTypeUtils.isPublicReimburseBill((String)pView.getEntityId())) continue;
                model.setValue("entrycontractno", (Object)contractcode, rowIndex);
                model.setValue("entrycontractname", (Object)contractname, rowIndex);
            }
        }
    }

    protected Set<String> getSerialNosByInvoiceNoAndCode(Set<String> invoiceNos, Set<String> invoiceCodes) {
        Set<Object> serialNos = Sets.newHashSet();
        if (invoiceNos.isEmpty() || invoiceCodes.isEmpty()) {
            logger.info("\u53d1\u7968\u53f7\u7801\u6216\u53d1\u7968\u4ee3\u7801\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u8be2\u53d1\u7968\u5e8f\u5217\u53f7.");
            return serialNos;
        }
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity(true);
        DynamicObjectCollection invoiceHeadEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceMergeEntryDOs = new DynamicObjectCollection();
        boolean hasInvoiceMergeEntry = dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoicemerge");
        if (hasInvoiceMergeEntry) {
            invoiceMergeEntryDOs = dataEntity.getDynamicObjectCollection("invoicemerge");
        }
        if (invoiceHeadEntryDOs.isEmpty() || invoiceMergeEntryDOs.isEmpty()) {
            logger.info("\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u6216\u53d1\u7968\u5408\u5e76\u4fe1\u606f\u5206\u5f55\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u8be2\u53d1\u7968\u5e8f\u5217\u53f7.");
            return serialNos;
        }
        Set keySerialNos = invoiceHeadEntryDOs.stream().filter(invoiceHead -> invoiceNos.contains(invoiceHead.getString("invoiceno")) && invoiceCodes.contains(invoiceHead.getString("invoicecode"))).map(invoiceHead -> invoiceHead.getString("serialno")).collect(Collectors.toSet());
        if (keySerialNos.isEmpty()) {
            logger.info("\u6839\u636e\u53d1\u7968\u53f7\u7801,\u53d1\u7968\u4ee3\u7801\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u53d1\u7968.\u53d1\u7968\u53f7\u7801:" + invoiceNos + ",\u53d1\u7968\u4ee3\u7801:" + invoiceCodes);
            return serialNos;
        }
        serialNos = invoiceMergeEntryDOs.stream().filter(invoiceMerge -> keySerialNos.contains(invoiceMerge.getString("keyserialno"))).map(invoiceMerge -> invoiceMerge.getString("serialno_merge")).collect(Collectors.toSet());
        return serialNos;
    }

    private void refreshDeductibletax(IDataModel dataModel, BigDecimal taxAmount, int rowIndex) {
        if (dataModel.getProperty("offset") == null) {
            return;
        }
        if (((Boolean)dataModel.getValue("offset", rowIndex)).booleanValue()) {
            dataModel.setValue("deductibletax", (Object)taxAmount, rowIndex);
        } else {
            dataModel.setValue("deductibletax", (Object)BigDecimal.ZERO, rowIndex);
        }
    }

    private void recountWriteBackAmount(IDataModel model, IDataModel parentModel, int index) {
        String quoteType;
        IFormView view = this.getView();
        int parentIndex = index;
        if (view != null && view.getFormShowParameter() != null && view.getFormShowParameter().getCustomParam("index") != null) {
            parentIndex = (Integer)view.getFormShowParameter().getCustomParam("index");
        }
        String writeOffType = (String)parentModel.getValue("writeofftype");
        BigDecimal wbExchangRate = (BigDecimal)parentModel.getValue("wbexchangrate", parentIndex);
        String string = quoteType = parentModel.getProperty("wbquotetype") == null ? "0" : (String)parentModel.getValue("wbquotetype", parentIndex);
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeOffType)) {
            BigDecimal amount = (BigDecimal)model.getValue("expeapproveamount", index);
            BigDecimal curAmount = BigDecimal.ZERO;
            if (wbExchangRate != null && wbExchangRate.compareTo(BigDecimal.ZERO) != 0) {
                curAmount = org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? amount.multiply(wbExchangRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP) : amount.divide(wbExchangRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP);
            }
            logger.info("---amount---" + amount + "---curAmount---" + curAmount);
            model.setValue("wbamount", (Object)amount, index);
            model.setValue("wbcuramount", (Object)curAmount, index);
        } else {
            BigDecimal curAmount = (BigDecimal)model.getValue("expeapprovecurramount", index);
            model.setValue("wbcuramount", (Object)curAmount, index);
            if (wbExchangRate != null && wbExchangRate.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal amount = org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? curAmount.divide(wbExchangRate, AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP) : curAmount.multiply(wbExchangRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)model, (String)"wbcurrency"), RoundingMode.HALF_UP);
                model.setValue("wbamount", (Object)amount, index);
                logger.info("---WBAMOUNT---" + amount);
            } else {
                model.setValue("wbamount", (Object)BigDecimal.ZERO, index);
            }
            logger.info("---curAmount---" + curAmount);
        }
    }

    private void setDefaultApproveTax(int rowIndex) {
        if (this.getModel().getProperty("approvetax") != null) {
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex);
            this.getModel().setValue("approvetax", (Object)taxAmount, rowIndex);
        }
    }

    private boolean validateExpeCurrAmount(int rowIndex) {
        IDataModel dataModel = this.getModel();
        BigDecimal expeApproveAmount = (BigDecimal)dataModel.getValue("expeapproveamount", rowIndex);
        BigDecimal expenseAmount = (BigDecimal)dataModel.getValue("expenseamount", rowIndex);
        Boolean expisredoffset = Boolean.FALSE;
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId())) {
            expisredoffset = (Boolean)dataModel.getValue("expisredoffset", rowIndex);
        }
        if (!(expisredoffset.booleanValue() && expeApproveAmount.compareTo(BigDecimal.ZERO) < 0 || expeApproveAmount.compareTo(expenseAmount) <= 0)) {
            dataModel.setValue("expeapproveamount", (Object)expenseAmount, rowIndex);
            return false;
        }
        return true;
    }
}

