/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.reimburse.listener;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.amount.control.feestandard.FeeStandardHelper;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemRangeImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class BeforeExpenseItemF7SelectListener
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(BeforeExpenseItemF7SelectListener.class);
    private IFormView view;
    private String number = null;
    private String entryCostDeptKey;
    private Long costDeptPkId;

    public BeforeExpenseItemF7SelectListener(IFormView view, String number, String entryCostDeptKey) {
        this.view = view;
        this.number = number;
        this.entryCostDeptKey = entryCostDeptKey;
    }

    private void setCostDeptPkId(Long costDeptPkId) {
        this.costDeptPkId = costDeptPkId;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String propName = arg0.getProperty().getName();
        if ("expenseitem".equals(propName) || "tripexpenseitem".equalsIgnoreCase(propName) || "headexpenseitem".equals(propName) || "travelexpenseitem".equals(propName) || "entryexpenseitem".equals(propName) || "entrytravelexpenseitem".equals(propName)) {
            Map<String, Long> costorgMap = this.getCostOrgIDByView(this.view, propName, arg0.getRow());
            if (this.view instanceof IMobileView && ErStdConfig.getBoolean((String)"mobile_expenseitem_treeview")) {
                arg0.setCancel(true);
                MobileFormShowParameter para = new MobileFormShowParameter();
                para.setFormId("er_expenseitem_mobilelist");
                para.getOpenStyle().setShowType(ShowType.Floating);
                para.setCustomParam("entityId", (Object)"er_expenseitemedit");
                para.setCustomParam("formIdSign", (Object)this.number);
                para.setCustomParam("costOrgId", (Object)costorgMap.get("costDeptId"));
                para.setCustomParam("costcompanyId", (Object)costorgMap.get("costCompanyId"));
                DynamicObject company = (DynamicObject)this.view.getModel().getValue("company");
                List empCltList = SystemParamterUtil.getEmpCltBillList((Long)((Long)company.getPkValue()));
                List deptCltList = SystemParamterUtil.getDeptCltBillList((Long)((Long)company.getPkValue()));
                boolean empNotContainsTrip = !empCltList.contains("2");
                boolean deptNotContainsTrip = !deptCltList.contains("2");
                para.setCustomParam("empNotContainsTrip", (Object)empNotContainsTrip);
                para.setCustomParam("deptNotContainsTrip", (Object)deptNotContainsTrip);
                CloseCallBack closeCallBack = new CloseCallBack();
                closeCallBack.setControlKey(arg0.getProperty().getName());
                para.setCloseCallBack(closeCallBack);
                this.view.showForm((FormShowParameter)para);
            } else {
                QFilter qFilterByProjecttype;
                Long enrtryCostDept;
                ListShowParameter cardF7Param = (ListShowParameter)arg0.getFormShowParameter();
                QFilter treeFilter = null;
                treeFilter = ErEntityTypeUtils.isTripReimburseBill((String)this.view.getEntityId()) && StringUtils.equals((CharSequence)"travelcostdept", (CharSequence)this.entryCostDeptKey) && this.view.getModel().getProperty("stdbilltype") != null && StringUtils.equals((CharSequence)((DynamicObject)this.view.getModel().getValue("stdbilltype")).getString("number"), (CharSequence)"er_tripreimbursebill_BT_S") && (enrtryCostDept = costorgMap.get("costDeptId")) != null ? ExpenseItemServiceHelper.getRelExpItemsFilter((String)this.number, (Long)enrtryCostDept) : ExpenseItemServiceHelper.getRelExpItemsFilter((String)this.number, (Long)this.costDeptPkId);
                boolean bizFilter = this.filterByBizItem(this.view, arg0);
                QFilter qFilterByGoodName = this.filterByInvoiceGoodName(this.view, propName, arg0.getRow());
                if (qFilterByGoodName != null) {
                    treeFilter = treeFilter.and(qFilterByGoodName);
                }
                if ((qFilterByProjecttype = this.filterByProjecttype(this.view, propName)) != null) {
                    treeFilter = treeFilter.and(qFilterByProjecttype);
                }
                if (bizFilter) {
                    cardF7Param.getTreeFilterParameter().getQFilters().add(treeFilter);
                    cardF7Param.getListFilterParameter().getQFilters().add(treeFilter);
                    return;
                }
                List<Long> expenseItemId = BeforeExpenseItemF7SelectListener.getUpBillExpItemId(this.view);
                if (expenseItemId != null) {
                    treeFilter.or(new QFilter("id", "in", expenseItemId));
                }
                cardF7Param.getListFilterParameter().getQFilters().add(treeFilter);
                cardF7Param.getListFilterParameter().getQFilters().add(QFilter.of((String)"isleaf=?", (Object[])new Object[]{Boolean.TRUE}));
                ArrayList<QFilter> treeQFilterList = new ArrayList<QFilter>(1);
                treeQFilterList.add(treeFilter);
                cardF7Param.setCustomParam("treeFilter", (Object)treeFilter.toSerializedString());
                cardF7Param.getTreeFilterParameter().setQFilters(treeQFilterList);
            }
        }
    }

    private static List<Long> getUpBillExpItemId(IFormView view) {
        String billType;
        List result = new ArrayList();
        IDataModel model = view.getModel();
        if (!BeforeExpenseItemF7SelectListener.isPCBill(view) && StringUtils.isNotBlank((CharSequence)view.getFormShowParameter().getParentPageId())) {
            model = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId()).getModel();
        }
        if (model.getProperty("writeoffapply") != null && model.getProperty("writeoffmoney") != null) {
            result = ExpenseItemServiceHelper.getUpBillExpItemId((DynamicObject)model.getDataEntity(true));
        }
        if (ErEntityTypeUtils.isShareBill((String)(billType = model.getDataEntity(true).getDynamicObjectType().getName())) || ErEntityTypeUtils.isDailyLoanBill((String)billType)) {
            result = ExpenseItemServiceHelper.getUpBillExpItemId((DynamicObject)model.getDataEntity(true));
        }
        return result;
    }

    private Map<String, Long> getCostOrgIDByView(IFormView view, String propName, int rowIndex) {
        IDataModel model = view.getModel();
        Long costDeptId = 0L;
        Long costCompanyId = 0L;
        if ("headexpenseitem".equals(propName)) {
            costDeptId = ErCommonUtils.getPk((Object)model.getDataEntity().getDynamicObject("costdept"));
            costCompanyId = ErCommonUtils.getPk((Object)model.getDataEntity().getDynamicObject("costcompany"));
        } else if ("travelexpenseitem".equals(propName) || "entrytravelexpenseitem".equals(propName)) {
            if (BeforeExpenseItemF7SelectListener.isPCBill(view)) {
                costDeptId = ErCommonUtils.getPk((Object)model.getValue("travelcostdept", rowIndex, 0));
                costCompanyId = ErCommonUtils.getPk((Object)model.getValue("travelcostcompany", rowIndex, 0));
            } else {
                costDeptId = ErCommonUtils.getPk((Object)model.getValue("travelcostdept", rowIndex));
                costCompanyId = ErCommonUtils.getPk((Object)model.getValue("travelcostcompany", rowIndex));
            }
        } else if ("entryexpenseitem".equals(propName)) {
            costDeptId = ErCommonUtils.getPk((Object)model.getValue("entrycostdept_orgrule", rowIndex));
            costCompanyId = ErCommonUtils.getPk((Object)model.getValue("entrycostcompany_orgrule", rowIndex));
        } else {
            costDeptId = ErCommonUtils.getPk((Object)model.getValue("entrycostdept", rowIndex));
            costCompanyId = ErCommonUtils.getPk((Object)model.getValue("entrycostcompany", rowIndex));
        }
        this.setCostDeptPkId(costDeptId);
        HashMap<String, Long> costorgMap = new HashMap<String, Long>();
        costorgMap.put("costDeptId", costDeptId);
        costorgMap.put("costCompanyId", costCompanyId);
        return costorgMap;
    }

    private static boolean isPCBill(IFormView view) {
        String modelType = view.getFormShowParameter().getFormConfig().getModelType();
        return modelType.equalsIgnoreCase("bill");
    }

    private QFilter filterByInvoiceGoodName(IFormView view, String propertyName, int index) {
        MappingItemRangeImpl.ExpRangeFactor factor;
        MappingItemRangeImpl impl;
        Set ids;
        String goodName;
        Set entityNames;
        if (!"expenseitem".equals(propertyName)) {
            return null;
        }
        IDataModel model = view.getModel();
        String entityName = model.getDataEntityType().getName();
        String bills = ErStdConfig.get((String)"ext.exprangelimitentities");
        Set set = entityNames = StringUtils.isBlank((CharSequence)bills) ? Collections.emptySet() : Arrays.stream(bills.split(",")).collect(Collectors.toSet());
        if (!(ErEntityTypeUtils.isPublicReimburseBillShare((String)entityName) || ErEntityTypeUtils.isDailyReimburseBillShare((String)entityName) || ErEntityTypeUtils.isDailyOrPubReimBill((String)entityName) || entityNames.contains(entityName))) {
            return null;
        }
        Long companyId = ErCommonUtils.getPk((Object)model.getValue("company"));
        boolean enable = SystemParamterUtil.isEnableExpItemFilterByInvoice((Long)companyId);
        if (!enable || view.getControl("expenseitem") == null) {
            return null;
        }
        Object invoiceType = model.getValue("invoicetypeitem", index);
        boolean hasProperty = model.getProperty("expensegoodsname") != null;
        String string = goodName = hasProperty ? (String)model.getValue("expensegoodsname", index) : "";
        if ((invoiceType != null || StringUtils.isNotBlank((CharSequence)goodName)) && (ids = (impl = new MappingItemRangeImpl(MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem, factor = new MappingItemRangeImpl.ExpRangeFactor(invoiceType == null ? "" : invoiceType.toString(), goodName), model.getDataEntity())).getItemIds()) != null) {
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            return qFilter;
        }
        return null;
    }

    private QFilter filterByProjecttype(IFormView view, String propertyName) {
        List numbers;
        IDataEntityProperty property = view.getModel().getProperty("projecttype");
        if (!"expenseitem".equals(propertyName) && !"er_billingpool".equals(this.number) || property == null) {
            return null;
        }
        DynamicObject projecttype = (DynamicObject)view.getModel().getValue("projecttype");
        if (projecttype != null && !(numbers = projecttype.getDynamicObjectCollection("entryentity").stream().map(a -> a.getLong("expenseitem.id")).collect(Collectors.toList())).isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", numbers);
            return qFilter;
        }
        return null;
    }

    private boolean filterByBizItem(IFormView view, BeforeF7SelectEvent p0) {
        IDataModel model = view.getModel();
        if (model.getProperty("bizitem") == null) {
            return false;
        }
        DynamicObject bizItem = (DynamicObject)model.getValue("bizitem");
        Set nums = FeeStandardHelper.getStandardTypeFilterInExpenseItem((DynamicObject)bizItem);
        if (nums.isEmpty()) {
            return false;
        }
        ListShowParameter formShowParameter = (ListShowParameter)p0.getFormShowParameter();
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        QFilter basedDataQFilter = this.getBasedDataQFilter(qFilters);
        if (basedDataQFilter == null) {
            basedDataQFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)ErCommonUtils.getPk((Object)model.getValue("entrycostcompany", p0.getRow())));
        }
        formShowParameter.getListFilterParameter().getQFilters().clear();
        formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("number", "in", (Object)nums));
        formShowParameter.getTreeFilterParameter().getQFilters().clear();
        formShowParameter.getTreeFilterParameter().getQFilters().addAll(formShowParameter.getListFilterParameter().getQFilters());
        if (basedDataQFilter != null) {
            formShowParameter.getListFilterParameter().getQFilters().add(basedDataQFilter);
        }
        return true;
    }

    private QFilter getBasedDataQFilter(List<QFilter> qFilters) {
        for (int i = 0; i < qFilters.size(); ++i) {
            if (!"ctrlstrategy".equals(qFilters.get(i).getProperty())) continue;
            return qFilters.get(i);
        }
        StringBuilder sb = new StringBuilder("match_ctrlstrategy_fail:qfilters:");
        qFilters.forEach(qf -> sb.append(qf.toString()).append(";"));
        log.info(sb.toString());
        return null;
    }

    @Deprecated
    public QFilter getExpenseItemTreeFilter() {
        return new QFilter("1", "=", (Object)1);
    }

    @Deprecated
    public static List<String> exceptRelExpItems(Long costDeptId) {
        return new ArrayList<String>();
    }

    @Deprecated
    public BeforeExpenseItemF7SelectListener(IFormView view, String number, Long costDeptId) {
        this.view = view;
        this.number = number;
        this.costDeptPkId = costDeptId;
    }

    @Deprecated
    public List<Long> getUpExpenseitemId(IDataModel model, boolean isCurrentView) {
        return new ArrayList<Long>();
    }
}

