/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.reimburse.topublic;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.pub.PublicUpBillUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ReimburseUtils;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.common.CommonUtilHelper;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.daily.web.reimburse.ErReimburseBaseBillEdit;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.mobile.amount.query.AmountQueryAndReimburseForMobUtils;
import kd.fi.er.formplugin.publicbiz.bill.common.ChangedAccountByPayer;
import kd.fi.er.formplugin.util.OffsetUtils;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.StringUtils;

public class ErPublicReimburseBillEditMobPlugin
extends AbstractMobBillPlugIn {
    private static Log logger = LogFactory.getLog(ErPublicReimburseBillEditMobPlugin.class);
    private static String PAYERACCOUNT_FLEX = "payeraccount_flex";
    private static String BANK_LABEL = "payer_label";
    private static String ACCOUNT_LABEL = "account_label";
    private static String NEXT_IMG = "payer_next_img";
    private static String[] EDITSTATUS = new String[]{"A", "D"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PAYERACCOUNT_FLEX});
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.fillAccountShowInfo();
    }

    public void afterBindData(EventObject e) {
        String formId;
        super.afterBindData(e);
        IFormView thisview = this.getView();
        IDataModel dataModel = this.getModel();
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (!Arrays.asList(EDITSTATUS).contains(billstatus)) {
            thisview.setVisible(Boolean.valueOf(false), new String[]{NEXT_IMG});
            thisview.setEnable(Boolean.valueOf(false), new String[]{PAYERACCOUNT_FLEX});
        }
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("isFirst"))) {
            this.getPageCache().put("isFirst", "true");
            String pageCopyData = this.getPageCache().get("pageCopyData");
            if (StringUtils.isEmpty((CharSequence)pageCopyData)) {
                this.fillAccountShowInfo();
            } else {
                this.getPageCache().remove("pageCopyData");
            }
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)(formId = thisview.getEntityId()))) {
            DynamicObject billpayer = (DynamicObject)this.getModel().getValue("billpayerid");
            if (billpayer != null) {
                ChangedAccountByPayer.setTotalbillPayeramountLab(this.getModel(), this.getView(), billpayer);
            }
            if (dataModel.getDataEntity().getDataEntityState().isPushChanged()) {
                DynamicObjectCollection expense = dataModel.getEntryEntity("expenseentryentity");
                if (expense != null && expense.size() > 0) {
                    BigDecimal totalAmount = BigDecimal.ZERO;
                    for (int i = 0; i < expense.size(); ++i) {
                        BigDecimal approveCurrAmount = (BigDecimal)dataModel.getValue("expeapprovecurramount", i);
                        totalAmount = totalAmount.add(approveCurrAmount);
                    }
                    this.getModel().setValue("payamount", (Object)totalAmount);
                } else if (dataModel.getEntryRowCount("accountentry") > 0) {
                    dataModel.deleteEntryData("accountentry");
                    logger.info("----\u591a\u51fa\u4e86\u591a\u4f59\u7684\u6536\u6b3e\u660e\u7ec6\u5e94\u8be5\u5c06\u5176\u5220\u9664\uff0c\u5bf9\u4e8e\u79fb\u52a8\u7aef\u6765\u8bf4\u5982\u679c\u8d39\u7528\u660e\u7ec6\u4e3a\u7a7a\u662f\u4e0d\u5e94\u8be5\u6709\u6536\u6b3e\u660e\u7ec6\u6570\u636e\uff0c\u4e14\u6b64\u573a\u666f\u6536\u6b3e\u8d26\u6237\u5e01\u79cd\u4e3a\u7a7a\uff0c\u9488\u5bf9\u6536\u6b3e\u5206\u5f55\u662f\u5426\u53d6\u8d26\u6237\u5e01\u79cd:\u662f\u7684\u573a\u666f\uff0c\u53ef\u80fd\u4f1a\u5bfc\u81f4\u7a7a\u6307\u9488\uff0c\u51fa\u73b0\u4e2d\u65ad\u95ee\u9898----");
                }
                BigDecimal payAmount = (BigDecimal)dataModel.getValue("payamount");
                if (payAmount != null && payAmount.compareTo(BigDecimal.ZERO) > 0) {
                    WriteOffMoneyUtils.showPayAmount((IDataModel)dataModel, (Label)((Label)this.getControl("label_account_amount")));
                    thisview.updateView("label_account_amount");
                    AmountChangeUtil.refreshReceiveAmount((IFormView)thisview, (IDataModel)dataModel, (BigDecimal)payAmount, (String)((String)dataModel.getValue("writeofftype")));
                    thisview.updateView("orireceiveamount", 0);
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.fillAccountShowInfo();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String clickName = source.getKey();
        if (clickName.equals(PAYERACCOUNT_FLEX)) {
            this.showSelectPayerAccount();
        }
    }

    private void showSelectPayerAccount() {
        DynamicObjectCollection payerAccountInfo;
        IDataModel thisModel = this.getModel();
        IFormView thisView = this.getView();
        String payerType = (String)thisModel.getValue("payertype_mob");
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (!Arrays.asList(EDITSTATUS).contains(billstatus)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)payerType)) {
            thisView.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u6b3e\u4eba\u7c7b\u578b\u3002", (String)"ErPublicReimburseBillEditMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        if (PayerTypeEnum.OTHER.getType().equals(payerType)) {
            thisView.showErrorNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u7c7b\u578b\u4e3a\u201c\u5176\u4ed6\u201d\uff0c\u4e0d\u652f\u6301\u5728\u79fb\u52a8\u7aef\u4fee\u6539\u201c\u6536\u6b3e\u4eba\u201d\u3002", (String)"ErPublicReimburseBillEditMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("payerType", payerType);
        if (PayerTypeEnum.PAYER.getType().equals(payerType)) {
            Long applierId = (Long)((DynamicObject)thisModel.getValue("applier")).getPkValue();
            customParam.put("applier", applierId);
        }
        if ((payerAccountInfo = thisModel.getEntryEntity("accountentry")) != null && payerAccountInfo.size() > 0) {
            DynamicObject accountOne = (DynamicObject)payerAccountInfo.get(0);
            Object payerId = PublicReimbursePayerAcctUtils.getPayerPkId((IDataModel)this.getModel(), (String)payerType);
            String account = accountOne.getString("payeraccount");
            DynamicObject bank = accountOne.getDynamicObject("payerbank");
            String payerName = accountOne.getString("payername");
            if (payerId != null) {
                AccountInfo accountInfo = new AccountInfo();
                accountInfo.setPayerId(payerId);
                accountInfo.setAccount(account);
                if (bank != null) {
                    accountInfo.setBeBank(bank.getPkValue());
                }
                accountInfo.setAccountName(payerName);
                customParam.put("accountInfo", accountInfo);
            }
        }
        FormModel formModel = new FormModel("er_public_payerselect_mb", ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4fe1\u606f", (String)"ErPublicReimburseBillEditMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true, customParam);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IDataModel thisModel = this.getModel();
        if (actionId.equals("er_public_payerselect_mb")) {
            DynamicObjectCollection payerAccountInfo = thisModel.getEntryEntity("accountentry");
            if (payerAccountInfo == null || payerAccountInfo.size() <= 0) {
                thisModel.createNewEntryRow("accountentry");
            }
            AccountInfo accountInfo = (AccountInfo)closedCallBackEvent.getReturnData();
            logger.info("\u5bf9\u516c\u62a5\u9500\u79fb\u52a8\u7aef\u586b\u5199\u94f6\u884c\u8d26\u53f7\u4fe1\u606f->" + accountInfo);
            String payerTypeOne = (String)thisModel.getValue("payertype_mob");
            if (!StringUtils.isEmpty((CharSequence)payerTypeOne) && accountInfo != null) {
                PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerTypeOne);
                thisModel.setValue(payerTypeEnum.name(), accountInfo.getPayerId(), 0);
                thisModel.setValue("payername", (Object)accountInfo.getAccountName(), 0);
                thisModel.setValue("payertype", (Object)payerTypeOne, 0);
                PublicReimbursePayerAcctUtils.fillBankInfo((IDataModel)this.getModel(), (AccountInfo)accountInfo, (Integer)0);
                this.fillAccountShowInfo();
            }
        }
    }

    private void fillAccountShowInfo() {
        IDataModel model = this.getModel();
        DynamicObjectCollection payerAccountInfo = model.getDataEntity(true).getDynamicObjectCollection("accountentry");
        if (payerAccountInfo != null && payerAccountInfo.size() > 0) {
            DynamicObject accountOne = (DynamicObject)payerAccountInfo.get(0);
            model.setValue("payertype_mob", (Object)accountOne.getString("payertype"));
            StringBuilder accountlable = new StringBuilder();
            accountlable.append(accountOne.getString("payername"));
            accountlable.append(accountOne.getString("payeraccount01"));
            DynamicObject accountBank = accountOne.getDynamicObject("payerbank");
            String bankName = accountBank == null ? "" : accountBank.getLocaleString("name").getLocaleValue();
            Label bank_label = (Label)this.getControl(BANK_LABEL);
            Label account_label = (Label)this.getControl(ACCOUNT_LABEL);
            bank_label.setText(bankName);
            account_label.setText(accountlable.toString());
        } else {
            model.setValue("payertype_mob", (Object)PayerTypeEnum.SUPPLIER.getType());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeName;
        switch (changeName = e.getProperty().getName()) {
            case "payertype_mob": {
                this.clearAccountShowInfo();
                PublicReimbursePayerAcctUtils.clearOldPayer((IFormView)this.getView(), (Integer)0, null);
                break;
            }
            case "company": {
                Object propValue = e.getChangeSet()[0].getOldValue();
                if (propValue != null && !propValue.toString().equals("-1")) {
                    this.getModel().deleteEntryData("accountentry");
                    this.getModel().createNewEntryRow("accountentry");
                    this.clearAccountShowInfo();
                }
            }
            case "currency": {
                this.changeTotalBillPayerAmountLabel();
                break;
            }
            case "billpayertype": 
            case "billpayerid": {
                if (!ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDataEntityType().getName())) break;
                String detailType = (String)this.getModel().getValue("detailtype");
                if (StringUtils.equalsIgnoreCase((CharSequence)detailType, (CharSequence)"biztype_other")) {
                    return;
                }
                PublicUpBillUtil.deleteEntryByBillpayerChanged((IFormView)this.getView());
                CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
                OffsetUtils.setHeadSumOffsetAmount((IDataModel)this.getModel());
                CommonUtilHelper.setWriteOffAmountLable(this.getModel(), this.getView(), new boolean[0]);
                BigDecimal totalOffsetAmount = ReimburseUtils.sumOffsetAmount((IDataModel)this.getModel(), (IFormView)this.getView());
                this.getModel().setValue("totaloffsetamount", (Object)totalOffsetAmount);
                WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)this.getModel(), (String)((String)this.getModel().getValue("writeofftype")), (IFormView)this.getView());
                AmountQueryAndReimburseForMobUtils.clearEntry(this.getModel(), "accountentry");
                ErReimburseBaseBillEdit.refreshBillHeadAmount(this.getModel());
            }
        }
    }

    private void clearAccountShowInfo() {
        Label bank_label = (Label)this.getControl(BANK_LABEL);
        Label account_label = (Label)this.getControl(ACCOUNT_LABEL);
        bank_label.setText("");
        account_label.setText("");
    }

    private void changeTotalBillPayerAmountLabel() {
        if (this.getControl("lab_totalbillpayeramount") != null && this.getModel().getProperty("billpayerid") != null) {
            DynamicObject billpayer = (DynamicObject)this.getModel().getValue("billpayerid");
            ChangedAccountByPayer.setTotalbillPayeramountLab(this.getModel(), this.getView(), billpayer);
        }
    }
}

