/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.repayment;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.ShowPageUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ErRepayBillEntryMobEdit
extends AbstractMobBillPlugIn {
    private static final String SAVE = "save";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE});
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        IDataModel selfModel = this.getModel();
        DynamicObjectCollection entry = parentModel.getDataEntity(true).getDynamicObjectCollection("repaymententry");
        int parentCurrentRowIndex = parentModel.getEntryCurrentRowIndex("repaymententry");
        DynamicObject currRow = (DynamicObject)entry.get(parentCurrentRowIndex);
        Set parentProperties = currRow.getDataEntityType().getProperties().stream().map(v -> v.getName()).collect(Collectors.toSet());
        Set selfProperties = selfModel.getDataEntityType().getProperties().stream().map(v -> v.getName()).collect(Collectors.toSet());
        for (String property : selfProperties) {
            if (parentProperties.contains(property)) {
                selfModel.setValue(property, currRow.get(property));
                continue;
            }
            selfModel.setValue(property, parentModel.getValue(property));
        }
        Boolean iscurrency = (Boolean)parentModel.getValue("iscurrency");
        Object company = parentModel.getValue("company");
        String writeOffType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)company), (String)"er010");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)writeOffType)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"accountcurrency"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getParentView().getFormShowParameter().getStatus();
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getParentView().getFormShowParameter();
        BillOperationStatus billStatus = formShowParameter.getBillStatus();
        ShowPageUtils.setMobilePageFormStatus((IFormView)this.getView());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        switch (propName) {
            case "accountcurrency": {
                Long sourceCurrencyId = ErCommonUtils.getPk((Object)newValue);
                Long targetCurrencyId = ErCommonUtils.getPk((Object)this.getModel().getValue("currency"));
                Object company = this.getView().getParentView().getModel().getValue("company");
                Object companay = this.getView().getParentView().getModel().getValue("costcompany");
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)companay, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Object)this.getModel());
                String quoteType = (String)ObjectUtils.defaultIfNull(exchangeRateAndQuoteType.get("quoteType"), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull(exchangeRateAndQuoteType.get("exchangeRate"), (Object)BigDecimal.ONE);
                this.getModel().setValue("detailquotetype", (Object)quoteType);
                this.getModel().setValue("repayexchangerate", (Object)exchangeRate);
                break;
            }
            case "repayexchangerate": 
            case "orirepayamount": {
                this.setAmountValue(propName, newValue);
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "save": {
                IDataModel parentModel = this.getView().getParentView().getModel();
                IDataModel selfModel = this.getModel();
                DynamicObjectCollection entry = parentModel.getDataEntity(true).getDynamicObjectCollection("repaymententry");
                int parentCurrentRowIndex = parentModel.getEntryCurrentRowIndex("repaymententry");
                DynamicObject currRow = (DynamicObject)entry.get(parentCurrentRowIndex);
                Set parentProperties = currRow.getDataEntityType().getProperties().stream().map(v -> v.getName()).collect(Collectors.toSet());
                Set selfProperties = selfModel.getDataEntityType().getProperties().stream().map(v -> v.getName()).collect(Collectors.toSet());
                HashMap<String, Object> returnData = new HashMap<String, Object>(selfProperties.size());
                for (String property : parentProperties) {
                    if (!selfProperties.contains(property)) continue;
                    returnData.put(property, selfModel.getValue(property));
                }
                this.getView().returnDataToParent(returnData);
                this.getView().close();
            }
        }
    }

    private void setAmountValue(String propName, Object propValue) {
        BigDecimal orirepayAmount;
        BigDecimal exchangeRate;
        IDataModel parenttModel = this.getView().getParentView().getModel();
        int currentRowIndex = parenttModel.getEntryCurrentRowIndex("repaymententry");
        DynamicObjectCollection entry = parenttModel.getDataEntity(true).getDynamicObjectCollection("repaymententry");
        IDataModel model = this.getModel();
        int precision = AmountUtils.getAmountFieldPrecision((DynamicObject)((DynamicObject)entry.get(currentRowIndex)), (String)"repayamount");
        String quoteType = (String)model.getValue("detailquotetype");
        Object company = this.getView().getParentView().getModel().getValue("company");
        Boolean iscurrency = (Boolean)model.getValue("iscurrency");
        String writeOffType = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)company), (String)"er010");
        if (StringUtils.equals((CharSequence)"repayexchangerate", (CharSequence)propName)) {
            exchangeRate = (BigDecimal)propValue;
            orirepayAmount = (BigDecimal)model.getValue("orirepayamount");
        } else {
            orirepayAmount = (BigDecimal)propValue;
            exchangeRate = (BigDecimal)model.getValue("repayexchangerate");
        }
        BigDecimal sourceBillExchangeRate = (BigDecimal)model.getValue("sourceexchangerate");
        BigDecimal repayamount = StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? orirepayAmount.multiply(exchangeRate).setScale(precision, 4) : orirepayAmount.divide(exchangeRate, precision, 4);
        model.setValue("repayamount", (Object)repayamount);
        this.countTotalrepayamount(model, orirepayAmount, repayamount, exchangeRate, quoteType, precision, writeOffType);
        model.setValue("orirepayapproveamount", (Object)orirepayAmount);
        model.setValue("repayapproveamount", (Object)repayamount);
    }

    private void countTotalrepayamount(IDataModel model, BigDecimal oriRepayAmount, BigDecimal repayAmount, BigDecimal exchangeRate, String quoteType, int currencyPrecision, String writeOffType) {
        BigDecimal srcExchangeRate = (BigDecimal)model.getValue("sourceexchangerate");
        DynamicObject reverseCurrency = (DynamicObject)model.getValue("reversecurrency");
        String srcQuoteType = model.getProperty("sourcequotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("sourcequotetype")), (Object)"0");
        int reverseCurrencyPrecision = AmountUtils.getCurrencyPrecision((Object)reverseCurrency.getPkValue());
        if ("1".equals(writeOffType)) {
            model.setValue("reverseorirepayamount", (Object)oriRepayAmount);
            if (StringUtils.equals((CharSequence)quoteType, (CharSequence)srcQuoteType) && exchangeRate.compareTo(srcExchangeRate) == 0) {
                model.setValue("reverserepayamount", (Object)repayAmount);
            } else {
                int curPrecision = currencyPrecision;
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                if (currency != null) {
                    curPrecision = AmountUtils.getCurrencyPrecision((Object)currency.getPkValue());
                }
                model.setValue("reverserepayamount", (Object)AmountUtils.getCurrencyAmount((BigDecimal)oriRepayAmount, (BigDecimal)srcExchangeRate, (int)curPrecision, (String)srcQuoteType));
            }
        } else {
            model.setValue("reverserepayamount", (Object)repayAmount);
            if (StringUtils.equals((CharSequence)quoteType, (CharSequence)srcQuoteType) && exchangeRate.compareTo(srcExchangeRate) == 0) {
                model.setValue("reverseorirepayamount", (Object)oriRepayAmount);
            } else {
                model.setValue("reverseorirepayamount", (Object)AmountUtils.getOriAmount((BigDecimal)repayAmount, (BigDecimal)srcExchangeRate, (int)reverseCurrencyPrecision, (String)srcQuoteType));
            }
        }
    }
}

