/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.mobile.repayment;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.formplugin.mobile.CoreBaseBillListNew;
import kd.fi.er.formplugin.mobile.MobileListStateInfo;
import kd.fi.er.formplugin.mobile.MultiLang;

public class ErRepaymentBillListPlugin
extends CoreBaseBillListNew
implements ClickListener,
TabSelectListener {
    private static final List<String> InRepayStatusList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "E", "F"}));
    private static final List<String> CompletedStatusList = Collections.unmodifiableList(Lists.newArrayList((Object[])new String[]{"G", "H", "I"}));
    private static final MobileListStateInfo todoStateInfo = new MobileListStateInfo("todotab", InRepayStatusList, new MultiLang(ErRepaymentBillListPlugin.getAuditMsg(), "ErRepaymentBillListPlugin_0", "fi-er-formplugin"));
    private static final MobileListStateInfo didStateInfo = new MobileListStateInfo("didtab", CompletedStatusList, new MultiLang(ErRepaymentBillListPlugin.getCompleteMsg(), "ErRepaymentBillListPlugin_1", "fi-er-formplugin"));
    private static final List<MobileListStateInfo> stateInfoList = Lists.newArrayListWithExpectedSize((int)2);

    public ErRepaymentBillListPlugin() {
        super(stateInfoList);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter billShowParameter = e.getParameter();
        MobileListShowParameter mobparameter = (MobileListShowParameter)this.getView().getFormShowParameter();
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        Long billId = (Long)billShowParameter.getPkId();
        String formId = billShowParameter.getFormId();
        customParam.put("FormId", formId);
        customParam.put("Status", billShowParameter.getBillStatusValue());
        customParam.put("PageId", billShowParameter.getPageId());
        customParam.put("billId", billId);
        billShowParameter.setPkId(null);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setCustomParams(customParam);
        formShowParameter.setFormId("er_dlbill_tabap");
        formShowParameter.setCaption(mobparameter.getCaption());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        formShowParameter.setCaption(FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue());
        if (e.getParameter().getBillStatus() != BillOperationStatus.ADDNEW) {
            String billStatus = ((IListView)this.getView()).getCurrentSelectedRowInfo().getBillStatus();
            if (ErBillStatusEnum.C.toString().equals(billStatus) || ErBillStatusEnum.E.toString().equals(billStatus) || ErBillStatusEnum.F.toString().equals(billStatus) || ErBillStatusEnum.G.toString().equals(billStatus) || ErBillStatusEnum.H.toString().equals(billStatus) || ErBillStatusEnum.I.toString().equals(billStatus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setOrderBy("repaymentdate desc,billno desc");
    }

    private static String getAuditMsg() {
        return ResManager.loadKDString((String)"\u8fd8\u6b3e\u4e2d", (String)"ErRepaymentBillListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    private static String getCompleteMsg() {
        return ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ErRepaymentBillListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
    }

    static {
        stateInfoList.add(todoStateInfo);
        stateInfoList.add(didStateInfo);
    }
}

