/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.reimctl;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Year;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ReimburseAmountServiceHelper;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class ErQuotaCarryForwardPlugin
extends AbstractFormPlugin {
    private Map<String, Object> getFormParams() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5217\u8868\u4e2d\u7684\u6570\u636e\u3002", (String)"ErQuotaCarryForwardPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return null;
        }
        return customParams;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.init();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.quotaCarryForward();
        }
    }

    private void quotaCarryForward() {
        if (this.getModel().getValue("orgto") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8f6c\u5165\u516c\u53f8\u7684\u503c\u3002", (String)"ErQuotaCarryForwardPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> customParams = this.getFormParams();
        if (customParams == null) {
            return;
        }
        JSONArray selectIds = (JSONArray)customParams.get("selectIds");
        if (selectIds.isEmpty()) {
            return;
        }
        String billFormId = (String)customParams.get("billFormId");
        QFilter qFilter = new QFilter("id", "in", (Object)selectIds);
        DynamicObject[] reimburseQuotaArray = BusinessDataServiceHelper.load((String)billFormId, (String)"costcompany,company,dept,employee,expenseitem,expenseitem.reimburseamountctlmethod,currency,dateyear,totalamount,quarter1,quarter2,quarter3,quarter4,month1,month2, month3, month4, month5, month6, month7, month8, month9, month10, month11, month12, amounttype,auditstatus,createtime,modifytime,creator,modifier", (QFilter[])new QFilter[]{qFilter});
        Object orgto = this.getModel().getValue("orgto");
        Object monthto = this.getModel().getValue("monthto");
        Object quarterto = this.getModel().getValue("quarterto");
        for (DynamicObject reimburseQuota : reimburseQuotaArray) {
            String ctlMethod = reimburseQuota.getString("expenseitem.reimburseamountctlmethod");
            if (StringUtils.isBlank((CharSequence)ctlMethod)) continue;
            if (("A".equals(ctlMethod) || "B".equals(ctlMethod)) && Objects.isNull(monthto)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6708\u4efd\u3002", (String)"ErQuotaCarryForwardPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!"E".equals(ctlMethod) || !Objects.isNull(quarterto)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b63\u5ea6\u3002", (String)"ErQuotaCarryForwardPlugin_10", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        int year = Year.now().getValue();
        for (DynamicObject reimburseQuota : reimburseQuotaArray) {
            BigDecimal orgToUsedAmount;
            BigDecimal reimbursedAmount;
            int i;
            qFilter = new QFilter("company", "=", ((DynamicObject)orgto).getPkValue()).and("currency", "=", reimburseQuota.get("currency.id")).and("dateyear", "=", reimburseQuota.get("dateyear")).and("expenseitem", "=", reimburseQuota.get("expenseitem.id")).and("employee", "=", reimburseQuota.get("employee.id"));
            Boolean orgtoQuota = QueryServiceHelper.exists((String)billFormId, (QFilter[])new QFilter[]{qFilter});
            if (orgtoQuota.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u5165\u516c\u53f8\u5df2\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ErQuotaCarryForwardPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String expName = reimburseQuota.getString("expenseitem.name");
            String string = reimburseQuota.getString("expenseitem.reimburseamountctlmethod");
            ReimburseAmountControlService service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)string));
            BigDecimal surplusAmount = BigDecimal.ZERO;
            if ("A".equals(string) || "B".equals(string)) {
                int monthIndex;
                for (i = monthIndex = Integer.parseInt(String.valueOf(monthto)); i <= 12; ++i) {
                    YearMonth yearMonth = YearMonth.of(year, i);
                    reimbursedAmount = service.getUserReimbursedAmountBetween(Long.valueOf(reimburseQuota.getLong("company.id")), Long.valueOf(reimburseQuota.getLong("employee.id")), Long.valueOf(reimburseQuota.getLong("expenseitem.id")), Long.valueOf(reimburseQuota.getLong("currency.id")), yearMonth.atDay(1), yearMonth.atEndOfMonth(), (List)Lists.newArrayList());
                    if (reimbursedAmount.compareTo(BigDecimal.ZERO) > 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s(\u8d39\u7528\u9879\u76ee)%2$s\u6708\u989d\u5ea6\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u7ed3\u8f6c\u3002", (String)"ErQuotaCarryForwardPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]), expName, i));
                        return;
                    }
                    surplusAmount = surplusAmount.add(reimburseQuota.getBigDecimal("month" + i));
                }
            }
            if ("E".equals(string)) {
                int quarterIndex;
                for (i = quarterIndex = Integer.parseInt(String.valueOf(quarterto)); i <= 4; ++i) {
                    reimbursedAmount = service.getReimbursedAmountByMonth(Long.valueOf(reimburseQuota.getLong("company.id")), Long.valueOf(reimburseQuota.getLong("employee.id")), Long.valueOf(reimburseQuota.getLong("expenseitem.id")), Long.valueOf(reimburseQuota.getLong("currency.id")), YearMonth.of(year, i * 3), (List)Lists.newArrayList());
                    if (reimbursedAmount.compareTo(BigDecimal.ZERO) > 0) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s(\u8d39\u7528\u9879\u76ee)%2$s\u5b63\u5ea6\u989d\u5ea6\u5df2\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u7ed3\u8f6c\u3002", (String)"ErQuotaCarryForwardPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]), expName, i));
                        return;
                    }
                    surplusAmount = surplusAmount.add(reimburseQuota.getBigDecimal("month" + i));
                }
            }
            if ((orgToUsedAmount = service.getUserReimbursedAmountBetween(Long.valueOf(Long.parseLong(((DynamicObject)orgto).getPkValue().toString())), Long.valueOf(reimburseQuota.getLong("employee.id")), Long.valueOf(reimburseQuota.getLong("expenseitem.id")), Long.valueOf(reimburseQuota.getLong("currency.id")), LocalDate.of(year, 1, 1), LocalDate.of(year, 12, 31), (List)Lists.newArrayList())).compareTo(surplusAmount) <= 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f6c\u5165\u516c\u53f8\u5df2\u7528\u989d\u5ea6\u5927\u4e8e\u7ed3\u8f6c\u540e\u603b\u989d\u7684\uff0c\u4e0d\u5141\u8bb8\u7ed3\u8f6c\u3002", (String)"ErQuotaCarryForwardPlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Long companyToId = (Long)((DynamicObject)orgto).get("id");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        Date now = new Date();
        ArrayList<DynamicObject> remiQuotas = new ArrayList<DynamicObject>(reimburseQuotaArray.length);
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)companyToId, (Boolean)true);
        for (DynamicObject reimburseQuota : reimburseQuotaArray) {
            int i;
            BigDecimal carryForwardAmount;
            String ctlMethod = reimburseQuota.getString("expenseitem.reimburseamountctlmethod");
            ReimburseAmountControlService service = (ReimburseAmountControlService)ReimburseAmountControlService.controlServiceMap.get(ErExpenseItemConstant.ReimburseAmountCtlMethod.getEnumByValue((String)ctlMethod));
            DynamicObject remiQuota = BusinessDataServiceHelper.newDynamicObject((String)billFormId);
            remiQuota.set("company", (Object)companyToId);
            remiQuota.set("costcompany", (Object)accountOrgId);
            remiQuota.set("dept", (Object)ReimburseAmountServiceHelper.getDept((Long)reimburseQuota.getLong("employee.id"), (Long)companyToId));
            remiQuota.set("employee", reimburseQuota.get("employee.id"));
            remiQuota.set("expenseitem", reimburseQuota.get("expenseitem.id"));
            remiQuota.set("currency", reimburseQuota.get("currency.id"));
            remiQuota.set("dateyear", reimburseQuota.get("dateyear"));
            remiQuota.set("amounttype", (Object)"1");
            remiQuota.set("auditstatus", (Object)"0");
            remiQuota.set("createtime", (Object)now);
            remiQuota.set("modifytime", (Object)now);
            remiQuota.set("creator", (Object)currentUserId);
            remiQuota.set("modifier", (Object)currentUserId);
            BigDecimal totalAmount = reimburseQuota.getBigDecimal("totalamount");
            if ("A".equals(ctlMethod) || "B".equals(ctlMethod)) {
                int monthIndex;
                carryForwardAmount = BigDecimal.ZERO;
                for (i = monthIndex = Integer.parseInt(String.valueOf(monthto)); i <= 12; ++i) {
                    remiQuota.set("month" + i, reimburseQuota.get("month" + i));
                    carryForwardAmount = carryForwardAmount.add(reimburseQuota.getBigDecimal("month" + i));
                    reimburseQuota.set("month" + i, (Object)BigDecimal.ZERO);
                }
                remiQuota.set("totalamount", (Object)carryForwardAmount);
                reimburseQuota.set("totalamount", (Object)totalAmount.subtract(carryForwardAmount));
            }
            if ("E".equals(ctlMethod)) {
                int quarterIndex;
                carryForwardAmount = BigDecimal.ZERO;
                for (i = quarterIndex = Integer.parseInt(String.valueOf(quarterto)); i <= 4; ++i) {
                    remiQuota.set("quarter" + i, reimburseQuota.get("quarter" + i));
                    carryForwardAmount = carryForwardAmount.add(reimburseQuota.getBigDecimal("quarter" + i));
                    reimburseQuota.set("quarter" + i, (Object)BigDecimal.ZERO);
                }
                remiQuota.set("totalamount", (Object)carryForwardAmount);
                reimburseQuota.set("totalamount", (Object)totalAmount.subtract(carryForwardAmount));
            }
            if ("C".equals(ctlMethod)) {
                BigDecimal reimbursedAmount = service.getReimbursedAmountByMonth(Long.valueOf(reimburseQuota.getLong("company.id")), Long.valueOf(reimburseQuota.getLong("employee.id")), Long.valueOf(reimburseQuota.getLong("expenseitem.id")), Long.valueOf(reimburseQuota.getLong("currency.id")), YearMonth.of(year, 1), (List)Lists.newArrayList());
                reimburseQuota.set("totalamount", (Object)reimbursedAmount);
                remiQuota.set("totalamount", (Object)totalAmount.subtract(reimbursedAmount));
            }
            remiQuotas.add(remiQuota);
        }
        try (TXHandle tXHandle = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])remiQuotas.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])reimburseQuotaArray);
            }
            catch (Exception e) {
                tXHandle.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErQuotaCarryForwardPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ed3\u8f6c\u6210\u529f\u3002", (String)"ErQuotaCarryForwardPlugin_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
    }

    private void init() {
        String ctlMethod;
        Map<String, Object> customParams = this.getFormParams();
        if (customParams == null) {
            return;
        }
        JSONArray selectIds = (JSONArray)customParams.get("selectIds");
        if (selectIds.isEmpty()) {
            return;
        }
        String billFormId = (String)customParams.get("billFormId");
        QFilter qFilter = new QFilter("id", "in", (Object)selectIds);
        DynamicObject[] reimburseQuotaArray = BusinessDataServiceHelper.load((String)billFormId, (String)"costcompany,company,dept,employee,expenseitem,expenseitem.reimburseamountctlmethod,currency,dateyear,totalamount,quarter1,quarter2,quarter3,quarter4,month1,month2, month3, month4, month5, month6, month7, month8, month9, month10, month11, month12, amounttype,auditstatus,createtime,modifytime,creator,modifier", (QFilter[])new QFilter[]{qFilter});
        this.getModel().setValue("orgfrom", reimburseQuotaArray[0].get("company"));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"monthto", "quarterto"});
        for (DynamicObject reimburseQuota : reimburseQuotaArray) {
            ctlMethod = reimburseQuota.getString("expenseitem.reimburseamountctlmethod");
            if (!"A".equals(ctlMethod) && !"B".equals(ctlMethod)) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"monthto"});
            ((FieldEdit)this.getControl("monthto")).setMustInput(true);
            break;
        }
        for (DynamicObject reimburseQuota : reimburseQuotaArray) {
            ctlMethod = reimburseQuota.getString("expenseitem.reimburseamountctlmethod");
            if (!"E".equals(ctlMethod)) continue;
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"quarterto"});
            ((FieldEdit)this.getControl("quarterto")).setMustInput(true);
            break;
        }
    }
}

