/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.reimctl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.OrgEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.OrgServiceHelper;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import org.apache.commons.lang.StringUtils;

public class ErReimburseAmountPlugin
extends AbstractBillPlugIn {
    protected boolean flag = false;
    private static String CALL_BACK_ID = "callback_approve";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        OrgEdit companyOrgEdit = (OrgEdit)this.getControl("company");
        companyOrgEdit.addBeforeF7SelectListener(event -> event.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)true));
        this.addItemClickListeners(new String[]{"tbmain", "bar_saveandaudit"});
    }

    public void afterCreateNewData(EventObject e) {
        String dateyear;
        IDataModel model = this.getModel();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            String choosedateyear = parentView.getPageCache().get("choosedateyear");
            model.setValue("dateyear", (Object)choosedateyear);
        }
        if (null == (dateyear = (String)model.getValue("dateyear")) || "".equals(dateyear) || " ".equals(dateyear)) {
            LocalDate localDate = LocalDate.now();
            int currentYear = localDate.getYear();
            model.setValue("dateyear", (Object)currentYear);
        }
        this.whenCompanyChange();
    }

    public void afterCopyData(EventObject e) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && StringUtils.isNotBlank((String)parentView.getPageCache().get("copymodify_wbsrcbillid"))) {
            IDataModel model = this.getModel();
            String wbsrcbillid = parentView.getPageCache().get("copymodify_wbsrcbillid");
            model.setValue("wbsrcbilltype", (Object)"er_reimctl_modify");
            model.setValue("wbsrcbillid", (Object)wbsrcbillid);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showQuotaFlexByCtlMethod(null);
        this.calcTotalYearAmount(true);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        switch (propertyName = e.getProperty().getName()) {
            case "month1": 
            case "month2": 
            case "month3": 
            case "month4": 
            case "month5": 
            case "month6": 
            case "month7": 
            case "month8": 
            case "month9": 
            case "month10": 
            case "month11": 
            case "month12": {
                boolean changeflag = (Boolean)model.getValue("amountchangeflag");
                String monthPrefix = propertyName.substring(0, 5);
                String index_str = propertyName.substring(5, propertyName.length());
                if (changeflag) {
                    RequestContext requestContext = RequestContext.get();
                    String requestId = requestContext.getRequestId();
                    if (this.getPageCache().get(requestId) != null || null == requestId) break;
                    this.getPageCache().put(requestId, requestId);
                    BigDecimal propertyNewValue = (BigDecimal)model.getValue(propertyName);
                    this.updateAfterMonthAmount(monthPrefix, index_str, propertyName, propertyNewValue, model);
                    break;
                }
                this.calculateTotalMonthAmount(monthPrefix, model);
                break;
            }
            case "quarter1": 
            case "quarter2": 
            case "quarter3": 
            case "quarter4": {
                boolean quarterChangeFlag = (Boolean)model.getValue("quarterchangeflag");
                BigDecimal propertyNewValue = (BigDecimal)model.getValue(propertyName);
                if (quarterChangeFlag) {
                    int i;
                    String quarterIndex = propertyName.substring(propertyName.length() - 1);
                    this.getModel().beginInit();
                    int quarter = Integer.parseInt(quarterIndex);
                    for (i = quarter + 1; i <= 4; ++i) {
                        this.getModel().setValue("quarter" + i, (Object)propertyNewValue);
                    }
                    this.getModel().endInit();
                    for (i = quarter + 1; i <= 4; ++i) {
                        this.getView().updateView("quarter" + i);
                    }
                }
                this.calcTotalYearAmount(false);
                break;
            }
            case "company": {
                ChangeData changeData = e.getChangeSet()[0];
                Object newValue = changeData.getNewValue();
                Object oldValue = changeData.getOldValue();
                if (newValue == null && oldValue != null) {
                    this.getModel().setValue("company", oldValue);
                    break;
                }
                this.whenCompanyChange();
                break;
            }
            case "costcompany": {
                Object newCostCompany = e.getChangeSet()[0].getNewValue();
                if (newCostCompany instanceof Long) {
                    this.checkExpenseItemValid((Long)newCostCompany);
                }
                if (!(newCostCompany instanceof DynamicObject)) break;
                this.checkExpenseItemValid((Long)((DynamicObject)newCostCompany).getPkValue());
                break;
            }
            case "expenseitem": {
                ChangeData changeData = e.getChangeSet()[0];
                Object newValue = changeData.getNewValue();
                if (newValue == null) break;
                String ctlMethod = (String)((DynamicObject)newValue).get("reimburseamountctlmethod");
                this.showQuotaFlexByCtlMethod(ctlMethod);
                this.calcTotalYearAmount(false);
                break;
            }
        }
    }

    private void checkExpenseItemValid(Long newCostCompanyPk) {
        if (newCostCompanyPk == null) {
            return;
        }
        Object expenseitem = this.getModel().getValue("expenseitem");
        if (expenseitem == null) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)newCostCompanyPk);
        DynamicObject single = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{baseDataFilter, QFilter.of((String)"id = ?", (Object[])new Object[]{((DynamicObject)expenseitem).getPkValue()})});
        if (single == null) {
            this.getModel().setValue("expenseitem", null);
        }
    }

    public void showQuotaFlexByCtlMethod(String ctlMethod) {
        if (StringUtils.isBlank((String)ctlMethod)) {
            Object expenseitem = this.getModel().getValue("expenseitem");
            if (Objects.isNull(expenseitem)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"quarterflex", "monthflex"});
                return;
            }
            ctlMethod = (String)((DynamicObject)expenseitem).get("reimburseamountctlmethod");
        }
        if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue().equals(ctlMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"quarterflex", "monthflex"});
        }
        if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue().equals(ctlMethod) || ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue().equals(ctlMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"quarterflex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"monthflex"});
        }
        if ("E".equals(ctlMethod)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"quarterflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"monthflex"});
        }
    }

    private void calcTotalYearAmount(boolean isInit) {
        int i;
        Object expenseitem = this.getModel().getValue("expenseitem");
        if (expenseitem == null) {
            return;
        }
        String ctlMethod = (String)((DynamicObject)expenseitem).get("reimburseamountctlmethod");
        Label totalYearAmountLabel = null;
        BigDecimal totalYearAmount = BigDecimal.ZERO;
        if ("E".equalsIgnoreCase(ctlMethod)) {
            for (i = 1; i <= 4; ++i) {
                BigDecimal quarterAmount = (BigDecimal)this.getModel().getValue("quarter" + i);
                totalYearAmount = totalYearAmount.add(quarterAmount);
            }
            totalYearAmountLabel = (Label)this.getControl("quartertotalamount");
        }
        if ("A".equalsIgnoreCase(ctlMethod) || "B".equalsIgnoreCase(ctlMethod)) {
            for (i = 1; i <= 12; ++i) {
                BigDecimal monthAmount = (BigDecimal)this.getModel().getValue("month" + i);
                totalYearAmount = totalYearAmount.add(monthAmount);
            }
            totalYearAmountLabel = (Label)this.getControl("dateyealabelvalue");
        }
        if (!isInit) {
            this.getModel().setValue("totalamount", (Object)totalYearAmount);
        }
        if (totalYearAmountLabel != null) {
            this.setTotalYearAmountLabelText(totalYearAmount, totalYearAmountLabel);
        }
    }

    protected void whenCompanyChange() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            return;
        }
        boolean ischanged = this.getModel().getDataChanged();
        Long accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)company.getPkValue()), (Boolean)true);
        if (this.getModel().getProperty("costcompany") != null) {
            this.getModel().setValue("costcompany", (Object)accountOrgId);
            this.checkExpenseItemValid(accountOrgId);
        }
        this.getModel().setDataChanged(ischanged);
    }

    protected void updateCurrency(Long companyId, IDataModel model) {
        if (companyId == null || companyId == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u516c\u53f8\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u5e01\u79cd\u3002", (String)"ErReimburseAmountPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Long)companyId);
        if (model.getValue("currency") == null && null != currencyId) {
            model.setValue("currency", (Object)currencyId);
        }
    }

    private void updateAfterMonthAmount(String monthPrefix, String index_str, String propertyName, BigDecimal propertyNewValue, IDataModel model) {
        int self_index = Integer.parseInt(index_str);
        for (int i = self_index + 1; i <= 12; ++i) {
            model.setValue(monthPrefix + "" + i, (Object)propertyNewValue);
        }
        this.calculateTotalMonthAmount(monthPrefix, model);
    }

    private void calculateTotalMonthAmount(String monthPrefix, IDataModel model) {
        BigDecimal totalYearAmount = BigDecimal.ZERO;
        for (int i = 1; i <= 12; ++i) {
            BigDecimal monthAmount = (BigDecimal)model.getValue(monthPrefix + "" + i);
            totalYearAmount = totalYearAmount.add(monthAmount);
        }
        model.setValue("totalamount", (Object)totalYearAmount);
        Label encashamountlabel = (Label)this.getControl("dateyealabelvalue");
        this.setTotalYearAmountLabelText(totalYearAmount, encashamountlabel);
    }

    private void setTotalYearAmountLabelText(BigDecimal totalYearAmount, Label totalYearAmountLabel) {
        String currencySign = "";
        int amountPrecition = 4;
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
            totalYearAmount = totalYearAmount.setScale(amountPrecition, 4);
        }
        String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)totalYearAmount, (int)amountPrecition);
        totalYearAmountLabel.setText(amountStr);
    }

    protected List<Long> getAllSubOrgsExcludeCompany(Long companyId) {
        return OrgServiceHelper.getAllSubOrgWithoutCompany((List)Lists.newArrayList((Object[])new Long[]{companyId}), (Boolean)true);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("bar_saveandaudit".equals(itemKey)) {
            this.getPageCache().put("op_bar_saveandaudit", "true");
        } else {
            this.getPageCache().remove("op_bar_saveandaudit");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BusinessDataServiceHelper.removeCache((DynamicObjectType)this.getModel().getDataEntityType());
    }

    public void afterDoOperation(AfterDoOperationEventArgs event) {
        super.afterDoOperation(event);
        if (StringUtils.isBlank((String)this.getPageCache().get("op_bar_saveandaudit"))) {
            return;
        }
        boolean isSuccess = false;
        if (event.getOperationResult() != null) {
            isSuccess = event.getOperationResult().isSuccess();
        }
        if (!isSuccess) {
            return;
        }
        this.getPageCache().remove("op_bar_saveandaudit");
        this.getView().addClientCallBack(CALL_BACK_ID);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (CALL_BACK_ID.equals(e.getName())) {
            this.getView().invokeOperation("approve");
        }
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map searchResult = e.getSearchResult();
        for (Map.Entry item : searchResult.entrySet()) {
            Long companyPk;
            Long accountOrgId;
            List value;
            if (!"expenseitem".equals(((BasedataItem)item.getKey()).getFieldKey()) || (value = (List)item.getValue()).size() <= 1 || (accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)(companyPk = (Long)this.getModel().getValue("company_id")), (Boolean)true)) == null) continue;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)((BasedataItem)item.getKey()).getEntityNumber(), (Long)accountOrgId);
            DynamicObject expenseitem = QueryServiceHelper.queryOne((String)((BasedataItem)item.getKey()).getEntityNumber(), (String)"id", (QFilter[])new QFilter[]{new QFilter(((BasedataItem)item.getKey()).getSearchKey(), "=", (Object)((BasedataItem)item.getKey()).getSearchValue()), baseDataFilter});
            if (expenseitem == null) continue;
            value.clear();
            value.add(expenseitem.get("id"));
        }
    }
}

