/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractReceiveEntryPlugin
extends AbstractBillPlugIn {
    private static Log logger = LogFactory.getLog(AbstractReceiveEntryPlugin.class);

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "payer": {
                this.payerChange(rowIndex, (DynamicObject)propValue);
                break;
            }
            case "payeraccount": {
                AbstractReceiveEntryPlugin.refreshPayerAcount(model, rowIndex, propValue);
                break;
            }
            case "accountcurrency": {
                this.refreshExchangeRate(rowIndex, (DynamicObject)propValue);
                break;
            }
            case "orireceiveamount": {
                this.orireceiveamountChange(propValue, rowIndex, model);
                break;
            }
            case "approveamount": {
                if (!ErEntityTypeUtils.isDailyLoanBill((String)this.getView().getEntityId())) break;
                AmountChangeUtil.handleDiiff((IDataModel)model, (String)"accountentry", (String)"receiveamount", (String)"orireceiveamount", (String)"accexchangerate", (String)"currency");
            }
        }
    }

    protected void orireceiveamountChange(Object propValue, int rowIndex, IDataModel model) {
        AmountChangeUtil.orireceiveamountChange((Object)propValue, (int)rowIndex, (IDataModel)model);
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        CommonServiceHelper.setPayerNameInEditStatus((IDataModel)model);
    }

    public static void refreshPayerAcount(IDataModel model, int rowIndex, Object propValue) {
        Map map = PayeeServiceHelper.getAllTypePayerAccount((String)((String)propValue));
        model.setValue("payeraccount01", map.get("payeraccount01"), rowIndex);
        model.setValue("payeraccount02", map.get("payeraccount02"), rowIndex);
    }

    private void payerChange(int rowIndex, DynamicObject payer) {
        AbstractReceiveEntryPlugin.payerChange(this.getView(), rowIndex, payer);
    }

    @Deprecated
    public static void payerChange(IDataModel model, int rowIndex, DynamicObject payer) {
    }

    public static void payerChange(IFormView view, int rowIndex, DynamicObject payer) {
        DynamicObject currency;
        Boolean isCurrency;
        IDataModel model = view.getModel();
        model.beginInit();
        model.setValue("payername", payer == null ? null : payer.get("outpayer"), rowIndex);
        model.endInit();
        view.updateView("payername", rowIndex);
        DynamicObject paymode = (DynamicObject)model.getValue("paymode", rowIndex);
        String settlementtype = null;
        if (paymode != null) {
            settlementtype = paymode.getString("settlementtype");
        }
        if ("0".equals(settlementtype)) {
            return;
        }
        model.setValue("payeraccount02", payer == null ? null : payer.get("payeraccount02"), rowIndex);
        model.setValue("payeraccount", payer == null ? null : payer.get("payeraccount"), rowIndex);
        model.setValue("payeraccount01", payer == null ? null : payer.get("payeraccount01"), rowIndex);
        model.setValue("payerbank", payer == null ? null : Long.valueOf(payer.getLong("payerbank_Id")), rowIndex);
        if (payer != null && payer.getDataEntityType().getProperties().containsKey((Object)"payeraccountname")) {
            model.setValue("payeraccountname", payer == null ? null : payer.get("payeraccountname"), rowIndex);
        }
        if (payer != null && (isCurrency = (Boolean)model.getValue("iscurrency")).booleanValue() && (currency = payer.getDynamicObject("CURRENCY")) != null) {
            model.beginInit();
            model.setValue("accountcurrency", null, rowIndex);
            model.endInit();
            model.setValue("accountcurrency", currency.getPkValue(), rowIndex);
        }
        PayeeServiceHelper.clearLimitInfo((IDataModel)model);
    }

    private void refreshExchangeRate(int rowIndex, DynamicObject entryCurrency) {
        DynamicObject costCompany;
        DynamicObject company;
        IDataModel model = this.getModel();
        BigDecimal exchangeRate = BigDecimal.ONE;
        if (model.getValue("currency") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"AbstractReceiveEntryPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        String isgetaccountcurrency = "0";
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (entryCurrency == null) {
            this.getModel().setValue("accountcurrency", (Object)currency, rowIndex);
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof MobileFormShowParameter) {
            IDataModel pModel = this.getView().getParentView().getModel();
            company = (DynamicObject)pModel.getValue("company");
            costCompany = (DynamicObject)pModel.getValue("costcompany");
        } else {
            company = (DynamicObject)model.getValue("company");
            costCompany = (DynamicObject)model.getValue("costcompany");
        }
        String quoteType = "0";
        if (currency != null && company != null && entryCurrency != null) {
            Long srcCurrencyId = (Long)entryCurrency.getPkValue();
            Long targetCurrencyId = (Long)currency.getPkValue();
            Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)ErCommonUtils.getPk((Object)company), (Object)costCompany, (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)model);
            quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
            exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ZERO);
        }
        if (exchangeRate == null && "0".equals(isgetaccountcurrency)) {
            logger.info(String.format("\u5e01\u79cdid:%s \u672a\u8bbe\u7f6e\u6c47\u7387", entryCurrency.getPkValue()));
            exchangeRate = BigDecimal.ONE;
        }
        if (model.getProperty("accquotetype") != null) {
            model.setValue("accquotetype", (Object)quoteType, rowIndex);
        }
        model.setValue("accexchangerate", (Object)exchangeRate, rowIndex);
    }
}

