/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.model.EntityInfo;

public class DailyReimburseBillListPlugin
extends AbstractListPlugin {
    private static final List<String> NODISPLAYTOOLSANDFILTER = Collections.unmodifiableList(Arrays.asList("er_dept_reimctl_query", "er_finance_amount_query", "er_employee_amount_query", "er_employee_dept_query"));

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam("formId");
        if (formId != null && NODISPLAYTOOLSANDFILTER.contains(formId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap", "filtercontainerap", "toolbarap"});
            e.setSpecialDataPermQFilter(null);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        Object pkId = parameter.getPkId();
        if (pkId != null) {
            this.setParameter(pkId, parameter);
        }
    }

    private void setParameter(Object pkId, BillShowParameter parameter) {
        String specialBill;
        DynamicObject reimbursebill = CommonServiceHelper.getObjById((String)"er_dailyreimbursebill", (Long)((Long)pkId));
        if (reimbursebill != null && !StringUtils.isEmpty((CharSequence)(specialBill = reimbursebill.getString("specialbill")))) {
            String caption = ((ComboProp)reimbursebill.getDynamicObjectType().getProperties().get((Object)"specialbill")).getItemByName(specialBill).split(",")[0];
            parameter.setCaption(caption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("genbeforeshare".equalsIgnoreCase(args.getOperateKey())) {
            this.refreshList();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        String operateKey = ((FormOperate)source).getOperateKey();
        ListView view = (ListView)this.getView();
        switch (operateKey) {
            case "modifyforredoffset": {
                Set selectbill = args.getListSelectedData().stream().map(v -> (Long)v.getPrimaryKeyValue()).collect(Collectors.toSet());
                if (selectbill.size() > 1) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"PublicReimListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                DynamicObject selectedDy = this.getSelectDailyReimburseBill();
                String billStatus = selectedDy.getString("billstatus");
                if (!billStatus.equals("E") && !billStatus.equals("F")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6838\u901a\u8fc7\u6216\u7b49\u5f85\u4ed8\u6b3e\u7684\u5355\u636e\u624d\u53ef\u4ee5\u201c\u7ea2\u51b2\u201d\u3002", (String)"PublicReimListPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                BigDecimal approveamount = selectedDy.getBigDecimal("approveamount");
                Boolean isredoffset = selectedDy.getBoolean("isredoffset");
                if (isredoffset.booleanValue() && approveamount.compareTo(BigDecimal.ZERO) == 0) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8d85\u989d\u7ea2\u51b2\u3002", (String)"PublicReimListPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                boolean isbeforeshare = selectedDy.getBoolean("isbeforeshare");
                if (isbeforeshare) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u8d39\u7528\u5206\u644a\u7684\u5355\u636e\uff0c\u4e0d\u652f\u6301\u7ea2\u51b2\u3002", (String)"PublicReimListPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (selectedDy != null && selectedDy.getBoolean("ischangeinvoice")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u6362\u53d1\u7968\u7684\u5355\u636e\u4e0d\u652f\u6301\u7ea2\u51b2\u3002", (String)"ErLoanBaseBillList_18", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (selectedDy != null && selectedDy.getBoolean("hasvoucher") && !"true".equals(ErStdConfig.get((String)"OffsetControl"))) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\u4e0d\u652f\u6301\u7ea2\u51b2\u3002", (String)"PublicReimListPlugin_13", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"er_dailyreimbursebill", (Long[])new Long[]{(Long)args.getListSelectedData().get(0).getPrimaryKeyValue()});
                if (targetBills.containsKey("er_expensesharebill") || targetBills.containsKey("ap_finapbill") || targetBills.containsKey("er_withholdingbill")) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u4e0b\u6e38\"\u8d39\u7528\u5206\u644a\u5355\"\u6216\"\u8d22\u52a1\u5e94\u4ed8\u5355\"\u6216\"\u8d39\u7528\u9884\u63d0\u5355\"\uff0c\u4e0d\u5141\u8bb8\u7ea2\u51b2\u3002", (String)"PublicReimListPlugin_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ArrayList<EntityInfo> res = new ArrayList<EntityInfo>(2);
                EntityInfo agent = new EntityInfo.Builder().statusName(new String[]{"A", "B", "C", "E"}).entityName("cas_agentpaybill").entryName("entry").sourceName("sourcebillid").build();
                EntityInfo pay = new EntityInfo.Builder().statusName(new String[]{"A", "B", "C", "E", "J"}).entityName("cas_paybill").entryName("entry").sourceName("e_sourcebillid").build();
                EntityInfo applypay = new EntityInfo.Builder().statusName(new String[]{"A", "B", "C", "D", "E", "F"}).entityName("er_applypaybill").entryName("accountentry").sourceName("recsrcbillid").build();
                res.add(agent);
                res.add(pay);
                res.add(applypay);
                boolean isHasOnWayBills = ErCommonUtils.isHasOnWayDownBill((String)view.getEntityTypeId(), (Long)((Long)args.getListSelectedData().get(0).getPrimaryKeyValue()), res);
                if (isHasOnWayBills) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u5728\u9014\u4e0b\u6e38\"\u4ee3\u53d1\u5355\"\u6216\"\u4ed8\u6b3e\u5355\"\u6216\"\u6302\u8d26\u4ed8\u6b3e\u7533\u8bf7\u5355\"\uff0c\u4e0d\u5141\u8bb8\u7ea2\u51b2\u3002", (String)"PublicReimListPlugin_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ListSelectedRowCollection selectedRows = this.getSelectedRows();
                Object selectId = selectedRows.get(0).getPrimaryKeyValue();
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("dailyreimisredoffset", (Object)"true");
                formShowParameter.setFormId(view.getEntityTypeId());
                formShowParameter.setBillStatus(BillOperationStatus.EDIT);
                formShowParameter.setPkId(selectId);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "redoffset"));
                view.showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection list;
        super.beforeItemClick(evt);
        if ("unaudit".equals(evt.getOperationKey()) && (list = this.getSelectedRows()).size() > 0) {
            ListSelectedRow row = list.get(0);
            String entityType = ((ListView)this.getView()).getEntityTypeId();
            DynamicObject dys = QueryServiceHelper.queryOne((String)entityType, (String)"isredoffset,ischangeinvoice", (QFilter[])new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())});
            Boolean isredoffset = dys.getBoolean("isredoffset");
            Boolean ischangeinvoice = dys.getBoolean("ischangeinvoice");
            if (isredoffset.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ea2\u51b2\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"UnAuditValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if (ischangeinvoice.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6362\u53d1\u7968\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"UnAuditValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "redoffset": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void refreshList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private DynamicObject getSelectDailyReimburseBill() {
        ListView view = (ListView)this.getView();
        String entityName = view.getListModel().getEntityId();
        Long pkId = (Long)view.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        return QueryServiceHelper.queryOne((String)entityName, (String)"billstatus,approveamount,isbeforeshare,billno,isredoffset,hasvoucher,ischangeinvoice", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
    }
}

