/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class DailyReimburseBillSetReimCtlDeptPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expenseEntries = dataEntity.getDynamicObjectCollection("expenseentryentity");
        if (expenseEntries == null || expenseEntries.size() < 1) {
            return;
        }
        DynamicObject applierDO = (DynamicObject)this.getModel().getValue("applier");
        boolean oldIsDataChanged = model.getDataChanged();
        for (int i = 0; i < expenseEntries.size(); ++i) {
            if (model.getValue("reimctldept", i) == null) {
                Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("expenseitem", i)), (DynamicObject)((DynamicObject)this.getModel().getValue("entrycostdept", i)), (IDataModel)this.getModel());
                model.setValue("reimctldept", (Object)quotaDeptId, i);
            }
            if (!ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName()) && this.getModel().getValue("reimburser", i) == null) {
                this.getModel().setValue("reimburser", (Object)ErCommonUtils.getPk((Object)applierDO), i);
            }
            if (model.getProperty("pubreimburser") == null || model.getValue("pubreimburser", i) != null) continue;
            model.setValue("pubreimburser", (Object)ErCommonUtils.getPk((Object)applierDO), i);
        }
        this.getModel().setDataChanged(oldIsDataChanged);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"expenseentryentity")) {
            DynamicObject applierDO = (DynamicObject)this.getModel().getValue("applier");
            this.getModel().beginInit();
            for (RowDataEntity rowDataEntity : e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("expenseitem", rowIndex)), (DynamicObject)((DynamicObject)this.getModel().getValue("entrycostdept", rowIndex)), (IDataModel)this.getModel());
                this.getModel().setValue("reimctldept", (Object)quotaDeptId, rowIndex);
                if (!ErEntityTypeUtils.isPublicReimburseBill((String)this.getModel().getDataEntity().getDynamicObjectType().getName())) {
                    this.getModel().setValue("reimburser", (Object)ErCommonUtils.getPk((Object)applierDO), rowIndex);
                    this.getView().updateView("reimburser", rowIndex);
                }
                if (this.getModel().getProperty("pubreimburser") == null) continue;
                this.getModel().setValue("pubreimburser", (Object)ErCommonUtils.getPk((Object)applierDO), rowIndex);
                this.getView().updateView("pubreimburser", rowIndex);
            }
            this.getModel().endInit();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObjectCollection expenseEntries;
        DynamicObject dataEntity;
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"org")) {
            dataEntity = model.getDataEntity(true);
            expenseEntries = dataEntity.getDynamicObjectCollection("expenseentryentity");
            for (int i = 0; i < expenseEntries.size(); ++i) {
                Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("expenseitem", i)), (DynamicObject)((DynamicObject)this.getModel().getValue("entrycostdept", i)), (IDataModel)this.getModel());
                model.setValue("reimctldept", (Object)quotaDeptId, i);
            }
        }
        if ((StringUtils.equals((CharSequence)propName, (CharSequence)"expenseitem") || StringUtils.equals((CharSequence)propName, (CharSequence)"entrycostdept")) && (expenseEntries = (dataEntity = model.getDataEntity(true)).getDynamicObjectCollection("expenseentryentity")).size() > 0 && rowIndex <= expenseEntries.size() - 1) {
            Long quotaDeptId = QuotaCtrlUtil.getQuotaCtrlDeptId((DynamicObject)((DynamicObject)this.getModel().getValue("expenseitem", rowIndex)), (DynamicObject)((DynamicObject)this.getModel().getValue("entrycostdept", rowIndex)), (IDataModel)this.getModel());
            model.setValue("reimctldept", (Object)quotaDeptId, rowIndex);
        }
        if (StringUtils.equals((CharSequence)propName, (CharSequence)"reimctldept") && newValue == null && oldValue != null) {
            model.setValue("reimctldept", oldValue, rowIndex);
        }
    }
}

