/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.bean.CostDeptF7ChangePram;
import kd.fi.er.business.ext.enums.ErExtcaseEnum;
import kd.fi.er.business.ext.helper.ErExtHelper;
import kd.fi.er.business.invoicecloud.util.InvoicePackageUtil;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.CreditLevelServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.task.datacheck.util.ErDataCheckUtil;
import kd.fi.er.business.utils.AttachmentCountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.UnRepaymentAmountUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.utils.Er;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCenterF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostCompanyF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeCostDeptF7SelectListener;
import kd.fi.er.formplugin.daily.mobile.reimburse.listener.BeforeExpenseItemF7SelectListener;
import kd.fi.er.formplugin.daily.web.util.ShowUserInfoUtils;
import kd.fi.er.formplugin.util.DataCopyUtils;
import kd.fi.er.formplugin.util.FormOperateUtil;
import kd.fi.er.model.FormModel;
import kd.sdk.fi.er.extpoint.dailyreimbursebill.ISuperClosedCallBack;
import org.apache.commons.lang.StringUtils;

public class ErExpenseBaseEdit
extends AbstractBillPlugIn
implements ItemClickListener {
    private static Log logger = LogFactory.getLog(ErExpenseBaseEdit.class);
    public static final String CHANGE_COSTDEPT = "changecostdept";
    public static final String CHANGE_APPLIER = "changeapplier";

    public void registerListener(EventObject e) {
        BasedataEdit entryexpenseitemF7;
        super.registerListener(e);
        this.addClickListeners(new String[]{CHANGE_COSTDEPT, CHANGE_APPLIER, "creditlevel", "bar_copyentry"});
        this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        IDataModel model = this.getModel();
        String number = model.getDataEntityType().getName();
        BasedataEdit expenseitemF7 = (BasedataEdit)this.getControl("expenseitem");
        if (null != expenseitemF7) {
            expenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "entrycostdept"));
        }
        if (null != (entryexpenseitemF7 = (BasedataEdit)this.getControl("entryexpenseitem"))) {
            entryexpenseitemF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeExpenseItemF7SelectListener(this.getView(), number, "entrycostdept"));
        }
        this.costDeptF7Filter();
        this.costCompanyF7Filter();
        this.costCenterF7Filter();
    }

    private void costCenterF7Filter() {
        BasedataEdit costCenterF7 = (BasedataEdit)this.getControl("std_costcenter");
        BasedataEdit entryCostCenterF7 = (BasedataEdit)this.getControl("std_entrycostcenter");
        BasedataEdit std_entrycostcenter_crule = (BasedataEdit)this.getControl("std_entrycostcenter_crule");
        BeforeCostCenterF7SelectListener beforeCostCenterF7SelectListener = new BeforeCostCenterF7SelectListener(this.getView());
        if (costCenterF7 != null) {
            costCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (entryCostCenterF7 != null) {
            entryCostCenterF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
        if (std_entrycostcenter_crule != null) {
            std_entrycostcenter_crule.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCenterF7SelectListener);
        }
    }

    protected void costDeptF7Filter() {
        BasedataEdit costDeptF7 = (BasedataEdit)this.getControl("costdept");
        BasedataEdit entrycostDeptF7 = (BasedataEdit)this.getControl("entrycostdept");
        BeforeCostDeptF7SelectListener beforeCostDeptF7SelectListener = new BeforeCostDeptF7SelectListener(this.getModel());
        if (costDeptF7 != null) {
            costDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
        if (entrycostDeptF7 != null) {
            entrycostDeptF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostDeptF7SelectListener);
        }
    }

    protected void costCompanyF7Filter() {
        boolean isNotRelated;
        Long companyID = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
        int showType = 1;
        if (companyID != null) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes((long)companyID);
        }
        boolean bl = isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        if (!isNotRelated) {
            BeforeCostCompanyF7SelectListener beforeCostCompanyF7SelectListener;
            Long deptID = ErCommonUtils.getPk((Object)this.getModel().getValue("costdept"));
            int index = this.getModel().getEntryCurrentRowIndex("expenseentryentity");
            Object rowDept = this.getModel().getValue("entrycostdept", index);
            Object company = this.getModel().getValue("company");
            BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
            BasedataEdit entrycostCompanyF7 = (BasedataEdit)this.getControl("entrycostcompany");
            if (costCompanyF7 != null && deptID != null && company != null) {
                beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(deptID, ErCommonUtils.getPk((Object)company));
                costCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
            }
            if (entrycostCompanyF7 != null && rowDept != null) {
                beforeCostCompanyF7SelectListener = new BeforeCostCompanyF7SelectListener(ErCommonUtils.getPk((Object)rowDept), ErCommonUtils.getPk((Object)company));
                entrycostCompanyF7.addBeforeF7SelectListener((BeforeF7SelectListener)beforeCostCompanyF7SelectListener);
                entrycostCompanyF7.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                    public void beforeF7Select(BeforeF7SelectEvent event) {
                        ((ListShowParameter)event.getFormShowParameter()).setMultiSelect(false);
                    }
                });
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadData();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DataCopyUtils.afterCopyBill((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        boolean dataChanged = model.getDataChanged();
        ShowUserInfoUtils.initUserInfo((IDataModel)model, (IFormView)view);
        if (FormOperateUtil.isCopyOperate((EventObject)e)) {
            DataCopyUtils.handleData((IDataModel)model, (IFormView)view);
        }
        DynamicObject company = (DynamicObject)model.getValue("company");
        String billtype = (String)this.getModel().getValue("formid");
        if (company != null) {
            CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)model);
            int showType = 1;
            if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            }
            model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
            if (showType == 1) {
                model.setValue("expensesassumeshowtypes", (Object)1);
                BasedataEdit costdept = (BasedataEdit)this.getControl("costdept");
                costdept.setMustInput(true);
                BasedataEdit costcompany = (BasedataEdit)this.getControl("costcompany");
                costcompany.setMustInput(true);
                String mode = ErCommonUtils.getCostOrgUseMode((Long)((Long)company.getPkValue()));
                if (!"0".equals(mode)) {
                    BasedataEdit costCenter = (BasedataEdit)this.getControl("std_costcenter");
                    costCenter.setMustInput(true);
                }
            } else {
                String entityId = this.getView().getEntityId();
                if (entityId != null && !ErEntityTypeUtils.isRepaymentBill((String)entityId)) {
                    BasedataEdit costcompany;
                    BasedataEdit costdept = (BasedataEdit)this.getControl("entrycostdept");
                    if (null != costdept) {
                        costdept.setMustInput(true);
                    }
                    if (null != (costcompany = (BasedataEdit)this.getControl("entrycostcompany"))) {
                        costcompany.setMustInput(true);
                    }
                }
            }
            boolean isPushBill = this.getModel().getDataEntity().getDataEntityState().isPushChanged();
            boolean billFlag = model.getDataEntity().getDataEntityType().getProperties().containsKey((Object)"writeoffapply");
            if (billFlag && isPushBill && company != null) {
                String filterType = ErCommonUtils.getEMParameter((long)((Long)company.getPkValue()), (String)"relatapplybillfilterrange").toString();
                this.checkApplyValid(model, filterType);
            }
        }
        this.hiddenChangeApplier(view);
        if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
            Object paycompany;
            Object currencyDO = model.getValue("currency");
            if (currencyDO == null) {
                Long companyId = ErCommonUtils.getPk((Object)model.getValue("company"));
                Long costCompanyId = ErCommonUtils.getPk((Object)model.getValue("costcompany"));
                Long currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)companyId, (Object)costCompanyId);
                logger.info("\u518d\u6b21\u83b7\u53d6\u672c\u4f4d\u5e01\uff0ccompanyId={}, costCompanyId={}, currencyId={}", new Object[]{companyId, costCompanyId, currencyId});
                model.setValue("currency", (Object)currencyId);
            }
            if (model.getDataEntity().getDataEntityState().isPushChanged() && this.isNeedToSetPayCompany() && (paycompany = model.getValue("paycompany")) == null) {
                this.setFundingOrg();
            }
        }
        model.setDataChanged(Boolean.FALSE.booleanValue());
        ErCostCenterUtil.dealCostCenter((IFormView)this.getView());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("package_import_pc")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{CHANGE_APPLIER});
            this.getView().setEnable(Boolean.FALSE, new String[]{"costdept", "costcompany"});
        }
    }

    protected void hiddenChangeApplier(IFormView view) {
        ShowUserInfoUtils.hiddenChangeApplier((IFormView)view);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "changeapplier": {
                HashMap<String, String> customParam = new HashMap<String, String>();
                customParam.put("showProps", "applierprops");
                FormModel formModel = new FormModel("er_changeapplier", ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f", (String)"ErExpenseBaseEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), "1", true, customParam);
                formModel.setShowType(ShowType.Modal);
                ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
                break;
            }
            case "changecostdept": {
                BasedataEdit costDept = (BasedataEdit)this.getControl("costdept");
                costDept.click();
                break;
            }
            case "creditlevel": {
                DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
                CreditLevelServiceHelper.showCreditFilesForm((IFormView)this.getView(), (String)String.valueOf(applier.getPkValue()));
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "expenseentryentity": {
                RowDataEntity[] rowDataEntities = e.getRowDataEntities();
                IDataModel model = this.getModel();
                for (RowDataEntity row : rowDataEntities) {
                    int rowIndex = row.getRowIndex();
                    BigDecimal amount = (BigDecimal)model.getValue("expenseamount", rowIndex);
                    BigDecimal approveAmount = (BigDecimal)model.getValue("expeapproveamount", rowIndex);
                    if (amount.compareTo(BigDecimal.ZERO) < 0) continue;
                    model.setValue("expeapproveamount", (Object)amount, rowIndex);
                }
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "applier": {
                this.refreshApplyImg((DynamicObject)propValue);
                this.applierInfoChange(propName, propValue);
                break;
            }
            case "applierposition": 
            case "tel": {
                this.applierInfoChange(propName, propValue);
                break;
            }
            case "org": {
                this.deptChange((DynamicObject)propValue);
                break;
            }
            case "costcompany": {
                if (this.getModel().getValue("company") == null) break;
                Long companyId = (Long)((DynamicObject)this.getModel().getValue("company")).getPkValue();
                if (propValue == null) {
                    if (!"0".equals(ErCommonUtils.getCostOrgUseMode((Long)companyId))) break;
                    this.getModel().setValue(propName, valueSet[0].getOldValue());
                    break;
                }
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                this.costCompanychange((DynamicObject)propValue);
                this.setFundingOrg();
                InvoiceUtils.changeAutoInvoice((IDataModel)this.getModel(), (IFormView)this.getView(), (Long)((Long)((DynamicObject)propValue).getPkValue()));
                PublicBillUtil.refreshSuplier((IDataModel)this.getModel(), (String)"costcompany", (Long)companyId);
                ErCostCenterUtil.headCostCompanyChange((DynamicObject)((DynamicObject)propValue), (IFormView)this.getView());
                break;
            }
            case "company": {
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])valueSet);
                CoreBaseBillServiceHelper.setBillCostOrgUseMode((IDataModel)this.getModel());
                DynamicObject company = (DynamicObject)valueSet[0].getNewValue();
                PublicBillUtil.refreshSuplier((IDataModel)this.getModel(), (String)"company", (Long)((Long)company.getPkValue()));
                ErCostCenterUtil.costDeptChange((IFormView)this.getView());
                break;
            }
            case "costdept": {
                if (propValue == null) {
                    propValue = valueSet[0].getOldValue();
                    this.getModel().setValue("costdept", ((DynamicObject)propValue).getPkValue());
                }
                this.costDeptChange(propName, (DynamicObject)propValue);
                break;
            }
            case "entrycostdept": {
                if (propValue == null) {
                    propValue = valueSet[0].getOldValue();
                    this.getModel().setValue("entrycostdept", ((DynamicObject)propValue).getPkValue(), rowIndex);
                } else {
                    this.entryCostDeptChange((DynamicObject)propValue, rowIndex);
                }
                this.checkExpenseItem((DynamicObject)propValue, rowIndex);
                break;
            }
            case "entrycostcompany": {
                this.entryCostCompanyChange(rowIndex, (DynamicObject)propValue);
                ErCostCenterUtil.entryCostCompanyChange((IFormView)this.getView());
                break;
            }
            case "iscurrency": {
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                if (((Boolean)propValue).booleanValue()) break;
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("expenseentryentity");
                int index = entryEntity.size();
                for (int i = 0; i < index; ++i) {
                    this.getModel().setValue("entrycurrency", currency == null ? null : currency.getPkValue(), i);
                }
                this.getView().updateView("expenseentryentity");
                break;
            }
            case "ismultireimburser": {
                if (((Boolean)propValue).booleanValue()) break;
                CoreBaseBillServiceHelper.refreshEntryCostOrgByHeadCostOrg((IDataModel)this.getModel());
                break;
            }
            case "std_costcenter": {
                if (propValue == null || propValue == "" || !ErCostCenterUtil.isLeafCostCenter((Object)propValue)) break;
                ErCostCenterUtil.headCostCenterChange((IFormView)this.getView(), (Object)propValue, (boolean)true);
                break;
            }
            case "std_entrycostcenter": {
                if (propValue == null || propValue == "") break;
                ErCostCenterUtil.costEntryCenterChangeForPC((IFormView)this.getView(), (Object)propValue, (int)rowIndex);
            }
        }
    }

    private void refreshApplyImg(DynamicObject applier) {
        if (applier != null) {
            String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applier.getPkValue()));
            Image applierPic = (Image)this.getView().getControl("applierpic");
            applierPic.setUrl(applierPicUrl);
        }
    }

    private void loadData() {
        IDataModel model = this.getView().getModel();
        Long currentUserID = 0L;
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (pageCache.get("consignorId") != null) {
            currentUserID = Long.valueOf(pageCache.get("consignorId"));
            pageCache.remove("consignorId");
        } else if (((IBillModel)model).isFromImport()) {
            currentUserID = (Long)model.getValue("applier_id");
        } else {
            RequestContext requestContext = RequestContext.get();
            currentUserID = Long.valueOf(requestContext.getUserId());
        }
        Map billMap = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("package_import_pc"))) ? InvoicePackageUtil.createNewData((Map)this.getView().getFormShowParameter().getCustomParams()) : CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)billMap);
        CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
        ErExtHelper.invokeExpandPlugin((IFormView)this.getView(), (ErExtcaseEnum)ErExtcaseEnum.ER_EXTCASE_BILLINIT);
        ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)false);
        ErCostCenterUtil.checkCostOrg((AbstractFormPlugin)this, (String)"1");
        String billtype = (String)this.getModel().getValue("formid");
        if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype) && model.getValue("company") != null && model.getValue("currency") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"ErExpenseBaseEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        this.setFundingOrg();
    }

    private void setFundingOrg() {
        IDataModel model = this.getModel();
        Object costCompany = model.getValue("costcompany");
        if (this.isNeedToSetPayCompany() && costCompany != null) {
            logger.info("\u5f00\u59cb\u8bbe\u7f6e\u652f\u4ed8\u516c\u53f8");
            DynamicObject fundingCompany = CoreBaseBillServiceHelper.getFundingOrg((DynamicObject)((DynamicObject)costCompany));
            model.setValue("paycompany", (Object)fundingCompany);
        }
    }

    private boolean isNeedToSetPayCompany() {
        String formId = this.getView().getEntityId();
        boolean flag = ErEntityTypeUtils.isPrePayBill((String)formId) || ErEntityTypeUtils.isDailyLoanBill((String)formId) || ErEntityTypeUtils.isApplyPayBill((String)formId) || ErEntityTypeUtils.isDailyReimburseBill((String)formId) || ErEntityTypeUtils.isPublicReimburseBill((String)formId);
        logger.info("\u662f\u5426\u5728\u9700\u8981\u8bbe\u7f6e\u652f\u4ed8\u516c\u53f8\u7684\u5355\u636e\u8303\u56f4\uff1a" + flag);
        return flag;
    }

    protected DynamicObject customerGetFundingOrg() {
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("currencychange".equals(messageBoxClosedEvent.getCallBackId())) {
            this.getModel().setDataChanged(false);
        }
        if ("ok".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            if (!(this.getView() instanceof ListView)) {
                this.getModel().setDataChanged(false);
            }
            this.getView().close();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        ErDataCheckUtil.recordEntryCount((String)operateKey, (IDataModel)model, (Log)logger);
        boolean cancel = false;
        String billtype = (String)this.getModel().getValue("formid");
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"save") || org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"submit")) {
            if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype) && model.getValue("currency") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"ErExpenseBaseEdit_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
            if (model.getValue("company") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ErExpenseBaseEdit_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
        }
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"submit")) {
            DynamicObject company = (DynamicObject)model.getValue("company");
            Long companyId = company == null ? Long.valueOf(0L) : (Long)company.getPkValue();
            String orgUseMode = ErCommonUtils.getCostOrgUseMode((Long)companyId);
            if (orgUseMode.equals("0")) {
                cancel = this.checkCostCompany(billtype);
            } else if (orgUseMode.equals("1")) {
                cancel = this.checkCostCompany(billtype);
                cancel = cancel || this.checkCostCenter(billtype);
            } else if (orgUseMode.equals("2")) {
                cancel = this.checkCostCompany(billtype);
                cancel = cancel || this.checkCostCenter(billtype);
            }
        }
        AttachmentCountUtils.setAttachmentCount((FormOperate)operate, (IDataModel)this.getModel(), (IFormView)this.getView());
        UnRepaymentAmountUtil.setUnrepaymentAmountAndBillPayerAmount((IFormView)this.getView(), (FormOperate)operate);
        if (cancel) {
            args.setCancel(cancel);
        }
    }

    private boolean checkCostCenter(String billType) {
        IDataModel model = this.getModel();
        boolean cancel = false;
        DynamicObject dynamicObject = model.getDataEntity(true);
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company != null) {
            DynamicObject costCenter;
            Long companyId = (Long)company.getPkValue();
            String entityType = model.getDataEntityType().toString();
            int showType = 1;
            if (!ErEntityTypeUtils.isDailyVehicleBill((String)billType)) {
                showType = ErCommonUtils.getExpenseAssumeShowTypes((long)companyId);
            }
            if (showType == 1 && null == (costCenter = dynamicObject.getDynamicObject("std_costcenter")) && !ErEntityTypeUtils.isWithholdingBill((String)billType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199  \u201c\u6210\u672c\u4e2d\u5fc3\u201d\u3002", (String)"ErExpenseBaseEdit_11", (String)"fi-er-formplugin", (Object[])new Object[0]));
                cancel = true;
            }
            if (showType == 2 && !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)entityType, (CharSequence)"er_repaymentbill") && !ErEntityTypeUtils.isDailyVehicleBill((String)billType)) {
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("expenseentryentity");
                int index = 1;
                DynamicProperty property = this.getModel().getDataEntityType().getProperty("expenseentryentity");
                String etnryName = property.getDisplayName().getLocaleValue();
                for (DynamicObject obj : collection) {
                    DynamicObject entryCostCenter = null;
                    if (obj.containsProperty("std_entrycostcenter")) {
                        entryCostCenter = obj.getDynamicObject("std_entrycostcenter");
                    }
                    if (obj.containsProperty("entrycostcenter")) {
                        entryCostCenter = obj.getDynamicObject("entrycostcenter");
                    }
                    if (null == entryCostCenter) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c\u6210\u672c\u4e2d\u5fc3\u201d\u5b57\u6bb5\u3002", (String)"ErExpenseBaseEdit_13", (String)"fi-er-formplugin", (Object[])new Object[0]), etnryName, index));
                        cancel = true;
                        break;
                    }
                    ++index;
                }
            }
        }
        return cancel;
    }

    private boolean checkCostCompany(String billtype) {
        IDataModel model = this.getModel();
        boolean cancel = false;
        DynamicObject dynamicObject = model.getDataEntity(true);
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company != null) {
            Long companyId = (Long)company.getPkValue();
            String entityType = model.getDataEntityType().toString();
            int showType = 1;
            if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                showType = ErCommonUtils.getExpenseAssumeShowTypes((long)companyId);
            }
            if (showType == 1) {
                DynamicObject costCompany = dynamicObject.getDynamicObject("costcompany");
                DynamicObject costDept = dynamicObject.getDynamicObject("costdept");
                if (null == costCompany) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3002", (String)"ErExpenseBaseEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    cancel = true;
                }
                if (null == costDept) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u3002", (String)"ErExpenseBaseEdit_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    cancel = true;
                }
            }
            if (showType == 2 && !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)entityType, (CharSequence)"er_repaymentbill") && !ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("expenseentryentity");
                int index = 1;
                DynamicProperty property = this.getModel().getDataEntityType().getProperty("expenseentryentity");
                String etnryName = property.getDisplayName().getLocaleValue();
                for (DynamicObject obj : collection) {
                    DynamicObject entryCostCompany = obj.getDynamicObject("entrycostcompany");
                    DynamicObject entryCostDept = obj.getDynamicObject("entrycostdept");
                    if (null == entryCostDept) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u201d\u5b57\u6bb5\u3002", (String)"ErExpenseBaseEdit_14", (String)"fi-er-formplugin", (Object[])new Object[0]), etnryName, index));
                        cancel = true;
                        break;
                    }
                    if (null == entryCostCompany) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u5b57\u6bb5\u3002", (String)"ErExpenseBaseEdit_15", (String)"fi-er-formplugin", (Object[])new Object[0]), etnryName, index));
                        cancel = true;
                        break;
                    }
                    ++index;
                }
            }
        }
        return cancel;
    }

    protected void applierInfoChange(String propName, Object propValue) {
        this.refreshBaseInfoLabel(propName, propValue);
    }

    protected void refreshBaseInfoLabel(String propName, Object propValue) {
        String propStr = null;
        if (propValue instanceof DynamicObject) {
            ILocaleString name = ((DynamicObject)propValue).getLocaleString("name");
            propStr = name.getLocaleValue();
        } else if (propValue instanceof String) {
            propStr = (String)propValue;
        }
        Label propControl = (Label)this.getControl(propName + "V");
        if (propControl != null) {
            propControl.setText(propStr);
        }
    }

    protected void deptChange(DynamicObject dept) {
        Long companyId = 0L;
        if (dept != null) {
            DynamicObjectCollection expItems;
            IDataModel model = this.getModel();
            Long deptId = (Long)dept.getPkValue();
            companyId = CoreBaseBillServiceHelper.initCompanyByDept((Long)deptId);
            model.setValue("company", (Object)companyId);
            int showType = 1;
            String billtype = (String)this.getModel().getValue("formid");
            if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                showType = ErCommonUtils.getExpenseAssumeShowTypes((long)companyId);
            }
            if (showType == 2 && (expItems = this.getModel().getEntryEntity("expenseentryentity")).size() > 0) {
                this.getModel().setValue("entrycostdept", (Object)dept, 0);
            }
        }
        this.refreshBaseInfoLabel("org", dept);
    }

    protected void checkExpenseItem(DynamicObject costDept, int rowIndex) {
        Long expItemId = ErCommonUtils.getPk((Object)this.getModel().getValue("expenseitem", rowIndex));
        if (expItemId == null) {
            return;
        }
        if (!ExpenseItemServiceHelper.checkExpenseItem((IDataModel)this.getModel(), (int)rowIndex, (Long)expItemId)) {
            this.getModel().setValue("expenseitem", null, rowIndex);
        }
    }

    protected void costDeptChange(String propName, DynamicObject costDept) {
        boolean isNotRelated;
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        this.refreshBaseInfoLabel(propName, costDept);
        Long costDeptId = (Long)costDept.getPkValue();
        DynamicObject company = (DynamicObject)model.getValue("company");
        int showType = 1;
        boolean isModeOne = true;
        if (company != null) {
            String billtype = (String)this.getModel().getValue("formid");
            if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
                showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
            }
            model.setValue("expensesassumeshowtypes", (Object)String.valueOf(showType));
            isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)((Long)company.getPkValue())));
        }
        boolean bl = isNotRelated = "2".equals(ErStdConfig.get((String)"Costcompany Unbinding")) && showType == 1;
        if (!isNotRelated && isModeOne) {
            if (showType != 3 || this.isShowTypeExceptionBill()) {
                DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
                CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
                Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
                model.setValue("costcompany", (Object)costCompanyId);
                costCompany = (DynamicObject)model.getValue("costcompany");
                this.refreshBaseInfoLabel("costcompany", costCompany);
                if (costCompanyId == null || costCompanyId.compareTo(Long.valueOf("0")) == 0) {
                    return;
                }
            }
            int entryRowCount = model.getEntryRowCount("expenseentryentity");
            if (showType == 3 && entryRowCount > 0 && !this.isShowTypeExceptionBill()) {
                model.setValue("entrycostdept", (Object)costDeptId, 0);
            }
            String changeapplier = this.getPageCache().get("er_changeapplier");
            if (showType == 1 || changeapplier != null && showType == 3) {
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue("entrycostdept", (Object)costDeptId, i);
                }
            }
        } else {
            DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
            int entryRowCount = model.getEntryRowCount("expenseentryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                if (isModeOne) {
                    model.setValue("entrycostdept", (Object)costDeptId, i);
                    model.setValue("entrycostcompany", (Object)costCompany, i);
                    continue;
                }
                model.beginInit();
                model.setValue("entrycostdept", (Object)costDeptId, i);
                model.endInit();
                this.getView().updateView("entrycostdept", i);
            }
        }
        if (!isModeOne) {
            ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)false);
        }
    }

    protected void costCompanychange(DynamicObject propValue) {
        IDataModel model = this.getModel();
        Object company = model.getValue("company");
        int showType = 1;
        String billtype = (String)this.getModel().getValue("formid");
        if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)company));
        }
        if (showType == 1 || showType == 3) {
            int entryRowCount = model.getEntryRowCount("expenseentryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                model.setValue("entrycostcompany", (Object)propValue, i);
            }
        }
    }

    protected void entryCostCompanyChange(int index, DynamicObject propValue) {
        IDataModel model = this.getModel();
        Object company = model.getValue("company");
        int showType = 1;
        String billtype = (String)this.getModel().getValue("formid");
        if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes((long)ErCommonUtils.getPk((Object)company));
        }
        if (showType == 2 && index == 0) {
            this.getModel().setValue("costcompany", (Object)propValue);
        }
    }

    protected void entryCostDeptChange(DynamicObject costDept, int rowIndex) {
        if (costDept == null) {
            return;
        }
        IDataModel model = this.getModel();
        String billtype = (String)this.getModel().getValue("formid");
        DynamicObject company = (DynamicObject)model.getValue("company");
        Long costDeptId = (Long)costDept.getPkValue();
        int showType = 1;
        if (!ErEntityTypeUtils.isDailyVehicleBill((String)billtype)) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)company.getPkValue()));
        }
        boolean isModeOne = "0".equals(ErCommonUtils.getCostOrgUseMode((Long)(company == null ? Long.valueOf(0L) : (Long)company.getPkValue())));
        if ((showType != 3 || this.isShowTypeExceptionBill()) && isModeOne) {
            DynamicObject costCompany = (DynamicObject)model.getValue("entrycostcompany", rowIndex);
            CostDeptF7ChangePram costDeptF7ChangePram = new CostDeptF7ChangePram(Boolean.TRUE, (Object)costDept, (Object)costCompany, (Object)company);
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((CostDeptF7ChangePram)costDeptF7ChangePram);
            model.setValue("entrycostcompany", (Object)costCompanyId, rowIndex);
        }
        if (!isModeOne) {
            if (showType == 3) {
                ErCostCenterUtil.setCostCenterByCostDept((IFormView)this.getView(), (String)"expenseentryentity", (DynamicObject)costDept, (int)rowIndex, (int)-1);
            } else {
                ErCostCenterUtil.initEntryCostCenter((IDataModel)this.getModel(), (String)"expenseentryentity", (int)rowIndex, (int)-1);
            }
        }
        if (company != null && rowIndex == 0 && (showType == 2 || showType == 3)) {
            model.setValue("costdept", (Object)costDeptId);
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        String showType = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView());
        if ("expenseentryentity".equals(entryName)) {
            int[] rowIndexs;
            for (int row : rowIndexs = e.getRowIndexs()) {
                Object entryCostCenter;
                if (row != 0) continue;
                int count = this.getModel().getEntryRowCount("expenseentryentity");
                if (count <= 0) break;
                Object entrycostdept = this.getModel().getValue("entrycostdept", 0);
                Object entrycostcompany = this.getModel().getValue("entrycostcompany", 0);
                if (entrycostdept != null) {
                    if (entrycostcompany != null) {
                        this.getModel().beginInit();
                        this.getModel().setValue("costdept", entrycostdept);
                        this.getModel().endInit();
                        this.getView().updateView("costdept");
                        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)showType, (CharSequence)"2") || org.apache.commons.lang3.StringUtils.equals((CharSequence)showType, (CharSequence)"3") && !this.isShowTypeExceptionBill()) {
                            this.getModel().setValue("costcompany", entrycostcompany);
                        }
                    } else {
                        this.entryCostDeptChange((DynamicObject)entrycostdept, 0);
                    }
                }
                String centerKey = "std_entrycostcenter";
                if (this.getModel().getProperty(centerKey) == null) {
                    centerKey = "entrycostcenter";
                }
                if ((entryCostCenter = this.getModel().getValue(centerKey, 0)) == null) break;
                this.getModel().setValue("std_costcenter", entryCostCenter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        IDataModel model = this.getModel();
        if ("er_changeapplier".equals(actionId)) {
            PluginProxy pluginProxy = PluginProxy.create(null, ISuperClosedCallBack.class, (String)"FI_ER_SUPERCLOSEDCALLBACK", null);
            AtomicBoolean b = new AtomicBoolean(true);
            pluginProxy.callReplace(p -> {
                b.set(p.beforeClosedCallBack(ErExpenseBaseEdit.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), e.getReturnData()}));
                return null;
            });
            if (b.get()) {
                this.getPageCache().put("er_changeapplier", "er_changeapplier");
                logger.info("\u7533\u8bf7\u4eba\u53d8\u66f4\u2014\u2014\u9009\u62e9\u8fd4\u56de");
                if (e.getReturnData() != null) {
                    String creditlevelStr;
                    String formId;
                    Map map = (Map)e.getReturnData();
                    long deptId = Long.parseLong(map.get("deptId").toString());
                    String userId = map.get("consignorId").toString();
                    String newtel = map.get("newtel").toString();
                    DynamicObject applier = (DynamicObject)model.getValue("applier");
                    String applierId = applier.getPkValue().toString();
                    String returnDataJson = Er.objToJson((Object)map);
                    logger.info(String.format("\u7533\u8bf7\u4eba\u53d8\u66f4\u2014\u2014\u9009\u62e9\u8fd4\u56de\u6570\u636e: %s", returnDataJson));
                    if (!applierId.equals(userId)) {
                        model.setValue("applier", (Object)Long.valueOf(userId));
                        DynamicObject newapplier = (DynamicObject)model.getValue("applier");
                        String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)newapplier.getPkValue()));
                        Image applierPic = (Image)this.getControl("applierpic");
                        applierPic.setUrl(applierPicUrl);
                        model.setValue("tel", (Object)newtel);
                        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
                        pageCache.put("consignorId", userId);
                    }
                    model.setValue("applierpositionstr", (Object)((String)map.get("newPositionStr")));
                    Label propControl = (Label)this.getControl("applierpositionv");
                    propControl.setText((String)map.get("newPositionStr"));
                    model.setValue("company", ErCommonUtils.getObjectValue(map.get("newCompanyId")));
                    model.setValue("org", (Object)deptId);
                    model.setValue("costdept", (Object)deptId);
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView()), (CharSequence)"3")) {
                        Long costCompany = CoreBaseBillServiceHelper.getAccountOrgId((Long)deptId);
                        model.setValue("costcompany", (Object)costCompany);
                    }
                    if (!ErEntityTypeUtils.isDailyApplyBill((String)(formId = (String)model.getValue("formid")))) {
                        CoreBaseBillServiceHelper.changeAccountEntry((IDataModel)model, (Long)Long.valueOf(userId));
                    }
                    if (StringUtils.isEmpty((String)(creditlevelStr = CreditLevelServiceHelper.getCreditLevelByUserAndView((Object)userId, (IFormView)this.getView())))) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"creditlevel"});
                    } else {
                        ((Label)this.getView().getControl("creditlevel")).setText(creditlevelStr);
                    }
                    if (ErEntityTypeUtils.isPublicReimburseBill((String)formId) || ErEntityTypeUtils.isPrePayBill((String)formId) || ErEntityTypeUtils.isCostEstimatebill((String)formId)) {
                        String relationcontract = "0";
                        if (model.getValue("company") != null) {
                            relationcontract = SystemParamterUtil.getRelationContract((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
                        }
                        model.setValue("relationcontract", (Object)relationcontract);
                    }
                }
                if (model.getDataEntity().getDataEntityType().getProperties().containsKey((Object)"writeoffapply")) {
                    Long newCurrencyID;
                    Long newCompanyID = (Long)((DynamicObject)model.getValue("company")).getPkValue();
                    Object costCompany = model.getValue("costcompany");
                    String filterType = ErCommonUtils.getEMParameter((long)newCompanyID, (String)"relatapplybillfilterrange").toString();
                    Long oldCurrencyID = ErCommonUtils.getPk((Object)model.getValue("currency"));
                    if (!oldCurrencyID.equals(newCurrencyID = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)newCompanyID, (Object)costCompany))) {
                        model.deleteEntryData("writeoffapply");
                    }
                    this.checkApplyValid(model, filterType);
                }
            }
            pluginProxy.callReplace(p -> {
                p.afterClosedCallBack(ErExpenseBaseEdit.class, "er_changeapplier", Boolean.TRUE, new Object[]{this.getView(), e.getReturnData()});
                return null;
            });
            this.getPageCache().remove("er_changeapplier");
        }
    }

    private void checkApplyValid(IDataModel model, String filterType) {
        if (ErStdConfig.getBoolean((String)"ext.cancel.checkapplyvalid")) {
            return;
        }
        DynamicObjectCollection writeOffApplyEntry = model.getEntryEntity("writeoffapply");
        if (!writeOffApplyEntry.isEmpty()) {
            LinkedList<Integer> noExistRow = new LinkedList<Integer>();
            Set<String> allBiiIdSet = this.getAllBillIdSet(filterType);
            for (int i = 0; i < writeOffApplyEntry.size(); ++i) {
                if (allBiiIdSet.contains(((DynamicObject)writeOffApplyEntry.get(i)).getString("applybillno"))) continue;
                noExistRow.add(i);
            }
            int[] noExistIndexs = noExistRow.stream().mapToInt(Integer::intValue).toArray();
            model.deleteEntryRows("writeoffapply", noExistIndexs);
        }
    }

    private Set<String> getAllBillIdSet(String filterType) {
        String selectFieds = "id as billid,billno,applier,org,company";
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"E");
        qFilter.and(new QFilter("expenseentryentity.orgiexpebalanceamount", ">", (Object)BigDecimal.ZERO));
        switch (filterType) {
            case "0": {
                qFilter.and(new QFilter("applier", "=", (Object)this.getFilterTypeId("applier")));
                qFilter.and(new QFilter("company", "=", (Object)this.getFilterTypeId("company")));
                break;
            }
            case "1": {
                qFilter.and(new QFilter("org", "=", (Object)this.getFilterTypeId("org")));
                break;
            }
            case "2": {
                qFilter.and(new QFilter("company", "=", (Object)this.getFilterTypeId("company")));
            }
        }
        Map allBillMap = BusinessDataServiceHelper.loadFromCache((String)"er_dailyapplybill", (String)selectFieds, (QFilter[])new QFilter[]{qFilter});
        Set<String> allBillIdSet = allBillMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet()).stream().map(v -> v.getString("billno")).collect(Collectors.toSet());
        return allBillIdSet;
    }

    private Long getFilterTypeId(String type) {
        if (StringUtils.equals((String)"company", (String)type) || StringUtils.equals((String)"org", (String)type) || StringUtils.equals((String)"applier", (String)type)) {
            DynamicObject typeObject = (DynamicObject)this.getModel().getValue(type);
            return typeObject == null ? Long.valueOf(0L) : (Long)typeObject.getPkValue();
        }
        return 0L;
    }

    private boolean isShowTypeExceptionBill() {
        String entryName = this.getView().getEntityId();
        return ErEntityTypeUtils.isApplyProjectBill((String)entryName) || ErEntityTypeUtils.isCostEstimateBill((String)entryName) || ErEntityTypeUtils.isApplyPayBill((String)entryName) || ErEntityTypeUtils.isRepaymentBill((String)entryName) || ErEntityTypeUtils.isShareBill((String)entryName) || ErEntityTypeUtils.isWithholdingBill((String)entryName);
    }
}

