/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Submit;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.formop.CopyEntryRow;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.util.InvoicePackageUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.util.OffsetUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ExpenseEntryPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ExpenseEntryPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("expenseentryentity");
        if (entryRowCount > 0) {
            DynamicObject company;
            String mode;
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency == null) {
                Map billMap = StringUtils.isNotEmpty((CharSequence)((CharSequence)this.getView().getFormShowParameter().getCustomParam("package_import_pc"))) ? InvoicePackageUtil.createNewData((Map)this.getView().getFormShowParameter().getCustomParams()) : CoreBaseBillServiceHelper.createNewData((Long)Long.valueOf(RequestContext.get().getUserId()));
                CoreBaseBillServiceHelper.extService((IFormView)this.getView(), (Map)billMap);
                CoreBaseBillServiceHelper.initObjByMap((Object)model, (Map)billMap);
                ErCostCenterUtil.initHeadCostCenter((IFormView)this.getView(), (boolean)false);
                currency = (DynamicObject)model.getValue("currency");
            }
            if (!"2".equals(mode = ErCommonUtils.getCostOrgUseMode((Long)((Long)(company = (DynamicObject)this.getModel().getValue("company")).getPkValue())))) {
                ((BasedataEdit)this.getControl("entrycostcompany")).setMustInput(true);
                ((BasedataEdit)this.getControl("entrycostdept")).setMustInput(true);
            }
            if (!"0".equals(mode)) {
                String entryCenterProp = "std_entrycostcenter";
                if (this.getControl(entryCenterProp) == null) {
                    entryCenterProp = "entrycostcenter";
                }
                ((BasedataEdit)this.getControl(entryCenterProp)).setMustInput(true);
            }
            DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
            DynamicObject costDept = (DynamicObject)model.getValue("costdept");
            DynamicObject costCenter = (DynamicObject)model.getValue("std_costcenter");
            for (int i = 0; i < entryRowCount; ++i) {
                model.setValue("entrycurrency", currency == null ? null : currency.getPkValue(), i);
                model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), i);
                model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), i);
                if (model.getProperty("std_entrycostcenter") != null) {
                    model.setValue("std_entrycostcenter", costCenter == null ? null : costCenter.getPkValue(), i);
                    continue;
                }
                if (model.getProperty("entrycostcenter") == null) continue;
                model.setValue("entrycostcenter", costCenter == null ? null : costCenter.getPkValue(), i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        ChangeData changeData = valueSet[0];
        Object propNewValue = changeData.getNewValue();
        Object propOldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        int parentRowIndex = changeData.getParentRowIndex();
        IDataModel dataModel = this.getModel();
        IFormView view = this.getView();
        String entityId = this.getView().getEntityId();
        switch (propName) {
            case "entrycurrency": {
                if (propNewValue == null) {
                    dataModel.setValue("entrycurrency", propOldValue, rowIndex);
                    this.refreshExchangeRate(dataModel, (DynamicObject)propOldValue, "exchangerate", "expquotetype", rowIndex);
                    break;
                }
                this.refreshExchangeRate(dataModel, (DynamicObject)propNewValue, "exchangerate", "expquotetype", rowIndex);
                break;
            }
            case "taxamount": {
                if (dataModel.getProperty("taxrate") != null && (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isApplyProjectBill((String)entityId) || ErEntityTypeUtils.isWithholdingBill((String)entityId) || ErEntityTypeUtils.isCostEstimateBill((String)entityId))) {
                    AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false);
                }
                this.setDefaultApproveTax(rowIndex);
                OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)false, (String)propName);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.TAX_AMOUNT);
                break;
            }
            case "expenseamount": {
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propNewValue), (String)"currexpenseamount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                if (dataModel.getProperty("taxrate") != null) {
                    BigDecimal taxRate = (BigDecimal)dataModel.getValue("taxrate", rowIndex);
                    if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isWithholdingBill((String)entityId) || ErEntityTypeUtils.isApplyProjectBill((String)entityId) || ErEntityTypeUtils.isCostEstimateBill((String)entityId)) {
                        AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                    }
                }
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) break;
                Object expenseAmountOri = dataModel.getValue("expenseamount", rowIndex);
                this.getModel().setValue("expeapproveamount", expenseAmountOri, rowIndex);
                break;
            }
            case "currexpenseamount": {
                dataModel.setValue("expeapproveamount", dataModel.getValue("expenseamount", rowIndex), rowIndex);
                break;
            }
            case "expeapproveamount": {
                IDataEntityProperty taxRateProp;
                if (!this.validateExpeCurrAmount(rowIndex)) {
                    return;
                }
                IPageCache pageCache = this.getView().getPageCache();
                String traceId = RequestContext.get().getTraceId();
                pageCache.put("isByCode", traceId + "modifyByCode");
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propNewValue), (String)"expeapprovecurramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
                pageCache.remove("isByCode");
                if (ErEntityTypeUtils.isDailyLoanBill((String)dataModel.getDataEntityType().getName()) || dataModel.getDataEntityType().getName().equalsIgnoreCase("er_dailyloanbill_ssc") || ErEntityTypeUtils.isPrePayBill((String)dataModel.getDataEntityType().getName())) {
                    this.modifyExpeBalanceRelAmount(dataModel, rowIndex);
                }
                if ((taxRateProp = dataModel.getProperty("taxrate")) != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    AmountChangeUtil.updateApproveInfo((IDataModel)this.getModel(), (int)rowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0);
                    OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)propName);
                }
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)view, (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"currency", (ChangeField)ChangeField.EXPEAPPROVE_AMOUNT);
                break;
            }
            case "proxyamt": {
                this.proxyamtchange(rowIndex, dataModel);
                break;
            }
            case "curproxyamt": {
                WriteOffMoneyUtils.writeOffMoney((IDataModel)dataModel, (String)this.getPageCache().get("writeOffType"), (IFormView)view);
                WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)dataModel, (String)this.getPageCache().get("writeOffType"), (IFormView)this.getView());
                WriteOffMoneyUtils.showPayAmount((IDataModel)dataModel, (Label)((Label)this.getControl("totalencashamountlabel")));
                BigDecimal totalNotPayAmount = (BigDecimal)dataModel.getValue("payamount");
                dataModel.beginInit();
                dataModel.setValue("notpayamount", (Object)totalNotPayAmount);
                dataModel.endInit();
                break;
            }
            case "exchangerate": {
                this.whenExchangeRateChangeRefreshCurrAmount(valueSet, rowIndex, parentRowIndex, entityId);
                break;
            }
            case "expenseitem": {
                DynamicObject newExpenseItem = (DynamicObject)propNewValue;
                if (newExpenseItem == null) break;
                if (newExpenseItem.containsProperty("taxrate") && dataModel.getProperty("taxrate") != null) {
                    BigDecimal taxRateFromExpenseItem = newExpenseItem.getBigDecimal("taxrate");
                    InvoiceUtils.updateTaxWhenItemChange((IFormView)view, (IDataModel)dataModel, (BigDecimal)taxRateFromExpenseItem, (int)rowIndex, (int)parentRowIndex);
                }
                if (!newExpenseItem.containsProperty("offset") || dataModel.getProperty("offset") == null) break;
                Boolean itemOffset = newExpenseItem.getBoolean("offset");
                InvoiceUtils.updateOffsetWhenItemChange((IFormView)view, (IDataModel)dataModel, (Boolean)itemOffset, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "taxrate": 
            case "airportconstructionfee": {
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBill((String)entityId) && !ErEntityTypeUtils.isDailyReimburseBillShare((String)entityId) && !ErEntityTypeUtils.isPublicReimburseBillShare((String)entityId) && !ErEntityTypeUtils.isApplyProjectBill((String)entityId) && !ErEntityTypeUtils.isWithholdingBill((String)entityId) && !ErEntityTypeUtils.isCostEstimateBill((String)entityId)) break;
                AmountChangeUtil.updateTaxAmount((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (boolean)true);
                break;
            }
            case "offset": {
                IDataEntityProperty taxRateProp = dataModel.getProperty("taxrate");
                if (taxRateProp != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    OffsetUtils.updateDeductibleTax((IFormView)this.getView(), (int)rowIndex, (int)parentRowIndex, (taxRate.compareTo(BigDecimal.ZERO) != 0 ? 1 : 0) != 0, (String)propName);
                }
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)view, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "deductibletax": {
                BigDecimal taxAmount = (BigDecimal)dataModel.getValue("taxamount", rowIndex, parentRowIndex);
                if (!OffsetUtils.checkDeductibletax((BigDecimal)taxAmount, (BigDecimal)((BigDecimal)propNewValue))) {
                    dataModel.setValue("deductibletax", propOldValue, rowIndex, parentRowIndex);
                    return;
                }
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)view, (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency", (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.DEDUCTIBLE_TAX);
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)view, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "itemreasonfortransferout": {
                OffsetUtils.updateInvoiceOutReason((int)rowIndex, (int)parentRowIndex, (String)((String)propNewValue), (IFormView)this.getView());
                break;
            }
            case "itemnodeductionreason": {
                OffsetUtils.updateInvoiceNoDeductionReason((int)rowIndex, (int)parentRowIndex, (String)((String)propNewValue), (IFormView)this.getView());
                break;
            }
            case "iteminoutamount": {
                InvoiceOffsetUtils.refreshInvoiceOffsetAndOutAmount((IFormView)view, (int)rowIndex, (int)parentRowIndex);
                break;
            }
            case "reimburser": {
                if (propNewValue != null || propOldValue == null) break;
                this.getModel().setValue("reimburser", propOldValue, rowIndex);
                break;
            }
            case "pubreimburser": {
                if (propNewValue != null || propOldValue == null) break;
                this.getModel().setValue("pubreimburser", propOldValue, rowIndex);
                break;
            }
            case "price": {
                AmountChangeUtil.setCurPrice((IDataModel)dataModel, (IFormView)this.getView(), (BigDecimal)((BigDecimal)propNewValue), (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency");
                break;
            }
            case "approvetax": {
                AmountChangeUtil.updatePrice((IDataModel)dataModel, (IFormView)view, (String)"expenseentryentity", (String)"expeapproveamount", (int)rowIndex, (int)parentRowIndex, (String)"entrycurrency", (ChangeField)ChangeField.APPROVE_TAX);
                AmountChangeUtil.updateInOutAmount((IDataModel)this.getModel(), (int)rowIndex, (int)parentRowIndex, (ChangeField)ChangeField.APPROVE_TAX);
                break;
            }
            case "invoicecurrency": {
                if (propNewValue == null) break;
                long pkValue = (Long)((DynamicObject)propNewValue).getPkValue();
                InvoiceUtils.lockCurrency((IFormView)this.getView(), Collections.singleton(pkValue));
                InvoiceUtils.changeInvoiceCurrency((IFormView)view, (ChangeData)changeData);
                break;
            }
        }
    }

    private void whenExchangeRateChangeRefreshCurrAmount(ChangeData[] valueSet, int rowIndex, int parentRowIndex, String entityId) {
        IDataModel dataModel = this.getModel();
        if (dataModel.getProperty("tripbookamount") != null && dataModel.getProperty("tripbookcuramount") != null) {
            BigDecimal oriorderamt = (BigDecimal)dataModel.getValue("tripbookamount", rowIndex, parentRowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)oriorderamt, (String)"tripbookcuramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
            BigDecimal monthSettleAmount = AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"expenseentryentity", (String)"tripbookcuramount");
            dataModel.setValue("monthsettleamount", (Object)monthSettleAmount);
        }
        BigDecimal orgReimAmount = (BigDecimal)dataModel.getValue("expenseamount", rowIndex, parentRowIndex);
        AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)orgReimAmount, (String)"currexpenseamount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
        if (ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isPrePayBill((String)entityId) || dataModel.getDataEntityType().getName().equalsIgnoreCase("er_dailyloanbill_ssc")) {
            BigDecimal orgBalanceAmount = (BigDecimal)dataModel.getValue("orgiexpebalanceamount", rowIndex, parentRowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)orgBalanceAmount, (String)"expebalanceamount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
        }
        this.proxyamtchange(rowIndex, dataModel);
        if (dataModel.getProperty("expeapproveamount") != null && dataModel.getProperty("expeapprovecurramount") != null) {
            BigDecimal approveAmount = (BigDecimal)dataModel.getValue("expeapproveamount", rowIndex, parentRowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)approveAmount, (String)"expeapprovecurramount", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
        }
        if (dataModel.getProperty("price") != null && dataModel.getProperty("curprice") != null) {
            BigDecimal price = (BigDecimal)dataModel.getValue("price", rowIndex, parentRowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)price, (String)"curprice", (String)"exchangerate", (String)"expquotetype", (int)rowIndex, (int)parentRowIndex);
        }
    }

    public void updateProjectAndCostEstimateTax(int rowIndex, int parentIndex) {
        BigDecimal expenseAmount = (BigDecimal)this.getModel().getValue("expenseamount", rowIndex, parentIndex);
        BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex, parentIndex);
        taxRate = taxRate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
        DynamicObject entryCurrency = (DynamicObject)this.getModel().getValue("entrycurrency", rowIndex, parentIndex);
        if (entryCurrency == null) {
            return;
        }
        int precision = entryCurrency.getInt("amtprecision");
        BigDecimal taxAmount = expenseAmount.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), precision, RoundingMode.HALF_EVEN);
        BigDecimal notTaxAmount = expenseAmount.subtract(taxAmount);
        this.getModel().setValue("taxamount", (Object)taxAmount, rowIndex, parentIndex);
        this.getModel().setValue("orientryamount", (Object)notTaxAmount, rowIndex, parentIndex);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName;
        switch (entryName = e.getEntryProp().getName()) {
            case "invoiceentry": {
                int rowCount = this.getModel().getEntryRowCount("invoiceentry");
                if (rowCount == 0) {
                    InvoiceUtils.lockCurrency((IFormView)this.getView(), (Set)Collections.EMPTY_SET);
                    break;
                }
                Set invoiceCurrencySet = this.getModel().getEntryEntity("invoiceentry").stream().map(invoiceEntry -> {
                    DynamicObject invoiceCurrency = invoiceEntry.getDynamicObject("invoicecurrency");
                    if (invoiceCurrency == null) {
                        return 0L;
                    }
                    return (Long)invoiceCurrency.getPkValue();
                }).collect(Collectors.toSet());
                InvoiceUtils.lockCurrency((IFormView)this.getView(), invoiceCurrencySet);
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        String name;
        switch (name = e.getEntryProp().getName()) {
            case "invoiceentry": {
                InvoiceUtils.lockCurrency((IFormView)this.getView(), (Set)Collections.EMPTY_SET);
            }
        }
    }

    protected void proxyamtchange(int rowIndex, IDataModel dataModel) {
        if (dataModel.getDataEntity().getDataEntityType().getProperties().get((Object)"proxytax") != null) {
            BigDecimal oriproxyamt = (BigDecimal)dataModel.getValue("proxyamt", rowIndex);
            AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)oriproxyamt, (String)"curproxyamt", (String)"exchangerate", (String)"expquotetype", (int)rowIndex);
        }
    }

    private void modifyExpeBalanceRelAmount(IDataModel dataModel, int rowIndex) {
        dataModel.beginInit();
        dataModel.setValue("expebalanceamount", dataModel.getValue("expeapprovecurramount", rowIndex), rowIndex);
        dataModel.setValue("orgiexpebalanceamount", dataModel.getValue("expeapproveamount", rowIndex), rowIndex);
        dataModel.endInit();
        this.getView().updateView("expebalanceamount", rowIndex);
        this.getView().updateView("orgiexpebalanceamount", rowIndex);
    }

    private boolean validateExpeCurrAmount(int rowIndex) {
        IDataModel dataModel = this.getModel();
        BigDecimal expeApproveAmount = (BigDecimal)dataModel.getValue("expeapproveamount", rowIndex);
        BigDecimal expenseAmount = (BigDecimal)dataModel.getValue("expenseamount", rowIndex);
        Boolean expisredoffset = Boolean.FALSE;
        if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId())) {
            expisredoffset = (Boolean)dataModel.getValue("expisredoffset", rowIndex);
        }
        if (!(expisredoffset.booleanValue() && expeApproveAmount.compareTo(BigDecimal.ZERO) < 0 || expeApproveAmount.compareTo(expenseAmount) <= 0)) {
            dataModel.setValue("expeapproveamount", (Object)expenseAmount, rowIndex);
            return false;
        }
        return true;
    }

    private void refreshExchangeRate(IDataModel dataModel, DynamicObject entryCurrency, String exchangeRateProp, String quoteTypeProp, int rowIndex) {
        BigDecimal exchangeRate = BigDecimal.ONE;
        String quoteType = "0";
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        DynamicObject company = (DynamicObject)dataModel.getValue("company");
        DynamicObject costCompany = (DynamicObject)dataModel.getValue("costcompany");
        Map exchangeRateAndQuoteType = null;
        if (entryCurrency != null && currency != null && company != null) {
            Long srcCurrencyId = (Long)entryCurrency.getPkValue();
            Long targetCurrencyId = (Long)currency.getPkValue();
            exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)ErCommonUtils.getPk((Object)company), (Object)ErCommonUtils.getPk((Object)costCompany), (Long)srcCurrencyId, (Long)targetCurrencyId, (Object)dataModel);
            exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ZERO);
            quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
        }
        if (StringUtils.isNotEmpty((CharSequence)quoteType)) {
            dataModel.setValue(quoteTypeProp, (Object)quoteType, rowIndex);
        }
        dataModel.setValue(exchangeRateProp, (Object)exchangeRate, rowIndex);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        Boolean isCopy = Boolean.valueOf(this.getPageCache().get("isentrycopy"));
        String adjustmenttype = "";
        if (model.getProperty("adjustmenttype") != null && model.getValue("adjustmenttype") != null) {
            adjustmenttype = (String)model.getValue("adjustmenttype");
        }
        this.getPageCache().remove("isentrycopy");
        isCopy = isCopy == null ? Boolean.FALSE : isCopy;
        String entityId = this.getView().getEntityId();
        if ("expenseentryentity".equals(entryName) && (rowDataEntities = e.getRowDataEntities()).length > 0) {
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
            DynamicObject costDept = (DynamicObject)model.getValue("costdept");
            DynamicObject costCenter = (DynamicObject)model.getValue("std_costcenter");
            DynamicObject company = (DynamicObject)model.getValue("company");
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                int parentRowIndex = rowDataEntity.getParentRowIndex();
                if (isCopy.booleanValue()) {
                    boolean expenseOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)((Long)company.getPkValue()));
                    boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer((IDataModel)model);
                    if (model.getProperty("offset") != null && model.getProperty("expenseitem") != null) {
                        if (expenseOffset && isOrgOffset) {
                            DynamicObject expenseItem = (DynamicObject)model.getValue("expenseitem", rowIndex, parentRowIndex);
                            if (expenseItem != null) {
                                Object offset = expenseItem.get("offset");
                                model.setValue("offset", offset, rowIndex, parentRowIndex);
                            }
                        } else {
                            model.setValue("offset", (Object)false, rowIndex, parentRowIndex);
                        }
                    }
                    if (adjustmenttype.equals("isredoffset")) continue;
                    if (model.getProperty("expenseamount") != null) {
                        BigDecimal amount = rowDataEntity.getDataEntity().getBigDecimal("expenseamount");
                        this.getModel().setValue("expenseamount", (Object)BigDecimal.ZERO, rowIndex);
                        this.getModel().setValue("expenseamount", (Object)amount, rowIndex);
                    }
                    if (model.getProperty("taxamount") == null) continue;
                    BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
                    model.setValue("taxamount", (Object)BigDecimal.ZERO, rowIndex);
                    model.setValue("taxamount", (Object)taxAmount, rowIndex);
                    continue;
                }
                model.beginInit();
                String centerKey = "std_entrycostcenter";
                if (model.getProperty(centerKey) == null) {
                    centerKey = "entrycostcenter";
                }
                model.setValue("entrycostcompany", costCompany == null ? null : costCompany.getPkValue(), rowIndex);
                model.setValue("entrycostdept", costDept == null ? null : costDept.getPkValue(), rowIndex);
                model.setValue(centerKey, costCenter == null ? null : costCenter.getPkValue(), rowIndex);
                model.endInit();
                this.getView().updateView("entrycostcompany", rowIndex);
                this.getView().updateView("entrycostdept", rowIndex);
                this.getView().updateView(centerKey, rowIndex);
                model.setValue("entrycurrency", currency == null ? null : currency.getPkValue(), rowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object operate = args.getSource();
        String entityId = this.getView().getEntityId();
        if (operate instanceof Submit) {
            boolean isReimber;
            boolean bl = isReimber = ErEntityTypeUtils.isTripReimburseBill((String)entityId) || ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId);
            if (isReimber) {
                OffsetUtils.updateInvoiceOffsetBeforeOpe((IFormView)this.getView(), (IDataModel)this.getModel());
            }
        }
        if (operate instanceof CopyEntryRow) {
            boolean isEntryCopy = ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyReimburseBill((String)entityId) || ErEntityTypeUtils.isDailyLoanBill((String)entityId) || ErEntityTypeUtils.isDailyApplyBill((String)entityId) || ErEntityTypeUtils.isReimCtlApplyBill((String)entityId) || ErEntityTypeUtils.isWithholdingBill((String)entityId);
            String entryId = "expenseentryentity";
            CopyEntryRow copyEntryRow = (CopyEntryRow)args.getSource();
            if (copyEntryRow.getParameter().containsKey("entryId")) {
                entryId = copyEntryRow.getParameter().get("entryId").toString();
            }
            EntryGrid grid = (EntryGrid)this.getView().getControl(entryId);
            int[] rowsIndex = grid.getSelectRows();
            if (isEntryCopy && rowsIndex.length > 0) {
                this.getPageCache().put("isentrycopy", "true");
            }
        }
    }

    private void setDefaultApproveTax(int rowIndex) {
        if (this.getModel().getProperty("approvetax") != null) {
            BigDecimal taxAmount = (BigDecimal)this.getModel().getValue("taxamount", rowIndex);
            this.getModel().setValue("approvetax", (Object)taxAmount, rowIndex);
        }
    }
}

