/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldDefValue;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ReceiveEntryPropChange;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.mobile.util.MobileEntryUtil;
import kd.fi.er.formplugin.daily.web.AbstractReceiveEntryPlugin;
import kd.fi.er.formplugin.util.EntryCopyUtil;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ReceiveEntrySecondViewMobPlugin
extends AbstractReceiveEntryPlugin {
    private static Log logger = LogFactory.getLog(ReceiveEntrySecondViewMobPlugin.class);
    private static final String SAVE_BTN = "save";
    private static final String ACOUNT_IMG = "accountclick";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SAVE_BTN});
        BasedataEdit realCardF7 = (BasedataEdit)this.getControl("payer");
        realCardF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            IFormView parentView = this.getView().getParentView();
            DynamicObject applier = parentView.getModel().getDataEntity(true).getDynamicObject("applier");
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            CoreBaseBillServiceHelper.setPayeeF7Filter((ListShowParameter)formShowParameter, (DynamicObject)applier, (List)CoreBaseBillServiceHelper.getMultiReimburserIdCollection((IFormView)parentView));
            String isgetaccountcurrency = "0";
            if (this.getModel().getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
            if ("1".equals(isgetaccountcurrency)) {
                int i = 0;
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("currency", "!=", (Object)i));
            }
        });
        this.addClickListeners(new String[]{ACOUNT_IMG});
    }

    protected void initHeadFieldValue() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel pModel = parentView.getModel();
            this.setValue(pModel, "currency", "iscurrency", "company", "costcompany", "billstatus", "bizdate");
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataEntityProperty property;
        super.afterCreateNewData(e);
        this.initHeadFieldValue();
        this.initEntryData();
        if (this.getView() instanceof MobileFormView && (property = this.getView().getModel().getProperty("billstatus")) != null) {
            String billStatus = (String)this.getView().getModel().getValue("billstatus");
            if (ErBillStatusEnum.A.toString().equalsIgnoreCase(billStatus) || ErBillStatusEnum.D.toString().equalsIgnoreCase(billStatus)) {
                ((MobileFormView)this.getView()).setStatus(OperationStatus.EDIT);
            } else {
                ((MobileFormView)this.getView()).setStatus(OperationStatus.VIEW);
            }
        }
    }

    private void setValue(IDataModel pModel, String ... fields) {
        for (String field : fields) {
            if (pModel.getProperty(field) == null) continue;
            this.getModel().setValue(field, pModel.getValue(field));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (propName) {
            case "accexchangerate": {
                this.accExchangeRateChange(valueSet[0].getNewValue(), rowIndex, this.getView().getParentView().getModel(), this.getView());
                break;
            }
            case "accountcurrency": {
                DynamicObject accountcurrency = (DynamicObject)valueSet[0].getNewValue();
                if (accountcurrency == null) break;
                int entryCurrencyPrecision = AmountUtils.getCurrencyPrecision((Object)accountcurrency.getPkValue());
                BigDecimal accExchangerate = (BigDecimal)this.getModel().getValue("accexchangerate", rowIndex);
                String accQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("accquotetype")), (Object)"0");
                BigDecimal receiveAmount = (BigDecimal)this.getModel().getValue("receiveamount", rowIndex);
                BigDecimal oriReceiveAmount = AmountUtils.getOriAmount((BigDecimal)receiveAmount, (BigDecimal)accExchangerate, (int)entryCurrencyPrecision, (String)accQuoteType);
                model.setValue("orireceiveamount", (Object)oriReceiveAmount.max(BigDecimal.ZERO), rowIndex);
                break;
            }
            case "payer": {
                DynamicObject payer = (DynamicObject)valueSet[0].getNewValue();
                String isgetaccountcurrency = "0";
                if (this.getModel().getValue("company") != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
                }
                if (!"1".equals(isgetaccountcurrency) || payer == null) break;
                DynamicObject currency = payer.getDynamicObject("CURRENCY");
                if (currency == null) {
                    model.beginInit();
                    model.setValue("accountcurrency", null, rowIndex);
                    model.setValue("accexchangerate", (Object)BigDecimal.ZERO, rowIndex);
                    model.setValue("accquotetype", (Object)"0", rowIndex);
                    model.endInit();
                    model.setValue("orireceiveamount", (Object)BigDecimal.ZERO, rowIndex);
                    ErCommonUtils.updateView((IFormView)this.getView(), (int)rowIndex, (String[])new String[]{"orireceiveamount", "accexchangerate", "accountcurrency", "accquotetype"});
                    break;
                }
                model.setValue("accountcurrency", currency.getPkValue(), rowIndex);
            }
        }
    }

    @Override
    protected void orireceiveamountChange(Object propValue, int rowIndex, IDataModel model) {
        IDataModel setValueModel = this.getModel();
        IDataModel getValueModel = this.getView().getParentView().getModel();
        new ReceiveEntryPropChange(getValueModel, setValueModel).orireceiveamountChange(propValue, rowIndex);
    }

    protected void accExchangeRateChange(Object propValue, int rowIndex, IDataModel model, IFormView view) {
        IDataModel setValueModel = this.getModel();
        IDataModel getValueModel = this.getView().getParentView().getModel();
        new ReceiveEntryPropChange(getValueModel, setValueModel).accExchangeRateChange(propValue, rowIndex, view);
    }

    protected void initEntryData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Integer index = (Integer)formShowParameter.getCustomParam("index");
        IFormView parentView = this.getView().getParentView();
        IDataModel model = parentView.getModel();
        String isgetaccountcurrency = "0";
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)model.getValue("company")).getPkValue()));
        }
        if (index != null && index != -1) {
            DynamicObjectCollection accountColl;
            if (parentView != null && !CollectionUtils.isEmpty((Collection)(accountColl = model.getEntryEntity("accountentry")))) {
                this.getModel().beginInit();
                int newRowIndex = MobileEntryUtil.addEntryToModel(this.getModel(), "accountentry", (DynamicObject)accountColl.get(index.intValue()), true);
                this.setAccInfoByParameter(model, isgetaccountcurrency, newRowIndex);
                this.getModel().endInit();
                this.getView().updateView("accountentry", newRowIndex);
            }
        } else {
            this.initEntryRow(0);
            this.setPayerTypeAndValue(0);
        }
    }

    private void setPayerTypeAndValue(int index) {
        IFormView pageView = this.getView().getParentView();
        if (pageView != null && pageView.getModel().getDataEntityType().getProperties().containsKey((Object)"billpayertype") && this.getModel().getDataEntityType().getProperties().containsKey((Object)"accountentry") && this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("accountentry").getDynamicObjectType().getProperties().containsKey((Object)"payertype") && pageView.getModel().getValue("billpayertype") != null) {
            Object val = pageView.getModel().getValue("billpayertype");
            if ("bos_user".equals(val)) {
                val = "er_payeer";
            }
            this.getModel().setValue("payertype", val, index);
        }
    }

    protected void setAccInfoByParameter(IDataModel pmodel, String isgetaccountcurrency, int newRowIndex) {
        this.getModel().beginInit();
        if ("1".equals(isgetaccountcurrency) && this.getModel().getValue("accountcurrency", newRowIndex) == null && pmodel.getEntryRowCount("accountentry") == 0) {
            Map exchangeMap = AmountChangeUtil.getCurrencyByParamentForInit((IFormView)this.getView().getParentView(), (IDataModel)pmodel, (String)isgetaccountcurrency);
            String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
            BigDecimal accchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeMap.get("exchangeRate")), (Object)BigDecimal.ZERO);
            this.getModel().setValue("accountcurrency", exchangeMap.get("currencyId"), newRowIndex);
            this.getModel().setValue("accexchangerate", (Object)accchangeRate, newRowIndex);
            this.getModel().setValue("accquotetype", (Object)quoteType, newRowIndex);
        } else if ("1".equals(isgetaccountcurrency) && this.getModel().getValue("accountcurrency", newRowIndex) == null && pmodel.getEntryRowCount("accountentry") != 0) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.getModel().setValue("accountcurrency", currency == null ? null : currency.getPkValue(), newRowIndex);
            this.getModel().setValue("accexchangerate", (Object)BigDecimal.ONE, newRowIndex);
        } else if ("0".equals(isgetaccountcurrency) && this.getModel().getValue("accountcurrency") != null) {
            long currencyDOId = (Long)((DynamicObject)this.getModel().getValue("accountcurrency")).getPkValue();
            Map exchangeMap = AmountChangeUtil.getCurrentEntryExchangeRate((long)currencyDOId, (IDataModel)pmodel);
            String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeMap.get("quoteType")), (Object)"0");
            this.getModel().setValue("accquotetype", (Object)quoteType);
        }
        this.getModel().endInit();
        ErCommonUtils.updateView((IFormView)this.getView(), (int)newRowIndex, (String[])new String[]{"accexchangerate", "accountcurrency", "accquotetype"});
    }

    protected void initEntryRow(int rowIndex) {
        String isgetaccountcurrency = "0";
        if (this.getModel().getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
        }
        if ("0".equals(isgetaccountcurrency)) {
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            this.getModel().setValue("accountcurrency", currency == null ? null : currency.getPkValue(), rowIndex);
            this.getModel().setValue("accexchangerate", (Object)BigDecimal.ONE, rowIndex);
        } else {
            IFormView parentView = this.getView().getParentView();
            this.setAccInfoByParameter(parentView.getModel(), isgetaccountcurrency, rowIndex);
        }
        this.setPayerTypeAndValue(rowIndex);
        DynamicObject paymode = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry").get(rowIndex)).getDynamicObject("paymode");
        if (paymode == null) {
            Long payModelId = this.getPayModelId();
            if (payModelId != null) {
                this.getModel().setValue("paymode", (Object)payModelId, rowIndex);
            } else {
                paymode = PayeeServiceHelper.getDefaultPayMode();
                this.getModel().setValue("paymode", paymode == null ? null : paymode.getPkValue(), rowIndex);
            }
        }
        DynamicObjectCollection accountEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry");
        long accountentryId = ORM.create().genLongId((IDataEntityType)accountEntries.getDynamicObjectType());
        ((DynamicObject)accountEntries.get(rowIndex)).set("id", (Object)accountentryId);
        IDataEntityProperty accCostCompanyProp = this.getModel().getProperty("acccostcompany");
        if (accCostCompanyProp != null) {
            this.getModel().setValue("acccostcompany", this.getModel().getValue("costcompany"), rowIndex);
        }
    }

    public void click(EventObject evt) {
        Object payerType;
        int rowIndex;
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)SAVE_BTN)) {
            DynamicObjectCollection accountEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("accountentry");
            if (this.checkMustInput(accountEntity)) {
                return;
            }
            DynamicObjectCollection parentAccountEntry = this.getParentAcctEntryCollection();
            if (!CollectionUtils.isEmpty((Collection)parentAccountEntry)) {
                FormShowParameter param = this.getView().getFormShowParameter();
                Integer rowIndex2 = (Integer)param.getCustomParam("index");
                if (rowIndex2 != null && rowIndex2 != -1) {
                    int index = (Integer)param.getCustomParam("index");
                    if (ErEntityTypeUtils.isApplyPayBill((String)this.getView().getParentView().getEntityId())) {
                        EntryCopyUtil.copyDynamicObject((DynamicObject)((DynamicObject)accountEntity.get(0)), (DynamicObject)((DynamicObject)parentAccountEntry.get(index)), new HashSet());
                    } else {
                        parentAccountEntry.remove(index);
                        EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)parentAccountEntry, (DynamicObjectCollection)accountEntity, (int)index);
                    }
                } else {
                    EntryCopyUtil.copyColl2TargetColl((DynamicObjectCollection)parentAccountEntry, (DynamicObjectCollection)accountEntity);
                }
            }
            IFormView parentView = this.getView().getParentView();
            this.getView().sendFormAction(parentView);
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)ACOUNT_IMG) && (rowIndex = this.getModel().getEntryCurrentRowIndex("accountentry")) >= 0 && (payerType = this.getModel().getValue("payertype", rowIndex)) instanceof String) {
            this.showBankAccountSelect((String)payerType);
        }
    }

    private void showBankAccountSelect(String payerType) {
        if (PayerTypeEnum.PAYER.getType().equals(payerType) || PayerTypeEnum.OTHER.getType().equals(payerType)) {
            return;
        }
        Object payerId = PublicReimbursePayerAcctUtils.getPayerPkId((IDataModel)this.getModel(), (String)payerType);
        if (payerId == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6536\u6b3e\u4eba\u3002", (String)"ReceiveEntrySecondViewMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("payerId", payerId);
        customParam.put("payerType", payerType);
        FormModel formModel = new FormModel("er_public_acctselect_mb", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u53f7", (String)"ReceiveEntrySecondViewMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), "5", true, customParam);
        ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this);
    }

    private boolean checkMustInput(DynamicObjectCollection accountEntity) {
        for (int i = 0; i < accountEntity.size(); ++i) {
            DynamicObject entry = (DynamicObject)accountEntity.get(i);
            if (!StringUtils.isBlank((CharSequence)entry.getString("payername"))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4eba\u3002", (String)"ReceiveEntrySecondViewMobPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("accountentry".equals(e.getEntryProp().getName())) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                this.initEntryRow(rowDataEntity.getRowIndex());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("er_public_acctselect_mb")) {
            AccountInfo accountInfo = (AccountInfo)closedCallBackEvent.getReturnData();
            this.fillThisShowView(accountInfo);
            ErExpandServiceFacade.get().invokeExtService("ext.service.er.fillbankInfoMB", "fillbankInfoMB", new Object[]{this.getView(), accountInfo.getExtMap()}, new Class[]{IFormView.class, Map.class});
        }
    }

    private void fillThisShowView(AccountInfo accountInfo) {
        IDataModel model = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("accountentry");
        if (rowIndex >= 0) {
            String account = accountInfo.getAccount();
            model.setValue("payerbank", accountInfo.getBeBank(), rowIndex);
            if (model.getEntryEntity("accountentry").getDynamicObjectType().getProperties().containsKey((Object)"payeraccountname") || model.getDataEntity(true).getDataEntityType().getProperties().containsKey((Object)"payeraccountname")) {
                model.setValue("payeraccountname", (Object)accountInfo.getAccountName(), rowIndex);
            }
            String isgetaccountcurrency = "0";
            if (this.getModel().getValue("company") != null) {
                isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((Long)((DynamicObject)this.getModel().getValue("company")).getPkValue()));
            }
            if ("1".equals(isgetaccountcurrency)) {
                model.setValue("accountcurrency", accountInfo.getCurrency(), rowIndex);
            } else {
                model.setValue("CURRENCY", accountInfo.getCurrency(), rowIndex);
            }
            model.setValue("payeraccount", (Object)account, rowIndex);
        }
    }

    private DynamicObjectCollection getParentAcctEntryCollection() {
        IFormView parentView = this.getView().getParentView();
        DynamicObject parentDataEntity = parentView.getModel().getDataEntity(true);
        return parentDataEntity.getDynamicObjectCollection("accountentry");
    }

    private Long getPayModelId() {
        Long paymodeid = null;
        try {
            String funcParameter;
            BasedataProp basedataProp;
            FieldDefValue defValue2;
            MainEntityType metaInfos;
            Map propertyMap;
            String entityId = this.getView().getParentView().getEntityId();
            if ((ErEntityTypeUtils.isPublicReimburseBill((String)entityId) || ErEntityTypeUtils.isPrePayBill((String)entityId)) && (propertyMap = (metaInfos = MetadataServiceHelper.getDataEntityType((String)entityId)).getAllFields()) != null && !propertyMap.isEmpty() && propertyMap.containsKey("paymode") && propertyMap.get("paymode") != null && propertyMap.get("paymode") instanceof BasedataProp && (defValue2 = (basedataProp = (BasedataProp)propertyMap.get("paymode")).getDefValue2()) != null && !StringUtils.isEmpty((CharSequence)(funcParameter = defValue2.getFuncParameter()))) {
                JSONObject json = JSON.parseObject((String)funcParameter);
                String id = json.getString("id");
                paymodeid = Long.parseLong(id);
            }
        }
        catch (Exception e) {
            paymodeid = null;
            logger.error("---error---", (Object)e.getMessage());
        }
        return paymodeid;
    }
}

