/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.AbstractConvertServiceArgs;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.botp.Push;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.RepaymentAssociateUtil;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class RepaymentBillListPlugin
extends AbstractListPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals((CharSequence)"create", (CharSequence)evt.getItemKey())) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("er_botp_repaybilllist");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_botp_repaybilllist"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else if ("bar_selrec".equals(evt.getItemKey())) {
            ListView list = (ListView)this.getView();
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"RepaymentBillListPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            Set selectrowMap = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if (selectrowMap.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"RepaymentBillListPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!RepaymentAssociateUtil.hasPermissionForAssoiate((IFormView)this.getView())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5173\u8054\u6536\u6b3e\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7edc\u7ba1\u7406\u5458\u3002", (String)"RepaymentBillListPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("id", "=", selectedRows.get(0).getPrimaryKeyValue());
            DynamicObject repaymentBill = QueryServiceHelper.queryOne((String)"er_repaymentbill", (String)"buildrelationway", (QFilter[])new QFilter[]{qFilter});
            if (RepaymentAssociateUtil.hasBOTPRelation((DynamicObject)repaymentBill)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4e0b\u63a8\u6536\u6b3e\u5355\uff0c\u65e0\u6cd5\u5173\u8054\u6536\u6b3e\u3002", (String)"RepaymentBillListPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("er_botp_repay_rec");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_botp_repay_rec"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("repaymentbillId", selectedRows.get(0).getPrimaryKeyValue());
            formShowParameter.setCustomParam("selType", (Object)"list");
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block11: {
            String actionId;
            block10: {
                super.closedCallBack(closedCallBackEvent);
                actionId = closedCallBackEvent.getActionId();
                if (!actionId.equals("er_botp_repay_rec")) break block10;
                List returnData = (List)closedCallBackEvent.getReturnData();
                if (returnData == null) break block11;
                ListView list = (ListView)this.getView();
                ListSelectedRowCollection selectedRows = list.getSelectedRows();
                DynamicObject repaymentBill = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"er_repaymentbill");
                DynamicObjectCollection recCollection = repaymentBill.getDynamicObjectCollection("recentry");
                List oldEntry = recCollection.stream().map(v -> v.getLong("recbillid")).collect(Collectors.toList());
                List newEntry = returnData.stream().map(v -> ((DynamicObject)v).getLong("id")).collect(Collectors.toList());
                List<Long> del = oldEntry.stream().filter(v -> !newEntry.contains(v)).collect(Collectors.toList());
                List add = newEntry.stream().filter(v -> !oldEntry.contains(v)).collect(Collectors.toList());
                boolean needUpdate = RepaymentAssociateUtil.delRecEntry((DynamicObjectCollection)recCollection, del) | RepaymentAssociateUtil.fillRecEntry((DynamicObjectCollection)recCollection, (List)returnData, add);
                if (needUpdate) {
                    if (recCollection.size() > 0 && ErBillStatusEnum.E.toString().equals(repaymentBill.getString("billstatus"))) {
                        repaymentBill.set("billstatus", (Object)ErBillStatusEnum.G.toString());
                    } else if (recCollection.size() == 0 && ErBillStatusEnum.G.toString().equals(repaymentBill.getString("billstatus"))) {
                        repaymentBill.set("billstatus", (Object)ErBillStatusEnum.E.toString());
                    }
                    if (recCollection.size() > 0) {
                        repaymentBill.set("buildrelationway", (Object)"2");
                    } else {
                        repaymentBill.set("buildrelationway", (Object)" ");
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{repaymentBill});
                    this.getView().invokeOperation("refresh");
                }
                if (del.size() > 0) {
                    RepaymentAssociateUtil.removeBOTPRelation((Long)((Long)repaymentBill.getPkValue()), (Long[])del.toArray(new Long[0]));
                }
                if (add.size() <= 0) break block11;
                RepaymentAssociateUtil.buildBOTPRelation((DynamicObjectCollection)recCollection);
                break block11;
            }
            if (StringUtils.equals((CharSequence)"er_botp_repaybilllist", (CharSequence)actionId)) {
                Map returnData = (Map)closedCallBackEvent.getReturnData();
                if (returnData == null) {
                    return;
                }
                for (Map.Entry entry : returnData.entrySet()) {
                    this.doPush((String)entry.getKey(), (List)entry.getValue());
                }
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillShowParameter parameter = e.getParameter();
    }

    private void doPush(String source, List<ListSelectedRow> rows) {
        if (rows.size() == 0) {
            return;
        }
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(source);
        pushArgs.setTargetEntityNumber("er_repaymentbill");
        pushArgs.setSelectedRows(rows);
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!convertResult.isSuccess() || convertResult.getCachePageIds().size() == 0) {
            Push.showReport((IFormView)this.getView(), (AbstractConvertServiceArgs)pushArgs, (ConvertOperationResult)convertResult);
        } else if (convertResult.getCachePageIds().size() == 1) {
            Push.showTargetBill((IFormView)this.getView(), (PushArgs)pushArgs, (ConvertOperationResult)convertResult, (boolean)false);
        } else {
            Push.showMultiTargetBills((IFormView)this.getView(), (PushArgs)pushArgs, (ConvertOperationResult)convertResult, (boolean)false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map map = this.getView().getFormShowParameter().getCustomParams();
        if (ErStdConfig.getBoolean((String)"repaymentbill_relate_casrecbill")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_selrec"});
        }
        Object fromReport = map.get("fromReport");
        if (map != null && null != fromReport && ((Boolean)fromReport).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"toolbarap"});
        }
    }
}

