/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.common.SpecialBillEnum;
import kd.fi.er.formplugin.util.SpecialReimbursebillUtils;

public class SpecialReimbursebill
extends AbstractBillPlugIn {
    private static String SOURCE = "source";
    private static String EXPENSEITEMID = "expenseItemId";
    private static String ISLOCK = "islock";
    private static String EXPITEMNUM = "expitemnum";

    public void registerListener(EventObject e) {
        SpecialReimbursebillUtils.addListener((AbstractFormPlugin)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        SpecialReimbursebillUtils.setExpenseInfoAfterAddNewSpecail((AbstractFormPlugin)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillShowParameter parameter = (BillShowParameter)this.getView().getFormShowParameter();
        String specialType = (String)parameter.getCustomParams().get("specialbill");
        specialType = specialType == null ? (String)this.getModel().getValue("specialbill") : specialType;
        SpecialReimbursebillUtils.setSpecialFiled((String)specialType, (AbstractFormPlugin)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String specialType = (String)model.getValue("specialbill");
        String changefiled = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object thisChanged = changeData[0].getNewValue();
        int rowIndex = changeData[0].getRowIndex();
        switch (changefiled) {
            case "happendate": {
                if (thisChanged == null || StringUtils.isEmpty((CharSequence)specialType)) break;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime((Date)thisChanged);
                model.setValue("happendate", (Object)CommonServiceHelper.getLastDayOfMonthBy((Date)((Date)thisChanged)), rowIndex);
                SpecialReimbursebillUtils.setDescriptionAfterChangeRow((AbstractFormPlugin)this);
            }
        }
    }

    public void afterLoadData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject expitem = (DynamicObject)model.getValue("expenseitem", 0);
        String specialType = (String)model.getValue("specialbill");
        if (expitem != null && !StringUtils.isEmpty((CharSequence)specialType) && !SpecialBillEnum.AMOUNT_DAILY_REIMBURSE.getType().equals(specialType)) {
            BasedataEdit expenseItemField = (BasedataEdit)this.getControl("expenseitem");
            int rows = model.getEntryRowCount("expenseentryentity");
            for (int i = 0; i < rows; ++i) {
                expenseItemField.setEnable("", false, i);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName;
        switch (entryName = e.getEntryProp().getName()) {
            case "expenseentryentity": {
                SpecialReimbursebillUtils.afterAddDetailEntry((AbstractFormPlugin)this);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equalsIgnoreCase("expenseentryentity")) {
            SpecialReimbursebillUtils.setDescriptionAfterChangeRow((AbstractFormPlugin)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String source;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String string = source = customParams.get(SOURCE) == null ? "" : customParams.get(SOURCE).toString();
        if (StringUtils.equals((CharSequence)source, (CharSequence)"amountQueryReport")) {
            Object expenseItemId = customParams.get(EXPENSEITEMID);
            if (expenseItemId == null) {
                return;
            }
            String expenseitemNum = CommonServiceHelper.getObjById((String)"er_expenseitemedit", (Long)((Long)expenseItemId)).getString("number");
            List items = ((ComboProp)EntityMetadataCache.getDataEntityType((String)"er_dailyreimbursebill").getProperties().get((Object)"specialbill")).getComboItems();
            for (ValueMapItem item : items) {
                String value = item.getValue();
                String[] captionInfo = item.getName().getLocaleValue().split(",");
                if (captionInfo.length < 2 || !expenseitemNum.equals(captionInfo[1])) continue;
                formShowParameter.setCaption(captionInfo[0]);
                customParams.put("specialbill", value);
                customParams.put(EXPITEMNUM, expenseitemNum);
                if (captionInfo.length < 3) break;
                customParams.put(ISLOCK, captionInfo[2]);
                break;
            }
        }
    }
}

