/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.reimburse;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.fi.er.business.daily.reimburse.AmountObject;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ApplyToReimburseAutoCreateLoanRowEnum;
import kd.fi.er.formplugin.daily.web.AbstractExpenseBaseBillPlugin;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import kd.fi.er.formplugin.util.AmountQueryAndReimburseUtils;
import kd.fi.er.formplugin.web.ErTripReimAutoWriteDescription;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ErReimburseBaseBillEdit
extends AbstractExpenseBaseBillPlugin
implements RowClickEventListener {
    private static Log logger = LogFactory.getLog(ErReimburseBaseBillEdit.class);

    public void initialize() {
        AbstractGrid invoiceentry;
        AbstractGrid entryentity;
        AbstractGrid applyGrid;
        super.initialize();
        BasedataEdit currencyF7 = (BasedataEdit)this.getControl("entrycurrency");
        if (currencyF7 == null) {
            return;
        }
        currencyF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        });
        AbstractGrid writeoffmoney = (AbstractGrid)this.getControl("writeoffmoney");
        if (writeoffmoney != null) {
            writeoffmoney.addRowClickListener((RowClickEventListener)this);
        }
        if ((applyGrid = (AbstractGrid)this.getControl("writeoffapply")) != null) {
            applyGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((entryentity = (AbstractGrid)this.getControl("expenseentryentity")) != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
        if ((invoiceentry = (AbstractGrid)this.getControl("invoiceentry")) != null) {
            invoiceentry.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap3", "advcontoolbarap22"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        CommonServiceHelper.getDeductibleTaxShowType((IDataModel)this.getModel(), (IFormView)this.getView());
    }

    @Override
    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        WriteOffMoneyUtils.showPayAmount((IDataModel)this.getModel(), (Label)((Label)this.getControl("totalencashamountlabel")));
        boolean isChanged = this.getModel().getDataChanged();
        CommonServiceHelper.getDeductibleTaxShowType((IDataModel)this.getModel(), (IFormView)this.getView());
        if (ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String isredoffset = "";
            isredoffset = ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) ? (String)formShowParameter.getCustomParam("isredoffset") : (String)formShowParameter.getCustomParam("dailyreimisredoffset");
            if ("true".equals(isredoffset)) {
                this.getModel().setValue("adjustmenttype", (Object)"isredoffset");
            }
        }
        this.getModel().setDataChanged(isChanged);
    }

    public void beforeBindData(EventObject e) {
        Container withholdingentry;
        super.beforeBindData(e);
        Container advconapoffapply = (Container)this.getControl("advconapoffapply");
        if (advconapoffapply != null) {
            if (this.getModel().getEntryRowCount("writeoffapply") > 0) {
                advconapoffapply.setCollapse(Boolean.FALSE.booleanValue());
            } else {
                advconapoffapply.setCollapse(Boolean.TRUE.booleanValue());
            }
        }
        if ((withholdingentry = (Container)this.getControl("whadvconap")) != null) {
            if (this.getModel().getEntryRowCount("withholdingentry") == 0) {
                withholdingentry.setCollapse(Boolean.TRUE.booleanValue());
            } else {
                withholdingentry.setCollapse(Boolean.FALSE.booleanValue());
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean dataChange = this.getModel().getDataChanged();
        if (this.getWriteOffType() == null) {
            this.showWoType();
        }
        PublicBillUtil.showInvoiceEntry((IFormView)this.getView());
        AmountQueryAndReimburseUtils.setExpenseInfoFromQueryAmount((AbstractBillPlugIn)this);
        IDataModel dataModel = this.getModel();
        String billStatus = (String)dataModel.getValue("billstatus");
        int rowcount = this.getModel().getEntryRowCount("accountentry");
        if (rowcount == 0 && ("A".equals(billStatus) || "D".equals(billStatus)) && !this.isPublicContractBiz()) {
            CoreBaseBillServiceHelper.initDefaultAccountEntry((IDataModel)dataModel);
        }
        if (this.getModel().getDataEntity().getDataEntityState().isPushChanged() || Boolean.TRUE.equals((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy"))) {
            DynamicObjectCollection expense = dataModel.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
            if (expense != null && expense.size() > 0) {
                BigDecimal approveCurrAmountOld = (BigDecimal)dataModel.getValue("expeapprovecurramount", 0);
                dataModel.beginInit();
                dataModel.setValue("expeapprovecurramount", (Object)0, 0);
                dataModel.endInit();
                dataModel.setValue("expeapprovecurramount", (Object)approveCurrAmountOld, 0);
            }
            WriteOffMoneyUtils.showPayAmount((IDataModel)dataModel, (Label)((Label)this.getControl("totalencashamountlabel")));
        }
        this.getModel().setDataChanged(dataChange);
        if ((ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) && ("E".equals(dataModel.getValue("billstatus")) || "F".equals(dataModel.getValue("billstatus")) || "G".equals(dataModel.getValue("billstatus")))) {
            DynamicObjectCollection accEntry;
            int i;
            DynamicObjectCollection entryEntity = dataModel.getEntryEntity("expenseentryentity");
            Object adjustmenttype = dataModel.getValue("adjustmenttype");
            if (adjustmenttype == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dataModel.getValue("adjustmenttype").toString()) || "ischangeinvoice".equals(dataModel.getValue("adjustmenttype").toString())) {
                for (i = 0; i < entryEntity.size(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"expenseamount", "expeapproveamount"});
                }
            } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)dataModel.getValue("adjustmenttype").toString(), (CharSequence)"isredoffset")) {
                for (i = 0; i < entryEntity.size(); ++i) {
                    Boolean expredoffset = (Boolean)dataModel.getValue("expisredoffset");
                    if (expredoffset.booleanValue()) continue;
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"expenseamount", "expeapproveamount"});
                }
            } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)dataModel.getValue("adjustmenttype").toString(), (CharSequence)"isstopreim")) {
                for (i = 0; i < entryEntity.size(); ++i) {
                    this.getView().setEnable(Boolean.FALSE, i, new String[]{"expenseamount"});
                }
            }
            if ((accEntry = dataModel.getEntryEntity("accountentry")) != null && accEntry.size() > 0) {
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                if (adjustmenttype != null && org.apache.commons.lang3.StringUtils.equals((CharSequence)dataModel.getValue("adjustmenttype").toString(), (CharSequence)"isredoffset") && proxy != null) {
                    proxy.invokeControlMethod("accountentry", "setColProp", new Object[]{"orireceiveamount", "l", 0});
                }
            }
        }
    }

    private boolean isPublicContractBiz() {
        boolean flag = false;
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            IDataModel model = this.getModel();
            String detailType = model.getDataEntity().getString("detailtype");
            DynamicObjectCollection accColl = model.getDataEntity().getDynamicObjectCollection("accountentry");
            DynamicObjectCollection expColl = model.getDataEntity().getDynamicObjectCollection("expenseentryentity");
            if (WriteOffMoneyUtils.isContract((IDataModel)this.getModel()) && expColl.size() > accColl.size()) {
                flag = true;
            }
        }
        return flag;
    }

    private void showWoType() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        if (company == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]), MessageTypes.Permission, new ConfirmCallBackListener("ok", (IFormPlugin)this));
            logger.warn("\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a, \u6838\u9500\u65b9\u5f0f\u9ed8\u8ba4\u4e3a\uff1a\u672c\u4f4d\u5e01\u51b2\u9500");
            String woType = WriteOffTypeEnum.CURR_WO.getValue();
            this.setModelWoType(woType);
            return;
        }
        Object woType = ErCommonUtils.getLoanCheckType((long)Long.parseLong(company.getPkValue().toString()));
        if (woType == null || woType.toString().isEmpty()) {
            logger.warn(String.format("\u516c\u53f8 {%s}\uff1a\u672a\u8bbe\u7f6e\u6838\u9500\u65b9\u5f0f", company.getPkValue()));
            woType = WriteOffTypeEnum.CURR_WO.getValue();
        }
        this.setModelWoType(woType);
    }

    private void setModelWoType(Object woType) {
        boolean dataChange = this.getModel().getDataChanged();
        this.getModel().setValue("writeofftype", woType);
        this.getModel().setDataChanged(dataChange);
        this.setWriteOffType(woType.toString());
    }

    private void setWriteOffType(String writeOffType) {
        this.getPageCache().put("writeOffType", writeOffType);
    }

    private String getWriteOffType() {
        return this.getPageCache().get("writeOffType");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("ok".equalsIgnoreCase(messageBoxClosedEvent.getCallBackId())) {
            if (!(this.getView() instanceof ListView)) {
                this.getModel().setDataChanged(false);
            }
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        Object oldValue = valueSet[0].getOldValue();
        int rowIndex = valueSet[0].getRowIndex();
        IDataModel dataModel = this.getModel();
        switch (propName) {
            case "expeapprovecurramount": {
                String writeOffType = this.getWriteOffType();
                if (writeOffType == null) {
                    this.showWoType();
                }
                if (!this.isPublicContractBiz()) {
                    WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
                    WriteOffMoneyUtils.writeOffMoney((IDataModel)dataModel, (String)this.getWriteOffType(), (IFormView)this.getView());
                    WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)dataModel, (String)this.getWriteOffType(), (IFormView)this.getView());
                    WriteOffMoneyUtils.showPayAmount((IDataModel)dataModel, (Label)((Label)this.getControl("totalencashamountlabel")));
                    ErReimburseBaseBillEdit.refreshBillHeadAmount(dataModel);
                    this.getView().updateView("reimburseamount");
                    dataModel.setValue("totalaccloanamount", (Object)AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"writeoffmoney", (String)"curraccloanamount"));
                    this.getView().updateView("expeapprovecurramount", rowIndex);
                    this.getView().updateView("exchangerate", rowIndex);
                    this.getView().updateView("expeapproveamount", rowIndex);
                    if (dataModel.getEntryRowCount("withholdingentry") <= 0) break;
                    DynamicObject entrycurrency = (DynamicObject)dataModel.getValue("entrycurrency", rowIndex);
                    DynamicObjectCollection dynamicObjectCollection = dataModel.getDataEntity(true).getDynamicObjectCollection("withholdingentry");
                    for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                        DynamicObject whcurrency = (DynamicObject)((DynamicObject)dynamicObjectCollection.get(i)).get("whcurrency");
                        if (entrycurrency == null || whcurrency == null || !entrycurrency.getPkValue().equals(whcurrency.getPkValue())) continue;
                        this.getView().updateView("whbursedamount", i);
                        this.getView().updateView("whbursedcurramount", i);
                    }
                    break;
                }
                WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
                WriteOffMoneyUtils.writeOffMoney((IDataModel)dataModel, (String)this.getWriteOffType(), (IFormView)this.getView());
                AmountObject payAmountObject = WriteOffMoneyUtils.calculatePayAmount((IDataModel)dataModel, (String)this.getWriteOffType(), (IFormView)this.getView());
                BigDecimal currPayAmount = payAmountObject.getCurrAmount();
                if (currPayAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    dataModel.setValue("payamount", (Object)BigDecimal.ZERO);
                } else {
                    dataModel.setValue("payamount", (Object)currPayAmount);
                }
                ErReimburseBaseBillEdit.refreshBillHeadAmount(dataModel);
                dataModel.setValue("totalaccloanamount", (Object)AmountUtils.getEntryAmount((IDataModel)dataModel, (String)"writeoffmoney", (String)"curraccloanamount"));
                WriteOffMoneyUtils.showPayAmount((IDataModel)dataModel, (Label)((Label)this.getControl("totalencashamountlabel")));
                break;
            }
            case "accloanamount": {
                BigDecimal loanAmount = (BigDecimal)this.getModel().getValue("loanamount", rowIndex);
                BigDecimal currloanamount = (BigDecimal)this.getModel().getValue("currloanamount", rowIndex);
                BigDecimal writeOffAmount = (BigDecimal)propValue;
                if (!this.getWriteOffType().equals(WriteOffTypeEnum.ORGI_WO.getValue())) break;
                if (!this.updateWoAmountValidator(dataModel, rowIndex)) {
                    return;
                }
                if (writeOffAmount.compareTo(loanAmount) > 0) {
                    this.getModel().setValue(propName, oldValue, rowIndex);
                    break;
                }
                if (writeOffAmount.compareTo(loanAmount) == 0) {
                    this.getModel().setValue("curraccloanamount", (Object)currloanamount, rowIndex);
                    break;
                }
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propValue), (String)"curraccloanamount", (String)"loanexchangerate", (String)"loancurrency", (String)"writeoffquotetype", (int)rowIndex);
                break;
            }
            case "reimbursedamount": {
                if (!this.getWriteOffType().equals(WriteOffTypeEnum.ORGI_WO.getValue())) break;
                if (!this.updateWoApplyValidator(dataModel, "applycurrency", "reimbursedamount", "reimbursedcurramount", rowIndex)) {
                    return;
                }
                this.getModel().beginInit();
                AmountUtils.refreshCurrAmount((IDataModel)dataModel, (BigDecimal)((BigDecimal)propValue), (String)"reimbursedcurramount", (String)"applyexchangerate", (String)"applycurrency", (String)"writeoffapplyquotetype", (int)rowIndex);
                this.getView().updateView("reimbursedcurramount", rowIndex);
                this.getModel().endInit();
                break;
            }
            case "reimbursedcurramount": {
                BigDecimal orgiAmount;
                String writeType = this.getWriteOffType();
                if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeType)) {
                    return;
                }
                this.getModel().beginInit();
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)dataModel.getValue("applyexchangerate", rowIndex)), (Object)BigDecimal.ONE);
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue("writeoffapplyquotetype", rowIndex)), (Object)"0");
                BigDecimal currAmount = (BigDecimal)propValue;
                if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType)) {
                    exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : exchangeRate;
                    orgiAmount = currAmount.divide(exchangeRate, AmountUtils.getCurrencyPrecision((IDataModel)dataModel, (String)"applycurrency"), RoundingMode.HALF_UP);
                } else {
                    orgiAmount = currAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision((IDataModel)dataModel, (String)"applycurrency"), RoundingMode.HALF_UP);
                }
                dataModel.setValue("reimbursedamount", (Object)orgiAmount, rowIndex);
                this.getModel().endInit();
                this.getView().updateView("reimbursedamount", rowIndex);
                break;
            }
            case "curraccloanamount": {
                BigDecimal currLoanAmoun = (BigDecimal)this.getModel().getValue("currloanamount", rowIndex);
                BigDecimal writeOffCurrAmount = (BigDecimal)propValue;
                if (this.getWriteOffType().equals(WriteOffTypeEnum.CURR_WO.getValue())) {
                    if (writeOffCurrAmount.compareTo(currLoanAmoun) > 0) {
                        this.getModel().setValue(propName, oldValue, rowIndex);
                        break;
                    }
                    if (writeOffCurrAmount.compareTo(currLoanAmoun) == 0) {
                        BigDecimal loanamount = (BigDecimal)this.getModel().getValue("loanamount", rowIndex);
                        dataModel.setValue("accloanamount", (Object)loanamount, rowIndex);
                        this.refreshEncashedAmount(dataModel);
                        break;
                    }
                }
                this.curCheckLoanAmountChange(propValue, rowIndex, dataModel);
                break;
            }
            case "company": 
            case "applier": {
                this.showWoType();
                dataModel.deleteEntryData("writeoffmoney");
                break;
            }
            case "org": {
                Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                String range = SystemParamterUtil.getLoanDrawRange((Long)companyId);
                if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)range, (CharSequence)"2")) break;
                dataModel.deleteEntryData("writeoffmoney");
                break;
            }
            case "expenseitem": {
                Object description = this.getModel().getValue("description");
                if (description != null && !((String)description).isEmpty()) break;
                logger.info("come in there one , description : " + description);
                ErTripReimAutoWriteDescription.setDiscription(this.getView());
                break;
            }
            case "proxytax": {
                if (!Boolean.TRUE.equals(propValue)) break;
                this.refreshEncashedAmount(dataModel);
                break;
            }
            case "currency": {
                WriteOffMoneyUtils.showPayAmount((IDataModel)dataModel, (Label)((Label)this.getControl("totalencashamountlabel")));
                break;
            }
            case "whbursedamount": {
                if (!this.getWriteOffType().equals(WriteOffTypeEnum.ORGI_WO.getValue())) break;
                if (!this.updateWoApplyValidator(dataModel, "whcurrency", "whbursedamount", "whbursedcurramount", rowIndex)) {
                    return;
                }
                BigDecimal whbursedamount = (BigDecimal)propValue;
                BigDecimal orgiwhbalanceamount = (BigDecimal)dataModel.getValue("orgiwhbalanceamount", rowIndex);
                BigDecimal whbalanceamount = (BigDecimal)dataModel.getValue("whbalanceamount", rowIndex);
                if (whbursedamount.compareTo(orgiwhbalanceamount) == 0) {
                    this.getModel().setValue("whbursedcurramount", (Object)whbalanceamount, rowIndex);
                    break;
                }
                int precision = AmountUtils.getCurrencyPrecision((IDataModel)dataModel, (String)"currency");
                String whquotetype = (String)dataModel.getValue("whquotetype", rowIndex);
                BigDecimal whexchangerate = (BigDecimal)dataModel.getValue("whexchangerate", rowIndex);
                BigDecimal whbursedcurramount = StringUtils.equals((String)"0", (String)whquotetype) ? whbursedamount.multiply(whexchangerate).setScale(precision, RoundingMode.HALF_UP) : whbursedamount.divide(whexchangerate, precision, RoundingMode.HALF_UP);
                this.getModel().setValue("whbursedcurramount", (Object)whbursedcurramount, rowIndex);
                break;
            }
            case "whbursedcurramount": {
                if (!this.getWriteOffType().equals(WriteOffTypeEnum.CURR_WO.getValue())) break;
                BigDecimal whbalanceamount = (BigDecimal)dataModel.getValue("whbalanceamount", rowIndex);
                BigDecimal orgiwhbalanceamount = (BigDecimal)dataModel.getValue("orgiwhbalanceamount", rowIndex);
                BigDecimal whbursedcurramount = (BigDecimal)propValue;
                if (whbursedcurramount.compareTo(whbalanceamount) == 0) {
                    this.getModel().setValue("whbursedamount", (Object)orgiwhbalanceamount, rowIndex);
                    break;
                }
                String whquotetype = (String)this.getModel().getValue("whquotetype", rowIndex);
                BigDecimal whexchangerate = (BigDecimal)dataModel.getValue("whexchangerate", rowIndex);
                DynamicObject accCurrency = (DynamicObject)dataModel.getValue("whcurrency", 0);
                int amountPrecision = AmountUtils.getCurrencyPrecision((Object)ErCommonUtils.getPk((Object)accCurrency));
                BigDecimal whbursedamount = StringUtils.equals((String)"0", (String)whquotetype) ? whbursedcurramount.divide(whexchangerate, amountPrecision, RoundingMode.HALF_UP) : whbursedcurramount.multiply(whexchangerate).setScale(amountPrecision, RoundingMode.HALF_UP);
                dataModel.setValue("whbursedamount", (Object)whbursedamount, rowIndex);
                break;
            }
            case "entrycostcompany": {
                int entryRowCount = dataModel.getEntryRowCount("expenseentryentity");
                if (entryRowCount <= 0 || this.checkExpenseItem(rowIndex)) break;
                dataModel.setValue("expenseitem", null, rowIndex);
                break;
            }
            case "costcompany": 
            case "automapinvoice": {
                PublicBillUtil.showInvoiceEntry((IFormView)this.getView());
            }
        }
    }

    private boolean checkExpenseItem(int rowIndex) {
        Long expItemId = ErCommonUtils.getPk((Object)this.getModel().getValue("expenseitem", rowIndex));
        if (expItemId == null) {
            return true;
        }
        return ExpenseItemServiceHelper.checkExpenseItem((IDataModel)this.getModel(), (int)rowIndex, (Long)expItemId);
    }

    private void curCheckLoanAmountChange(Object propValue, int rowIndex, IDataModel dataModel) {
        if (WriteOffTypeEnum.CURR_WO.getValue().equals(this.getWriteOffType())) {
            dataModel.beginInit();
            BigDecimal exchangeRate1 = (BigDecimal)dataModel.getValue("loanexchangerate", rowIndex);
            DynamicObject curWriteOffMoneyEntity = (DynamicObject)dataModel.getDataEntity(true).getDynamicObjectCollection("writeoffmoney").get(rowIndex);
            BigDecimal currAmount = BigDecimal.ZERO;
            String quoteType = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)"writeoffquotetype") || dataModel.getProperty("writeoffquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)dataModel.getValue("writeoffquotetype", rowIndex)), (Object)"0");
            currAmount = org.apache.commons.lang3.StringUtils.equals((CharSequence)"0", (CharSequence)quoteType) ? ((BigDecimal)propValue).divide(exchangeRate1, AmountUtils.getAmountFieldPrecision((DynamicObject)curWriteOffMoneyEntity, (String)"accloanamount"), RoundingMode.HALF_UP) : ((BigDecimal)propValue).multiply(exchangeRate1).setScale(AmountUtils.getAmountFieldPrecision((DynamicObject)curWriteOffMoneyEntity, (String)"accloanamount"), RoundingMode.HALF_UP);
            dataModel.setValue("accloanamount", (Object)currAmount, rowIndex);
            dataModel.endInit();
            this.getView().updateView("accloanamount", rowIndex);
        }
        this.refreshEncashedAmount(dataModel);
    }

    private boolean updateWoAmountValidator(IDataModel dataModel, int rowIndex) {
        boolean resultFlag = true;
        Set currencyIds = AmountUtils.getCurrencyIdSet((IDataModel)dataModel, (String)"expenseentryentity", (String)"entrycurrency");
        DynamicObject writeOffCurrency = (DynamicObject)dataModel.getValue("loancurrency", rowIndex);
        BigDecimal woAloanAmount = (BigDecimal)dataModel.getValue("accloanamount", rowIndex);
        if (writeOffCurrency != null && !currencyIds.contains(writeOffCurrency.getPkValue()) && woAloanAmount != null && woAloanAmount.compareTo(BigDecimal.ZERO) > 0) {
            resultFlag = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u4e0d\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ErReimburseBaseBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            dataModel.setValue("accloanamount", (Object)0.0, rowIndex);
            dataModel.setValue("curraccloanamount", (Object)0.0, rowIndex);
        }
        return resultFlag;
    }

    private boolean updateWoApplyValidator(IDataModel dataModel, String currencyfile, String orgiamount, String amount, int rowIndex) {
        boolean resultFlag = true;
        Set currencyIds = AmountUtils.getCurrencyIdSet((IDataModel)dataModel, (String)"expenseentryentity", (String)"entrycurrency");
        DynamicObject writeOffCurrency = (DynamicObject)dataModel.getValue(currencyfile, rowIndex);
        BigDecimal woAloanAmount = (BigDecimal)dataModel.getValue(orgiamount, rowIndex);
        if (writeOffCurrency != null && !currencyIds.contains(writeOffCurrency.getPkValue()) && woAloanAmount != null && woAloanAmount.compareTo(BigDecimal.ZERO) > 0) {
            resultFlag = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5e01\u79cd\u4e0d\u5728\u8d39\u7528\u660e\u7ec6\u4e2d\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"ErReimburseBaseBillEdit_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            dataModel.setValue(orgiamount, (Object)0.0, rowIndex);
            dataModel.setValue(amount, (Object)0.0, rowIndex);
        }
        return resultFlag;
    }

    public void entryRowClick(RowClickEvent arg0) {
        int rowIndex = arg0.getRow();
        IFormView view = this.getView();
        EntryGrid source = (EntryGrid)arg0.getSource();
        IDataModel model = this.getModel();
        String key = source.getKey();
        if (rowIndex == -1) {
            if ((ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId()) || ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityId())) && "expenseentryentity".equals(key) && model.getValue("adjustmenttype") != null && "isredoffset".equals(model.getValue("adjustmenttype").toString())) {
                view.setEnable(Boolean.TRUE, new String[]{"redexpenseimportinvoice"});
            }
            return;
        }
        switch (key) {
            case "writeoffmoney": {
                String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
                if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) && "2".equals(applyprojectbillRelated) && "biztype_project".equals(model.getValue("detailtype"))) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"deleteloancheck11"});
                    break;
                }
                String autoCreate = ErStdConfig.get((String)"applytoreimburse.autocreateloanrow");
                if (!ApplyToReimburseAutoCreateLoanRowEnum.AUTO_CREATE_LOANROW.getValue().equals(autoCreate)) break;
                this.lockButton("writeoffmoney", "sourcesign", "deleteloancheck11", rowIndex);
                break;
            }
            case "expenseentryentity": {
                if (!ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId()) && !ErEntityTypeUtils.isDailyReimburseBill((String)view.getEntityId()) || model.getValue("adjustmenttype") == null || !"isredoffset".equals(model.getValue("adjustmenttype").toString())) break;
                int[] selectedExpenseEntryRows = source.getSelectRows();
                Boolean isEnable = Boolean.TRUE;
                for (int i = 0; i < selectedExpenseEntryRows.length; ++i) {
                    Boolean expisredoffset = (Boolean)model.getValue("expisredoffset", selectedExpenseEntryRows[i]);
                    if (expisredoffset.booleanValue()) continue;
                    isEnable = Boolean.FALSE;
                    break;
                }
                view.setEnable(isEnable, new String[]{"redexpenseimportinvoice"});
            }
        }
    }

    private void lockButton(String entryName, String signName, String buttonName, int rowIndex) {
        DynamicObjectCollection entry = this.getModel().getEntryEntity(entryName);
        DynamicObject entryRow = (DynamicObject)entry.get(rowIndex);
        Boolean enble = entryRow.getBoolean(signName);
        this.getView().setEnable(Boolean.valueOf(enble == false), new String[]{buttonName});
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel dataModel = this.getModel();
        switch (entryName) {
            case "expenseentryentity": {
                int[] row;
                WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
                WriteOffMoneyUtils.writeOffMoney((IDataModel)dataModel, (String)this.getWriteOffType(), (IFormView)this.getView());
                WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)dataModel, (String)this.getWriteOffType(), (IFormView)this.getView());
                WriteOffMoneyUtils.showPayAmount((IDataModel)dataModel, (Label)((Label)this.getControl("totalencashamountlabel")));
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) && !ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) break;
                ErReimburseBaseBillEdit.refreshBillHeadAmount(dataModel);
                this.getView().updateView("reimburseamount");
                if (dataModel.getProperty("adjustmenttype") == null || dataModel.getValue("adjustmenttype") == null || !"isredoffset".equals(dataModel.getValue("adjustmenttype").toString()) || (row = e.getRowIndexs()) == null || row.length <= 0) break;
                int rowIdex = row[0] - 1;
                Boolean expisredoffset = (Boolean)dataModel.getValue("expisredoffset", rowIdex);
                if (!expisredoffset.booleanValue()) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"redexpenseimportinvoice"});
                    break;
                }
                this.getView().setEnable(Boolean.TRUE, new String[]{"redexpenseimportinvoice"});
                break;
            }
            case "writeoffmoney": {
                this.refreshEncashedAmount(dataModel);
                break;
            }
            case "withholdingentry": {
                if (WriteOffTypeEnum.ORGI_WO.getValue().equals(this.getWriteOffType())) {
                    WriteOffMoneyUtils.writeoffWithholdingByOrgiCurrcy((IDataModel)dataModel);
                    break;
                }
                WriteOffMoneyUtils.writeoffWithholdingByCurrcy((IDataModel)dataModel);
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        String name = e.getEntryProp().getName();
        if ("expenseentryentity".equals(name)) {
            WriteOffMoneyUtils.sortWriteOffEntry((IFormView)this.getView());
            WriteOffMoneyUtils.writeOffMoney((IDataModel)this.getModel(), (String)this.getWriteOffType(), (IFormView)this.getView());
            WriteOffMoneyUtils.refreshReceiveAmount((IDataModel)this.getModel(), (String)this.getWriteOffType(), (IFormView)this.getView());
            WriteOffMoneyUtils.showPayAmount((IDataModel)this.getModel(), (Label)((Label)this.getControl("totalencashamountlabel")));
        }
    }

    protected void refreshEncashedAmount(IDataModel dataModel) {
        WriteOffMoneyUtils.refreshEncashedAmount((String)this.getWriteOffType(), (IDataModel)dataModel, (IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        IDataModel model = this.getModel();
        EntryGrid expenseEntryGrid = (EntryGrid)this.getControl("expenseentryentity");
        if (operate instanceof Save || operate instanceof Submit) {
            ErReimburseBaseBillEdit.refreshBillHeadAmount(this.getModel());
            PublicBillUtil.calNonpayAmount((IDataModel)model, (IFormView)this.getView());
        }
        if (ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId())) {
            Boolean expisredoffset = Boolean.FALSE;
            switch (operateKey) {
                case "copyentryrowforred": {
                    int[] selectedExpenseEntryRowsArr = expenseEntryGrid.getSelectRows();
                    for (int i = 0; i < selectedExpenseEntryRowsArr.length; ++i) {
                        expisredoffset = (Boolean)model.getValue("expisredoffset", selectedExpenseEntryRowsArr[i]);
                        if (!expisredoffset.booleanValue()) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u4e3a\u7ea2\u51b2\u5206\u5f55\uff0c\u65e0\u6cd5\u518d\u8fdb\u884c\u7ea2\u51b2\u3002", (String)"PublicReimBillEdit_4", (String)"fi-er-formplugin", (Object[])new Object[0]), selectedExpenseEntryRowsArr[i] + 1));
                        args.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    break;
                }
                case "deleteexpentry": {
                    int[] selectedExpenseEntryRows = expenseEntryGrid.getSelectRows();
                    for (int i = 0; i < selectedExpenseEntryRows.length; ++i) {
                        expisredoffset = (Boolean)model.getValue("expisredoffset", selectedExpenseEntryRows[i]);
                        if (expisredoffset.booleanValue()) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u4e3a\u975e\u7ea2\u51b2\u5206\u5f55\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"PublicReimBillEdit_5", (String)"fi-er-formplugin", (Object[])new Object[0]), selectedExpenseEntryRows[i] + 1));
                        args.setCancel(Boolean.TRUE.booleanValue());
                        return;
                    }
                    break;
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if ((ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) && "expenseentryentity".equalsIgnoreCase(entryName)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            if (model.getProperty("adjustmenttype") != null && model.getValue("adjustmenttype") != null && "isredoffset".equals(model.getValue("adjustmenttype").toString()) && rowDataEntities.length > 0) {
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    model.setValue("expisredoffset", (Object)Boolean.TRUE, rowIndex);
                    BigDecimal expenseamount = (BigDecimal)model.getValue("expenseamount", rowIndex);
                    model.setValue("expenseamount", (Object)expenseamount.multiply(new BigDecimal(-1)), rowIndex);
                    BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", rowIndex);
                    if (taxRate == null || taxRate.compareTo(BigDecimal.ZERO) == 0) {
                        BigDecimal taxamount = (BigDecimal)model.getValue("taxamount", rowIndex);
                        model.setValue("taxamount", (Object)taxamount.multiply(new BigDecimal(-1)), rowIndex);
                        BigDecimal approvetax = (BigDecimal)model.getValue("approvetax", rowIndex);
                        model.setValue("approvetax", (Object)approvetax.multiply(new BigDecimal(-1)), rowIndex);
                    }
                    model.setValue("invoiceno_entry", null, rowIndex);
                    model.setValue("invoicelink", null, rowIndex);
                    model.setValue("invoicetypeitem", null, rowIndex);
                    model.setValue("expensegoodsname", null, rowIndex);
                    model.setValue("serialno_entry", null, rowIndex);
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"expenseamount"});
                }
            }
        }
    }

    public static void refreshBillHeadAmount(IDataModel dataModel) {
        WriteOffMoneyUtils.refreshBillHeadAmount((IDataModel)dataModel);
    }

    public void itemClick(ItemClickEvent evt) {
        Toolbar toolbar;
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        if ("redexpenseimportinvoice".equals(itemkey) && (toolbar = (Toolbar)this.getView().getControl("advcontoolbarap3")) != null) {
            toolbar.itemClick("expenseimportinvoice", "");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String opKey;
        switch (opKey = e.getOperateKey()) {
            case "confirmstopreim": {
                OperationResult opResult = e.getOperationResult();
                if (!opResult.isSuccess()) break;
                this.getView().close();
            }
        }
    }
}

