/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.reimburse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.UserEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.ErCacheUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.CollectorsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class MultiReimburserPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(MultiReimburserPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit control;
        super.registerListener(e);
        if (!this.isPCView()) {
            return;
        }
        this.addItemClickListeners(new String[]{"receiveentrytoolbar"});
        if (!ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
            this.addItemClickListeners(new String[]{"multireimburserreceivebtn"});
            this.addClickListeners(new String[]{"receiveentrytoolbar", "multireimburserreceivebtn"});
        }
        if (ErEntityTypeUtils.isDailyLoanBill((String)this.getView().getEntityId())) {
            this.addItemClickListeners(new String[]{"advcontoolbarap2", "multireimburserreceivebtn"});
        }
        if (null != (control = (BasedataEdit)this.getControl("reimburser"))) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((control = (BasedataEdit)this.getControl("pubreimburser")) != null) {
            control.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (this.isMobView()) {
            return;
        }
        if ("reimburser".equals(arg0.getProperty().getName()) || "pubreimburser".equals(arg0.getProperty().getName())) {
            QFilter qFilter;
            int multiReimburser = 0;
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            if (company != null) {
                multiReimburser = SystemParamterUtil.getScopeOfMultiReimburserNew((Long)ErCommonUtils.getPk((Object)company));
            }
            Long id = 0L;
            switch (multiReimburser) {
                case 1: {
                    company = (DynamicObject)this.getModel().getValue("company");
                    if (company == null) {
                        return;
                    }
                    id = ErCommonUtils.getPk((Object)company);
                    List allOrgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, Collections.singletonList(Long.valueOf(company.get("masterid").toString())), (boolean)true);
                    qFilter = new QFilter("entryentity.dpt.masterid", "in", (Object)allOrgList);
                    break;
                }
                case 2: {
                    qFilter = null;
                    break;
                }
                case 3: {
                    company = (DynamicObject)this.getModel().getValue("company");
                    if (company == null) {
                        return;
                    }
                    id = ErCommonUtils.getPk((Object)company);
                    qFilter = this.getSubOrgWithExcludePatternFilter(ErCommonUtils.getPk((Object)company));
                    break;
                }
                case 4: {
                    DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
                    if (dept == null) {
                        return;
                    }
                    id = ErCommonUtils.getPk((Object)dept);
                    qFilter = this.getSubOrgWithExcludePatternFilter(ErCommonUtils.getPk((Object)dept));
                    break;
                }
                default: {
                    DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
                    if (dept == null) {
                        return;
                    }
                    id = ErCommonUtils.getPk((Object)dept);
                    qFilter = QFilter.of((String)"entryentity.dpt.masterid=?", (Object[])new Object[]{dept.get("masterid")});
                }
            }
            ListShowParameter cardF7Param = (ListShowParameter)arg0.getFormShowParameter();
            if ((multiReimburser == 0 || multiReimburser == 1 || multiReimburser == 3 || multiReimburser == 4) && id != null && id != 0L) {
                arg0.getFormShowParameter().setCustomParam("initRootOrgId", (Object)id);
                arg0.getFormShowParameter().setCustomParam("initOrgId", (Object)id);
            }
            cardF7Param.getListFilterParameter().setFilter(qFilter);
            cardF7Param.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
    }

    private QFilter getSubOrgWithExcludePatternFilter(Long orgId) {
        if (orgId == null || orgId == 0L) {
            return null;
        }
        List<String> excludePattren = Arrays.asList("1", "2");
        List allOrgList = OrgUnitServiceHelper.getSubOrgLimitLevel(Collections.singletonList(orgId), (int)1, (boolean)true);
        Map allOrgMap = BusinessDataServiceHelper.loadFromCache((Object[])allOrgList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
        Set allOrgNotInexcludePattern = allOrgMap.values().stream().filter(org -> !excludePattren.contains(org.getDynamicObject("orgpattern").getString("patterntype"))).map(ErCommonUtils::getPk).collect(Collectors.toSet());
        allOrgNotInexcludePattern.add(orgId);
        return new QFilter("entryentity.dpt", "in", allOrgNotInexcludePattern);
    }

    public void afterBindData(EventObject e) {
        Boolean multiReimburserFlag;
        super.afterBindData(e);
        if ("1".equals(ErStdConfig.get((String)"scope_of_multi_reimburser"))) {
            ErCommonUtils.saveEMParameter((long)OrgUnitServiceHelper.getRootOrgId(), (String)"scopeofmultireimburser", (Object)1);
            DynamicObject erStdconfig = BusinessDataServiceHelper.loadSingle((String)"er_stdconfig", (String)"key,value", (QFilter[])new QFilter[]{new QFilter("key", "=", (Object)"scope_of_multi_reimburser")});
            erStdconfig.set("value", (Object)2);
            SaveServiceHelper.update((DynamicObject)erStdconfig);
            ErCacheUtils.remove((String)"er_stdconfig", (String)"scope_of_multi_reimburser");
        }
        IDataModel model = this.getModel();
        if (this.isMobView() && this.isAddNewBill()) {
            Boolean ismultireimburser = MultiReimburserPlugin.getIsMultiReimburser();
            model.beginInit();
            model.setValue("ismultireimburser", (Object)ismultireimburser);
            model.endInit();
        }
        if (this.isPCView() && (multiReimburserFlag = (Boolean)model.getValue("ismultireimburser")).booleanValue()) {
            UserEdit editor = (UserEdit)this.getView().getControl("reimburser");
            if (null != editor) {
                editor.setMustInput(true);
            }
            if ((editor = (UserEdit)this.getView().getControl("pubreimburser")) != null) {
                editor.setMustInput(true);
            }
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        String name = e.getName();
        if ("updataRowReimburserByMulti".equals(name)) {
            Long deptId;
            Long applierId = ErCommonUtils.getPk((Object)this.getModel().getValue("applier"));
            int multiReimburser = 0;
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            if (company != null) {
                multiReimburser = SystemParamterUtil.getScopeOfMultiReimburserNew((Long)ErCommonUtils.getPk((Object)company));
            }
            if (multiReimburser == 1 || multiReimburser == 3) {
                Long companyId = 0L;
                if (company != null) {
                    companyId = ErCommonUtils.getPk((Object)company);
                }
                if (companyId != null && companyId != 0L) {
                    this.updataRowReimburserByCompanyOrDept("company", companyId, applierId, multiReimburser);
                }
            } else if (multiReimburser != 2 && (deptId = ErCommonUtils.getPk((Object)this.getModel().getValue("org"))) != null && deptId != 0L) {
                this.updataRowReimburserByCompanyOrDept("org", deptId, applierId, multiReimburser);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        block8 : switch (propName) {
            case "ismultireimburser": {
                if (((Boolean)propValue).booleanValue()) {
                    UserEdit editor = (UserEdit)this.getView().getControl("reimburser");
                    if (editor != null) {
                        editor.setMustInput(true);
                    }
                    if ((editor = (UserEdit)this.getView().getControl("pubreimburser")) != null) {
                        editor.setMustInput(true);
                    }
                    this.initMultiReimburseData();
                }
                if (((Boolean)propValue).booleanValue()) break;
                this.deleteMoreReimburserData();
                break;
            }
            case "applier": {
                Boolean ismultireimburser = (Boolean)this.getModel().getValue("ismultireimburser");
                if (ismultireimburser.booleanValue()) {
                    this.getView().addClientCallBack("updataRowReimburserByMulti");
                    break;
                }
                this.deleteMoreReimburserData();
                break;
            }
            case "org": {
                Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                int multiReimburser = SystemParamterUtil.getScopeOfMultiReimburserNew((Long)companyId);
                if (null == propValue || multiReimburser == 1 || multiReimburser == 3 || multiReimburser == 2) {
                    return;
                }
                Boolean flag = (Boolean)this.getModel().getValue("ismultireimburser");
                if (!flag.booleanValue()) break;
                this.deleteMoreReimburserData();
                break;
            }
            case "company": {
                Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                int multiReimburser = SystemParamterUtil.getScopeOfMultiReimburserNew((Long)companyId);
                if (null == propValue || multiReimburser == 0 || multiReimburser == 4 || multiReimburser == 2) {
                    return;
                }
                if (!((Boolean)this.getModel().getValue("ismultireimburser")).booleanValue()) break;
                this.deleteMoreReimburserData();
                break;
            }
            case "reimburser": 
            case "pubreimburser": {
                String costOrgHeadShow = CommonServiceHelper.getBillCostOrgShowType((IFormView)this.getView());
                Long companyId = ErCommonUtils.getPk((Object)this.getModel().getValue("company"));
                if (StringUtils.equals((CharSequence)"1", (CharSequence)costOrgHeadShow) || propValue == null || companyId == null) {
                    return;
                }
                if (!((Boolean)this.getModel().getValue("ismultireimburser")).booleanValue()) break;
                int multiReimburser = SystemParamterUtil.getScopeOfMultiReimburserNew((Long)companyId);
                switch (multiReimburser) {
                    case 0: {
                        return;
                    }
                    case 2: {
                        DynamicObjectCollection reimburserEntry = ((DynamicObject)propValue).getDynamicObjectCollection("entryentity");
                        Optional<DynamicObject> item = reimburserEntry.stream().filter(row -> !row.getBoolean("ispartjob")).findFirst();
                        item.ifPresent(dyn -> this.getModel().setValue("entrycostdept", (Object)dyn.getDynamicObject("dpt"), valueSet[0].getRowIndex()));
                        break block8;
                    }
                }
                DynamicObjectCollection reimburserEntry = ((DynamicObject)propValue).getDynamicObjectCollection("entryentity");
                List validDpts = reimburserEntry.stream().filter(row -> {
                    long dptId = row.getDynamicObject("dpt").getLong("id");
                    List allSubordinateOrgs = null;
                    if (multiReimburser == 3) {
                        allSubordinateOrgs = OrgUnitServiceHelper.getSubOrgLimitLevel(Collections.singletonList(companyId), (int)1, (boolean)true);
                    }
                    if (multiReimburser == 4) {
                        allSubordinateOrgs = OrgUnitServiceHelper.getSubOrgLimitLevel(Collections.singletonList(dptId), (int)1, (boolean)true);
                    }
                    if (allSubordinateOrgs != null && !allSubordinateOrgs.isEmpty()) {
                        Map allSubordinateOrgsMap = BusinessDataServiceHelper.loadFromCache((Object[])allSubordinateOrgs.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"));
                        List<String> excludePattren = Arrays.asList("1", "2");
                        return dptId == companyId || allSubordinateOrgsMap.values().stream().filter(org -> !excludePattren.contains(org.getDynamicObject("orgpattern").getString("patterntype"))).map(ErCommonUtils::getPk).collect(Collectors.toSet()).contains(companyId);
                    }
                    return dptId == companyId || OrgUnitServiceHelper.getAllSuperiorOrgs((String)"01", (long)dptId).stream().collect(Collectors.toSet()).contains(companyId);
                }).collect(Collectors.toList());
                Map<Boolean, List<DynamicObject>> groupByIspartDeptMap = validDpts.stream().collect(Collectors.partitioningBy(row -> row.getBoolean("ispartjob")));
                if (!groupByIspartDeptMap.get(false).isEmpty()) {
                    this.getModel().setValue("entrycostdept", (Object)groupByIspartDeptMap.get(false).get(0).getDynamicObject("dpt"), valueSet[0].getRowIndex());
                    return;
                }
                if (groupByIspartDeptMap.get(true).isEmpty()) break;
                Optional<DynamicObject> dptOp = groupByIspartDeptMap.get(true).stream().sorted(Comparator.comparing(row -> row.getDynamicObject("dpt").getLong("id"))).findFirst();
                this.getModel().setValue("entrycostdept", (Object)dptOp.get().getDynamicObject("dpt"), valueSet[0].getRowIndex());
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        if (!this.isPCView()) {
            return;
        }
        switch (itemKey = evt.getItemKey()) {
            case "multireimburserreceivebtn": {
                this.deleteAccountEntry();
                this.groupBySumAmount();
            }
        }
    }

    private void deleteMoreReimburserData() {
        this.initMultiReimburseData();
        if (!ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
            this.deleteAccountEntry();
        }
    }

    private void initMultiReimburseData() {
        IDataModel model = this.getModel();
        int expEntryCount = model.getEntryRowCount("expenseentryentity");
        Long applier = ErCommonUtils.getPk((Object)model.getValue("applier"));
        for (int i = expEntryCount - 1; i >= 0; --i) {
            if (!ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
                model.setValue("reimburser", (Object)applier, i);
                continue;
            }
            model.setValue("pubreimburser", (Object)applier, i);
        }
    }

    private void deleteAccountEntry() {
        if (this.isMobView()) {
            return;
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("accountentry");
    }

    private void groupBySumAmount() {
        IDataModel model = this.getModel();
        HashSet buildFailedSet = new HashSet();
        DynamicObjectCollection expenseEntryDOs = model.getEntryEntity("expenseentryentity");
        expenseEntryDOs.stream().filter(expenseEntryDO -> expenseEntryDO.getDynamicObject("reimburser") != null).collect(Collectors.groupingBy(expenseEntryDO -> (Long)expenseEntryDO.getDynamicObject("reimburser").getPkValue(), CollectorsUtil.summingBigDecimal(expenseEntryDO -> expenseEntryDO.getBigDecimal("expeapprovecurramount")))).forEach((reimburserId, approveCurrAmount) -> {
            if (!this.buildMultiAccountEntry((Long)reimburserId, (BigDecimal)approveCurrAmount)) {
                buildFailedSet.add(reimburserId);
            }
        });
        if (buildFailedSet.size() > 0) {
            Map userArray = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", buildFailedSet)});
            ArrayList<String> userNameList = new ArrayList<String>(userArray.size());
            for (DynamicObject user : userArray.values()) {
                userNameList.add(user.getLocaleString("name").getLocaleValue());
            }
            if (userNameList.size() > 0) {
                this.getView().showConfirm(String.format(ResManager.loadKDString((String)"%s\u6ca1\u6709\u81ea\u52a8\u4ea7\u751f\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u5de5\u6dfb\u52a0\u3002", (String)"MultiReimburserPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]), userNameList), MessageBoxOptions.OK);
            }
        }
    }

    private boolean buildMultiAccountEntry(Long reimburserId, BigDecimal approveCurrAmount) {
        IDataModel model = this.getModel();
        List defaultAccounts = PayeeServiceHelper.getOtherDefaultAccountByPayerID((Long)reimburserId, null, (boolean)false);
        if (null == defaultAccounts || defaultAccounts.size() < 1) {
            return false;
        }
        DynamicObjectCollection expenseEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        Optional<DynamicObject> costCompanyOp = expenseEntry.stream().filter(row -> {
            DynamicObject rowReimburse = row.getDynamicObject("reimburser");
            return rowReimburse != null && rowReimburse.getLong("id") == reimburserId.longValue();
        }).map(row -> {
            DynamicObject entryCostCompany = row.getDynamicObject("entrycostcompany");
            if (entryCostCompany == null) {
                int seq = row.getInt("seq");
                LocaleString displayName = expenseEntry.getDynamicObjectType().getDisplayName();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5206\u5f55\u7b2c%2$s\u884c\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u5b57\u6bb5\u4e3a\u7a7a\u3002", (String)"MultiReimburserPlugin_5", (String)"fi-er-formplugin", (Object[])new Object[0]), displayName, seq));
            }
            return entryCostCompany;
        }).findFirst();
        int rowIndex = model.createNewEntryRow("accountentry");
        CoreBaseBillServiceHelper.fillAccountEntry((IDataModel)model, (int)rowIndex, (DynamicObject)((DynamicObject)defaultAccounts.get(0)));
        Map currencyMap = AmountChangeUtil.getCurrencyPayerAndParam((IDataModel)model, (int)rowIndex, (Long)reimburserId);
        BigDecimal approveOriAmount = AmountChangeUtil.getOriAmount((BigDecimal)approveCurrAmount, (Map)currencyMap, (String)((String)model.getValue("accquotetype", rowIndex)));
        model.setValue("accountcurrency", currencyMap.get("currencyId"), rowIndex);
        model.setValue("accexchangerate", currencyMap.get("exchangeRate"), rowIndex);
        model.setValue("receiveamount", (Object)approveCurrAmount, rowIndex);
        model.setValue("orireceiveamount", (Object)approveOriAmount, rowIndex);
        model.setValue("accnotpayamount", (Object)approveCurrAmount, rowIndex);
        model.setValue("oriaccnotpayamount", (Object)approveOriAmount, rowIndex);
        if (costCompanyOp.isPresent() && model.getProperty("acccostcompany") != null) {
            model.setValue("acccostcompany", (Object)costCompanyOp.get(), rowIndex);
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "submit": {
                Boolean flag = (Boolean)this.getModel().getValue("ismultireimburser");
                DynamicObjectCollection entrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
                if (flag.booleanValue()) {
                    for (int i = 0; i < entrys.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entrys.get(i);
                        DynamicObject reimburser = null;
                        reimburser = ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBillShare((String)this.getView().getEntityId()) ? (DynamicObject)entry.get("pubreimburser") : (DynamicObject)entry.get("reimburser");
                        if (reimburser != null) continue;
                        args.setCancel(true);
                        int index = i + 1;
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d39\u7528\u660e\u7ec6\u201d\u7b2c$s\u884c\u201c\u62a5\u9500\u4eba\u201d\u5b57\u6bb5\u3002", (String)"MultiReimburserPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]), index));
                        break;
                    }
                }
                if (flag.booleanValue()) break;
                Long applierId = (Long)this.getModel().getDataEntity(true).getDynamicObject("applier").getPkValue();
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBillShare((String)this.getView().getEntityId())) {
                        entry.set("pubreimburser_id", (Object)applierId);
                        continue;
                    }
                    entry.set("reimburser_id", (Object)applierId);
                }
                break;
            }
        }
    }

    private boolean isPCView() {
        boolean isPCView = false;
        IFormView view = this.getView();
        if (!(view instanceof IMobileView)) {
            isPCView = true;
        }
        return isPCView;
    }

    private boolean isMobView() {
        boolean isMobView = false;
        IFormView view = this.getView();
        if (view instanceof IMobileView) {
            isMobView = true;
        }
        return isMobView;
    }

    private boolean isAddNewBill() {
        boolean isAddNewBill = false;
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (BillOperationStatus.ADDNEW.equals((Object)billShowParameter.getBillStatus())) {
            isAddNewBill = true;
        }
        return isAddNewBill;
    }

    private static Boolean getIsMultiReimburser() {
        boolean ismultireimburser = false;
        DynamicObject[] personalSettingInfos = CommonServiceHelper.getTripPersonalSetting((long)Long.parseLong(RequestContext.get().getUserId()));
        if (personalSettingInfos != null && personalSettingInfos.length > 0) {
            ismultireimburser = personalSettingInfos[0].getBoolean("ismultireimburser");
        }
        return ismultireimburser;
    }

    private void updataRowReimburserByCompanyOrDept(String updataFlag, Long newFlagId, Object applier, int multiReimburser) {
        IDataModel model = this.getModel();
        DynamicObjectCollection expenses = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        int rowIndex = 0;
        List<String> excludePattren = Arrays.asList("1", "2");
        for (DynamicObject expense : expenses) {
            boolean flag = true;
            DynamicObject reimburser = null;
            reimburser = ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId()) ? expense.getDynamicObject("pubreimburser") : expense.getDynamicObject("reimburser");
            if (reimburser != null) {
                DynamicObjectCollection reimburserEntrys = reimburser.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : reimburserEntrys) {
                    DynamicObject org;
                    Long commonID = null;
                    DynamicObject dept = entry.getDynamicObject("dpt");
                    if (dept == null) continue;
                    Long deptID = (Long)dept.getPkValue();
                    if (updataFlag.equals("company")) {
                        commonID = CoreBaseBillServiceHelper.initCompanyByDept((Long)((Long)dept.getPkValue()));
                        if (multiReimburser == 3 && commonID != null && excludePattren.contains((org = BusinessDataServiceHelper.loadSingleFromCache((Object)commonID, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"))).getDynamicObject("orgpattern").getString("patterntype")) || commonID == null || !commonID.equals(newFlagId)) continue;
                        ++rowIndex;
                        flag = false;
                    } else {
                        if (multiReimburser == 4 && excludePattren.contains((org = BusinessDataServiceHelper.loadSingleFromCache((Object)deptID, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bos_org"))).getDynamicObject("orgpattern").getString("patterntype")) || !deptID.equals(newFlagId)) continue;
                        ++rowIndex;
                        flag = false;
                    }
                    break;
                }
            } else {
                logger.info("reimburser is null.");
            }
            if (!flag) continue;
            if (ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) {
                model.setValue("pubreimburser", applier, rowIndex++);
                continue;
            }
            model.setValue("reimburser", applier, rowIndex++);
        }
    }
}

