/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.repayment;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleInfo;
import kd.fi.er.business.servicehelper.rule.BillSettingRuleUtil;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.RepaymentAssociateUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.daily.web.AbstractExpenseBaseBillPlugin;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ErRepayMentBillPlugin
extends AbstractExpenseBaseBillPlugin
implements HyperLinkClickListener {
    protected BillSettingRuleInfo ruleInfo = null;
    private int[] rowIndexs = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit payerF7 = (BasedataEdit)this.getControl("payer");
        payerF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
            CoreBaseBillServiceHelper.setPayeeF7Filter((ListShowParameter)((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()), (DynamicObject)applier, null);
        });
        AbstractGrid repaymententry = (AbstractGrid)this.getControl("repaymententry");
        AbstractGrid recentry = (AbstractGrid)this.getControl("recentry");
        AbstractGrid recentrydetail = (AbstractGrid)this.getControl("recentrydetail");
        if (repaymententry != null) {
            repaymententry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if (recentry != null) {
            recentry.addHyperClickListener((HyperLinkClickListener)this);
        }
        if (recentrydetail != null) {
            recentrydetail.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData[] valueSet = e.getChangeSet();
        Object propValue = valueSet[0].getNewValue();
        int rowIndex = valueSet[0].getRowIndex();
        switch (propName) {
            case "orirepayamount": 
            case "repayexchangerate": {
                this.countRepayAmount(e);
                break;
            }
            case "payer": {
                DynamicObject payer = (DynamicObject)e.getChangeSet()[0].getNewValue();
                this.getModel().setValue("payeraccount", payer == null ? null : payer.get("payeraccount"));
                this.getModel().setValue("payerbank", payer == null ? null : Long.valueOf(payer.getLong("payerbank_Id")));
                break;
            }
            case "accountcurrency": {
                Object company = this.getModel().getValue("company");
                Object costCompany = this.getModel().getValue("costcompany");
                DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject raccCurrency = (DynamicObject)e.getChangeSet()[0].getNewValue();
                if (currency == null || raccCurrency == null) break;
                long sourceCurrencyId = raccCurrency.getLong("id");
                long targetCurrencyId = currency.getLong("id");
                Map exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams((Object)company, (Object)costCompany, (Long)sourceCurrencyId, (Long)targetCurrencyId, (Object)this.getModel());
                String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
                if (this.getModel().getProperty("detailquotetype") != null) {
                    this.getModel().setValue("detailquotetype", (Object)quoteType, rowIndex);
                }
                this.getModel().setValue("repayexchangerate", (Object)exchangeRate, rowIndex);
                break;
            }
            case "orirepayapproveamount": {
                BigDecimal exchangeRate = (BigDecimal)model.getValue("repayexchangerate", rowIndex);
                DynamicObject accountcurrency = (DynamicObject)model.getValue("accountcurrency", rowIndex);
                int currencyPrecision = AmountUtils.getCurrencyPrecision((Object)accountcurrency.getPkValue());
                String quoteType = (String)model.getValue("detailquotetype", rowIndex);
                int curPrecision = currencyPrecision;
                DynamicObject headcurrency = (DynamicObject)model.getValue("currency");
                if (headcurrency != null) {
                    curPrecision = AmountUtils.getCurrencyPrecision((Object)headcurrency.getPkValue());
                }
                BigDecimal repayapproveamount = AmountUtils.getCurrencyAmount((BigDecimal)((BigDecimal)propValue), (BigDecimal)exchangeRate, (int)curPrecision, (String)quoteType);
                model.setValue("repayapproveamount", (Object)repayapproveamount, rowIndex);
                model.setValue("reverserepayamount", (Object)repayapproveamount, rowIndex);
                this.countTotalrepayamount(model, (BigDecimal)propValue, repayapproveamount, exchangeRate, quoteType, curPrecision, rowIndex);
                DynamicObjectCollection entryEntitys = model.getDataEntity(true).getDynamicObjectCollection("repaymententry");
                BigDecimal approveamount = AmountChangeUtil.sumAmountBy((Collection)entryEntitys, (String)"repayapproveamount");
                model.setValue("approveamount", (Object)approveamount);
                model.setValue("totalnotactrecamt", (Object)approveamount);
                break;
            }
        }
    }

    private void countRepayAmount(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData[] valueSet = e.getChangeSet();
        int rowIndex = valueSet[0].getRowIndex();
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        BigDecimal oriRepayAmount = (BigDecimal)model.getValue("orirepayamount", rowIndex);
        BigDecimal exchangeRate = (BigDecimal)model.getValue("repayexchangerate", rowIndex);
        String quoteType = model.getProperty("detailquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("detailquotetype", rowIndex)), (Object)"0");
        int currencyPrecision = AmountUtils.getCurrencyPrecision((Object)currency.getPkValue());
        BigDecimal repayAmount = AmountUtils.getCurrencyAmount((BigDecimal)oriRepayAmount, (BigDecimal)exchangeRate, (int)currencyPrecision, (String)quoteType);
        model.setValue("repayamount", (Object)repayAmount, rowIndex);
        this.countTotalrepayamount(model, oriRepayAmount, repayAmount, exchangeRate, quoteType, currencyPrecision, rowIndex);
        model.setValue("orirepayapproveamount", (Object)oriRepayAmount, rowIndex);
        model.setValue("repayapproveamount", (Object)repayAmount, rowIndex);
        this.countTotalrepayamount();
    }

    private void countTotalrepayamount(IDataModel model, BigDecimal oriRepayAmount, BigDecimal repayAmount, BigDecimal exchangeRate, String quoteType, int currencyPrecision, int rowIndex) {
        BigDecimal srcExchangeRate = (BigDecimal)model.getValue("sourceexchangerate", rowIndex);
        DynamicObject reverseCurrency = (DynamicObject)model.getValue("reversecurrency", rowIndex);
        String srcQuoteType = model.getProperty("sourcequotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("sourcequotetype", rowIndex)), (Object)"0");
        int reverseCurrencyPrecision = AmountUtils.getCurrencyPrecision((Object)reverseCurrency.getPkValue());
        Object writeoffType = model.getValue("writeofftype");
        if ("1".equals(writeoffType)) {
            model.setValue("reverseorirepayamount", (Object)oriRepayAmount, rowIndex);
            if (StringUtils.equals((CharSequence)quoteType, (CharSequence)srcQuoteType) && exchangeRate.compareTo(srcExchangeRate) == 0) {
                model.setValue("reverserepayamount", (Object)repayAmount, rowIndex);
            } else {
                model.setValue("reverserepayamount", (Object)AmountUtils.getCurrencyAmount((BigDecimal)oriRepayAmount, (BigDecimal)srcExchangeRate, (int)currencyPrecision, (String)srcQuoteType), rowIndex);
            }
        } else {
            model.setValue("reverserepayamount", (Object)repayAmount, rowIndex);
            if (StringUtils.equals((CharSequence)quoteType, (CharSequence)srcQuoteType) && exchangeRate.compareTo(srcExchangeRate) == 0) {
                model.setValue("reverseorirepayamount", (Object)oriRepayAmount, rowIndex);
            } else {
                model.setValue("reverseorirepayamount", (Object)AmountUtils.getOriAmount((BigDecimal)repayAmount, (BigDecimal)srcExchangeRate, (int)reverseCurrencyPrecision, (String)srcQuoteType), rowIndex);
            }
        }
    }

    private void countTotalrepayamount() {
        IDataModel model = this.getModel();
        BigDecimal repayTotalamount = BigDecimal.ZERO;
        int rowNumber = this.getModel().getEntryRowCount("repaymententry");
        for (int i = 0; i < rowNumber; ++i) {
            BigDecimal repayamount = (BigDecimal)model.getValue("repayamount", i);
            repayTotalamount = repayTotalamount.add(repayamount);
        }
        model.setValue("amount", (Object)repayTotalamount);
        model.setValue("totalnotactrecamt", (Object)repayTotalamount);
        model.setValue("approveamount", (Object)repayTotalamount);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean dataChanged = this.getModel().getDataChanged();
        this.showLoanBillNum();
        this.setWriteOffType();
        this.getModel().setDataChanged(dataChanged);
        this.showReceiveEntry();
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!(ErBillStatusEnum.B.toString().equals(this.getModel().getValue("billstatus")) || ErBillStatusEnum.C.toString().equals(this.getModel().getValue("billstatus")) || ErBillStatusEnum.A.toString().equals(this.getModel().getValue("billstatus")))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advcontoolbarap1"});
        }
        BillSettingRuleUtil.setFormTitleForPC((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldNameForPC((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldHidden((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldMustInput((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
        BillSettingRuleUtil.setFieldLock((BillSettingRuleInfo)this.getBillSettingRuleInfo(), (IFormView)this.getView());
    }

    private void setWriteOffType() {
        DynamicObject company = (DynamicObject)this.getModel().getValue("company");
        Object writeOffType = null;
        if (company != null) {
            writeOffType = ErCommonUtils.getLoanCheckType((long)Long.parseLong(company.getPkValue().toString()));
        }
        if (writeOffType == null || StringUtils.isBlank((CharSequence)writeOffType.toString())) {
            writeOffType = WriteOffTypeEnum.CURR_WO.getValue();
        }
        this.getModel().setValue("writeofftype", writeOffType);
    }

    private void showLoanBillNum() {
        DynamicObjectCollection collection = this.getModel().getDataEntity().getDynamicObjectCollection("repaymententry");
        for (int i = 0; i < collection.size(); ++i) {
            String relationBill = ((DynamicObject)collection.get(i)).getString("relationloanbill");
            if (!StringUtils.isNotBlank((CharSequence)relationBill)) continue;
            Long tripentryId = 0L;
            try {
                tripentryId = Long.valueOf(relationBill);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (tripentryId != 0L) {
                QFilter filter = new QFilter("tripentry.id", "=", (Object)tripentryId);
                DynamicObjectCollection coll = QueryServiceHelper.query((String)"er_tripreqbill", (String)"billno", (QFilter[])new QFilter[]{filter});
                if (coll.isEmpty()) continue;
                this.getModel().setValue("relationloanbillnum", ((DynamicObject)coll.get(0)).get("billno"), i);
                continue;
            }
            this.getModel().setValue("relationloanbillnum", (Object)relationBill, i);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (source instanceof NewEntry) {
            if ("newrecentry".equalsIgnoreCase(operateKey)) {
                args.setCancel(true);
                if (RepaymentAssociateUtil.hasBOTPRelation((DynamicObject)this.getModel().getDataEntity())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u6b3e\u52a8\u4f5c\u5df2\u8fdb\u884c\uff0c\u65e0\u6cd5\u5173\u8054\u6536\u6b3e\u3002", (String)"ErRepayMentBillPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!RepaymentAssociateUtil.hasPermissionForAssoiate((IFormView)this.getView())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5173\u8054\u6536\u6b3e\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ErRepayMentBillPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("er_botp_repay_rec");
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_botp_repay_rec"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("repaymentbillId", this.getModel().getDataEntity().getPkValue());
                formShowParameter.setCustomParam("selType", (Object)"edit");
                this.getView().showForm(formShowParameter);
            }
        } else if (source instanceof DeleteEntry) {
            DeleteEntry deleteEntry = (DeleteEntry)source;
            if ("deleterecentry".equalsIgnoreCase(operateKey)) {
                if (RepaymentAssociateUtil.hasBOTPRelation((DynamicObject)this.getModel().getDataEntity())) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u624b\u5de5\u7ed1\u5b9a\u7684\u6536\u6b3e\u5355\u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"ErRepayMentBillPlugin_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    return;
                }
                String entryId = (String)deleteEntry.getParameter().get("entryId");
                EntryGrid entryGrid = (EntryGrid)this.getControl(entryId);
                this.rowIndexs = entryGrid.getSelectRows();
                if (this.rowIndexs.length > 0) {
                    ArrayList recBillPks = Lists.newArrayList();
                    for (int row : this.rowIndexs) {
                        recBillPks.add((Long)this.getModel().getValue("recbillid", row));
                    }
                    RepaymentAssociateUtil.removeBOTPRelation((Long)((Long)this.getModel().getDataEntity().getPkValue()), (Long[])recBillPks.toArray(new Long[0]));
                }
            }
        }
        if (StringUtils.equals((CharSequence)"draw_cas_rec_bill", (CharSequence)operateKey) && !ErBillStatusEnum.A.toString().equals(this.getModel().getValue("billstatus")) && !ErBillStatusEnum.B.toString().equals(this.getModel().getValue("billstatus")) && !ErBillStatusEnum.C.toString().equals(this.getModel().getValue("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\u8fd8\u6b3e\u5355\u4e0d\u5141\u8bb8\u5173\u8054\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((CharSequence)"deletereceiveentry", (CharSequence)operateKey) && !ErBillStatusEnum.A.toString().equals(this.getModel().getValue("billstatus")) && !ErBillStatusEnum.B.toString().equals(this.getModel().getValue("billstatus")) && !ErBillStatusEnum.C.toString().equals(this.getModel().getValue("billstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u72b6\u6001\u8fd8\u6b3e\u5355\u4e0d\u5141\u8bb8\u5220\u9664\u6536\u6b3e\u5355\u3002", (String)"ErRepayMentBillPlugin_7", (String)"fi-er-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DeleteEntry deleteEntry;
        super.afterDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if (source instanceof DeleteEntry && "deleterecentry".equalsIgnoreCase((deleteEntry = (DeleteEntry)source).getOperateKey()) && this.rowIndexs != null && this.rowIndexs.length > 0) {
            this.invokeSave();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        List returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("er_botp_repay_rec") && (returnData = (List)closedCallBackEvent.getReturnData()) != null && !returnData.isEmpty()) {
            this.fillRecEntry(returnData);
            this.invokeSave();
            DynamicObjectCollection recentryCollectoin = this.getModel().getDataEntity(true).getDynamicObjectCollection("recentry");
            RepaymentAssociateUtil.buildBOTPRelation((DynamicObjectCollection)recentryCollectoin);
        }
    }

    private void invokeSave() {
        DynamicObject repaymentBill = this.getModel().getDataEntity(true);
        DynamicObjectCollection recCollection = repaymentBill.getDynamicObjectCollection("recentry");
        if (!recCollection.isEmpty() && ErBillStatusEnum.E.toString().equals(repaymentBill.getString("billstatus"))) {
            this.getModel().setValue("billstatus", (Object)ErBillStatusEnum.G.toString());
        } else if (recCollection.isEmpty() && ErBillStatusEnum.G.toString().equals(repaymentBill.getString("billstatus"))) {
            this.getModel().setValue("billstatus", (Object)ErBillStatusEnum.E.toString());
        }
        if (!recCollection.isEmpty()) {
            this.getModel().setValue("buildrelationway", (Object)"2");
        } else {
            this.getModel().setValue("buildrelationway", (Object)" ");
        }
        this.getView().invokeOperation("save");
    }

    private void fillRecEntry(List<Object> recBillInfos) {
        int[] batchCreateNewEntryRow = this.getModel().batchCreateNewEntryRow("recentry", recBillInfos.size());
        DynamicObjectCollection recentryCollectoin = this.getModel().getDataEntity(true).getDynamicObjectCollection("recentry");
        int index = 0;
        for (int curRow : batchCreateNewEntryRow) {
            DynamicObject recBill = (DynamicObject)recBillInfos.get(index++);
            DynamicObject repayRecEntry = (DynamicObject)recentryCollectoin.get(curRow);
            DataEntityPropertyCollection properties = recBill.getDataEntityType().getProperties();
            DataEntityPropertyCollection recProperties = repayRecEntry.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                if (recProperties.get((Object)property.getName()) == null || "id".equalsIgnoreCase(property.getName()) || "seq".equalsIgnoreCase(property.getName()) || recBill.get(property.getName()) == null) continue;
                this.getModel().setValue(property.getName(), recBill.get(property.getName()), curRow);
            }
            this.getModel().setValue("recbillno", recBill.get("billno"), curRow);
            this.getModel().setValue("reccurrency", recBill.get("currency"), curRow);
            this.getModel().setValue("recexchangerate", recBill.get("exchangerate"), curRow);
            this.getModel().setValue("oriactrecamt", recBill.get("actrecamt"), curRow);
            this.getModel().setValue("actrecamt", recBill.get("localamt"), curRow);
            this.getModel().setValue("recbillid", recBill.get("id"), curRow);
            this.getModel().setValue("payeedate", recBill.get("bizdate"), curRow);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if ("B".equals(this.getModel().getValue("billstatus"))) {
            e.setCheckDataChange(false);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String fieldName = hyperLinkClickEvent.getFieldName();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"sourcebillno")) {
            this.repaymentSourcebillCheck(rowIndex);
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"recbillno")) {
            Long billId = ((DynamicObject)this.getModel().getEntryEntity("recentry").get(rowIndex)).getLong("recbillid");
            if (billId != null) {
                this.openLinkedForm(billId, "cas_recbill");
            }
        } else if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"casbillno")) {
            String billNo = ((DynamicObject)this.getModel().getEntryEntity("recentrydetail").get(rowIndex)).getString("casbillno");
            Optional<Long> billIdOp = this.getModel().getDataEntity(true).getDynamicObjectCollection("recentry").stream().filter(row -> StringUtils.equals((CharSequence)row.getString("recbillno"), (CharSequence)billNo)).map(row -> row.getLong("recbillid")).findFirst();
            if (billIdOp.isPresent()) {
                this.openLinkedForm(billIdOp.get(), "cas_recbill");
            }
        }
    }

    protected String getOpenBillType(String openBillId) {
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        String billtype = null;
        Map sourceBills = BFTrackerServiceHelper.findSourceBills((String)this.getView().getEntityId(), (Long[])new Long[]{pkValue});
        for (Map.Entry next : sourceBills.entrySet()) {
            if (!((HashSet)next.getValue()).contains(Long.valueOf(openBillId))) continue;
            billtype = (String)next.getKey();
            break;
        }
        return billtype;
    }

    protected void openLinkedForm(Object pkValue, String formId) {
        ShowPageUtils.openLinkedForm((Object)pkValue, (String)formId, (IFormView)this.getView());
    }

    protected void repaymentSourcebillCheck(int rowIndex) {
        DynamicObjectCollection repaymentEntries = this.getModel().getEntryEntity("repaymententry");
        DynamicObject repaymentEntry = (DynamicObject)repaymentEntries.get(rowIndex);
        String loanBillId = repaymentEntry.getString("sourcebillid");
        String openBillType = repaymentEntry.getString("srcbilltype");
        if (openBillType == null) {
            openBillType = this.getOpenBillType(loanBillId);
        }
        if (openBillType == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0e\u6e90\u5355\u7684\u5173\u8054\u5173\u7cfb\u672a\u751f\u6210\uff0c\u8bf7\u6682\u5b58\u5355\u636e\u540e\u518d\u8bd5\u3002", (String)"ErRepayMentBillPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (loanBillId != null && openBillType != null) {
            this.openLinkedForm(loanBillId, openBillType);
        }
    }

    private void showReceiveEntry() {
        AdvContainer receiveEntryContainer = (AdvContainer)this.getControl("advconap1");
        int entryRowCount = this.getModel().getEntryRowCount("recentry");
        if (entryRowCount < 1) {
            receiveEntryContainer.setCollapse(true);
        } else {
            receiveEntryContainer.setCollapse(false);
        }
    }

    protected BillSettingRuleInfo getBillSettingRuleInfo() {
        if (this.ruleInfo == null) {
            this.ruleInfo = BillSettingRuleUtil.getBillSettingRuleInfo((IDataModel)this.getModel());
        }
        return this.ruleInfo;
    }
}

