/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.formplugin.entryimport.excelhandle.AbstractEntryExcelDataHandler;
import kd.fi.er.formplugin.entryimport.service.EntryImportServiceFactory;
import org.apache.commons.lang.StringUtils;

public class EntryImport
extends AbstractFormPlugin
implements UploadListener {
    private static Log logger = LogFactory.getLog(EntryImport.class);
    private static final String FILEPANEL = "filepanel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnresetfile", "download", "btn_upload"});
        Image fileLabel = (Image)this.getControl("btnupload");
        fileLabel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{FILEPANEL});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control contol = (Control)evt.getSource();
        switch (key = contol.getKey()) {
            case "download": {
                FormShowParameter currShowParameter = this.getView().getFormShowParameter();
                String billFormId = (String)currShowParameter.getCustomParam("BillFormId");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_downloadtemplate");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("BillFormId", (Object)billFormId);
                showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                this.getView().showForm(showParameter);
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{FILEPANEL});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"uploadpanel"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
                break;
            }
            case "btn_upload": {
                this.uploadData();
            }
        }
    }

    private void uploadData() {
        String rowDataString = this.getPageCache().get("rowDatas");
        if (null == rowDataString) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6587\u6863\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EntryImport_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        List rowDatas = (List)SerializationUtils.fromJsonString((String)rowDataString, List.class);
        Object importMethod = this.getModel().getValue("imptmethod");
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("imptmethod", importMethod);
        returnData.put("rowDatas", rowDatas);
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void upload(UploadEvent evt) {
        String billEntryId;
        super.upload(evt);
        Object[] urls = evt.getUrls();
        String url = (String)urls[0];
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream inputStream = service.getInputStream(url);
        final ArrayList dataIndexes = new ArrayList();
        final ArrayList mustInputIndexes = new ArrayList();
        final StringBuilder errorInfo = new StringBuilder();
        final HashMap title = new HashMap();
        final ArrayList<Map<String, String>> returnData = new ArrayList<Map<String, String>>();
        final HashMap titleName = new HashMap();
        String billEntryKey = billEntryId = (String)this.getView().getFormShowParameter().getCustomParam("BillEntryId");
        if ("er_contractbill".equals(this.getView().getFormShowParameter().getParentFormId())) {
            billEntryKey = billEntryId + "_contract";
        }
        try {
            AbstractEntryExcelDataHandler excelDataHander;
            new ExcelReader().read(inputStream, new SheetHandler(){
                private Integer titleNameIndex = 3;
                private Integer dataStartIndex = 4;

                public void handleRow(SheetHandler.ParsedRow row) {
                    String titleStr;
                    Integer index2;
                    Object rowTitle;
                    if (row.getRowNum() == 0) {
                        if (row.isEmpty()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"EntryImport_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        }
                        Iterator iterator = row.getData().entrySet().iterator();
                        Boolean isGoodField = false;
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            String s = (String)entry.getValue();
                            if (null == s || s.trim().isEmpty() || !s.contains(" # ") || !s.split(" # ")[1].equalsIgnoreCase(billEntryId)) continue;
                            isGoodField = true;
                            break;
                        }
                        if (!isGoodField.booleanValue()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6a21\u677f\u3002", (String)"EntryImport_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                        }
                    } else if (row.getRowNum() == 2) {
                        rowTitle = row.getData();
                        for (Map.Entry rowTitleColumnData : rowTitle.entrySet()) {
                            index2 = (Integer)rowTitleColumnData.getKey();
                            titleStr = (String)rowTitleColumnData.getValue();
                            if (!StringUtils.isEmpty((String)titleStr) && titleStr.contains("#")) {
                                this.titleNameIndex = 2;
                                this.dataStartIndex = 3;
                                if (titleStr.startsWith("*")) {
                                    mustInputIndexes.add(index2);
                                }
                                String titleCode = titleStr.split(" # ")[1];
                                if (titleStr.contains(".name")) continue;
                                title.put(index2, titleCode);
                                continue;
                            }
                            title.put(index2, titleStr);
                        }
                    } else if (row.getRowNum() == this.titleNameIndex.intValue()) {
                        rowTitle = row.getData();
                        for (Map.Entry rowTitleColumnData : rowTitle.entrySet()) {
                            index2 = (Integer)rowTitleColumnData.getKey();
                            titleStr = (String)rowTitleColumnData.getValue();
                            if (titleStr.startsWith("*")) {
                                titleName.put(index2, titleStr.substring(1));
                                continue;
                            }
                            titleName.put(index2, titleStr);
                        }
                    }
                    if (row.getRowNum() == this.titleNameIndex.intValue() && mustInputIndexes.isEmpty()) {
                        rowTitle = row.getData();
                        rowTitle.forEach((index, titleName) -> {
                            if (titleName.startsWith("*")) {
                                mustInputIndexes.add(index);
                            }
                        });
                    }
                    if (row.getRowNum() >= this.dataStartIndex && !row.isEmpty()) {
                        dataIndexes.add(row.getRowNum());
                        for (Integer index3 : mustInputIndexes) {
                            if (row.get(index3) != null && !"".equals(row.get(index3))) continue;
                            errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c: \u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5[%2$s]\u672a\u586b\u5199, \u8bf7\u8865\u5145\u5b8c\u6574\u3002 \n", (String)"EntryImport_12", (String)"fi-er-formplugin", (Object[])new Object[0]), row.getRowNum() + 1, titleName.get(index3)));
                            break;
                        }
                        HashMap<String, String> dataRow = new HashMap<String, String>();
                        dataRow.put("excelrow", row.getRowNum() + 1 + "");
                        if (title.size() > 0) {
                            title.forEach((index, key) -> dataRow.put((String)key, row.get(index)));
                            returnData.add(dataRow);
                        }
                    }
                }
            });
            for (int i = dataIndexes.size() - 1; i > 0; --i) {
                if ((Integer)dataIndexes.get(i) - (Integer)dataIndexes.get(i - 1) > 1) continue;
                dataIndexes.remove(i);
            }
            if (dataIndexes.size() >= 2) {
                StringBuilder sb = new StringBuilder();
                Integer i = 1;
                Integer size = dataIndexes.size();
                Integer first = (Integer)dataIndexes.get(0);
                Integer last = (Integer)dataIndexes.get(i);
                while (i < size) {
                    first = first + 1;
                    sb.append(first + 1).append("\u3001");
                    if (first + 1 != last) continue;
                    if ((i = Integer.valueOf(i + 1)) >= size) break;
                    first = last;
                    last = (Integer)dataIndexes.get(i);
                }
                sb.setLength(sb.length() - 1);
                errorInfo.append(ResManager.loadKDString((String)"\u5b58\u5728\u4e3a\u7a7a\u7684\u6570\u636e\u884c\uff0c\u8bf7\u5220\u9664\u540e\u518d\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"EntryImport_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
                errorInfo.append('\n');
            }
            if ((excelDataHander = EntryImportServiceFactory.getExcelDataHandlerService(billEntryKey)) != null) {
                IFormView viewNoPlugin = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                excelDataHander.setView(viewNoPlugin);
                if (returnData.size() > 0) {
                    Map map = (Map)returnData.get(0);
                    String entityId = viewNoPlugin.getEntityId();
                    if (entityId != null) {
                        map.put("importentityid", entityId);
                    }
                }
                excelDataHander.doConvert(returnData, errorInfo);
            }
        }
        catch (KDBizException e) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImport_5", (String)"fi-er-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            logger.info("EntryImport >>> " + ThrowableHelper.toString((Exception)((Object)e)));
        }
        catch (Exception e) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_upload"});
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EntryImport_6", (String)"fi-er-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            logger.info("EntryImport >>> " + ThrowableHelper.toString((Exception)e));
            return;
        }
        if (errorInfo.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6587\u6863\u89e3\u6790\u5b58\u5728\u5f02\u5e38\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntryImport_7", (String)"fi-er-formplugin", (Object[])new Object[0]), errorInfo.toString(), MessageTypes.Default);
            return;
        }
        String rowDatas = SerializationUtils.toJsonString(returnData);
        this.getPageCache().put("rowDatas", rowDatas);
        logger.info("EntryImport >> \u89e3\u6790\u540e\u7684\u6570\u636e" + SerializationUtils.toJsonString((Object)rowDatas));
        this.getView().setVisible(Boolean.valueOf(true), new String[]{FILEPANEL});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"uploadpanel"});
        this.getModel().setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
        this.getModel().setValue("filepath", (Object)url);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_upload"});
    }
}

