/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.datahandle;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.formplugin.entryimport.datahandle.AbstractEntryModelDataHandler;
import org.apache.commons.lang3.StringUtils;

public class AccountEntryImportDataHandler
extends AbstractEntryModelDataHandler {
    public AccountEntryImportDataHandler() {
        super("accountentry");
    }

    @Override
    public void setEntryData(IDataModel model, IFormView view, IPageCache pageCache, Map<String, Object> returnData) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (currency == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u83b7\u53d6\u5230\u672c\u4f4d\u5e01\u3002", (String)"AccountEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        returnData.put("currencyId", currency.getPkValue());
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u516c\u53f8", (String)"AccountEntryImportDataHandler_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        returnData.put("companyId", company.getPkValue());
        this.handleReturnCurrencyAndExchangeRate(returnData, model);
        model.beginInit();
        super.setEntryData(model, view, pageCache, returnData);
        model.endInit();
        if (ErEntityTypeUtils.isPublicReimburseBill((String)view.getEntityId())) {
            DynamicObjectCollection accountEntry = model.getEntryEntity("accountentry");
            double receiveAmountSum = accountEntry.stream().mapToDouble(account -> account.getBigDecimal("orireceiveamount").doubleValue()).sum();
            boolean isOnAccount = receiveAmountSum == 0.0 ? false : accountEntry.stream().anyMatch(r -> !r.getBoolean("ispaynow"));
            model.setValue("isonaccount", (Object)isOnAccount);
        }
        view.updateView(this.getEntryId());
        int accEntryRow = model.getEntryRowCount("accountentry");
        for (int rowIndex = 0; rowIndex < accEntryRow; ++rowIndex) {
            BigDecimal oriReceiveAmount = (BigDecimal)model.getValue("orireceiveamount", rowIndex);
            BigDecimal accExchangeRate = (BigDecimal)model.getValue("accexchangerate", rowIndex);
            model.beginInit();
            model.setValue("orireceiveamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("accexchangerate", (Object)BigDecimal.ONE, rowIndex);
            model.endInit();
            model.setValue("orireceiveamount", (Object)oriReceiveAmount, rowIndex);
            model.setValue("accexchangerate", (Object)accExchangeRate, rowIndex);
        }
    }

    private void handleReturnCurrencyAndExchangeRate(Map<String, Object> returnData, IDataModel model) {
        List rowDatas = (List)returnData.get("rowDatas");
        Long currencyId = (Long)returnData.get("currencyId");
        currencyId = currencyId == null ? Long.valueOf(0L) : currencyId;
        Long companyId = (Long)returnData.get("companyId");
        companyId = companyId == null ? Long.valueOf(OrgUnitServiceHelper.getRootOrgId()) : companyId;
        for (Map rowData : rowDatas) {
            BigDecimal exchangeRate;
            String accExchangeRate;
            String accCurrencyNum = (String)rowData.get("accountcurrency.number");
            Long accCurrencyId = 0L;
            if (StringUtils.isEmpty((CharSequence)accCurrencyNum)) {
                rowData.put("accountcurrency.id", currencyId.toString());
                rowData.remove("accountcurrency.number");
                accCurrencyId = currencyId;
            } else {
                DynamicObject accCurrencyDym = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id", (QFilter[])new QFilter("number", "=", (Object)accCurrencyNum).toArray());
                accCurrencyId = ErCommonUtils.getPk((Object)accCurrencyDym);
            }
            if (!StringUtils.isEmpty((CharSequence)(accExchangeRate = (String)rowData.get("accexchangerate")))) continue;
            if (accCurrencyId == null || accCurrencyId.equals(currencyId)) {
                // empty if block
            }
            exchangeRate = (exchangeRate = CommonServiceHelper.getExchangeRateFromSysParams((Long)accCurrencyId, (Long)currencyId, (Long)companyId, (Object)model)) == null ? BigDecimal.ONE : exchangeRate;
            rowData.put("accexchangerate", exchangeRate.toString());
        }
    }

    @Override
    public void setColumnData(Map<String, String> row, int rowIndex, String key, IDataModel model, IFormView view, StringBuilder errorInfo) {
        String value = row.get(key);
        if (StringUtils.isEmpty((CharSequence)value) || key.contains(".name")) {
            return;
        }
        value = value.trim();
        if (StringUtils.equals((CharSequence)"payertype", (CharSequence)key) || StringUtils.equals((CharSequence)"payeraccount", (CharSequence)key) || StringUtils.equals((CharSequence)"orireceiveamount", (CharSequence)key)) {
            view.getModel().setValue(key, (Object)value, rowIndex);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"payername", (CharSequence)key)) {
            DynamicObject company;
            Long companyId;
            QFilter baseDataFilter;
            Map map;
            String payerType = row.get("payertype");
            PayerTypeEnum payerEnum = PayerTypeEnum.getValue((String)payerType);
            String payername = row.get("payername");
            DynamicObject[] accountBanks = null;
            DynamicObject accountInfo = null;
            if (PayerTypeEnum.CASORG == payerEnum) {
                Map map2 = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)payername)});
                if (map2 != null && map2.size() != 0) {
                    accountBanks = map2.values().toArray(new DynamicObject[0]);
                }
            } else if (PayerTypeEnum.PAYER == payerEnum) {
                DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)payername)});
                if (user == null) {
                    view.showMessage(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u5b58\u5728", (String)"LoanBillImportDataOp_40", (String)"fi-er-opplugin", (Object[])new Object[0]));
                } else {
                    accountBanks = new DynamicObject[]{user};
                }
            } else if ((PayerTypeEnum.CUSTOMER == payerEnum || PayerTypeEnum.SUPPLIER == payerEnum) && (map = BusinessDataServiceHelper.loadFromCache((String)payerType, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)payername).and(baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)payerType, (Long)(companyId = Long.valueOf((company = (DynamicObject)model.getValue("company")).getLong("id")))))})) != null && map.size() != 0) {
                accountBanks = map.values().toArray(new DynamicObject[0]);
            }
            if (PayerTypeEnum.CASORG == payerEnum || PayerTypeEnum.PAYER == payerEnum || PayerTypeEnum.SUPPLIER == payerEnum || PayerTypeEnum.CUSTOMER == payerEnum) {
                if (accountBanks == null || accountBanks.length == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4e0d\u5b58\u5728", (String)"LoanBillImportDataOp_40", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                accountInfo = accountBanks[0];
                if (this.checkBaseDataDisenable(accountInfo)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4eba%s\u5df2\u7981\u7528\u3002", (String)"LoanBillImportDataOp_42", (String)"fi-er-opplugin", (Object[])new Object[0]), payername));
                }
                if (PayerTypeEnum.CASORG == payerEnum && view.getControl("casorg") != null) {
                    model.setValue("casorg", accountInfo.getPkValue(), rowIndex);
                    model.setValue("payername", (Object)accountInfo.getString("name"), rowIndex);
                } else if (PayerTypeEnum.SUPPLIER == payerEnum && view.getControl("supplier") != null) {
                    model.setValue("supplier", accountInfo.getPkValue(), rowIndex);
                    model.setValue("payername", (Object)accountInfo.getString("name"), rowIndex);
                } else if (PayerTypeEnum.CUSTOMER == payerEnum && view.getControl("customer") != null) {
                    model.setValue("customer", accountInfo.getPkValue(), rowIndex);
                    model.setValue("payername", (Object)accountInfo.getString("name"), rowIndex);
                } else if (PayerTypeEnum.PAYER == payerEnum) {
                    Long userPk = (Long)accountInfo.getPkValue();
                    QFilter qFilter = new QFilter("payer", "=", (Object)userPk);
                    Optional.ofNullable(row.get("payeraccount")).ifPresent(e -> qFilter.and(new QFilter("payeraccount", "=", e)));
                    Optional.ofNullable(row.get("payeraccountname")).ifPresent(e -> qFilter.and(new QFilter("payeraccountname", "=", e)));
                    Map payers = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (QFilter[])new QFilter[]{qFilter});
                    if (payers == null || payers.size() == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"LoanBillImportDataOp_41", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                    DynamicObject payer = (DynamicObject)payers.values().toArray()[0];
                    model.setValue("payer", (Object)ErCommonUtils.getPk((Object)payer.getPkValue()), rowIndex);
                    model.setValue("payername", (Object)accountInfo.getString("name"), rowIndex);
                } else if (PayerTypeEnum.OTHER == payerEnum) {
                    model.setValue("payername", (Object)accountInfo.getString("name"), rowIndex);
                }
                return;
            }
        }
        super.setColumnData(row, rowIndex, key, model, view, errorInfo);
    }

    private boolean checkBaseDataDisenable(DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return false;
        }
        return !"1".equals(dynamicObject.getString("enable"));
    }
}

