/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.datahandle;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.TextAreaProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.ComboEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.budget.BudgetCommonUtil;
import kd.fi.er.formplugin.entryimport.datahandle.AbstractEntryModelDataHandler;
import org.apache.commons.lang3.StringUtils;

public class AssetEntryImportDataHandler
extends AbstractEntryModelDataHandler {
    private static final Log logger = LogFactory.getLog(AssetEntryImportDataHandler.class);

    public AssetEntryImportDataHandler() {
        super("assetentry");
    }

    @Override
    public void setEntryData(IDataModel model, IFormView view, IPageCache pageCache, Map<String, Object> returnData) {
        Boolean isCurrency;
        Object imptMethod = returnData.get("imptmethod");
        if (imptMethod != null && "cover".equals(imptMethod)) {
            ArrayList<IDataEntityProperty> entries = new ArrayList<IDataEntityProperty>();
            entries.add(model.getProperty("assetentry"));
            for (IDataEntityProperty entry : entries) {
                if (entry == null) continue;
                model.deleteEntryData(entry.getName());
            }
        }
        if ((isCurrency = (Boolean)model.getValue("iscurrency")) == null) {
            isCurrency = Boolean.FALSE;
        }
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        String currencyNum = "-1";
        if (currency != null) {
            currencyNum = currency.getString("number");
        }
        List rowDatas = (List)returnData.get("rowDatas");
        Boolean isQueryBudgetFlag = BudgetCommonUtil.getIsQueryBudgetFlag(pageCache);
        BudgetCommonUtil.setIsQueryBudgetFlag(pageCache, false);
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)true);
        StringBuilder errorInfo = new StringBuilder();
        for (int rowNum = 0; rowNum < rowDatas.size(); ++rowNum) {
            boolean isSetOriAmount = false;
            boolean isSetTaxOAmount = false;
            Map row = (Map)rowDatas.get(rowNum);
            String entryCurrency = (String)row.get("assetcurrency.number");
            if (!(isCurrency.booleanValue() || entryCurrency == null || "".equals(entryCurrency.trim()) || entryCurrency.equals(currencyNum))) {
                model.setValue("iscurrency", (Object)Boolean.TRUE);
                isCurrency = Boolean.TRUE;
            }
            if (rowNum == rowDatas.size() - 1) {
                ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
            }
            int rowIndex = model.createNewEntryRow("assetentry");
            try {
                List keys = row.keySet().stream().collect(Collectors.toList());
                for (int i = 0; i < keys.size(); ++i) {
                    String key = (String)keys.get(i);
                    String value = (String)row.get(key);
                    if ("assetcurrency".equals(key) && !isCurrency.booleanValue() || "assetexchangerate".equals(key) && (!isCurrency.booleanValue() || currencyNum.equals(row.get("assetcurrency.number")))) continue;
                    if ("assetorientryamount".equals(key) && value != null && !value.isEmpty()) {
                        isSetOriAmount = true;
                    }
                    if ("assettaxamount".equals(key) && value != null && !value.isEmpty()) {
                        isSetTaxOAmount = true;
                    }
                    this.setColumnData(row, rowIndex, key, model, view, errorInfo, isSetOriAmount, isSetTaxOAmount);
                }
            }
            catch (Exception e) {
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"ExpenseEntryImportDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append((String)row.get("excelrow")).append(ResManager.loadKDString((String)"\u884c: ", (String)"ExpenseEntryImportDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0])).append(e.getMessage() == null ? e.toString() : e.getMessage()).append("\n");
                logger.info("EntryImport >> \u6570\u636e\u5bfc\u5165\u5b58\u5728\u5f02\u5e38 >> ", (Object)e);
            }
            if (rowNum % 3 != 1) continue;
            view.getPageCache().put("task_percent", String.valueOf(((float)rowNum - 1.0f) / (float)rowDatas.size() * 100.0f).replaceAll("\\.[0-9]*", ""));
        }
        if (!"".equals(errorInfo.toString())) {
            view.getPageCache().put("task_error", errorInfo.toString());
        }
        ErCommonUtils.setIsBatchExcelImportExpenseEnry((IPageCache)pageCache, (boolean)false);
        BudgetCommonUtil.setIsQueryBudgetFlag(pageCache, isQueryBudgetFlag);
        if (isQueryBudgetFlag.booleanValue()) {
            BudgetCommonUtil.buildBudgetAmountField(view);
        }
    }

    public void setColumnData(Map<String, String> row, int rowIndex, String key, IDataModel model, IFormView view, StringBuilder errorInfo, boolean isSetOriAmount, boolean isSetTaxOAmount) {
        String value = row.get(key);
        if (StringUtils.isEmpty((CharSequence)value) || key.contains(".name")) {
            return;
        }
        if (key.endsWith(".id")) {
            model.setValue(key.replace(".id", ""), (Object)value, rowIndex);
            return;
        }
        IDataEntityProperty property = model.getProperty(key = key.replace(".number", ""));
        if (property == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"assettype")) {
            return;
        }
        if (property instanceof TextAreaProp) {
            TextAreaProp text = (TextAreaProp)property;
            if (text.getMaxLenth() > 0 && value.length() > text.getMaxLenth()) {
                String tip = ResManager.loadKDString((String)"\u884c: \"%1$s\" \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"AbstractEntryModelDataHandler_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"AbstractEntryModelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append(row.get("excelrow")).append(String.format(tip, property.getDisplayName().getLocaleValue())).append("\n");
                value = value.substring(0, text.getMaxLenth());
            }
            model.setValue(key, (Object)value, rowIndex);
        } else if (property instanceof ItemClassProp) {
            DynamicObject classItemBaseDataDym;
            ItemClassProp itemClassProp = (ItemClassProp)property;
            String typePropName = itemClassProp.getTypePropName();
            String dataType = row.get(typePropName);
            String dataTypeNumber = "";
            ItemClassTypeProp typeProp = (ItemClassTypeProp)model.getProperty(typePropName);
            List comboItems = typeProp.getComboItems();
            for (ValueMapItem item : comboItems) {
                if (!StringUtils.equals((CharSequence)dataType, (CharSequence)item.getName().getLocaleValue())) continue;
                dataTypeNumber = item.getValue();
                model.setValue(typePropName, (Object)item.getValue(), rowIndex);
                break;
            }
            String numberProperty = "number";
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)dataTypeNumber);
            if (dataEntityType instanceof BasedataEntityType) {
                numberProperty = ((BasedataEntityType)dataEntityType).getNumberProperty();
            }
            if ((classItemBaseDataDym = BusinessDataServiceHelper.loadSingleFromCache((String)dataTypeNumber, (String)"id", (QFilter[])new QFilter(numberProperty, "=", (Object)value).toArray())) != null) {
                model.setValue(key, classItemBaseDataDym.get("id"), rowIndex);
            } else {
                model.setItemValueByNumber(key, value, rowIndex);
            }
        } else if (property instanceof BasedataProp || property instanceof CurrencyProp) {
            BasedataProp baseProp = (BasedataProp)property;
            DynamicObject basedataDOFromCache = BusinessDataServiceHelper.loadSingleFromCache((String)baseProp.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{value})});
            if (basedataDOFromCache != null) {
                model.setValue(key, basedataDOFromCache.get("id"), rowIndex);
            } else {
                model.setItemValueByNumber(key, value, rowIndex);
            }
        } else if (property instanceof BooleanProp) {
            if ("\u662f".equals(value)) {
                model.setValue(key, (Object)Boolean.TRUE, rowIndex);
            } else {
                model.setValue(key, (Object)Boolean.FALSE, rowIndex);
            }
        } else if (property instanceof ComboProp) {
            ComboEdit type = (ComboEdit)view.getControl(key);
            ComboProp itemProp = (ComboProp)type.getProperty();
            List comboItems = itemProp.getComboItems();
            for (ValueMapItem item : comboItems) {
                if (!StringUtils.equals((CharSequence)value, (CharSequence)item.getName().getLocaleValue())) continue;
                model.setValue(key, (Object)item.getValue(), rowIndex);
                return;
            }
        } else if (property instanceof AmountProp || property instanceof DecimalProp) {
            BigDecimal amount = new BigDecimal(value);
            if (isSetOriAmount && (StringUtils.equals((CharSequence)key, (CharSequence)"assetpricewithouttax") || StringUtils.equals((CharSequence)key, (CharSequence)"asset_quantity"))) {
                model.beginInit();
                model.setValue(key, (Object)amount, rowIndex);
                model.endInit();
            } else if (isSetTaxOAmount && StringUtils.equals((CharSequence)key, (CharSequence)"assettaxrate")) {
                model.beginInit();
                model.setValue(key, (Object)amount, rowIndex);
                model.endInit();
            } else {
                model.setValue(key, (Object)amount, rowIndex);
            }
        } else if (property instanceof TextProp) {
            TextProp text = (TextProp)property;
            if (text.getMaxLenth() > 0 && value.length() > text.getMaxLenth()) {
                String tip = ResManager.loadKDString((String)"\u884c: \"%1$s\" \u5b57\u6bb5\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236, \u5df2\u622a\u53d6\u6709\u6548\u90e8\u5206\u3002", (String)"AbstractEntryModelDataHandler_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
                errorInfo.append(ResManager.loadKDString((String)"\u7b2c", (String)"AbstractEntryModelDataHandler_0", (String)"fi-er-formplugin", (Object[])new Object[0])).append(row.get("excelrow")).append(String.format(tip, property.getDisplayName().getLocaleValue())).append("\n").append("\n");
                value = value.substring(0, text.getMaxLenth());
            }
            model.setValue(key, (Object)value, rowIndex);
        } else {
            model.setValue(key, (Object)value, rowIndex);
        }
    }
}

