/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.excelhandle;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.entryimport.excelhandle.AbstractEntryExcelDataHandler;
import org.apache.commons.lang3.StringUtils;

public class TripGridEntryExcelDataHandler
extends AbstractEntryExcelDataHandler {
    private static final String tripCostCompany_id = "travelcostcompany.number";
    private static final String tripCostdept_id = "travelcostdept.number";
    private static final String expItem_id = "travelexpenseitem.number";
    private static final String travelExpItem_id = "expenseitem.number";
    private static final String tripTo_id = "trip2to.name";
    private static final String tripFrom_id = "trip2from.name";
    private static final String currency_id = "entrycurrency.number";
    private static final String travelers_id = "trip2travelers.number";
    private static final String mulTravelers_id = "trip2travelers.number";

    public TripGridEntryExcelDataHandler() {
        super("entryentity");
    }

    @SafeVarargs
    private final void removeNullStrElement(Set<String> ... sets) {
        ((Stream)Arrays.stream(sets).parallel()).forEach(set -> set.removeIf(r -> r == null || StringUtils.equalsIgnoreCase((CharSequence)r, (CharSequence)"")));
    }

    private void removeTmpSet(Set<String> set, String element, DynamicObjectCollection dyms) {
        dyms.forEach(e -> set.remove(e.getString(element)));
    }

    @Override
    public void doConvert(List<Map<String, String>> returnData, StringBuilder errorInfo) {
        int size = returnData.size();
        int startIndex = 0;
        HashSet<String> costDept = new HashSet<String>(size);
        HashSet<String> costCompany = new HashSet<String>(size);
        HashSet<String> expItem = new HashSet<String>(size);
        HashSet<String> travelExpItem = new HashSet<String>(size);
        HashSet<String> admindivision = new HashSet<String>(size * 2);
        HashSet<String> currency = new HashSet<String>(size * 2);
        HashSet date = new HashSet(size * 2);
        HashSet<String> travelers = new HashSet<String>(size * 2);
        IFormView view = this.getView();
        Long company = 0L;
        Long costcompany = 0L;
        if (null != view) {
            IDataModel model = view.getModel();
            if (null != model.getProperty("company")) {
                company = ErCommonUtils.getPk((Object)model.getValue("company"));
            }
            if (null != model.getProperty("costcompany")) {
                costcompany = ErCommonUtils.getPk((Object)model.getValue("costcompany"));
            }
        }
        for (Map map : returnData) {
            String orientryamountStr;
            DynamicObject tripArea;
            String triparea;
            ++startIndex;
            costDept.add(map.getOrDefault(tripCostdept_id, ""));
            costCompany.add(map.getOrDefault(tripCostCompany_id, ""));
            expItem.add(map.getOrDefault(expItem_id, ""));
            admindivision.add(map.getOrDefault(tripTo_id, ""));
            admindivision.add(map.getOrDefault(tripFrom_id, ""));
            currency.add(map.getOrDefault(currency_id, ""));
            travelExpItem.add(map.getOrDefault(travelExpItem_id, ""));
            String travelersId = (String)map.get("trip2travelers.number");
            if (travelersId != null) {
                String[] split = travelersId.split(",");
                travelers.addAll(Arrays.asList(split));
            }
            if ((triparea = map.getOrDefault("triparea.number", "")) != null && !triparea.isEmpty() && (tripArea = QueryServiceHelper.queryOne((String)"er_triparea", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)triparea)})) == null) {
                this.buildErrorInfo(errorInfo, String.valueOf(startIndex), ResManager.loadKDString((String)"\u51fa\u5dee\u5730\u57df ", (String)"TripGridEntryExcelDataHandler_10", (String)"fi-er-formplugin", (Object[])new Object[0]), triparea, ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"TripGridEntryExcelDataHandler_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            String tripStartDate = map.getOrDefault("trip2startdate", "");
            Date startdate = TripCommonUtil.convertToDate((String)tripStartDate);
            if (tripStartDate == null || tripStartDate.isEmpty() || startdate == null) {
                this.buildErrorInfo(errorInfo, String.valueOf(startIndex), ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4 ", (String)"TripGridEntryExcelDataHandler_13", (String)"fi-er-formplugin", (Object[])new Object[0]), tripStartDate, ResManager.loadKDString((String)"\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"TripGridEntryExcelDataHandler_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            String tripEndDate = map.getOrDefault("trip2enddate", "");
            Date enddate = TripCommonUtil.convertToDate((String)tripEndDate);
            if (tripEndDate == null || tripEndDate.isEmpty() || enddate == null) {
                this.buildErrorInfo(errorInfo, String.valueOf(startIndex), ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4 ", (String)"TripGridEntryExcelDataHandler_15", (String)"fi-er-formplugin", (Object[])new Object[0]), tripEndDate, ResManager.loadKDString((String)"\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"TripGridEntryExcelDataHandler_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (startdate instanceof Date && enddate instanceof Date && startdate.compareTo(enddate) > 0) {
                SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd");
                this.buildErrorInfo(errorInfo, String.valueOf(startIndex), ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\uff1a", (String)"TripGridEntryExcelDataHandler_3", (String)"fi-er-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"%1$s \u665a\u4e8e %2$s", (String)"TripGridEntryExcelDataHandler_22", (String)"fi-er-formplugin", (Object[])new Object[0]), simple.format((Object)startdate), simple.format((Object)enddate)), ResManager.loadKDString((String)" \u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"TripGridEntryExcelDataHandler_16", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (null != map.get("exchangerate")) {
                String exchangerate = map.getOrDefault("exchangerate", "");
                try {
                    BigDecimal exchangerateB = new BigDecimal(exchangerate);
                    if (exchangerateB.compareTo(BigDecimal.ZERO) <= 0) {
                        this.buildErrorInfo(errorInfo, String.valueOf(startIndex), ResManager.loadKDString((String)"\u6c47\u7387 ", (String)"TripGridEntryExcelDataHandler_23", (String)"fi-er-formplugin", (Object[])new Object[0]), exchangerate, ResManager.loadKDString((String)"\u6570\u503c\u8303\u56f4\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"ShareEntryExcelDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    this.buildErrorInfo(errorInfo, String.valueOf(startIndex), ResManager.loadKDString((String)"\u6c47\u7387 ", (String)"TripGridEntryExcelDataHandler_23", (String)"fi-er-formplugin", (Object[])new Object[0]), exchangerate, ResManager.loadKDString((String)"\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"TripGridEntryExcelDataHandler_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            }
            if ((orientryamountStr = map.getOrDefault("orientryamount", "")) == null || orientryamountStr.isEmpty()) {
                orientryamountStr = "0";
            }
            BigDecimal orientryamount = BigDecimal.ZERO;
            try {
                orientryamount = new BigDecimal(orientryamountStr);
            }
            catch (Exception e) {
                this.buildErrorInfo(errorInfo, String.valueOf(startIndex), ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d ", (String)"TripGridEntryExcelDataHandler_17", (String)"fi-er-formplugin", (Object[])new Object[0]), orientryamountStr, ResManager.loadKDString((String)"\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"TripGridEntryExcelDataHandler_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
        this.removeNullStrElement(costDept, costCompany, expItem, travelExpItem, admindivision, currency, date, travelers);
        QFilter orgFilter = new QFilter("isfreeze", "=", (Object)false).and("view", "=", (Object)1);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bos_adminorg_structure", (String)"id,org.number", (QFilter[])new QFilter[]{orgFilter, new QFilter("org.number", "in", costDept)});
        this.removeTmpSet(costDept, "org.number", dynamicObjectCollection);
        QFilter costcompanyFilter = new QFilter("structure.view", "=", (Object)10);
        costcompanyFilter.and("structure.isfreeze", "=", (Object)false);
        if (ErCommonUtils.costcompanyonlyleaf()) {
            costcompanyFilter.and("structure.isleaf", "=", (Object)true);
        }
        costcompanyFilter.and("enable", "=", (Object)true);
        costcompanyFilter.and("number", "in", costCompany);
        DynamicObjectCollection companyDyms = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{costcompanyFilter});
        this.removeTmpSet(costCompany, "number", companyDyms);
        QFilter enableFilter = new QFilter("enable", "=", (Object)true);
        if (null != costcompany && 0L != costcompany) {
            QFilter qFilter = new QFilter("number", "in", expItem);
            qFilter.and(enableFilter).and(new QFilter("isleaf", "=", (Object)true));
            Map queryDynamicObjectMap = BaseDataServiceHelper.queryBaseDataFromCache((String)"er_expenseitemedit", (Long)costcompany, (QFilter)qFilter, (String)"id, number, isleaf");
            if (queryDynamicObjectMap != null) {
                Iterator iterator = queryDynamicObjectMap.entrySet().iterator();
                DynamicObjectCollection expItemDyms = new DynamicObjectCollection();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    expItemDyms.add(entry.getValue());
                }
                this.removeTmpSet(expItem, "number", expItemDyms);
            }
        }
        DynamicObjectCollection currencyDyms = QueryServiceHelper.query((String)"bd_currency", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", currency), enableFilter});
        this.removeTmpSet(currency, "number", currencyDyms);
        DynamicObjectCollection travlesDyms = QueryServiceHelper.query((String)"bos_user", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", travelers), enableFilter});
        this.removeTmpSet(travelers, "number", travlesDyms);
        if (null != company && 0L != company) {
            QFilter qFilter = new QFilter("number", "in", travelExpItem);
            qFilter.and(enableFilter);
            Map queryDynamicObjectMap = BaseDataServiceHelper.queryBaseDataFromCache((String)"er_tripexpenseitem", (Long)company, (QFilter)qFilter, (String)"id,number");
            if (queryDynamicObjectMap != null) {
                Iterator iterator = queryDynamicObjectMap.entrySet().iterator();
                DynamicObjectCollection travelExpItemDyms = new DynamicObjectCollection();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    travelExpItemDyms.add(entry.getValue());
                }
                this.removeTmpSet(travelExpItem, "number", travelExpItemDyms);
            }
        }
        DynamicObjectCollection admindivisionDyms = QueryServiceHelper.query((String)"bd_admindivision", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("name", "in", admindivision), enableFilter});
        this.removeTmpSet(admindivision, "name", admindivisionDyms);
        for (Map<String, String> rowData : returnData) {
            int currentRowIndex = size - startIndex + 1;
            if (costDept.contains(rowData.get(tripCostdept_id))) {
                this.buildErrorInfo(errorInfo, String.valueOf(currentRowIndex), ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8", (String)"TripGridEntryExcelDataHandler_18", (String)"fi-er-formplugin", (Object[])new Object[0]), rowData.get(tripCostdept_id), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"TripGridEntryExcelDataHandler_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (costCompany.contains(rowData.get(tripCostCompany_id))) {
                this.buildErrorInfo(errorInfo, String.valueOf(currentRowIndex), ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8", (String)"TripGridEntryExcelDataHandler_9", (String)"fi-er-formplugin", (Object[])new Object[0]), rowData.get(tripCostCompany_id), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u5c01\u5b58\u3002", (String)"TripGridEntryExcelDataHandler_12", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (expItem.contains(rowData.get(expItem_id))) {
                this.buildErrorInfo(errorInfo, String.valueOf(currentRowIndex), ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"TripGridEntryExcelDataHandler_19", (String)"fi-er-formplugin", (Object[])new Object[0]), rowData.get(expItem_id), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"TripGridEntryExcelDataHandler_20", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (currency.contains(rowData.get(currency_id))) {
                this.buildErrorInfo(errorInfo, String.valueOf(currentRowIndex), ResManager.loadKDString((String)"\u5e01\u79cd", (String)"TripGridEntryExcelDataHandler_21", (String)"fi-er-formplugin", (Object[])new Object[0]), rowData.get(currency_id), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"TripGridEntryExcelDataHandler_20", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (travelers.contains(rowData.get("trip2travelers.number"))) {
                this.buildErrorInfo(errorInfo, String.valueOf(currentRowIndex), ResManager.loadKDString((String)"\u591a\u51fa\u5dee\u4eba", (String)"TripGridEntryExcelDataHandler_6", (String)"fi-er-formplugin", (Object[])new Object[0]), rowData.get("trip2travelers.number"), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"TripGridEntryExcelDataHandler_20", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (travelExpItem.contains(rowData.get(travelExpItem_id))) {
                this.buildErrorInfo(errorInfo, String.valueOf(currentRowIndex), ResManager.loadKDString((String)"\u5dee\u65c5\u9879\u76ee", (String)"TripGridEntryExcelDataHandler_7", (String)"fi-er-formplugin", (Object[])new Object[0]), rowData.get(travelExpItem_id), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"TripGridEntryExcelDataHandler_20", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            if (admindivision.contains(rowData.get(tripFrom_id)) || admindivision.contains(rowData.get(tripTo_id))) {
                this.buildErrorInfo(errorInfo, String.valueOf(currentRowIndex), ResManager.loadKDString((String)"\u51fa\u53d1\u5730/\u76ee\u7684\u5730", (String)"TripGridEntryExcelDataHandler_8", (String)"fi-er-formplugin", (Object[])new Object[0]), rowData.get(tripFrom_id) + "/" + rowData.get(tripTo_id), ResManager.loadKDString((String)"\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"TripGridEntryExcelDataHandler_20", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            --startIndex;
        }
    }
}

