/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.entryimport.process;

import java.util.EventObject;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.cache.ErCloudFrameworkCache;
import org.apache.commons.lang3.StringUtils;

public class ProcessBarPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String PROGRESSBAR = "progressbarap";
    public static final String TASK_PERCENT = "task_percent";
    public static final String TASK_ERROR = "task_error";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
        bar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(PROGRESSBAR);
            bar.start();
        }
    }

    public void onProgress(ProgressEvent event) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            String percent = parentView.getPageCache().get(TASK_PERCENT);
            String invoicePercent = ErCloudFrameworkCache.getValueByPageId((String)parentView.getPageId(), (String)TASK_PERCENT);
            if (StringUtils.isNotBlank((CharSequence)invoicePercent)) {
                percent = invoicePercent;
            }
            if (StringUtils.isNotBlank((CharSequence)percent)) {
                Integer percentInt = Integer.valueOf(percent);
                event.setProgress(percentInt.intValue());
                if (percentInt >= 100 || percentInt == -1) {
                    this.getView().close();
                }
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && ProcessBarPlugin.inprocess(parentView.getPageCache())) {
            e.setCancel(true);
        }
    }

    public static boolean inprocess(IPageCache pageCache) {
        Integer percentInt;
        String percent = pageCache.get(TASK_PERCENT);
        return StringUtils.isNotBlank((CharSequence)percent) && (percentInt = Integer.valueOf(percent)) < 100 && percentInt >= 0;
    }
}

