/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.image;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.formula.OutValue;
import kd.bos.form.CloseCallBack;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.invoicecloud.mergerule.ShowUserDefineFilterCustomParaBO;
import kd.fi.er.formplugin.invoicecloud.mergerule.UserDefineFilterReturnBO;
import kd.fi.er.formplugin.paramsetting.ReimburseTypeSetting;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.StringUtils;

public class ImageTplFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ImageTplFormPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit entityMeta = (BasedataEdit)this.getControl("entitymeta");
        entityMeta.addBeforeF7SelectListener(beforeF7Event -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7Event.getFormShowParameter();
            DynamicObject bizapp = (DynamicObject)this.getModel().getValue("bizapp");
            showParameter.getListFilterParameter().getQFilters().add(this.getEntityMetaF7QFilter(bizapp));
            if (bizapp == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e1a\u52a1\u5e94\u7528\u201d\u3002", (String)"ImageTplFormPlugin_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        });
        BasedataEdit printTplBasedataEdit = (BasedataEdit)this.getControl("printtpl");
        printTplBasedataEdit.addBeforeF7SelectListener(beforeF7Event -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7Event.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f", (String)"ImageTplFormPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            int rowIndex = this.getModel().getEntryCurrentRowIndex("print_tpl_entry");
            DynamicObject entityMetaDO = (DynamicObject)this.getModel().getValue("entitymeta", rowIndex);
            showParameter.getListFilterParameter().getQFilters().add(this.getPrintTplF7QFilter(entityMetaDO));
        });
        this.addClickListeners(new String[]{"conditionname"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"bizapp")) {
            this.clearPrintTplEntry();
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"entitymeta")) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (newValue == null) {
                this.getModel().setValue("printtpl", null, rowIndex);
            } else {
                DynamicObject mainEntityDO = (DynamicObject)newValue;
                this.getModel().setValue("printtpl", (Object)this.getDefaultPrintTplFormId((String)mainEntityDO.getPkValue()), rowIndex);
            }
        } else if ("conditionname".equals(name) && StringUtils.isEmpty((CharSequence)((CharSequence)newValue))) {
            this.getModel().setValue("condition", (Object)"", e.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("condition_tag", (Object)"", e.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("conditionjs_tag", (Object)"", e.getChangeSet()[0].getRowIndex());
            this.getModel().setValue("conditionjs", (Object)"", e.getChangeSet()[0].getRowIndex());
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control && "conditionname".equals(((Control)evt.getSource()).getKey())) {
            int index = this.getModel().getEntryCurrentRowIndex("print_tpl_entry");
            DynamicObject v = (DynamicObject)this.getModel().getValue("entitymeta", index);
            if (v == null) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u3002", (String)"ImageTplFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(msg);
                return;
            }
            HashMap<String, String> customMap = new HashMap<String, String>(4);
            ShowUserDefineFilterCustomParaBO param = new ShowUserDefineFilterCustomParaBO();
            param.setEntityName(v.getString("number"));
            param.setFilterValue((String)this.getModel().getValue("condition_tag", index));
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)v.getString("number"));
            EntityTypeUtil helper = new EntityTypeUtil();
            List filterFields = helper.getFilterFields((IDataEntityType)entityType, true);
            Set set = filterFields.stream().map(m -> m.getFieldName()).filter(m -> m.split("\\.").length <= 2).collect(Collectors.toSet());
            param.setFields(new ArrayList<String>(set));
            customMap.put("showUserDefineFilterCustomParaBO", JSON.toJSONString((Object)param));
            FormModel formModel = new FormModel("er_userdefinerule", "", "14", true, customMap);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "showUserDefineRule");
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this, (CloseCallBack)callBack);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object map = closedCallBackEvent.getReturnData();
        if (StringUtils.isEmpty((CharSequence)((CharSequence)map))) {
            return;
        }
        UserDefineFilterReturnBO bo = (UserDefineFilterReturnBO)JSON.parseObject((String)map.toString(), UserDefineFilterReturnBO.class);
        String name = bo.getDesc();
        String conditionValue = bo.getFilterConJson();
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)conditionValue, FilterCondition.class);
        OutValue errorMsg = new OutValue();
        String js = ReimburseTypeSetting.translateFilterToJs(errorMsg, filterCondition);
        if (StringUtils.isNotEmpty((CharSequence)((CharSequence)errorMsg.get()))) {
            this.getView().showErrorNotification((String)errorMsg.get());
            return;
        }
        int index = this.getModel().getEntryCurrentRowIndex("print_tpl_entry");
        this.getModel().setValue("condition_tag", (Object)conditionValue, index);
        this.getModel().setValue("conditionjs_tag", (Object)js, index);
        this.getModel().setValue("conditionname", (Object)name, index);
    }

    private void clearPrintTplEntry() {
        int size = this.getModel().getEntryRowCount("print_tpl_entry");
        for (int i = 0; i < size; ++i) {
            this.getModel().setValue("entitymeta", null, i);
            this.getModel().setValue("printtpl", null, i);
            this.getModel().setValue("condition", null, i);
            this.getModel().setValue("conditionname", null, i);
        }
    }

    private QFilter getEntityMetaF7QFilter(DynamicObject bizAppDO) {
        QFilter qFilter = bizAppDO == null ? QFilter.of((String)"1!=?", (Object[])new Object[]{1}) : new QFilter("bizappid.id", "=", bizAppDO.getPkValue());
        log.info("getEntityMetaF7QFilter return: " + qFilter);
        return qFilter;
    }

    private QFilter getPrintTplF7QFilter(DynamicObject entityMetaDO) {
        QFilter qFilter;
        if (entityMetaDO == null) {
            qFilter = QFilter.of((String)"1!=?", (Object[])new Object[]{1});
        } else {
            List<String> printTplFormIds = this.getManagePrintTplDOs((String)entityMetaDO.getPkValue());
            qFilter = new QFilter("id", "in", printTplFormIds);
        }
        log.info("getPrintTplF7QFilter return: " + qFilter);
        return qFilter;
    }

    private String getDefaultPrintTplFormId(String mainEntityId) {
        if (StringUtils.isBlank((CharSequence)mainEntityId)) {
            return null;
        }
        QFilter qFilter = QFilter.of((String)"billformid.id=? and enable='1' and isdefault='1'", (Object[])new Object[]{mainEntityId});
        DynamicObject managePrintTpl = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (QFilter[])qFilter.toArray());
        if (managePrintTpl == null) {
            return null;
        }
        DynamicObject printTpl = managePrintTpl.getDynamicObject("printtplid");
        if (printTpl == null) {
            return null;
        }
        String templateId = (String)printTpl.getPkValue();
        log.info("\u6253\u5370\u6a21\u677f id\uff1a" + templateId);
        return templateId;
    }

    private List<String> getManagePrintTplDOs(String mainEntityId) {
        List<Object> templateIds = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)mainEntityId)) {
            return templateIds;
        }
        QFilter qFilter = QFilter.of((String)"billformid.id=? and enable='1'", (Object[])new Object[]{mainEntityId});
        Map managePintTplMap = BusinessDataServiceHelper.loadFromCache((String)"bos_manageprinttpl", (QFilter[])new QFilter[]{qFilter});
        if (managePintTplMap == null || managePintTplMap.isEmpty()) {
            return templateIds;
        }
        templateIds = managePintTplMap.values().stream().filter(entry -> entry.getDynamicObject("printtplid") != null).map(entity -> (String)entity.getDynamicObject("printtplid").getPkValue()).collect(Collectors.toList());
        return templateIds;
    }
}

