/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.invoicepackage;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.MenuItem;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.mcontrol.MBlockMenuItemAp;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.invoicecloud.invoicepackage.QuickReimServiceFactory;
import kd.fi.er.business.invoicecloud.invoicepackage.quickreimservice.AbstractQuickReimburseService;
import kd.fi.er.business.invoicecloud.invoicepackage.util.QuickReimUtil;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.DailyBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.common.model.invoice.QuickConfigBo;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import org.apache.commons.lang3.StringUtils;

public class QuickReimburseListMob
extends AbstractMobBillPlugIn
implements ClickListener {
    private static final Log log = LogFactory.getLog(QuickReimburseListMob.class);
    private static final String DEFAULT_FLEX_PANEL = "defaultflexpanelap";
    private static final String DEFAULT_FLEX_PANEL1 = "defaultflexpanelap1";
    private static final String LB_CHANGE = "lb_change";
    private static final String BLOCK_PANEL = "reimtypeblock";
    private static final String ER_DAILY_APPLIER_MOB = "er_daily_applier_mb";
    private QuickReimServiceFactory factory = new QuickReimServiceFactory();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LB_CHANGE});
        this.setCostCompanyF7Filter();
    }

    protected void setCostCompanyF7Filter() {
        BasedataEdit costCompanyF7 = (BasedataEdit)this.getControl("costcompany");
        if (costCompanyF7 != null) {
            costCompanyF7.addBeforeF7SelectListener(event -> {
                FormShowParameter formShowParameter = event.getFormShowParameter();
                List selectIDs = CoreBaseBillServiceHelper.findAllCostCompany();
                if (selectIDs == null || selectIDs.isEmpty()) {
                    return;
                }
                formShowParameter.setCustomParam("isOnlyDisplayOrgLeaves", (Object)true);
                QFilter qFilter = new QFilter("id", "in", (Object)selectIDs);
                if (formShowParameter instanceof MobileFormShowParameter) {
                    formShowParameter.setCustomParam("range", (Object)selectIDs);
                } else {
                    event.getCustomQFilters().add(qFilter);
                }
            });
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        List<QuickConfigBo> configs = this.loadCacheQuickReimConfig(false);
        if (configs == null) {
            return;
        }
        List idList = configs.stream().map(dy -> dy.getId().toString()).collect(Collectors.toList());
        idList.add("more");
        if (!idList.contains(key)) {
            return;
        }
        MenuItem item = new MenuItem();
        item.setKey(key);
        item.setView(this.getView());
        item.addClickListener((ClickListener)this);
        e.setControl((Control)item);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Container menuBlock = (Container)this.getControl(BLOCK_PANEL);
        List<QuickConfigBo> configs = this.loadCacheQuickReimConfig(true);
        if (configs == null) {
            return;
        }
        List<ControlAp> apControls = this.createApControls(configs);
        List controls = apControls.stream().map(ap -> ap.buildRuntimeControl()).collect(Collectors.toList());
        menuBlock.getItems().addAll(controls);
        this.getView().createControlIndex(menuBlock.getItems());
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
        this.showBlockControls();
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String entityName = this.getModel().getDataEntity().getDataEntityType().getName();
        if (StringUtils.isNumeric((CharSequence)key)) {
            this.createBill(Long.parseLong(key));
        }
        if ("more".equals(key)) {
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            showParameter.setFormId("quickreimmoremob");
            showParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e8b\u9879", (String)"QuickReimburseListMob_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            showParameter.getCustomParams().put("reimconfig", this.loadCacheQuickReimConfig(false));
            showParameter.getCustomParams().put("costcompany", ((DynamicObject)this.getModel().getValue("costcompany")).getPkValue());
            showParameter.getCustomParams().put("applier", ((DynamicObject)this.getModel().getValue("applier")).getPkValue());
            showParameter.getCustomParams().put("org", ((DynamicObject)this.getModel().getValue("org")).getPkValue());
            showParameter.getCustomParams().put("company", ((DynamicObject)this.getModel().getValue("company")).getPkValue());
            showParameter.getCustomParams().put("selectedInvoiceInfoBo", this.getView().getFormShowParameter().getCustomParam("selectedInvoiceInfoBo"));
            showParameter.setAppId("exp");
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)LB_CHANGE)) {
            CommonViewControlUtil.changeApplier(entityName, (IFormPlugin)this, this.getView());
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        if (ER_DAILY_APPLIER_MOB.equalsIgnoreCase(event.getActionId()) && event.getReturnData() != null && (returnData = (Map)event.getReturnData()) != null) {
            this.setApplierInfo(this.getModel(), returnData);
            DynamicObject applier = (DynamicObject)returnData.get("applier");
            DynamicObject org = (DynamicObject)returnData.get("org");
            DynamicObject company = (DynamicObject)returnData.get("company");
            Long costCompanyId = CoreBaseBillServiceHelper.getAccountOrgId((Long)((Long)org.getPkValue()), (Boolean)Boolean.FALSE);
            Object position = returnData.get("position");
            this.getModel().setValue("applier", (Object)applier);
            this.getModel().setValue("org", (Object)org);
            this.getModel().setValue("company", (Object)company);
            this.getModel().setValue("applierpositionstr", position);
            this.getModel().setValue("costcompany", (Object)costCompanyId);
            if (company != null && company.getPkValue() != null) {
                Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)company, (Object)costCompanyId);
                this.getModel().setValue("currency", (Object)baseCurrencyId);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        switch (name) {
            case "company": {
                if (newValue == null) {
                    this.getModel().setValue(name, oldValue);
                    break;
                }
                DailyBillServiceHelper.refreshCurrency((IFormView)this.getView(), (ChangeData[])changeSet);
                this.updateBlockControls();
            }
        }
    }

    private List<QuickConfigBo> loadCacheQuickReimConfig(boolean needMeg) {
        String configCache = this.getPageCache().get("reimconfig");
        if (StringUtils.isNotEmpty((CharSequence)configCache)) {
            List quickConfigBos = JSONArray.parseArray((String)configCache, QuickConfigBo.class);
            return quickConfigBos;
        }
        Long companyId = this.getCompany();
        if (companyId == null || companyId == 0L) {
            this.nullCompanyVisible();
            if (needMeg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7533\u8bf7\u4eba\u516c\u53f8\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"QuickReimburseListMob_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            return Collections.EMPTY_LIST;
        }
        List quickConfigs = QuickReimUtil.getQuickConfigs((Long)companyId, (boolean)needMeg, (IFormView)this.getView(), null);
        List match = quickConfigs.stream().filter(config -> config.getInvoicePlugin() != null && config.getInvoicePlugin() != 0L).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(match)) {
            return Collections.EMPTY_LIST;
        }
        List result = QuickReimUtil.getSortConfigs(match);
        this.getPageCache().put("reimconfig", JSON.toJSONString((Object)result));
        return result;
    }

    private void createBill(Long configId) {
        if (configId == null) {
            log.info("\u4e00\u952e\u62a5\u9500\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        String configCache = this.getPageCache().get("reimconfig");
        List quickConfigCache = JSONArray.parseArray((String)configCache, QuickConfigBo.class);
        List matchConfigBOs = quickConfigCache.stream().filter(bo -> bo.getId().equals(configId)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(matchConfigBOs)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u52a0\u8f7d\u5230\u62a5\u9500\u6d41\u7a0b\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"QuickReimburseListMob_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        QuickConfigBo quickConfigBo = (QuickConfigBo)matchConfigBOs.get(0);
        AbstractQuickReimburseService process = this.factory.getQuickReimburseService(quickConfigBo, this.getView());
        if (process == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u52a0\u8f7d\u5230\u62a5\u9500\u6d41\u7a0b\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"QuickReimburseListMob_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        process.setPlugin((AbstractBillPlugIn)this);
        process.create();
    }

    private void noDataVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEFAULT_FLEX_PANEL1});
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{DEFAULT_FLEX_PANEL});
    }

    private void nullCompanyVisible() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{DEFAULT_FLEX_PANEL1});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{DEFAULT_FLEX_PANEL});
    }

    @Deprecated
    private List<QuickConfigBo> buildConfigModel(DynamicObjectCollection quickReimConfig) {
        ArrayList<QuickConfigBo> list = new ArrayList<QuickConfigBo>();
        if (CollectionUtils.isEmpty((Collection)quickReimConfig)) {
            return list;
        }
        for (DynamicObject configDo : quickReimConfig) {
            QuickConfigBo bo = new QuickConfigBo();
            bo.setId(Long.valueOf(configDo.getLong("id")));
            bo.setName(configDo.getString("name"));
            bo.setMenuImg(configDo.getString("menuimg"));
            bo.setCreateOrg(Long.valueOf(configDo.getLong("createorg")));
            bo.setCreateTime(configDo.getDate("createtime"));
            bo.setInvoicePlugin(Long.valueOf(configDo.getLong("invoiceplugin")));
            list.add(bo);
        }
        return list;
    }

    private List<ControlAp> createApControls(List<QuickConfigBo> configs) {
        ArrayList<ControlAp> controlItems = new ArrayList<ControlAp>(configs.size());
        if (configs.size() <= 9) {
            for (QuickConfigBo config : configs) {
                MBlockMenuItemAp ap = new MBlockMenuItemAp();
                ap.setName(new LocaleString(config.getName()));
                ap.setKey(config.getId().toString());
                ap.setImageKey(config.getMenuImg());
                controlItems.add((ControlAp)ap);
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                QuickConfigBo config = configs.get(i);
                MBlockMenuItemAp ap = new MBlockMenuItemAp();
                ap.setName(new LocaleString(config.getName()));
                ap.setKey(config.getId().toString());
                ap.setImageKey(config.getMenuImg());
                controlItems.add((ControlAp)ap);
            }
            MBlockMenuItemAp ap = new MBlockMenuItemAp();
            ap.setName(new LocaleString(ResManager.loadKDString((String)"\u66f4\u591a", (String)"QuickReimburseListMob_7", (String)"fi-er-formplugin", (Object[])new Object[0])));
            ap.setKey("more");
            ap.setImageKey("/icons/pc/entrance/addicon_48_48.png");
            controlItems.add((ControlAp)ap);
        }
        return controlItems;
    }

    private void setApplierInfo(IDataModel model, Map paraMap) {
        DynamicObject applier = (DynamicObject)paraMap.get("applier");
        model.setValue("applier", applier == null ? null : applier.getPkValue());
        DynamicObject applierobj = (DynamicObject)model.getValue("applier");
        String applierStr = applierobj.getLocaleString("name").getLocaleValue();
        Label applierName = (Label)this.getControl("lb_name");
        applierName.setText(applierStr);
        String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applierobj.getPkValue()));
        Image imageap_photo = (Image)this.getControl("imageap_photo");
        imageap_photo.setUrl(applierPicUrl);
        model.setValue("applierpositionstr", paraMap.get("applierpositionstr"));
        model.setValue("tel", paraMap.get("tel"));
        if (applier != null) {
            this.getPageCache().put("consignorId", applier.getString("id"));
        }
    }

    private void initData() {
        Long currentUserID = Long.valueOf(RequestContext.get().getUserId());
        Map initData = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
        Long costCompanyId = (Long)initData.get("costcompany");
        if (costCompanyId == null || costCompanyId == 0L) {
            this.nullCompanyVisible();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u516c\u53f8\u65e0\u53ef\u7528\u8d39\u7528\u627f\u62c5\u516c\u53f8\uff0c\u8bf7\u5207\u6362\u516c\u53f8\u3002", (String)"QuickReimburseListMob_2", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("costcompany", (Object)costCompanyId);
        Long applierId = (Long)initData.get("applier");
        this.getModel().setValue("applier", (Object)applierId);
        Long companyId = (Long)initData.get("company");
        this.getModel().setValue("company", (Object)companyId);
        DynamicObject org = (DynamicObject)initData.get("org");
        this.getModel().setValue("org", (Object)org);
        DynamicObject applierObj = (DynamicObject)this.getModel().getValue("applier");
        String applierName = applierObj.getLocaleString("name").getLocaleValue();
        Label applierNameLb = (Label)this.getControl("lb_name");
        applierNameLb.setText(applierName);
        String applierPicUrl = ErCommonUtils.getUserImageFullPath((Long)((Long)applierObj.getPkValue()));
        Image imageLb = (Image)this.getControl("imageap_photo");
        imageLb.setUrl(applierPicUrl);
        this.getModel().setValue("applierpositionstr", initData.get("applierpositionstr"));
        this.getModel().setValue("tel", initData.get("tel"));
        if (companyId != null && costCompanyId != null) {
            Long baseCurrencyId = BaseCurrencyServiceHelper.getBaseCurrencyId((Object)companyId, (Object)costCompanyId);
            this.getModel().setValue("currency", (Object)baseCurrencyId);
        }
    }

    private void showBlockControls() {
        List<QuickConfigBo> quickReimConfig = this.loadCacheQuickReimConfig(true);
        List<ControlAp> apControls = this.createApControls(quickReimConfig);
        Container reimBlock = (Container)this.getControl(BLOCK_PANEL);
        List controlItems = apControls.stream().map(apControl -> apControl.createControl()).collect(Collectors.toList());
        reimBlock.addControls(controlItems);
        this.noDataVisible(CollectionUtils.isEmpty(quickReimConfig));
    }

    private void updateBlockControls() {
        Container reimBlock = (Container)this.getControl(BLOCK_PANEL);
        List<QuickConfigBo> quickReimConfig = this.loadCacheQuickReimConfig(false);
        String[] objects = (String[])quickReimConfig.stream().map(config -> config.getId().toString()).toArray(String[]::new);
        reimBlock.deleteControls(objects);
        reimBlock.deleteControls(new String[]{"more"});
        this.getPageCache().remove("reimconfig");
        this.showBlockControls();
        this.getView().updateView();
    }

    private Long getCompany() {
        Object company;
        Long companyId = null;
        IDataModel model = this.getModel();
        if (model != null && (company = (DynamicObject)model.getValue("company")) != null) {
            companyId = (Long)company.getPkValue();
        }
        if (companyId == null) {
            company = this.getView().getFormShowParameter().getCustomParam("company");
            if (company instanceof Integer) {
                companyId = ((Integer)company).longValue();
            } else if (company instanceof Long) {
                companyId = (Long)company;
            }
        }
        if (companyId == null) {
            Long currentUserID = Long.valueOf(RequestContext.get().getUserId());
            Map initData = CoreBaseBillServiceHelper.createNewData((Long)currentUserID);
            companyId = (Long)initData.get("company");
        }
        return companyId;
    }

    private Long getCurrentUserId() {
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        Long currentUserId = applier != null ? (Long)applier.getPkValue() : Long.valueOf(RequestContext.get().getUserId());
        return currentUserId;
    }
}

