/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.kingdee;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Html;
import kd.bos.form.control.IFrame;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.provider.param.req.EditInvoiceIframeReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.param.req.ShowInvoiceUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.IframeParam;
import kd.fi.er.business.invoicecloud.provider.service.InvoiceServiceForPC;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import org.apache.commons.lang3.StringUtils;

public abstract class InvoiceCloudPagePlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(InvoiceCloudPagePlugin.class);
    private static final String IFRAME_WEB_SOCKET = "iframewebsocket";
    protected final String STATE = "state";

    public void beforeBindData(EventObject e) {
        try {
            String actionType = this.getParam("actionType");
            if ("selectInvoice".equals(actionType)) {
                this.selectInvoice();
            } else if ("viewInvoice".equals(actionType)) {
                this.viewInvoiceList();
            } else if ("viewInvoiceList".equals(actionType)) {
                this.viewInvoiceList();
            } else if ("editInvoice".equals(actionType)) {
                this.editInvoice();
            } else if ("deleteattach".equals(actionType)) {
                this.deleteAttach();
            }
        }
        catch (Exception ex) {
            logger.error("\u52a0\u8f7d\u53d1\u7968\u4e91\u9875\u9762\u4e4b\u524d\u51fa\u73b0\u5f02\u5e38", (Throwable)ex);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("state", "1");
            m.put("msg", ResManager.loadKDString((String)"\u52a0\u8f7d\u53d1\u7968\u4e91\u9875\u9762\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceCloudPagePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent(m);
            this.getPageCache().put("state", "1");
            this.getView().close();
        }
    }

    private void editInvoice() {
        IframeParam iframeParam;
        String editParamStr = this.getParam("editInvoiceIframeReqParam");
        EditInvoiceIframeReqParam request = null;
        if (StringUtils.isNotBlank((CharSequence)editParamStr)) {
            logger.info("edit invoice param: " + editParamStr);
            request = (EditInvoiceIframeReqParam)JSON.parseObject((String)editParamStr, EditInvoiceIframeReqParam.class);
        } else {
            request = new EditInvoiceIframeReqParam();
            request.setSerialNo(this.getParam("serialNo"));
            request.setTaxRegNum(this.getParam("taxRegNum"));
            request.setTicketParam(KingdeeInvoiceCloudConfig.getTicketParam((String)request.getTaxRegNum()));
        }
        try {
            InvoiceServiceForPC invoiceServiceForPC = (InvoiceServiceForPC)InvoiceServiceFactory.getSingletonService(InvoiceServiceForPC.class);
            if (invoiceServiceForPC == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002");
                throw new Exception(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002", (String)"ImportInvoice_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            iframeParam = invoiceServiceForPC.getEditInvoiceIframeParam(request, this.getView());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        IFrame websocket = (IFrame)this.getControl(IFRAME_WEB_SOCKET);
        websocket.setSrc(iframeParam.getSocketUrl());
        this.showURL(iframeParam.getUrl());
    }

    private void viewInvoiceList() {
        IframeParam iframeParam;
        ShowInvoiceUrlReqParam request;
        String showInvoiceParamStr = this.getParam("showInvoiceUrlReqParam");
        if (StringUtils.isNotBlank((CharSequence)showInvoiceParamStr)) {
            request = (ShowInvoiceUrlReqParam)JSON.parseObject((String)showInvoiceParamStr, ShowInvoiceUrlReqParam.class);
        } else {
            request = new ShowInvoiceUrlReqParam();
            DynamicObject pDataEntity = this.getView().getParentView().getModel().getDataEntity();
            request.setBillId(APIHelper.getBillNoCachedInCloud((DynamicObject)pDataEntity));
            request.setBillNumber(pDataEntity.getString("billno"));
            request.setSerialNos(JSON.parseArray((String)this.getParam("serialNo"), String.class));
            request.setTaxRegNum(this.getParam("taxRegNum"));
        }
        try {
            InvoiceServiceForPC invoiceServiceForPC = (InvoiceServiceForPC)InvoiceServiceFactory.getSingletonService(InvoiceServiceForPC.class);
            if (invoiceServiceForPC == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002");
                throw new Exception(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002", (String)"ImportInvoice_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            iframeParam = invoiceServiceForPC.getShowInvoiceIframeParam(request, this.getView());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        boolean isGetMethod = iframeParam.isGetMethod();
        if (isGetMethod) {
            this.showURL(iframeParam.getUrl());
        } else {
            this.showURLByPost(iframeParam);
        }
    }

    private void showURL(String url) {
        logger.info("\u5c55\u793aURL: " + url);
        Html htmlap = (Html)this.getControl("htmlap");
        String htmlContent = "<iframe id='invoicepageframe' style='width:100%;border:0px;' src='" + url + "' ></iframe>";
        htmlap.setConent(htmlContent);
    }

    private void showURLByPost(IframeParam iframeParam) {
        Map params = iframeParam.getContent();
        logger.info("\u5c55\u793aURL: " + iframeParam.getUrl());
        logger.info("\u5c55\u793a\u7684\u53c2\u6570\uff1a " + iframeParam.getContent());
        Html htmlap = (Html)this.getControl("htmlap");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : params.entrySet()) {
            sb.append(String.format("<input type=\"text\" name=\"%s\" value=\"%s\" />\n", entry.getKey(), entry.getValue()));
        }
        String inputParams = sb.toString();
        String htmlContent = "<div style=\"display: flex; flex-direction: column; flex-grow:1\">\n      <form\nid=\"helperForm\"\ntarget=\"myFrame\"\naction=\"" + iframeParam.getUrl() + "\"\nstyle=\"display: none;\"\nmethod=\"POST\">\n" + inputParams + "<input type=\"submit\" />\n      </form>\n      <iframe\nid=\"invoicepageframe\"\nstyle=\"width:100%;flex-grow: 1\"\nname=\"myFrame\"\n      >\n      </iframe>\n    </div>";
        htmlap.setConent(htmlContent);
    }

    private void deleteAttach() {
        IframeParam iframeParam;
        ImportInvoiceIframeUrlReqParam request = new ImportInvoiceIframeUrlReqParam();
        String requestJson = this.getParam("importInvoiceIframeUrlReqParam");
        if (StringUtils.isNotBlank((CharSequence)requestJson)) {
            request = (ImportInvoiceIframeUrlReqParam)JSON.parseObject((String)requestJson, ImportInvoiceIframeUrlReqParam.class);
        } else {
            request.setBillId(this.getParam("bxd_key"));
            request.setTaxRegNum(this.getParam("taxRegNum"));
        }
        try {
            InvoiceServiceForPC invoiceServiceForPC = (InvoiceServiceForPC)InvoiceServiceFactory.getSingletonService(InvoiceServiceForPC.class);
            if (invoiceServiceForPC == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002");
                throw new Exception(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002", (String)"ImportInvoice_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            iframeParam = invoiceServiceForPC.getDeleteAttachIframeParam(request, this.getView());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        IFrame socketIFrame = (IFrame)this.getControl(IFRAME_WEB_SOCKET);
        socketIFrame.setSrc(iframeParam.getSocketUrl());
        boolean isGetMethod = iframeParam.isGetMethod();
        if (isGetMethod) {
            this.showURL(iframeParam.getUrl());
        } else {
            this.showURLByPost(iframeParam);
        }
    }

    private void selectInvoice() {
        IframeParam iframeParam;
        ImportInvoiceIframeUrlReqParam request = new ImportInvoiceIframeUrlReqParam();
        String requestJson = "";
        requestJson = this.getParam("importInvoiceIframeUrlReqParam");
        if (StringUtils.isNotBlank((CharSequence)requestJson)) {
            request = (ImportInvoiceIframeUrlReqParam)JSON.parseObject((String)requestJson, ImportInvoiceIframeUrlReqParam.class);
        } else {
            request.setBillId(this.getParam("bxd_key"));
            request.setTaxRegNum(this.getParam("taxRegNum"));
        }
        try {
            InvoiceServiceForPC invoiceServiceForPC = (InvoiceServiceForPC)InvoiceServiceFactory.getSingletonService(InvoiceServiceForPC.class);
            if (invoiceServiceForPC == null) {
                logger.info("\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002");
                throw new Exception(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u672a\u627e\u5230\u6784\u9020InvoiceServiceForPC\u7684\u670d\u52a1\u3002", (String)"ImportInvoice_14", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
            iframeParam = invoiceServiceForPC.getImportInvoiceIframeParam(request, this.getView());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            return;
        }
        IFrame socketIFrame = (IFrame)this.getControl(IFRAME_WEB_SOCKET);
        socketIFrame.setSrc(iframeParam.getSocketUrl());
        boolean isGetMethod = iframeParam.isGetMethod();
        if (isGetMethod) {
            this.showURL(iframeParam.getUrl());
        } else {
            this.showURLByPost(iframeParam);
        }
    }

    @Deprecated
    protected abstract String getUrlWebSocket(String var1, String var2, String var3, String var4, String var5);

    public static String genTimestamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String genRandom() {
        SecureRandom secRandom = new SecureRandom();
        return String.valueOf(secRandom.nextDouble());
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String msg = e.getEventArgs();
        logger.info("\u3010\u53d1\u7968\u4e91\u3011aws\u63a5\u6536\u524d\u7aef\u7684\u8c03\u7528" + msg);
        if ("invoicecloudmsg".equalsIgnoreCase(eventName) || StringUtils.equals((CharSequence)eventName, (CharSequence)"selectInvoice")) {
            this.handleInvoiceData(msg);
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"editInvoice")) {
            EditInvoiceReturnDataVO returnDataVO = (EditInvoiceReturnDataVO)JSON.parseObject((String)msg, EditInvoiceReturnDataVO.class);
            if (!returnDataVO.getSuccess().booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InvoiceCloudPagePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            } else {
                HashMap<String, String> returnMap = new HashMap<String, String>();
                returnMap.put("serialNo", returnDataVO.getSerialNo());
                returnMap.put("oldSerialNo", this.getParam("serialNo"));
                this.getView().returnDataToParent(returnMap);
                this.getView().close();
            }
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"deleteattach")) {
            this.getView().close();
        }
    }

    protected abstract void handleInvoiceData(String var1);

    protected String getParam(String key) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object object = customParams.get(key);
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected static class EditInvoiceReturnDataVO {
        private Boolean success;
        private JSONObject option;
        private String serialNo;

        protected EditInvoiceReturnDataVO() {
        }

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }

        public String getSerialNo() {
            return this.serialNo;
        }

        public void setSerialNo(String serialNo) {
            this.serialNo = serialNo;
        }

        public void setOption(JSONObject option) {
            this.option = option;
        }

        public JSONObject getOption() {
            return this.option;
        }
    }
}

