/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.mergerule;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.formplugin.invoicecloud.mergerule.CompareTypeEnum;
import kd.fi.er.formplugin.invoicecloud.mergerule.ShowUserDefineFilterCustomParaBO;
import kd.fi.er.formplugin.invoicecloud.mergerule.UserDefineFilterReturnBO;
import kd.fi.er.model.FormModel;
import org.apache.commons.lang3.StringUtils;

public class ManualMergeRulePlugin
extends AbstractFormPlugin {
    private static final String costumerRuleDefineId = "userdefineruledisplay";
    private static final String billType = "billtype";
    private static final String fieldMetaEntityId = "er_manualrulefield";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{costumerRuleDefineId});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object billtype = this.getModel().getValue(billType);
        if (billtype != null && !billtype.toString().isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{costumerRuleDefineId});
        }
    }

    public void click(EventObject evt) {
        TextEdit userDefine;
        String key;
        Object source = evt.getSource();
        if (source instanceof TextEdit && StringUtils.equals((CharSequence)(key = (userDefine = (TextEdit)source).getKey()), (CharSequence)costumerRuleDefineId)) {
            ArrayList<String> fields = new ArrayList<String>(MetadataServiceHelper.getDataEntityType((String)fieldMetaEntityId).getAllFields().keySet());
            HashMap<String, String> customParam = new HashMap<String, String>();
            ShowUserDefineFilterCustomParaBO param = new ShowUserDefineFilterCustomParaBO();
            param.setEntityName(fieldMetaEntityId);
            param.setFilterValue((String)this.getModel().getValue("userdefinerule"));
            param.setFields(fields);
            customParam.put("showUserDefineFilterCustomParaBO", JSON.toJSONString((Object)param));
            FormModel formModel = new FormModel("er_userdefinerule", "", "14", true, customParam);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "showUserDefineRule");
            ShowPageUtils.showPage((FormModel)formModel, (AbstractFormPlugin)this, (CloseCallBack)callBack);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"showUserDefineRule") && (returnData = closedCallBackEvent.getReturnData()) != null) {
            UserDefineFilterReturnBO returnBO = (UserDefineFilterReturnBO)JSON.parseObject((String)returnData.toString(), UserDefineFilterReturnBO.class);
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)returnBO.getFilterConJson(), FilterCondition.class);
            String js = this.translateFilterToJs(filterCondition);
            this.getModel().setValue("js", (Object)js);
            if (filterCondition.getFilterRow().isEmpty() || StringUtils.isBlank((CharSequence)js)) {
                this.getModel().setValue(costumerRuleDefineId, (Object)"");
                this.getModel().setValue("userdefinerule", (Object)"");
            } else {
                this.getModel().setValue(costumerRuleDefineId, (Object)returnBO.getDesc());
                this.getModel().setValue("userdefinerule", (Object)returnBO.getFilterConJson());
            }
        }
    }

    private String translateFilterToJs(FilterCondition filterCondition) {
        StringBuilder jsExpressSb = new StringBuilder();
        List filterRows = filterCondition.getFilterRow();
        for (SimpleFilterRow filterRow : filterRows) {
            String compareType = filterRow.getCompareType();
            if (CompareTypeEnum.isNotSupportType(compareType)) {
                jsExpressSb.setLength(0);
                break;
            }
            if (!CompareTypeEnum.containById(compareType)) continue;
            String varName = filterRow.getFieldName();
            String value = "";
            List values = filterRow.getValue();
            value = values.size() == 1 ? "'" + ((FilterValue)values.get(0)).getValue().toString() + "'" : values.stream().map(val -> "'" + val.getValue().toString() + "'").collect(Collectors.joining(","));
            CompareTypeEnum compare = CompareTypeEnum.of(compareType);
            String js = compare.getJs(varName, value);
            String logic = filterRow.getLogic();
            String logicSymbol = logic.equals("1") ? "||" : "&& ";
            jsExpressSb.append(filterRow.getLeftBracket());
            jsExpressSb.append(js);
            jsExpressSb.append(filterRow.getRightBracket());
            jsExpressSb.append(" ");
            jsExpressSb.append(logicSymbol);
        }
        String jsExpress = "";
        if (jsExpressSb.length() > 0) {
            jsExpress = jsExpressSb.substring(0, jsExpressSb.length() - 3);
        }
        return jsExpress;
    }
}

