/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Vector;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.cache.ErCloudFrameworkCache;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.cache.model.ErCacheUtils;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.QueryInvoiceDetailBO;
import kd.fi.er.business.invoicecloud.provider.param.DataModelProxy;
import kd.fi.er.business.invoicecloud.provider.param.FormViewProxy;
import kd.fi.er.business.invoicecloud.provider.param.req.ImportInvoiceIframeUrlReqParam;
import kd.fi.er.business.invoicecloud.provider.service.IAfterProcessExtService;
import kd.fi.er.business.invoicecloud.provider.service.factory.InvoiceServiceFactory;
import kd.fi.er.business.invoicecloud.util.InvoicePackageUtil;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.IWebJsonParseService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceCloudDeserializeServicePC;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DoNothingImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveDuplicateInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.servicehelper.InvoiceServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.ShowPageUtils;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.InvoiceConfig;
import kd.fi.er.common.model.invoice.InvoiceProcessMessage;
import kd.fi.er.common.model.invoice.InvoiceProcessResult;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.common.utils.ThrowableHelper;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimByItemEntry;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceNonautoPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.IInvoiceCloudWebParse;
import kd.fi.er.formplugin.invoicecloud.v2.InvoiceAttachmentRemoveListener;
import kd.fi.er.formplugin.invoicecloud.v2.SynInvoiceViewProxy;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoiceMobClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoicePcClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.service.InvoiceFormPluginService;
import kd.fi.er.formplugin.invoicecloud.v2.service.InvoicePluginServiceFactory;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import kd.fi.er.formplugin.invoicecloud.v2.validator.InvoiceCurrencyValidator;
import kd.fi.er.formplugin.invoicecloud.v2.validator.InvoiceTypeValidator;
import kd.fi.er.formplugin.invoicecloud.v2.validator.InvoiceValidator;
import kd.sdk.fi.er.extpoint.invoicecloud.AfterSelectInvoice;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoicePlugin
extends AbstractBillPlugIn
implements IInvoiceCloudWebParse,
HyperLinkClickListener,
PagerClickListener {
    private static final Log log = LogFactory.getLog(AbstractImportInvoicePlugin.class);
    protected static final String CLICK_KEY = "clickKey";
    protected static final String IMPORT_INVOICE_IN_MOB = "IMPORT_INVOICE_IN_MOB";
    public static final String LAB_DELETE_INVOICE = "lab_delete_invoice";
    public static final String LAB_DONE_INVOICE = "lab_done_invoice";
    public static final String DELINVOICEHEADENTRY = "delinvoiceheadentry";
    private static final String DELETE_ENTRY_CALLBACK = "beforedeleteentry";
    private static final String IS_DELETING_INVOICE = "is_deleting_invoice";
    public static final String FLEX_AROW111 = "flex_arow111";
    public static final String VECTORAP111 = "vectorap111";
    public static final String SHOW_INVOICE_ENTRY = "show_invoice_entry";
    protected boolean isNewPlugin = false;
    protected PluginProxy<AfterSelectInvoice> afterSelectInvoicePluginProxy = PluginProxy.create(null, AfterSelectInvoice.class, (String)"FI_ER_INVOICE_AFTERSELECTINVOICE", null);
    private List<IInvoiceService> processServices = new ArrayList<IInvoiceService>();
    private List<InvoiceValidator> invoiceValidators = new ArrayList<InvoiceValidator>();
    private Map isqueryInvoiceMap = null;

    public void registerListener(EventObject e) {
        EntryGrid entryGrid;
        super.registerListener(e);
        Map<String, Object> panelMap = InvoicePluginUtils.getAttachmentPanel(this);
        InvoiceAttachmentRemoveListener.register((AttachmentPanel)panelMap.get("panel"), (IDataModel)panelMap.get("model"));
        this.addClickListeners(new String[]{LAB_DELETE_INVOICE, LAB_DONE_INVOICE, DELINVOICEHEADENTRY, FLEX_AROW111, VECTORAP111, "lbl_invoicecount", "invoiceno", "vectorapinvoice"});
        if (this.getControl("invoiceentry") instanceof CardEntry && null != (entryGrid = (EntryGrid)this.getView().getControl("invoiceentry"))) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            entryGrid.addPagerClickListener((PagerClickListener)this);
        }
        if (this.getControl("tbmain") != null) {
            this.addItemClickListeners(new String[]{"tbmain"});
        }
        if (this.getControl("invoiceentry") != null) {
            ((EntryGrid)this.getControl("invoiceentry")).addHyperClickListener((HyperLinkClickListener)this);
        }
        if (this.getControl("advcontoolbarap22") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap22"});
        }
        if (this.getControl("advcontoolbarap31") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap31"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sign = this.getPageCache().get("PACKAGE_IMPORT");
        if (StringUtils.isEmpty((CharSequence)sign)) {
            InvoicePackageUtil.setPackageSign((AbstractFormPlugin)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.invoiceDeletePageRule(this.isDeleting());
        this.updateInvoiceCloudEnable();
        InvoicePluginUtils.importInvoiceForQuickReim(this);
    }

    protected void updateInvoiceCloudEnable() {
        DynamicObject newCostCompanyDO = this.getCostCompanyDO();
        String billStatus = (String)this.getModel().getValue("billstatus");
        billStatus = (String)StringUtils.defaultIfBlank((CharSequence)billStatus, (CharSequence)"A");
        List<String> allowEditStatusList = Arrays.asList("A", "D");
        if (newCostCompanyDO != null) {
            boolean invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)newCostCompanyDO.getPkValue()));
            this.setInvoiceCloudEnable(invoiceIsEnabled);
            if (allowEditStatusList.contains(billStatus)) {
                if (invoiceIsEnabled) {
                    this.processWhenInvoiceIsEnable();
                } else {
                    this.processWhenInvoiceIsDisable();
                }
            }
        }
    }

    protected void setInvoiceCloudEnable(boolean isEnable) {
        String key = this.invoiceCloudEnableKey();
        if (this.getModel().getDataEntityType().getProperty(key) != null) {
            this.getModel().setValue(key, (Object)isEnable);
        }
        this.getModel().setDataChanged(false);
    }

    protected String invoiceCloudEnableKey() {
        String entityId = this.getView().getEntityId();
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId) || StringUtils.equals((CharSequence)entityId, (CharSequence)"er_tripreimexpenseitem_m")) {
            return "invoicecloudenable";
        }
        return "isenableinvoice";
    }

    protected void processWhenInvoiceIsEnable() {
    }

    protected void processWhenInvoiceIsDisable() {
    }

    public void invoiceDeletePageRule(boolean delete) {
        log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807\u663e\u793a\u4e0e\u5426:{}", (Object)delete);
        boolean flag = this.getModel().getDataEntity(true).getDataEntityType().getProperties().containsKey((Object)"invoiceentry");
        if (!flag) {
            return;
        }
        if (delete) {
            this.getView().setVisible(Boolean.TRUE, new String[]{LAB_DONE_INVOICE});
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_DELETE_INVOICE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_DONE_INVOICE});
            this.getView().setVisible(Boolean.TRUE, new String[]{LAB_DELETE_INVOICE});
        }
        if ((ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId()) || ErEntityTypeUtils.isPublicReimburseBill((String)this.getView().getEntityId())) && this.getModel().getEntryRowCount("withholdingentry") > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_DONE_INVOICE});
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_DELETE_INVOICE});
            delete = false;
        }
        this.changeDeleteInvoiceStatus(delete);
        int invoiceEntrySize = this.getModel().getEntryRowCount("invoiceentry");
        log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807 invoiceEntrySize {}", (Object)invoiceEntrySize);
        if (0 == invoiceEntrySize) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_DELETE_INVOICE});
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_DONE_INVOICE});
        }
        if (this.getControl("invoiceentry") instanceof CardEntry) {
            CardEntry invoiceCard = (CardEntry)this.getControl("invoiceentry");
            log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807 invoiceCard {}", (Object)invoiceCard);
            if (null != invoiceCard) {
                for (int rowIndex = 0; rowIndex < invoiceEntrySize; ++rowIndex) {
                    invoiceCard.setChildVisible(delete, rowIndex, new String[]{DELINVOICEHEADENTRY});
                }
                Vector vector = (Vector)this.getView().getControl(VECTORAP111);
                log.info("\u63a7\u5236\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u7684\u5220\u9664\u56fe\u6807 SHOW_INVOICE_ENTRY {}", (Object)this.getPageCache().get(SHOW_INVOICE_ENTRY));
                if (null != this.getPageCache().get(SHOW_INVOICE_ENTRY)) {
                    vector.setFontClass("kdfont kdfont-zhankai4");
                } else {
                    vector.setFontClass("kdfont kdfont-shouqi7");
                }
                this.getView().setVisible(Boolean.valueOf(null != this.getPageCache().get(SHOW_INVOICE_ENTRY)), new String[]{"invoiceentry"});
            }
        }
    }

    private void changeDeleteInvoiceStatus(boolean status) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put(IS_DELETING_INVOICE, String.valueOf(status));
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        ConfirmTransferBO transfer;
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((CharSequence)callBackId, (CharSequence)DELETE_ENTRY_CALLBACK) && event.getResult() == MessageBoxResult.Yes && (transfer = (ConfirmTransferBO)ErCacheUtils.getValueFromPageCache((IPageCache)this.getPageCache(), (String)DELETE_ENTRY_CALLBACK, ConfirmTransferBO.class)) != null && transfer.getDeleteIds() != null) {
            transfer.setOK(true);
            ErCacheUtils.removeInPage((IPageCache)this.getPageCache(), (String)DELETE_ENTRY_CALLBACK);
            this.getModel().deleteEntryRows(transfer.getEntryName(), transfer.getDeleteIds().stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public boolean isDeleting() {
        IPageCache pageCache = this.getPageCache();
        String status = pageCache.get(IS_DELETING_INVOICE);
        return Boolean.parseBoolean(status);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            String key = ctl.getKey();
            Vector vector = (Vector)this.getView().getControl(VECTORAP111);
            switch (key) {
                case "lab_delete_invoice": {
                    this.invoiceDeletePageRule(true);
                    vector.setFontClass("kdfont kdfont-zhankai4");
                    this.getPageCache().put(SHOW_INVOICE_ENTRY, "false");
                    this.getView().setVisible(Boolean.TRUE, new String[]{"invoiceentry"});
                    break;
                }
                case "lab_done_invoice": {
                    this.invoiceDeletePageRule(false);
                    break;
                }
                case "lbl_invoicecount": {
                    List serialNos = InvoiceServiceHelper.getAllSerialNos((IDataModel)this.getModel());
                    ShowInvoiceCloudPageUtil.showAllInvoiceList((AbstractFormPlugin)this, KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO())), serialNos);
                    break;
                }
                case "vectorapinvoice": {
                    EntryGrid entryGrid = (EntryGrid)this.getView().getControl("invoiceentry");
                    int[] rowIndexs = entryGrid.getSelectRows();
                    ArrayList<String> serialNos = new ArrayList<String>();
                    if (rowIndexs == null || rowIndexs.length <= 0) break;
                    for (int rowIndex : rowIndexs) {
                        String serialNo = (String)this.getModel().getValue("serialno", rowIndex);
                        serialNos.add(serialNo);
                    }
                    ShowInvoiceCloudPageUtil.showAllInvoiceList((AbstractFormPlugin)this, KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO())), serialNos);
                }
            }
        }
    }

    public void setVector(IFormView view) {
        Vector vector = (Vector)this.getView().getControl(VECTORAP111);
        if (vector == null) {
            return;
        }
        if (null == this.getPageCache().get(SHOW_INVOICE_ENTRY)) {
            vector.setFontClass("kdfont kdfont-zhankai4");
            this.getPageCache().put(SHOW_INVOICE_ENTRY, "false");
        } else {
            vector.setFontClass("kdfont kdfont-shouqi7");
            this.getPageCache().remove(SHOW_INVOICE_ENTRY);
        }
        view.setVisible(Boolean.valueOf(null != this.getPageCache().get(SHOW_INVOICE_ENTRY)), new String[]{"invoiceentry"});
    }

    public void hyperLinkClick(HyperLinkClickEvent hlcEvent) {
        if (!this.isPc()) {
            String fieldName = hlcEvent.getFieldName();
            int rowIndex = hlcEvent.getRowIndex();
            if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"invoiceno")) {
                String serialNo = (String)this.getModel().getValue("serialno", rowIndex);
                HashSet serialNos = Sets.newHashSet((Object[])new String[]{serialNo});
                ShowInvoiceCloudPageUtil.showAllInvoiceList((AbstractFormPlugin)this, KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO())), serialNos);
            }
        }
    }

    protected String getCloseCallBackKey() {
        return "";
    }

    protected String getAnotherCloseCallBackKey() {
        return "";
    }

    protected boolean checkCacheClickKey(String clickKey) {
        String cacheClickKey = this.getPageCache().get(CLICK_KEY);
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cacheClickKey}) && StringUtils.equals((CharSequence)cacheClickKey, (CharSequence)clickKey) && StringUtils.equals((CharSequence)this.getAnotherCloseCallBackKey(), (CharSequence)clickKey);
    }

    @Override
    public IWebJsonParseService getWebParaParse() {
        return new InvoiceCloudDeserializeServicePC();
    }

    public void showInvoiceList(List<String> serialNos) {
    }

    public boolean isPc() {
        if (this instanceof InvoicePcClientInterface) {
            return true;
        }
        if (this instanceof InvoiceMobClientInterface) {
            return false;
        }
        return false;
    }

    protected void showDeleteAttachPage() {
        ImportInvoiceIframeUrlReqParam importRequestParam = new ImportInvoiceIframeUrlReqParam();
        importRequestParam.setBillId(APIHelper.getBillNoCachedInCloud((DynamicObject)this.getView().getModel().getDataEntity()));
        importRequestParam.setTaxRegNum(this.getTaxRegNum());
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        importRequestParam.setInvoiceCompanyId((Long)costCompanyDO.getPkValue());
        if (this.isPc()) {
            ShowInvoiceCloudPageUtil.showDeleteAttachPageInPC((AbstractFormPlugin)this, this.getModel(), new CloseCallBack((IFormPlugin)this, "delete_attach_callback_key"), importRequestParam);
        } else {
            ShowInvoiceCloudPageUtil.showDeleteAttachPageInMob((AbstractFormPlugin)this, this.getModel(), new CloseCallBack((IFormPlugin)this, "delete_attach_callback_key"), importRequestParam);
        }
    }

    protected void showSelectedInvoicePage(IFormView view, String key) {
        this.setClickKey(key);
        this.showSelectedInvoicePage("", view);
    }

    protected void showSelectedInvoicePage(String serialNo, IFormView view, String key) {
        this.setClickKey(key);
        this.showSelectedInvoicePage(serialNo, view);
    }

    protected void showSelectedInvoicePage(String serialNo, IFormView view) {
        this.showSelectedInvoicePage(serialNo, "0", view);
    }

    protected void showSelectedInvoicePage(String serialNo, String optMode, IFormView view) {
        String callBackKey;
        log.info(String.format("showSelectedInvoicePage method input parameter serialNo is : %s", serialNo));
        DynamicObject costCompany = this.getCostCompanyDO();
        if (costCompany == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8d39\u7528\u627f\u62c5\u516c\u53f8\u3002", (String)"AbstractImportInvoicePlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)((Long)costCompany.getPkValue()));
        if (config == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u672a\u542f\u7528\u53d1\u7968\u4e91\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AbstractImportInvoicePlugin_8", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String firmName = config.getFirmname();
        if (StringUtils.isBlank((CharSequence)firmName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u4f01\u4e1a\u5de5\u5546\u767b\u8bb0\u540d\u79f0\u672a\u586b\u5199\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u540e\u518d\u4f7f\u7528\u53d1\u7968\u5bfc\u5165\u529f\u80fd\u3002", (String)"AbstractImportInvoicePlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ImportInvoiceIframeUrlReqParam importRequestParam = new ImportInvoiceIframeUrlReqParam();
        importRequestParam.setBillId(APIHelper.getBillNoCachedInCloud((DynamicObject)view.getModel().getDataEntity()));
        importRequestParam.setTaxRegNum(config.getTaxRegnum());
        importRequestParam.setInvoiceCompanyId((Long)this.getCostCompanyDO().getPkValue());
        importRequestParam.setEntityName(view.getEntityId());
        importRequestParam.setSerialNo(serialNo);
        if (StringUtils.isNotBlank((CharSequence)optMode)) {
            importRequestParam.setOptMode(optMode);
        }
        if (!this.checkCacheClickKey(callBackKey = this.getAnotherCloseCallBackKey())) {
            callBackKey = this.getCloseCallBackKey();
        }
        ShowInvoiceCloudPageUtil.showImportInvoicePageInPC((AbstractFormPlugin)this, view.getModel(), new CloseCallBack((IFormPlugin)this, callBackKey), importRequestParam);
    }

    protected void openInvoiceCloudDel(String billId, String entityId, IFormView view) {
        this.showDeleteAttachPage();
    }

    protected void openInvoiceCloudQuery(String billId, String entityId, IFormView view) {
        this.showDeleteAttachPage();
    }

    protected void buildInvoiceConfig(InvoiceContext invoiceContext) {
        InvoiceConfig invoiceConfig = invoiceContext.getInvoiceConfig();
        invoiceConfig.setOrgOffset(this.isOrgOffset());
        invoiceConfig.setImportNonDeductionTaxAmout(this.isNonOffsetImportTaxAmout());
        invoiceConfig.setInvoicesCredits(ErStdConfig.getInvoicesCredits());
        invoiceConfig.setExpenseDateValue(ErStdConfig.getExpenseDateValue());
        invoiceConfig.setUseExpenseDate(this.isUseExpenseDate());
        invoiceConfig.setInvoiceCurrencyId(Long.valueOf(this.getInvoiceCurrency()));
        invoiceConfig.setMustRelateExpenseItem(ErStdConfig.getInvoiceMustWithExpense());
        invoiceConfig.setPreciseMatch(ErStdConfig.getInvoiceAutoMappingItem());
        invoiceConfig.setOutLog(ErStdConfig.getImportInvoiceOutLog());
    }

    public abstract void processInvoiceVO(InvoiceContext var1) throws InvoiceCloudException;

    @Deprecated
    public void processInvoiceVO(List<InvoiceVO> invoiceVOs) throws InvoiceCloudException {
        InvoiceContext invoiceContext = new InvoiceContext();
        this.buildInvoiceConfig(invoiceContext);
        invoiceContext.setInvoiceVOs(invoiceVOs);
        this.processInvoiceVO(invoiceContext);
    }

    private void registerInvoiceValidators() {
        this.invoiceValidators.add(new InvoiceCurrencyValidator());
        this.invoiceValidators.add(new InvoiceTypeValidator());
        List<InvoiceValidator> otherInvoiceValidators = this.addInvoiceValidators();
        if (otherInvoiceValidators != null && !otherInvoiceValidators.isEmpty()) {
            this.invoiceValidators.addAll(otherInvoiceValidators);
        }
    }

    private void executeInvoiceValidators(InvoiceContext context) {
        DataModelProxy proxy = new DataModelProxy(this.getModel());
        FormViewProxy proxyView = new FormViewProxy(this.getView());
        for (InvoiceValidator invoiceValidator : this.invoiceValidators) {
            invoiceValidator.validator(proxyView, proxy, context);
        }
    }

    private final boolean validateInvoiceInfo(InvoiceContext invoiceContext) {
        Map invoiceResult = invoiceContext.getInvoiceResult();
        for (Map.Entry entry : invoiceResult.entrySet()) {
            InvoiceProcessResult result = (InvoiceProcessResult)entry.getValue();
            List processResult = result.getProcessResult();
            for (InvoiceProcessMessage processMessage : processResult) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)"error", (CharSequence)processMessage.getLevel())) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u4e1a\u52a1\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\uff1a%1$s", (String)"AbstractImportInvoicePlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]), processMessage.getMessage()));
                return false;
            }
        }
        return true;
    }

    protected final void addProcessServices(IInvoiceService ... services) {
        for (IInvoiceService service : services) {
            this.processServices.add(service);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void process() {
        try {
            String serviceSeqStr = this.processServices.stream().map(service -> "\u3010" + service.getClass().getSimpleName() + "\u3011").collect(Collectors.joining(" -->> "));
            log.info("\u3010\u53d1\u7968\u6d41\u7a0b\u3011" + this.getClass().getSimpleName() + "\u53d1\u7968\u6d41\u7a0b\u6267\u884c\u987a\u5e8f:" + serviceSeqStr);
            if (CollectionUtils.isEmpty(this.processServices)) return;
            int allSize = this.processServices.size();
            int index = 1;
            for (IInvoiceService processService : this.processServices) {
                String serviceName = processService.getClass().getSimpleName();
                if (processService == null) continue;
                try {
                    log.info("\u3010\u5bfc\u5165\u53d1\u7968\u3011\u5f00\u59cb\u6267\u884c\uff1a " + serviceName + " ......");
                    long startTime = System.currentTimeMillis();
                    processService.process();
                    if (this.getView().getPageCache().get("isSyn") != null) {
                        String percent = String.valueOf(((float)index - 1.0f) / (float)allSize * 100.0f).replaceAll("\\.[0-9]*", "");
                        ErCloudFrameworkCache.putValueByPageId((String)this.getView().getPageId(), (String)"task_percent", (String)percent);
                    }
                    ++index;
                    long endTime = System.currentTimeMillis();
                    long actionTime = (endTime - startTime) / 1000L;
                    log.info("\u3010\u5bfc\u5165\u53d1\u7968\u3011 " + serviceName + " \u6267\u884c\u7ed3\u675f\uff0c\u5171\u8017\u65f6\uff1a" + actionTime + "s");
                }
                catch (Exception e) {
                    throw e;
                    return;
                }
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u3010\u53d1\u7968\u5bfc\u5165\u3011\u5f02\u5e38\uff1a", (String)"AbstractImportInvoicePlugin_0", (String)"fi-er-business", (Object[])new Object[0]);
            log.error(msg, (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("0", msg + e.getMessage()), new Object[0]);
        }
    }

    public final void executeProcess(List<InvoiceVO> queryInvoiceDetail) {
        try {
            InvoiceContext invoiceContext = new InvoiceContext();
            this.buildInvoiceConfig(invoiceContext);
            invoiceContext.setInvoiceVOs(queryInvoiceDetail);
            if (AbstractImportInvoiceNonautoPlugin.class.isAssignableFrom(this.getClass())) {
                invoiceContext.setSelectItem(((AbstractImportInvoiceNonautoPlugin)this).getSelectedItems());
            } else if (AbstractImportInvoiceForReimByItemEntry.class.isAssignableFrom(this.getClass())) {
                DynamicObject selectedItem = ((AbstractImportInvoiceForReimByItemEntry)this).getSelectedItem();
                invoiceContext.setSelectItem(Collections.singletonList(selectedItem));
            }
            invoiceContext.setCurrentPageInvoiceSerialNos(this.getCurrentPageInvoiceSerialNos());
            invoiceContext.setView(this.getView());
            invoiceContext.setExtView(this.getExtView());
            invoiceContext.setImportInvoiceClass(this.getClass());
            this.registerInvoiceValidators();
            this.executeInvoiceValidators(invoiceContext);
            if (!this.validateInvoiceInfo(invoiceContext)) {
                return;
            }
            this.processInvoiceVO(invoiceContext);
            long startProcessTime = System.currentTimeMillis();
            this.process();
            long endProcessTime = System.currentTimeMillis();
            log.info(String.format("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u6267\u884c\u5bfc\u5165\u5171\u8017\u65f6\uff1a%s s", (endProcessTime - startProcessTime) / 1000L));
            if (CollectionUtils.isNotEmpty((Collection)invoiceContext.getInvoiceEntryBOs())) {
                long startUpdateDataTime = System.currentTimeMillis();
                this.loadAfterProcessUpdateData(invoiceContext);
                long endUpdateDataTime = System.currentTimeMillis();
                log.info(String.format("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u5237\u65b0\u6570\u636e\u5171\u8017\u65f6\uff1a%s s", (endUpdateDataTime - startUpdateDataTime) / 1000L));
                this.loadAfterProcessUpdateView();
                ErCloudFrameworkCache.putValueByPageId((String)super.getView().getPageId(), (String)"isProxyView", (String)"true");
                this.loadAfterProcessExtServiceI(invoiceContext);
                ErCloudFrameworkCache.removeCache((String)super.getView().getPageId(), (String)"isProxyView");
            }
            this.getView().getPageCache().remove("invoice.ClickKey");
        }
        catch (InvoiceCloudException e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u5bfc\u5165\u3011\u5f02\u5e38\uff1a", (String)"AbstractImportInvoicePlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
            log.error("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public PreHandleInvoiceService getPreHandleInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new PreHandleInvoiceServiceImpl(invoiceContext);
    }

    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DoNothingImpl(invoiceContext);
    }

    public RemoveInvoiceService getRemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new RemoveDuplicateInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    public MergeInvoiceService getMergeInvoiceService(InvoiceContext invoiceContext) {
        return new MergeInvoiceServiceImpl(invoiceContext, this.getView().getEntityId(), this.getModel());
    }

    public IInvoiceService getBeforeCreateItemServiceImpl(InvoiceContext invoiceContext) {
        return new DoNothingImpl(invoiceContext);
    }

    public CreateInvoiceServiceI getCreateInvoiceService(InvoiceContext invoiceContext) {
        return new CreateInvoiceEntryServiceImpl(invoiceContext, this.getModel());
    }

    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new DoNothingImpl(invoiceContext);
    }

    public IInvoiceService getAfterCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new DoNothingImpl(invoiceContext);
    }

    public IInvoiceService getMappingItemImpl(InvoiceContext invoiceContext) {
        return new MappingItemWithOrgInvoiceServiceImp(invoiceContext, this.getBillType(), this.getModel().getDataEntity(true));
    }

    protected Set<String> getCurrentPageInvoiceSerialNos() {
        if (this.getExtView().getModel().getProperty("invoiceentry") != null) {
            return this.getExtView().getModel().getEntryEntity("invoiceentry").stream().map(invoiceEntryDO -> invoiceEntryDO.getString("serialno")).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public abstract MappingItemWithOrgInvoiceServiceImp.BillType getBillType();

    public String getTaxRegNum() {
        return "";
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (this.progressCloseCallBack(closedCallBackEvent.getActionId())) {
            return;
        }
        if (!this.isPc()) {
            return;
        }
        Object returnData = closedCallBackEvent.getReturnData();
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91PC\u524d\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + JSON.toJSONString((Object)returnData));
        String billNo = "";
        IDataEntityProperty billNoProp = this.getModel().getProperty("billno");
        if (billNoProp != null) {
            billNo = (String)this.getModel().getValue("billno");
        }
        InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)billNo, (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91PC\u524d\u7aef\u8fd4\u56de", (String)"ImportInvoice_0", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91PC\u524d\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_1", (String)"fi-er-formplugin", (Object[])new Object[0]), JSON.toJSONString((Object)returnData)));
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(closedCallBackEvent));
        if (returnData == null) {
            return;
        }
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"delete_attach_callback_key")) {
            return;
        }
        InvoiceFormPluginService invoiceFormPluginService = InvoicePluginServiceFactory.getInstance();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"selectBillingPool")) {
            invoiceFormPluginService = InvoicePluginServiceFactory.getXhInvoiceService();
        }
        log.info("actionId:" + actionId + ",getCloseCallBackKey:" + this.getCloseCallBackKey() + ",checkCacheClickKey:" + this.checkCacheClickKey(actionId));
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)this.getCloseCallBackKey()) || this.checkCacheClickKey(actionId)) {
            try {
                this.afterImportInvoicePCandMob(invoiceFormPluginService, closedCallBackEvent, null);
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.getView().showErrorNotification(e.getMessage());
            }
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)"editinvoice")) {
            invoiceFormPluginService.afterEditInvoicePC(this, new InvoiceEvent<ClosedCallBackEvent>(closedCallBackEvent));
        }
        log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u53d1\u7968\u5bfc\u5165\u5904\u7406\u5b8c\u6210\u540e\uff0c\u4e8c\u5f00\u6267\u884c\u540e\u7eed\u64cd\u4f5c\u3002");
        IFormView view = this.getExtView();
        this.afterSelectInvoicePluginProxy.callReplace(p -> {
            p.finish(view);
            return null;
        });
        log.info("\u3010\u53d1\u7968\u5bfc\u5165\u3011\u53d1\u7968\u5bfc\u5165\u5904\u7406\u5b8c\u6210\u540e\uff0c\u4e8c\u5f00\u6267\u884c\u540e\u7eed\u64cd\u4f5c\u7ed3\u675f\u3002");
    }

    protected void afterImportInvoicePCandMob(final InvoiceFormPluginService invoiceFormPluginService, final ClosedCallBackEvent closedCallBackEvent, final CustomEventArgs e) throws Exception {
        IDataEntityProperty automapinvoiceProp = this.getModel().getProperty("automapinvoice");
        final IFormView view = this.getView();
        boolean isAutoMapInvoice = false;
        if (automapinvoiceProp != null) {
            isAutoMapInvoice = (Boolean)this.getModel().getValue("automapinvoice");
        }
        if (!isAutoMapInvoice) {
            if (this.isPc()) {
                invoiceFormPluginService.afterImportInvoicePC(this, new InvoiceEvent<ClosedCallBackEvent>(closedCallBackEvent));
            } else {
                invoiceFormPluginService.afterImportInvoiceMob(this, new InvoiceEvent<CustomEventArgs>(e));
            }
            return;
        }
        boolean isHeadImport = StringUtils.equals((CharSequence)this.getClickKey(), (CharSequence)"selectinvoice");
        boolean isEnableSyn = this.isEnableSynAfterImport(closedCallBackEvent, e);
        log.info("getClickKey\uff1a" + this.getClickKey() + " isEnableSynAfterImport:" + isEnableSyn);
        if ((this.isPc() && isHeadImport || !this.isPc()) && isEnableSyn) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("formId", "er_progressbar");
            paramMap.put("showType", ShowType.Modal);
            paramMap.put("needCallBack", Boolean.TRUE);
            ShowPageUtils.showWebForm(paramMap, (AbstractFormPlugin)this);
            this.getView().getPageCache().put("isSyn", "true");
            ThreadService.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractImportInvoicePlugin.this.afterImportInvoice(invoiceFormPluginService, closedCallBackEvent, e);
                        view.getActionResult();
                    }
                    catch (Exception e2) {
                        String error = ErCloudFrameworkCache.getValueByPageId((String)view.getPageId(), (String)"task_error");
                        if (error == null || error.isEmpty()) {
                            ErCloudFrameworkCache.putValueByPageId((String)view.getPageId(), (String)"task_error", (String)e2.getMessage());
                        }
                    }
                    finally {
                        ErCloudFrameworkCache.putValueByPageId((String)view.getPageId(), (String)"task_percent", (String)"100");
                    }
                }
            }, (TaskType)TaskType.ER_WORK_TASK, (RequestContext)RequestContext.get());
        } else if (this.isPc()) {
            invoiceFormPluginService.afterImportInvoicePC(this, new InvoiceEvent<ClosedCallBackEvent>(closedCallBackEvent));
        } else {
            invoiceFormPluginService.afterImportInvoiceMob(this, new InvoiceEvent<CustomEventArgs>(e));
        }
    }

    protected void afterImportInvoice(InvoiceFormPluginService invoiceFormPluginService, ClosedCallBackEvent closedCallBackEvent, CustomEventArgs e) throws Exception {
        if (this.isPc()) {
            invoiceFormPluginService.afterImportInvoicePC(this, new InvoiceEvent<ClosedCallBackEvent>(closedCallBackEvent));
        } else {
            invoiceFormPluginService.afterImportInvoiceMob(this, new InvoiceEvent<CustomEventArgs>(e));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Boolean isEnableSynAfterImport(ClosedCallBackEvent closedCallBackEvent, CustomEventArgs event) throws Exception {
        invoiceDatas = null;
        if (this.isPc()) {
            isXhInvoiceService = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud() != false || StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"selectBillingPool") != false;
            returnData = closedCallBackEvent.getReturnData();
            if (isXhInvoiceService) {
                if (returnData instanceof JSONObject) {
                    importInvoiceReturnData = (JSONObject)returnData;
                    jsonString = importInvoiceReturnData.toJSONString();
                    simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)jsonString, SimpleXhInvoiceVO.class);
                    if (simpleXhInvoiceVO == null) {
                        return false;
                    }
                    invoiceData = simpleXhInvoiceVO.getInvoiceData();
                    if (invoiceData == null) {
                        data = importInvoiceReturnData.getJSONArray("data");
                        if (data != null) {
                            invoiceVOS = data.toJavaList(InvoiceVO.class);
                            simpleXhInvoiceVO.setInvoiceData(invoiceVOS);
                        } else {
                            return false;
                        }
                    }
                    invoiceDatas = simpleXhInvoiceVO.getInvoiceData();
                }
            } else {
                m = (Map)returnData;
                if ("0".equals(m.get("state"))) {
                    serialNosStr = (String)m.get("msg");
                    serialNosStr = (String)StringUtils.defaultIfBlank((CharSequence)serialNosStr, (CharSequence)"");
                    serialNoArr = serialNosStr.split(",");
                    serialNos = Arrays.stream(serialNoArr).collect(Collectors.toSet());
                    try {
                        if (serialNos == null || serialNos.isEmpty()) ** GOTO lbl54
                        queryInvoiceDetailBO = InvoicePluginUtils.buildQueryInvoiceDetailBO(this, serialNosStr);
                        invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailBO)queryInvoiceDetailBO, this.getAfterSelectInvoicePluginProxy());
                        if (!CollectionUtils.isEmpty((Collection)invoiceVOs)) {
                            m.put("isquery", JSONArray.toJSONString((Object)invoiceVOs));
                        }
                        invoiceDatas = invoiceVOs;
                    }
                    catch (InvoiceCloudException e) {
                        AbstractImportInvoicePlugin.log.error((Throwable)e);
                    }
                    catch (Exception e) {
                        throw new KDException(ThrowableHelper.toString((Exception)e));
                    }
                }
            }
        } else {
            _event = new InvoiceEvent<CustomEventArgs>(event);
            msg = (String)_event.getReturnData();
            serialNosStr = InvoicePluginUtils.getOutSideInvoiceSerialNos(msg);
            if (!StringUtils.isBlank((CharSequence)serialNosStr)) {
                queryInvoiceDetailBO = InvoicePluginUtils.buildQueryInvoiceDetailBO(this, serialNosStr);
                invoiceVOs = APIHelper.queryInvoiceDetailBySerialNo((QueryInvoiceDetailBO)queryInvoiceDetailBO);
                if (!CollectionUtils.isEmpty((Collection)invoiceVOs)) {
                    this.isqueryInvoiceMap = new HashMap<K, V>();
                    this.getQueryInvoiceMap().put("isquery", JSONArray.toJSONString((Object)invoiceVOs));
                }
                invoiceDatas = invoiceVOs;
            }
        }
lbl54:
        // 8 sources

        if (invoiceDatas != null && invoiceDatas.size() > 0) {
            invoiceTypeMap = invoiceDatas.stream().collect(Collectors.groupingBy((Function<InvoiceVO, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getInvoiceType(), (Lkd/fi/er/common/model/invoice/InvoiceVO;)Ljava/lang/String;)()));
            invoicetypes = new HashSet<String>(invoiceTypeMap.keySet());
            invoicetypes.add(InvoiceTypeEnum.key_11.getValue());
            qFilter = new QFilter("invoicetype", "in", invoicetypes);
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("mergetype", "=", (Object)"2");
            invoiceMergeRule = BusinessDataServiceHelper.loadFromCache((String)"er_invoicemergerule", (String)"id,invoicetype", (QFilter[])new QFilter[]{qFilter});
            invoiceMergeRuleMap = invoiceMergeRule.values().stream().collect(Collectors.groupingBy((Function<DynamicObject, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$isEnableSynAfterImport$3(kd.bos.dataentity.entity.DynamicObject ), (Lkd/bos/dataentity/entity/DynamicObject;)Ljava/lang/String;)()));
            ruleSize = 0;
            for (Map.Entry<String, List<InvoiceVO>> typeKey : invoiceTypeMap.entrySet()) {
                if (invoiceMergeRuleMap.containsKey(typeKey.getKey())) {
                    ++ruleSize;
                    continue;
                }
                vos = typeKey.getValue();
                if (vos == null) continue;
                ruleSize += vos.size();
            }
            synImportInvoiceValue = ErStdConfig.getSynImportInvoiceValue();
            AbstractImportInvoicePlugin.log.info("ruleSize\uff1a" + ruleSize + " SynImportInvoiceValue:" + synImportInvoiceValue);
            if (ruleSize > synImportInvoiceValue) {
                return true;
            }
        }
        return false;
    }

    private boolean progressCloseCallBack(String event) {
        log.info("closedCallBackEvent.getActionId():" + event);
        if (StringUtils.equals((CharSequence)"er_progressbar", (CharSequence)event)) {
            String synTipMessage;
            this.getView().updateView();
            String pageId = this.getView().getPageId();
            ErCloudFrameworkCache.removeCache((String)pageId, (String)"task_percent");
            this.getView().getPageCache().remove("isSyn");
            String taskError = ErCloudFrameworkCache.getValueByPageId((String)pageId, (String)"task_error");
            if (StringUtils.isNotBlank((CharSequence)taskError)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6570\u636e\u5bfc\u5165\u5f02\u5e38\uff0c\u8be6\u60c5\u5982\u4e0b\u3002", (String)"EntryImportBillFormPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]), taskError, MessageTypes.Default);
                ErCloudFrameworkCache.removeCache((String)pageId, (String)"task_error");
            }
            if (StringUtils.isNotBlank((CharSequence)(synTipMessage = ErCloudFrameworkCache.getValueByPageId((String)pageId, (String)"synTipMessage")))) {
                this.getView().showMessage(synTipMessage);
                ErCloudFrameworkCache.removeCache((String)pageId, (String)"synTipMessage");
            }
            return true;
        }
        return false;
    }

    public void customEvent(CustomEventArgs e) {
        if (this.isPc()) {
            return;
        }
        String billNo = "";
        if (this.getModel().getProperty("billno") != null) {
            billNo = (String)this.getModel().getValue("billno");
        }
        String msg = e.getEventArgs();
        String eventName = e.getEventName();
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u5916\u90e8 \u53d1\u7968\u52a9\u624b\u8fd4\u56de\u4e8b\u4ef6\u540d\u79f0\uff1a" + eventName + "\uff0c\u8fd4\u56de\uff1a" + msg);
        InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.INVOICE_ORI_INFO, (String)billNo, (String)ResManager.loadKDString((String)"\u91c7\u96c6\u53d1\u7968\u5e8f\u5217\u53f7", (String)"ImportInvoice_4", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)msg);
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<CustomEventArgs>(e));
        if (this instanceof InvoiceMobClientInterface && ((InvoiceMobClientInterface)((Object)this)).getCustomeEventName().equalsIgnoreCase(eventName) && this.isCurrentClickKey()) {
            try {
                InvoiceFormPluginService invoiceFormPluginService = InvoicePluginServiceFactory.getOutSideInvoiceService();
                this.afterImportInvoicePCandMob(invoiceFormPluginService, null, e);
                log.info("\u53d1\u7968\u5bfc\u5165\u5904\u7406\u5b8c\u6210\u540e\uff0c\u4e8c\u5f00\u6267\u884c\u540e\u7eed\u64cd\u4f5c");
                this.afterSelectInvoicePluginProxy.callReplace(p -> {
                    p.finish(this.getView());
                    return null;
                });
                log.info("end \u53d1\u7968\u5bfc\u5165\u5904\u7406\u5b8c\u6210\u540e\uff0c\u4e8c\u5f00\u6267\u884c\u540e\u7eed\u64cd\u4f5c");
                this.invoiceDeletePageRule(this.isDeleting());
            }
            catch (Exception e2) {
                log.error((Throwable)e2);
                this.getView().showErrorNotification(e2.getMessage());
            }
        }
    }

    public IFormView getExtView() {
        return this.getView();
    }

    public void editInvoice(String oldSerialNo, InvoiceVO invoiceVO) {
    }

    public DynamicObject getCostCompanyDO() {
        DynamicObject costCompanyDO = (DynamicObject)this.getModel().getValue(this.getCostCompanyKey());
        return costCompanyDO;
    }

    protected abstract boolean isUseExpenseDate();

    protected boolean handleXhInvoice(AbstractImportInvoicePlugin plugin, SimpleXhInvoiceVO simpleXhInvoiceVO, IDataModel model) {
        List queryInvoiceDetail = simpleXhInvoiceVO.getInvoiceData();
        if (queryInvoiceDetail.isEmpty()) {
            log.info("\u661f\u701a\u53d1\u7968\u4e91\u8fd4\u56de\u53d1\u7968\u6570\u636e\u4e3a\u7a7a");
            return false;
        }
        plugin.executeProcess(queryInvoiceDetail);
        return true;
    }

    public String getAttachmentPanelId() {
        return "attachmentpanel";
    }

    protected abstract DynamicObject getCompany(DynamicObject var1);

    protected DynamicObject getCompany() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        return this.getCompany(dataEntity);
    }

    protected long getInvoiceCurrency() {
        DynamicObject company = this.getCompany(this.getModel().getDataEntity(true));
        if (company != null) {
            Long companyId = ErCommonUtils.getPk((Object)company);
            log.info("\u7533\u8bf7\u4eba\u516c\u53f8ID\u4e3anull\uff0ccompanyId\uff1a" + companyId);
            if (companyId != null) {
                return SystemParamterUtil.getInvoiceEntryCurrency((Long)companyId);
            }
        } else {
            log.info("\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a");
        }
        return 1L;
    }

    protected boolean isOrgOffset() {
        return InvoiceOffsetUtils.deductibleOfTaxPayer((Long)ErCommonUtils.getPk((Object)this.getCompany()), (Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
    }

    protected boolean isNonOffsetImportTaxAmout() {
        return KingdeeInvoiceCloudConfig.isNonOffsetImportTaxAmout((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
    }

    private boolean isCurrentClickKey() {
        String key = this.getPageCache().get("invoice.ClickKey");
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getClickKey(), (CharSequence)key);
    }

    protected void setClickKey(String key) {
        this.getPageCache().put("invoice.ClickKey", key);
    }

    protected String getClickKey() {
        return this.getPageCache().get("invoice.ClickKey");
    }

    public PluginProxy<AfterSelectInvoice> getAfterSelectInvoicePluginProxy() {
        return this.afterSelectInvoicePluginProxy;
    }

    private void loadAfterProcessExtServiceI(InvoiceContext context) {
        IAfterProcessExtService afterService = (IAfterProcessExtService)InvoiceServiceFactory.getSingletonService(IAfterProcessExtService.class);
        if (afterService != null) {
            afterService.afterProcess(this.getView(), context);
        }
    }

    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        Set invoiceCurrencyId;
        if (this.getModel().getProperty("iscurrency") != null && ((invoiceCurrencyId = context.getInvoiceEntryBOs().stream().map(bo -> bo.getInvoiceCurrencyId()).collect(Collectors.toSet())).isEmpty() || invoiceCurrencyId.size() == 1 && (invoiceCurrencyId.contains(null) || invoiceCurrencyId.contains(0L)))) {
            this.getModel().setValue("iscurrency", (Object)Boolean.TRUE);
        }
    }

    public void pagerClick(PagerClickEvent event) {
        this.invoiceDeletePageRule(this.isDeleting());
    }

    protected void loadAfterProcessUpdateView() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"automapinvoice"});
    }

    public boolean isNewPlugin() {
        return this.isNewPlugin;
    }

    protected String getCostCompanyKey() {
        return "costcompany";
    }

    protected void importInvoiceMob(String key) {
        long orgId;
        this.setClickKey(key);
        DynamicObject org = this.getCostCompanyDO();
        if (org == null) {
            RequestContext requestContext = RequestContext.get();
            orgId = requestContext.getOrgId();
        } else {
            orgId = org.getLong("id");
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)orgId);
        if (config == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"ImportInvoiceForTripReimGridMobPlugin_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String firmName = config.getFirmname();
        if (StringUtils.isBlank((CharSequence)firmName)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8d39\u7528\u627f\u62c5\u516c\u53f8\u7684\u4f01\u4e1a\u5de5\u5546\u767b\u8bb0\u540d\u79f0\u672a\u586b\u5199\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u540e\u518d\u4f7f\u7528\u53d1\u7968\u5bfc\u5165\u529f\u80fd\u3002", (String)"ImportInvoiceForTripReimGridMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        log.info("\u6253\u5f00\u5c0f\u7a0b\u5e8f\uff0c\u9009\u62e9\u53d1\u7968");
        IDataModel model = this.getExtView().getModel();
        DynamicObject dataEntity = model.getDataEntity();
        Long billId = (Long)dataEntity.getPkValue();
        if (billId == null || Objects.equals(billId, 0L)) {
            billId = ORM.create().genLongId((IDataEntityType)model.getDataEntityType());
            model.setValue("id", (Object)billId);
        }
        ImportInvoiceIframeUrlReqParam importRequestParam = new ImportInvoiceIframeUrlReqParam();
        importRequestParam.setBillId(String.valueOf(billId));
        importRequestParam.setInvoiceCompanyId(Long.valueOf(orgId));
        importRequestParam.setTaxRegNum(config.getTaxRegnum());
        importRequestParam.setEntityName(dataEntity.getDataEntityType().getName());
        InvoiceService.getInstanceService().showImportInvoicePageInMob((AbstractFormPlugin)this, model, new CloseCallBack((IFormPlugin)this, IMPORT_INVOICE_IN_MOB), importRequestParam);
    }

    protected List<InvoiceValidator> addInvoiceValidators() {
        return null;
    }

    public IFormView getView() {
        if (super.getView().getPageCache().get("isSyn") != null && ErCloudFrameworkCache.getValueByPageId((String)super.getView().getPageId(), (String)"isProxyView") != null) {
            IFormView view = new SynInvoiceViewProxy(super.getView()).getInstance();
            return view;
        }
        return super.getView();
    }

    public Map getQueryInvoiceMap() {
        return this.isqueryInvoiceMap;
    }

    private static /* synthetic */ String lambda$isEnableSynAfterImport$3(DynamicObject m) {
        return m.getString("invoicetype");
    }

    private static class ConfirmTransferBO {
        private String entryName;
        private boolean isOK;
        private List<Integer> deleteIds;

        private ConfirmTransferBO() {
        }

        public boolean isOK() {
            return this.isOK;
        }

        public void setOK(boolean isOK) {
            this.isOK = isOK;
        }

        public List<Integer> getDeleteIds() {
            return this.deleteIds;
        }

        public void setDeleteIds(List<Integer> deleteIds) {
            this.deleteIds = deleteIds;
        }

        public String getEntryName() {
            return this.entryName;
        }

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }
    }
}

