/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DailyReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpenseItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.MobShowUtils;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.daily.mobile.util.CommonViewControlUtil;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForDailyReimMobPlugin
extends AbstractImportInvoiceForReimMobPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceForDailyReimMobPlugin.class);

    @Override
    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DailyReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ErCommonUtils.genBillIdIfNotExist((IDataModel)this.getModel());
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        super.loadAfterProcessUpdateData(context);
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"expenseentryentity", "flexpanelap9", "expenseflex", "reimbursecontrolinfo"});
        InvoicePluginUtils.updateInvoiceLabel(this.getView());
        CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
        MobShowUtils.updateInvoiceCloudEnable((IDataModel)this.getModel(), (IFormView)this.getView());
        MobShowUtils.accountPageRules((IDataModel)this.getModel(), (IFormView)this.getView());
        InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateExpenseItemEntryServiceImpl createExpenseItemEntryServiceImpl = new CreateExpenseItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        return createExpenseItemEntryServiceImpl;
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            InvoicePluginUtils.updateInvoiceLabel(this.getView());
            CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            InvoicePluginUtils.updateInvoiceLabel(this.getView());
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("currency".equals(propName)) {
            InvoicePluginUtils.updateInvoiceLabel(this.getView());
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        InvoicePluginUtils.updateInvoiceLabel(this.getView());
        CommonViewControlUtil.setExpenseAmount(this.getModel(), this.getView());
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"image_invoice", "lbl_invoicecount", "btn_add_invoice"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expenseItemEntryDOs = dataEntity.getDynamicObjectCollection("expenseentryentity");
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            String key = ctl.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"image_invoice")) {
                int rowIndex = this.getModel().getEntryCurrentRowIndex("expenseentryentity");
                DynamicObject expenseEntryDO = (DynamicObject)expenseItemEntryDOs.get(rowIndex);
                Long itemEntryID = (Long)expenseEntryDO.getPkValue();
                ArrayList<String> serialNos = new ArrayList<String>();
                serialNos.addAll(this.getSerialNosByItemEntryId(itemEntryID));
                String rawInvoiceNo = expenseEntryDO.getString("invoiceno_entry");
                String rawInvoiceCode = expenseEntryDO.getString("invoicelink");
                if (StringUtils.isNotEmpty((CharSequence)rawInvoiceNo) && StringUtils.isNotEmpty((CharSequence)rawInvoiceCode)) {
                    Set<String> invoiceNos = Arrays.stream(rawInvoiceNo.split(",")).collect(Collectors.toSet());
                    Set<String> invoiceCodes = Arrays.stream(rawInvoiceCode.split(",")).collect(Collectors.toSet());
                    invoiceNos.add(rawInvoiceNo);
                    invoiceCodes.add(rawInvoiceCode);
                    List<String> serialNosFromInvoiceMergeEntry = this.getSerialNosByInvoiceNoAndCode(invoiceNos, invoiceCodes);
                    serialNos.addAll(serialNosFromInvoiceMergeEntry);
                }
                Set invoiceEntryIds = dataEntity.getDynamicObjectCollection("invoiceandexpense").stream().filter(entry -> Objects.equals(entry.getLong("expenseentryid"), itemEntryID)).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
                List mapSerialNos = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("serialno")).collect(Collectors.toList());
                serialNos.addAll(mapSerialNos);
                this.showInvoiceList(serialNos);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"lbl_invoicecount")) {
                List<String> serialNos = this.getAllSerialNos();
                ShowInvoiceCloudPageUtil.showAllInvoiceList((AbstractFormPlugin)this, KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO())), serialNos);
            } else if ("btn_add_invoice".equalsIgnoreCase(key)) {
                this.importInvoiceMob(key);
            }
        }
    }

    @Override
    protected String getItemEntryEntityKey() {
        return "expenseentryentity";
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        if (serialNos == null || serialNos.isEmpty()) {
            log.info("\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u770b\u53d1\u7968");
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        ShowInvoiceCloudPageUtil.showAllInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNos);
    }

    @Override
    protected void processWhenInvoiceIsDisable() {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            log.info("\u5bfc\u5165\u53d1\u7968\uff0c\u5237\u65b0\u6309\u94ae\u63a7\u4ef6");
            this.invoiceDeletePageRule(this.isDeleting());
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
    }

    @Override
    protected String getClickKey() {
        return "btn_add_invoice";
    }
}

