/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DailyReimburseBeforeImportInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpenseItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimPCPlugin;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForDailyReimPCPlugin
extends AbstractImportInvoiceForReimPCPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceForDailyReimPCPlugin.class);

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateExpenseItemEntryServiceImpl createExpenseItemEntryServiceImpl = new CreateExpenseItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        return createExpenseItemEntryServiceImpl;
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hlcEvent) {
        super.hyperLinkClick(hlcEvent);
        String fieldName = hlcEvent.getFieldName();
        int rowIndex = hlcEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"invoiceno_entry")) {
            Long expenseItemEntryId;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObject expenseEntryDO = (DynamicObject)dataEntity.getDynamicObjectCollection("expenseentryentity").get(rowIndex);
            Long invoiceFromEntryId = expenseItemEntryId = (Long)expenseEntryDO.getPkValue();
            if (expenseEntryDO.getBoolean("invoicefromparent")) {
                invoiceFromEntryId = Long.parseLong(expenseEntryDO.getString("splitline"));
            }
            ArrayList<String> serialNos = new ArrayList<String>();
            serialNos.addAll(this.getSerialNosByItemEntryId(invoiceFromEntryId));
            String rawInvoiceNo = expenseEntryDO.getString("invoiceno_entry");
            String rawInvoiceCode = expenseEntryDO.getString("invoicelink");
            if (StringUtils.isNotEmpty((CharSequence)rawInvoiceNo) && StringUtils.isNotEmpty((CharSequence)rawInvoiceCode)) {
                HashSet invoiceNos = Sets.newHashSet((Iterable)Arrays.stream(rawInvoiceNo.split(",")).collect(Collectors.toSet()));
                HashSet invoiceCodes = Sets.newHashSet((Iterable)Arrays.stream(rawInvoiceCode.split(",")).collect(Collectors.toSet()));
                invoiceNos.add(rawInvoiceNo);
                invoiceCodes.add(rawInvoiceCode);
                List<String> serialNosFromInvoiceMergeEntry = this.getSerialNosByInvoiceNoAndCode(invoiceNos, invoiceCodes);
                serialNos.addAll(serialNosFromInvoiceMergeEntry);
            }
            Set invoiceEntryIds = dataEntity.getDynamicObjectCollection("invoiceandexpense").stream().filter(entry -> Objects.equals(entry.getLong("expenseentryid"), expenseItemEntryId)).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
            List mapSerialNos = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("serialno")).collect(Collectors.toList());
            serialNos.addAll(mapSerialNos);
            this.showInvoiceList(serialNos);
        }
    }

    @Override
    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DailyReimburseBeforeImportInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    protected String getItemEntryEntityKey() {
        return "expenseentryentity";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getControl("advcontoolbarap3") != null) {
            this.addItemClickListeners(new String[]{"advcontoolbarap3"});
        }
    }

    private void toggleAutoMapInvoice(boolean isAutoMapInvoice) {
        this.getView().setVisible(Boolean.valueOf(!isAutoMapInvoice), new String[]{"mapinvoice", "importnotcreateitem", "mapinvoicebyinvoiceno"});
        this.getView().setVisible(Boolean.valueOf(!isAutoMapInvoice), new String[]{"mapinvoiceentry", "mapinvoicebyinvoicenoentr"});
        this.getView().setVisible(Boolean.valueOf(isAutoMapInvoice), new String[]{"merge", "expenseimportinvoice"});
        this.showSingleLineImportInvoice(isAutoMapInvoice);
    }

    @Override
    protected void editExpenseOrTripItemEntry(long expenseItemEntryId, AbstractImportInvoiceForReimPCPlugin.InvoiceEditItemBean invoiceEditItemBean) {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection expenseEntrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
        for (int i = 0; i < expenseEntrys.size(); ++i) {
            DynamicObject expenseEntryDO = (DynamicObject)expenseEntrys.get(i);
            if (!Objects.equals(expenseItemEntryId, expenseEntryDO.getPkValue())) continue;
            log.info("\u4fee\u6539\u7b2c" + (i + 1) + "\u884c\u6570\u636e");
            BigDecimal reimAmount = (BigDecimal)model.getValue("expenseamount", i);
            BigDecimal airportConstructionFeeAmount = (BigDecimal)model.getValue("airportconstructionfee", i);
            BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", i);
            BigDecimal excludedAmount = (BigDecimal)model.getValue("orientryamount", i);
            model.setValue("expenseamount", (Object)reimAmount.add(invoiceEditItemBean.getDeltaTotalAmount()), i);
            model.setValue("airportconstructionfee", (Object)airportConstructionFeeAmount.add(invoiceEditItemBean.getDeltaAirportConstructionFee()), i);
            model.setValue("taxamount", (Object)taxAmount.add(invoiceEditItemBean.getDeltaTaxAmount()), i);
            model.setValue("orientryamount", (Object)excludedAmount.add(invoiceEditItemBean.getDeltaExcludeTaxAmount()), i);
            model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)invoiceEditItemBean.getInvoiceNo()), i);
            model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)invoiceEditItemBean.getInvoiceCode()), i);
            return;
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"automapinvoice")) {
            Boolean isAutoMapInvoice = (Boolean)e.getChangeSet()[0].getNewValue();
            this.toggleAutoMapInvoice(isAutoMapInvoice);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof DefaultEntityOperate) {
            DefaultEntityOperate op = (DefaultEntityOperate)source;
            String key = op.getOperateKey();
            String opName = op.getOperateName().getLocaleValue();
            String formId = this.getView().getFormShowParameter().getFormId();
            log.info(String.format("\u9875\u9762%s(pageId=%s)\u6267\u884c%s(%s)\u64cd\u4f5c)", formId, this.getView().getPageId(), opName, key));
        }
    }

    @Override
    protected String getClickKey() {
        return "selectinvoice";
    }
}

