/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.util.SimpleRelateExpenseOrTripItemAndInvoiceUtil;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.common.model.invoice.bo.InvoiceEntryBO;
import kd.fi.er.common.model.invoice.bo.PropBo;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceSupplementMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForSupplementMobPlugin
extends AbstractImportInvoiceSupplementMobPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceForSupplementMobPlugin.class);
    private static String ER_REIMBURSE_SUPPLEMENT = "er_reimburse_supplement";

    @Override
    public boolean check(InvoiceContext invoiceContext) {
        if (ErStdConfig.isMustSameInvoiceTypeInRelatingInvoice()) {
            List<DynamicObject> selectedItems = this.getSelectedItems();
            DynamicObject bill = this.getView().getModel().getDataEntity(true);
            Map expenseInvoiceMap = InvoiceUtils.getInvoiceItemColl((DynamicObject)bill, (String)"invoiceandexpense", (String)"expenseentryid", (String)"invoiceentryid");
            DynamicObjectCollection invoices = bill.getDynamicObjectCollection("invoiceentry");
            Set importTypes = invoiceContext.getInvoiceVOs().stream().map(m -> m.getInvoiceType()).collect(Collectors.toSet());
            if (importTypes.size() > 1) {
                invoiceContext.getInvoiceVOs().clear();
                DynamicObjectCollection expenseEntry = this.getModel().getEntryEntity("expenseentry");
                List idList = selectedItems.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toList());
                ArrayList<String> indexs = new ArrayList<String>();
                for (int index = 0; index < expenseEntry.size(); ++index) {
                    Long pkValue = (Long)((DynamicObject)expenseEntry.get(index)).getPkValue();
                    if (!idList.contains(pkValue)) continue;
                    indexs.add(String.valueOf(index + 1));
                }
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u5bf9\u5e94\u7684\u53d1\u7968\u5fc5\u987b\u662f\u540c\u4e00\u7c7b\u578b\u7684\u53d1\u7968\u3002", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_3", (String)"fi-er-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", indexs.toArray(new String[0]))));
                return true;
            }
            for (int index = 0; index < selectedItems.size(); ++index) {
                DynamicObject dynamicObject = selectedItems.get(index);
                Long pkValue = (Long)dynamicObject.getPkValue();
                Set invoiceEntryIds = (Set)expenseInvoiceMap.get(pkValue);
                if (invoiceEntryIds == null || invoiceEntryIds.size() == 0) continue;
                Set invoiceTypes = invoices.stream().filter(m -> invoiceEntryIds.contains(m.getLong("id"))).map(m -> m.getString("invoicetype")).collect(Collectors.toSet());
                invoiceTypes.addAll(invoiceContext.getInvoiceVOs().stream().map(m -> m.getInvoiceType()).collect(Collectors.toSet()));
                if (invoiceTypes.size() <= 1) continue;
                invoiceContext.getInvoiceVOs().clear();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u5bf9\u5e94\u7684\u53d1\u7968\u5fc5\u987b\u662f\u540c\u4e00\u7c7b\u578b\u7684\u53d1\u7968\u3002", (String)"ImportInvoiceForDailyReimPCWithoutExpenseItem_3", (String)"fi-er-formplugin", (Object[])new Object[0]), index + 1));
                return true;
            }
        }
        return false;
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext invoiceContext) {
        super.loadAfterProcessUpdateData(invoiceContext);
        List invoiceEntryBOs = invoiceContext.getInvoiceEntryBOs();
        if (invoiceEntryBOs == null || invoiceEntryBOs.size() == 0) {
            log.error("\u6ca1\u6709\u9009\u62e9\u5f85\u540e\u8865\u53d1\u7968\u7684\u8d39\u7528\u660e\u7ec6\u5206\u5f55, \u6216\u662f\u6ca1\u6709\u53d1\u7968\u5bfc\u5165");
            return;
        }
        Set newInvoiceIds = invoiceEntryBOs.stream().map(v -> v.getEntryId()).collect(Collectors.toSet());
        List<DynamicObject> selectedItems = this.getSelectedItems();
        Set entryIds = selectedItems.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(entryIds) || newInvoiceIds.size() == 0 || CollectionUtils.isEmpty((Collection)invoiceContext.getInvoiceVOs())) {
            log.error("\u6ca1\u6709\u9009\u62e9\u5f85\u540e\u8865\u53d1\u7968\u7684\u8d39\u7528\u660e\u7ec6\u5206\u5f55, \u6216\u662f\u6ca1\u6709\u53d1\u7968\u5bfc\u5165");
            return;
        }
        InvoiceUtils.updateAutomapinvoiceEnable((IFormView)this.getView(), (String[])new String[]{"automapinvoice"});
        ArrayList<PropBo> propBos = new ArrayList<PropBo>(invoiceEntryBOs.size());
        for (int i = 0; i < invoiceEntryBOs.size(); ++i) {
            PropBo propBo = new PropBo();
            propBo.setInvoiceEntryId(((InvoiceEntryBO)invoiceEntryBOs.get(i)).getEntryId());
            propBo.setSerialNo(((InvoiceEntryBO)invoiceEntryBOs.get(i)).getSerialNo());
            propBos.add(propBo);
        }
        InvoiceUtils.buildMapinfo((IDataModel)this.getModel(), entryIds, propBos);
        SimpleRelateExpenseOrTripItemAndInvoiceUtil.refreshExpenseField((IDataModel)this.getModel(), (BillOfInvoice)this.getBillOfInvoice(), entryIds, newInvoiceIds);
        OperateOption operateOption = OperateOption.create();
        this.getView().invokeOperation("saveinvoice", operateOption);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        Object automapinvoice = e.getChangeSet()[0].getNewValue();
        if ("needsuppleinvoice".equals(propName) && Boolean.parseBoolean(automapinvoice.toString())) {
            this.getModel().setValue("automapinvoice", (Object)"0");
            String str = ResManager.loadKDString((String)"\u6309\u94ae\u5f00\u542f\u540e\uff0c\u53ef\u5728\u5355\u636e\u5ba1\u6838\u901a\u8fc7\u4e4b\u540e\u8865\u53d1\u7968\u3002", (String)"ImportInvoiceForSupplementReimMobPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(str);
        }
    }

    @Override
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_suppleinvoice"});
    }

    @Override
    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control) {
            String key;
            Control ctl = (Control)source;
            switch (key = ctl.getKey()) {
                case "btn_suppleinvoice": {
                    MobileFormShowParameter showSupplementParameter = new MobileFormShowParameter();
                    String formId = ER_REIMBURSE_SUPPLEMENT;
                    if (ErEntityTypeUtils.isDailyReimburseBill((String)this.getView().getEntityId())) {
                        formId = "er_dailyreimburse_supple";
                    }
                    showSupplementParameter.setFormId(formId);
                    showSupplementParameter.getOpenStyle().setShowType(ShowType.Floating);
                    showSupplementParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ER_REIMBURSE_SUPPLEMENT));
                    this.getView().showForm((FormShowParameter)showSupplementParameter);
                    this.getPageCache().put("supplementinvoice", "true");
                }
            }
        }
    }

    @Override
    protected String getCloseCallBackKey() {
        return "btn_suppleinvoice";
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        Object result = event.getReturnData();
        if (ER_REIMBURSE_SUPPLEMENT.equals(actionId) && result instanceof Map && !((Map)result).isEmpty()) {
            this.importInvoiceMob("btn_suppleinvoice");
        } else if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            log.info("\u5bfc\u5165\u53d1\u7968\uff0c\u5237\u65b0\u6309\u94ae\u63a7\u4ef6");
            this.invoiceDeletePageRule(this.isDeleting());
            InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
        }
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        if (collection.size() > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"invoiceentry"});
            Vector vector = (Vector)this.getView().getControl("vectorap111");
            if (vector != null) {
                vector.setFontClass("kdfont kdfont-shouqi7");
            }
        }
    }

    protected BillOfInvoice getBillOfInvoice() {
        return BillOfInvoice.DailyReimburseBill;
    }

    @Override
    protected String getClickKey() {
        return "btn_suppleinvoice";
    }

    @Override
    protected List<DynamicObject> getSelectedItems() {
        String supplementEntryIds = this.getView().getPageCache().get(ER_REIMBURSE_SUPPLEMENT);
        if (StringUtils.isEmpty((CharSequence)supplementEntryIds)) {
            return new ArrayList<DynamicObject>();
        }
        Map supplementEntryMap = (Map)SerializationUtils.fromJsonString((String)supplementEntryIds, Map.class);
        ArrayList<DynamicObject> selectItems = new ArrayList<DynamicObject>(supplementEntryMap.size());
        DynamicObjectCollection expenseEntry = this.getModel().getEntryEntity("expenseentryentity");
        for (Map.Entry entry : supplementEntryMap.entrySet()) {
            int rowIndex = (Integer)entry.getValue();
            DynamicObject dynamicObject = (DynamicObject)expenseEntry.get(rowIndex);
            selectItems.add(dynamicObject);
        }
        return selectItems;
    }
}

