/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.TripRemoveSameItemServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimMobPlugin
extends AbstractImportInvoiceForReimMobPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimMobPlugin.class);
    private final String TRIP_ITEM_ENTRY = "entryentity";
    private final String TRIP_ENTRY = "tripentry";
    private final String BTN_IMPORT_INVOICE_DEV = "importinvoicedev";

    @Override
    protected String getItemEntryEntityKey() {
        return "entryentity";
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.getView().updateView("entryentity");
    }

    @Override
    public IInvoiceService getBeforeCreateItemServiceImpl(InvoiceContext invoiceContext) {
        return new TripRemoveSameItemServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public IInvoiceService getMappingItemImpl(InvoiceContext invoiceContext) {
        return new MappingItemWithOrgInvoiceServiceImp(invoiceContext, this.getBillType(), this.getView().getParentView().getModel().getDataEntity(true));
    }

    @Override
    protected void processWhenInvoiceIsDisable() {
    }

    @Override
    protected void processWhenInvoiceIsEnable() {
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud() && !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloudInMob()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_add_invoice"});
        }
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateTripItemEntryServiceImpl createtripitementryservice = new CreateTripItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        return createtripitementryservice;
    }

    @Override
    public boolean isPc() {
        return false;
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"importinvoicedev", "image_invoice", "btn_add_invoice"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            Control ctl = (Control)evt.getSource();
            if (StringUtils.equalsIgnoreCase((CharSequence)ctl.getKey(), (CharSequence)"importinvoicedev") || StringUtils.equalsIgnoreCase((CharSequence)ctl.getKey(), (CharSequence)"btn_add_invoice")) {
                this.importInvoiceMob(ctl.getKey());
            } else if (StringUtils.equalsIgnoreCase((CharSequence)ctl.getKey(), (CharSequence)"image_invoice")) {
                int tripItemIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                int tripIndex = this.getModel().getEntryCurrentRowIndex("tripentry");
                DynamicObject tripItemEntryDO = (DynamicObject)((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry").get(tripIndex)).getDynamicObjectCollection("entryentity").get(tripItemIndex);
                Long tripItemId = (Long)tripItemEntryDO.getPkValue();
                List<String> serialNos = this.getSerialNosByItemEntryId(tripItemId);
                String rawInvoiceNo = tripItemEntryDO.getString("invoiceno_entry");
                String rawInvoiceCode = tripItemEntryDO.getString("invoicelink");
                if (StringUtils.isNotEmpty((CharSequence)rawInvoiceNo) && StringUtils.isNotEmpty((CharSequence)rawInvoiceCode)) {
                    Set<String> invoiceNos = Arrays.stream(rawInvoiceNo.split(",")).collect(Collectors.toSet());
                    Set<String> invoiceCodes = Arrays.stream(rawInvoiceCode.split(",")).collect(Collectors.toSet());
                    invoiceNos.add(rawInvoiceNo);
                    invoiceCodes.add(rawInvoiceCode);
                    List<String> serialNosFromInvoiceMergeEntry = this.getSerialNosByInvoiceNoAndCode(invoiceNos, invoiceCodes);
                    serialNos.addAll(serialNosFromInvoiceMergeEntry);
                }
                this.showInvoiceList(serialNos);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getView().getParentView().getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        if (serialNos == null || serialNos.isEmpty()) {
            log.info("\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u770b\u53d1\u7968");
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyId()));
        ShowInvoiceCloudPageUtil.showAllInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNos);
    }

    @Override
    public String getTaxRegNum() {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)this.getCostCompanyId());
        if (config == null) {
            return null;
        }
        return config.getTaxRegnum();
    }

    private Long getCostCompanyId() {
        DynamicObject costCompanyDO = this.getCostCompanyDO();
        if (costCompanyDO == null) {
            log.info("\u5f53\u524d\u5355\u636e\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a");
            return null;
        }
        return ErCommonUtils.getPk((Object)costCompanyDO);
    }

    @Override
    public DynamicObject getCostCompanyDO() {
        return (DynamicObject)this.getView().getParentView().getModel().getValue("costcompany");
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return this.billCompany();
    }

    protected DynamicObject billCompany() {
        IDataModel model;
        IFormView view = this.getView();
        IFormView pView = view.getParentView();
        if (pView != null && (model = pView.getModel()).getDataEntityType().getProperty("company") != null) {
            return (DynamicObject)model.getValue("company");
        }
        return null;
    }

    @Override
    protected long billCompany4Mob() {
        long companyid = 0L;
        DynamicObject billCompany = this.billCompany();
        if (billCompany != null) {
            companyid = ErCommonUtils.getPk((Object)this.billCompany());
        }
        return companyid;
    }

    @Override
    protected String getClickKey() {
        return "btn_add_invoice";
    }
}

