/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.form.IMobileView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.EntityTypeEnum;
import kd.fi.er.common.model.invoice.OperationConfigBo;
import kd.fi.er.common.utils.InvoiceCloudUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoicePlugin;

public class ImportInvoicePluginSupplier
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(ImportInvoicePluginSupplier.class);
    private AbstractImportInvoicePlugin plugin;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "supplementinvoice"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        boolean isPc = !(this.getView() instanceof IMobileView);
        String billType = this.getView().getEntityId();
        EntityTypeEnum entityType = ErEntityTypeUtils.getEntityType((String)billType);
        if (entityType != null) {
            billType = entityType.getEntityIds()[0];
        }
        OperationConfigBo invoicePlugin = InvoiceCloudUtil.getInvoicePlugin((String)billType, (boolean)isPc, (String)itemKey);
        log.info("\u3010\u53d1\u7968\u4e91\u3011\u5355\u636e\u7c7b\u578b\uff1a" + billType + "\uff0c\u64cd\u4f5c" + itemKey + "\u52a0\u8f7d\u5230\u63d2\u4ef6\u4fe1\u606f" + invoicePlugin);
        if (invoicePlugin != null) {
            try {
                Class<?> invoicePluginClass = Class.forName(invoicePlugin.getPluginPath());
                this.plugin = (AbstractImportInvoicePlugin)invoicePluginClass.newInstance();
                if (this.plugin != null && this.plugin.isNewPlugin()) {
                    log.info("\u3010\u53d1\u7968\u4e91\u3011\u89e6\u53d1\u63d2\u4ef6\u7ed1\u5b9a\uff1a" + this.plugin.getClass().getName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

