/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.APIHelper;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoiceMobClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;

public class TripReimburseAboutInvoiceMainPageMobPlugin
extends AbstractImportInvoiceForReimPlugin
implements InvoiceMobClientInterface {
    private static final Log log = LogFactory.getLog(TripReimburseAboutInvoiceMainPageMobPlugin.class);
    private final String TRIP_ITEM_ENTRY = "entryentity";
    private final String TRIP_ENTRY = "tripentry";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lbl_invoicecount"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        APIHelper.getBillNoCachedInCloud((DynamicObject)this.getModel().getDataEntity());
        ErCommonUtils.genBillIdIfNotExist((IDataModel)this.getModel());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(closedCallBackEvent));
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateInvoiceLabel();
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
    }

    private void updateInvoiceLabel() {
        boolean invoiceIsEnabled = false;
        DynamicObject newCostCompanyDO = this.getCostCompanyDO();
        if (newCostCompanyDO != null) {
            invoiceIsEnabled = KingdeeInvoiceCloudConfig.isEnabled((long)((Long)newCostCompanyDO.getPkValue()));
        }
        if (invoiceIsEnabled) {
            DynamicObjectCollection invoiceHeadEntryDOs = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
            int invoiceCount = invoiceHeadEntryDOs.stream().mapToInt(invoiceHead -> invoiceHead.getInt("count")).sum();
            BigDecimal invoiceAmount = invoiceHeadEntryDOs.stream().map(invoiceHeadDO -> invoiceHeadDO.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            Label invoiceCountLab = (Label)this.getControl("lbl_invoicecount");
            Label invoiceAmountLab = (Label)this.getControl("lbl_totalamount");
            invoiceCountLab.setText(String.valueOf(invoiceCount));
            Integer amtprecision = 4;
            String sign = "\uffe5";
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject company = (DynamicObject)this.getModel().getValue("company");
            Long invoiceEntryCurrency = SystemParamterUtil.getInvoiceEntryCurrency((Long)((Long)company.getPkValue()));
            if (invoiceEntryCurrency != null && !currency.getPkValue().equals(invoiceEntryCurrency)) {
                this.getModel().setValue("iscurrency", (Object)true);
                String selectPropties = "id,createorg,number,name,enable,sign,amtprecision";
                DynamicObject invoiceCurrency = BusinessDataServiceHelper.loadSingle((Object)invoiceEntryCurrency, (String)"bd_currency", (String)selectPropties);
                if (invoiceCurrency != null) {
                    sign = invoiceCurrency.getString("sign");
                    amtprecision = invoiceCurrency.getInt("amtprecision");
                }
            } else {
                sign = currency.getString("sign");
                amtprecision = currency.getInt("amtprecision");
            }
            String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)invoiceAmount);
            invoiceAmountLab.setText(formatMoneyByUser);
        }
    }

    @Override
    protected void processWhenInvoiceIsDisable() {
    }

    @Override
    protected void setDeleteAttachButtonVisible() {
        Long costCompanyId = ErCommonUtils.getPk((Object)this.getCostCompanyDO());
        boolean invoiceIsEnabled = costCompanyId == null ? false : KingdeeInvoiceCloudConfig.isEnabled((long)costCompanyId);
        this.getView().setVisible(Boolean.valueOf(invoiceIsEnabled), new String[]{"invoiceattachpanel"});
    }

    @Override
    protected String getItemEntryEntityKey() {
        return "entryentity";
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return null;
    }

    @Override
    public boolean isPc() {
        return false;
    }

    @Override
    public String getCustomeEventName() {
        return "";
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        if (serialNos == null || serialNos.isEmpty()) {
            log.info("\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u770b\u53d1\u7968");
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        ShowInvoiceCloudPageUtil.showAllInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNos);
    }
}

