/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.collection.one4one;

import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.form.container.AdvContainer;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.formplugin.invoicecloud.v2.clientInterface.InvoicePcClientInterface;
import kd.fi.er.formplugin.invoicecloud.v2.collection.one4one.AbstractImportInvoiceForReimOne4One;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractImportInvoiceForReimPCOne4One
extends AbstractImportInvoiceForReimOne4One
implements InvoicePcClientInterface {
    private static final String IMPORT_INVOICE_ONE_BY_ONE = "importinvoiceonebyone";

    @Override
    protected String getCloseCallBackKey() {
        return IMPORT_INVOICE_ONE_BY_ONE;
    }

    @Override
    protected DynamicObject getCompany(DynamicObject dataEntity) {
        return dataEntity.getDynamicObject("company");
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        int entryRowCount = this.getModel().getEntryRowCount("invoiceentry");
        AdvContainer invoiceAdvContainer = (AdvContainer)this.getControl("invoice_entry_container");
        if (entryRowCount > 0) {
            invoiceAdvContainer.setCollapse(false);
        }
        this.updateInvoiceValidateSummary();
    }

    public void updateInvoiceValidateSummary() {
        Label label;
        if (((EntityType)this.getModel().getDataEntityType().getAllEntities().get("invoiceentry")).getProperty("ie_validatest") == null) {
            return;
        }
        DynamicObjectCollection invoiceHeadDOs = this.getModel().getDataEntity(true).getDynamicObjectCollection("invoiceentry");
        String notOKInvoiceNos = invoiceHeadDOs.stream().filter(entry -> StringUtils.equals((CharSequence)entry.getString("ie_validatest"), (CharSequence)InvoiceVO.CheckStatus.NOT_OK.getValue())).map(entry -> entry.getString("invoiceno")).collect(Collectors.joining("\uff0c"));
        String validateSummary = "";
        if (StringUtils.isNotBlank((CharSequence)notOKInvoiceNos)) {
            validateSummary = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a\uff1a\u53d1\u7968%1$s \u67e5\u9a8c\u4e0d\u901a\u8fc7\u3002", (String)"AbstractImportInvoiceForReimPCOne4One_0", (String)"fi-er-formplugin", (Object[])new Object[0]);
            validateSummary = String.format(validateSummary, notOKInvoiceNos);
        }
        if ((label = (Label)this.getControl("invoice_validate_summary")) != null) {
            label.setText(validateSummary);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObjectCollection tripEntry;
        String itemKey = evt.getItemKey();
        if (this.getCloseCallBackKey().equalsIgnoreCase(itemKey) && this.getModel().getProperty("tripentry") != null && (tripEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("tripentry")).isEmpty()) {
            String tip = ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u884c\u7a0b\uff0c\u518d\u540c\u53d1\u7968\u5408\u5e76\u5bfc\u5165\u3002", (String)"AbstractImportInvoiceForReimPCOne4One_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tip);
            evt.setCancel(true);
        }
    }

    @Override
    protected String getClickKey() {
        return IMPORT_INVOICE_ONE_BY_ONE;
    }
}

