/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.collection.one4one;

import java.math.BigDecimal;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.AfterCreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.TripRemoveSameItemServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.BeforeImportInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.beforeImportService.DoNothingImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.formplugin.invoicecloud.v2.collection.one4one.AbstractImportInvoiceForReimMobOne4One;

public class ImportInvoiceForTripGridReimMobOne4One
extends AbstractImportInvoiceForReimMobOne4One {
    @Override
    public BeforeImportInvoiceService getBeforeImportInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new DoNothingImpl(invoiceContext);
    }

    @Override
    public IInvoiceService getMappingItemImpl(InvoiceContext invoiceContext) {
        return new MappingItemWithOrgInvoiceServiceImp(invoiceContext, this.getBillType(), this.getModel().getDataEntity(true));
    }

    @Override
    public IInvoiceService getBeforeCreateItemServiceImpl(InvoiceContext invoiceContext) {
        return new TripRemoveSameItemServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new CreateTripItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
    }

    @Override
    public IInvoiceService getAfterCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        return new AfterCreateTripItemEntryServiceImpl(this.getView(), invoiceContext);
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        super.loadAfterProcessUpdateData(context);
        AmountChangeUtil.recalcReimburseAmountField((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true);
        AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.updateInvoiceLabel();
    }

    private void updateInvoiceLabel() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        int invoiceCount = invoiceEntryDOs.stream().mapToInt(invoiceHead -> invoiceHead.getInt("count")).sum();
        BigDecimal invoiceTotalAmount = invoiceEntryDOs.stream().map(invoiceEntryDO -> invoiceEntryDO.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Label countLab = (Label)this.getControl("lbl_invoicecount");
        Label amountLab = (Label)this.getControl("lbl_totalamount");
        countLab.setText(String.valueOf(invoiceCount));
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Integer amtprecision = 4;
        String sign = "\uffe5";
        if (currency != null) {
            sign = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        String formatMoneyByUser = AmountUtils.formatMoneyByUser((Long)RequestContext.get().getCurrUserId(), (String)sign, (int)amtprecision, (BigDecimal)invoiceTotalAmount);
        amountLab.setText(formatMoneyByUser);
    }
}

