/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.expensepool;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.kingdee.action.QueryBySerialNoAction;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.InvoiceVo2BoService.CopyInvoiceVOToInvoiceEntryBOServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.OffsetAmountInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpensePoolByItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateExpensePoolItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createInvoiceService.CreateInvoiceServiceI;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.invoicecloud.v2.service.impl.mergeInvoiceService.MergeInvoicesInOneServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.preHandleInvoiceService.PreHandleInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveDuplicateInvoiceServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.removeInvoiceService.RemoveInvoiceService;
import kd.fi.er.business.invoicecloud.v2.util.InvoiceJsonParseUtils;
import kd.fi.er.business.servicehelper.AdminDivisionServiceHelper;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForDailyReimPCInOneExpenseItem;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForPoolPCInOneExpenseItem
extends ImportInvoiceForDailyReimPCInOneExpenseItem {
    private static final Log log = LogFactory.getLog(ImportInvoiceForPoolPCInOneExpenseItem.class);
    private static final String IMPORTNOTCREATEITEM = "importnotcreateitem";
    private static final String TOTALTICKETMOUNTLABEL = "totalticketmountlabel";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getControl("tbmain") != null) {
            this.addItemClickListeners(new String[]{"tbmain", "advcontoolbarap22"});
        }
        if (this.getControl("invoiceentry") != null) {
            ((EntryGrid)this.getControl("invoiceentry")).addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)this.getCloseCallBackKey()) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)IMPORTNOTCREATEITEM)) {
            if (ErStdConfig.isDev() && ErStdConfig.getShowImportInvoiceDataSimulatorPC() && itemKey.equals(this.getCloseCallBackKey())) {
                QueryBySerialNoAction action = new QueryBySerialNoAction("test");
                String apiReturnJson = action.execute();
                try {
                    List invoiceVOs = InvoiceJsonParseUtils.parseInvoiceVO((String)apiReturnJson);
                    this.executeProcess(invoiceVOs);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
            } else {
                this.showSelectedInvoicePage(this.getExtView(), itemKey);
            }
        }
    }

    @Override
    public void processInvoiceVO(InvoiceContext invoiceContext) {
        IDataModel model = this.getModel();
        RemoveInvoiceService removeDuplicateInvoiceService = this.getRemoveDuplicateInvoiceServiceImpl(invoiceContext);
        PreHandleInvoiceService addInvoiceItemService = this.getPreHandleInvoiceServiceImpl(invoiceContext);
        CopyInvoiceVOToInvoiceEntryBOServiceImpl copyInvoiceVOToInvoiceEntryBOService = new CopyInvoiceVOToInvoiceEntryBOServiceImpl(invoiceContext, this.getView().getEntityId());
        OffsetAmountInvoiceServiceImpl offsetAmountInvoiceService = new OffsetAmountInvoiceServiceImpl(invoiceContext);
        IInvoiceService mappingExpenseOrTripItemInvoiceService = this.getMappingItemImpl(invoiceContext);
        Long expenseOrTripItemEntryId = ErCommonUtils.getPk((Object)this.getModel().getDataEntity().getPkValue());
        if (expenseOrTripItemEntryId == null || expenseOrTripItemEntryId == 0L) {
            expenseOrTripItemEntryId = ORM.create().genLongId(this.getView().getEntityId());
        }
        this.getModel().setValue("id", (Object)expenseOrTripItemEntryId);
        MergeInvoicesInOneServiceImpl mergeInvoiceServiceImpl = new MergeInvoicesInOneServiceImpl(invoiceContext, expenseOrTripItemEntryId.longValue(), this.getModel());
        CreateExpensePoolByItemEntryServiceImpl incremetalServiceImpl = new CreateExpensePoolByItemEntryServiceImpl(invoiceContext, model);
        CreateInvoiceServiceI createInvoiceEntryServiceImpl = this.getCreateInvoiceService(invoiceContext);
        IInvoiceService createExpenseOrTripItemService = this.getCreateExpenseOrTripItemService(invoiceContext);
        this.addProcessServices(new IInvoiceService[]{removeDuplicateInvoiceService, addInvoiceItemService, copyInvoiceVOToInvoiceEntryBOService, offsetAmountInvoiceService, mappingExpenseOrTripItemInvoiceService, mergeInvoiceServiceImpl, incremetalServiceImpl, createInvoiceEntryServiceImpl, createExpenseOrTripItemService});
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        this.reCalcField();
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        this.updateInvoiceLabel();
    }

    @Override
    public RemoveInvoiceService getRemoveDuplicateInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new RemoveDuplicateInvoiceServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateExpensePoolItemEntryServiceImpl createExpenseOrTripItemService = new CreateExpensePoolItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        return createExpenseOrTripItemService;
    }

    @Override
    public IInvoiceService getMappingItemImpl(InvoiceContext invoiceContext) {
        return new MappingItemWithOrgInvoiceServiceImp(invoiceContext, this.getBillType(), this.getModel().getDataEntity(true));
    }

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public PreHandleInvoiceService getPreHandleInvoiceServiceImpl(InvoiceContext invoiceContext) {
        return new PreHandleInvoiceServiceImpl(invoiceContext);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            this.updateInvoiceLabel();
            this.reCalcField();
        }
    }

    private void reCalcField() {
        boolean isOrgOffset = this.isOrgOffset();
        boolean isImportNonDeductionTaxAmout = this.isNonOffsetImportTaxAmout();
        IDataModel model = this.getModel();
        DynamicObjectCollection invoiceEntryDOs = model.getEntryEntity("invoiceentry");
        DynamicObjectCollection invoiceItemEntryDOs = model.getEntryEntity("invoiceitementry");
        BigDecimal taxRate = BigDecimal.ZERO;
        Set taxRates = invoiceItemEntryDOs.stream().map(entry -> entry.getBigDecimal("invoiceitemtaxrate")).collect(Collectors.toSet());
        if (taxRates.size() == 1) {
            taxRate = (BigDecimal)taxRates.iterator().next();
        }
        BigDecimal taxAmount = invoiceEntryDOs.stream().map(entry -> entry.getBigDecimal("taxamount_invoice")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (!isImportNonDeductionTaxAmout) {
            taxAmount = InvoiceOffsetUtils.getOffsetInvoiceItem((Collection)invoiceItemEntryDOs).map(entry -> entry.getBigDecimal("invoiceitemtaxamout")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            boolean allOffset = InvoiceOffsetUtils.isInvoiceItemAllOffset((Collection)invoiceItemEntryDOs);
            if (!allOffset) {
                taxRate = BigDecimal.ZERO;
            }
        }
        BigDecimal totalAmount = invoiceEntryDOs.stream().map(entry -> entry.getBigDecimal("totalamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal airportConstruAmount = invoiceEntryDOs.stream().map(entry -> entry.getBigDecimal("invoiceairportconstfee")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal excludeTaxAmount = totalAmount.subtract(taxAmount);
        model.setValue("expenseamount", (Object)totalAmount);
        model.setValue("airportconstructionfee", (Object)airportConstruAmount);
        model.setValue("taxrate", (Object)taxRate.multiply(BigDecimal.valueOf(100L)));
        model.setValue("taxamount", (Object)taxAmount);
        model.setValue("orientryamount", (Object)excludeTaxAmount);
        DynamicObject firstInvoiceDO = null;
        List firstInvoiceItems = null;
        if (invoiceEntryDOs.size() >= 1) {
            firstInvoiceDO = (DynamicObject)invoiceEntryDOs.get(0);
            Long firstInvoiceEntryId = (Long)firstInvoiceDO.getPkValue();
            firstInvoiceItems = invoiceItemEntryDOs.stream().filter(entry -> Objects.equals(firstInvoiceEntryId, entry.getLong("invoiceheadentryid"))).collect(Collectors.toList());
        }
        DynamicObject firtInvoiceItemDO = firstInvoiceItems != null ? (DynamicObject)firstInvoiceItems.stream().filter(entry -> StringUtils.isNotBlank((CharSequence)entry.getString("goodsname"))).findAny().orElse(null) : null;
        String goodName = "";
        Long goodCodeId = null;
        if (firtInvoiceItemDO != null) {
            goodName = firtInvoiceItemDO.getString("goodsname");
            String goodsCode = firtInvoiceItemDO.getString("goodscode");
            DynamicObject taxClassCodeDO = BusinessDataServiceHelper.loadSingleFromCache((String)"er_taxclasscode", (String)"id", (QFilter[])new QFilter[]{new QFilter("mergecode", "=", (Object)goodsCode)});
            if (taxClassCodeDO != null) {
                goodCodeId = (Long)taxClassCodeDO.getPkValue();
            }
        }
        model.setValue("expensegoodsname", (Object)goodName);
        model.setValue("taxclasscode", goodCodeId);
        Long startCityId = null;
        Long destCityId = null;
        Date startDate = null;
        Set vehicleInvoiceTypes = InvoiceTypeUtils.loadVehicleInvoiceTypes();
        List vehicleInvoiceEntryDOs = invoiceEntryDOs.stream().filter(entry -> vehicleInvoiceTypes.contains(entry.getString("invoicetype")) && entry.getDate("invoicedate") != null).collect(Collectors.toList());
        vehicleInvoiceEntryDOs.sort(Comparator.comparing(a -> a.getDate("invoicedate")));
        if (!vehicleInvoiceEntryDOs.isEmpty()) {
            DynamicObject firstTripDO = (DynamicObject)vehicleInvoiceEntryDOs.get(0);
            DynamicObject lastTripDO = (DynamicObject)vehicleInvoiceEntryDOs.get(vehicleInvoiceEntryDOs.size() - 1);
            String startCity = firstTripDO.getString("istartcity");
            String destCity = lastTripDO.getString("idestcity");
            startCity = startCity.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"ImportInvoiceForPoolPCInOneExpenseItem_2", (String)"fi-er-formplugin", (Object[])new Object[0])) ? startCity.substring(0, startCity.length() - 1) : startCity;
            destCity = destCity.endsWith(ResManager.loadKDString((String)"\u5e02", (String)"ImportInvoiceForPoolPCInOneExpenseItem_2", (String)"fi-er-formplugin", (Object[])new Object[0])) ? destCity.substring(0, destCity.length() - 1) : destCity;
            startCity = startCity.replace(ResManager.loadKDString((String)"\u7279\u522b\u884c\u653f\u533a", (String)"ImportInvoiceForPoolPCInOneExpenseItem_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "");
            destCity = destCity.replace(ResManager.loadKDString((String)"\u7279\u522b\u884c\u653f\u533a", (String)"ImportInvoiceForPoolPCInOneExpenseItem_3", (String)"fi-er-formplugin", (Object[])new Object[0]), "");
            List startCityDOs = AdminDivisionServiceHelper.getCityByName((String)startCity);
            List endCityDOs = AdminDivisionServiceHelper.getCityByName((String)destCity);
            if (!startCityDOs.isEmpty()) {
                startCityId = (Long)((DynamicObject)startCityDOs.get(0)).getPkValue();
            }
            if (!endCityDOs.isEmpty()) {
                destCityId = (Long)((DynamicObject)endCityDOs.get(0)).getPkValue();
            }
            startDate = firstTripDO.getDate("invoicedate");
        }
        model.setValue("tripfrom", startCityId);
        model.setValue("tripto", destCityId);
        model.setValue("tripcityfield", destCityId);
        model.setValue("startdate", startDate);
        String passenger = invoiceEntryDOs.stream().filter(entry -> vehicleInvoiceTypes.contains(entry.getString("invoicetype")) && StringUtils.isNotBlank((CharSequence)entry.getString("passengername"))).map(entry -> entry.getString("passengername")).findFirst().orElse("");
        model.setValue("trippassenger", (Object)passenger);
        String invoiceCodeUnion = invoiceEntryDOs.stream().map(entry -> entry.getString("invoicecode")).collect(Collectors.joining(","));
        model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode((String)invoiceCodeUnion));
        String invoiceNoUnion = invoiceEntryDOs.stream().map(entry -> entry.getString("invoiceno")).collect(Collectors.joining(","));
        model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo((String)invoiceNoUnion));
        model.setValue("invoicetotalcount", (Object)invoiceEntryDOs.size());
        if (!isOrgOffset) {
            model.setValue("taxrate", (Object)BigDecimal.ZERO);
            model.setValue("taxamount", (Object)BigDecimal.ZERO);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        int[] rowIndexs;
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry") && (rowIndexs = e.getRowIndexs()) != null && rowIndexs.length > 0) {
            IDataModel model = this.getModel();
            DynamicObjectCollection invoiceEntry = model.getEntryEntity("invoiceentry");
            if (invoiceEntry.size() == 0) {
                return;
            }
            Set invoiceEntryIds = Arrays.stream(rowIndexs).mapToObj(index -> (DynamicObject)invoiceEntry.get(index)).map(entry -> (Long)entry.getPkValue()).filter(id -> !Objects.equals(id, 0L)).collect(Collectors.toSet());
            DynamicObjectCollection invoiceItemDOs = model.getEntryEntity("invoiceitementry");
            ArrayList needDeleteInvoiceItemEntryRowIndexs = Lists.newArrayListWithCapacity((int)invoiceItemDOs.size());
            for (int i = 0; i < invoiceItemDOs.size(); ++i) {
                if (!invoiceEntryIds.contains(((DynamicObject)invoiceItemDOs.get(i)).getLong("invoiceheadentryid"))) continue;
                needDeleteInvoiceItemEntryRowIndexs.add(i);
            }
            if (!needDeleteInvoiceItemEntryRowIndexs.isEmpty()) {
                model.beginInit();
                model.deleteEntryRows("invoiceitementry", needDeleteInvoiceItemEntryRowIndexs.stream().mapToInt(Integer::intValue).toArray());
                model.endInit();
            }
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateInvoiceLabel();
    }

    private void updateInvoiceLabel() {
        IDataModel dataModel = this.getModel();
        Label totalencashamountlabel = (Label)this.getControl("totalencashamountlabel");
        Label totalticketmountlabel = (Label)this.getControl(TOTALTICKETMOUNTLABEL);
        DynamicObjectCollection collection = dataModel.getEntryEntity("invoiceentry");
        BigDecimal sumtotal = BigDecimal.ZERO;
        for (DynamicObject o : collection) {
            sumtotal = sumtotal.add(o.getBigDecimal("totalamount"));
        }
        String currencySign = "";
        int amountPrecition = 4;
        DynamicObject currency = (DynamicObject)dataModel.getValue("currency");
        if (currency != null) {
            currencySign = currency.getString("sign");
            amountPrecition = currency.getInt("amtprecision");
        }
        int ticketSize = collection.size();
        if (null != totalticketmountlabel) {
            totalticketmountlabel.setText(String.valueOf(ticketSize));
        }
        String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat((String)currencySign, (BigDecimal)sumtotal, (int)amountPrecition);
        if (null != totalencashamountlabel) {
            totalencashamountlabel.setText(amountStr);
        }
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hlcEvent) {
        super.hyperLinkClick(hlcEvent);
        String fieldName = hlcEvent.getFieldName();
        int rowIndex = hlcEvent.getRowIndex();
        if (StringUtils.equals((CharSequence)fieldName, (CharSequence)"invoiceno")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            String invoiceFrom = (String)this.getModel().getValue("invoicefrom", rowIndex);
            if (StringUtils.equals((CharSequence)invoiceFrom, (CharSequence)InvoiceFrom.InvoiceCloud.getValue())) {
                DynamicObjectCollection invoiceMergeEntryDOs = new DynamicObjectCollection();
                boolean hasInvoiceMergeEntry = dataEntity.getDataEntityType().getProperties().containsKey((Object)"invoicemerge");
                if (hasInvoiceMergeEntry) {
                    invoiceMergeEntryDOs = dataEntity.getDynamicObjectCollection("invoicemerge");
                }
                String serialNo = (String)this.getModel().getValue("serialno", rowIndex);
                ArrayList serialNos = Lists.newArrayList((Object[])new String[]{serialNo});
                Set serialNosFromInvoiceMergeEntry = invoiceMergeEntryDOs.stream().filter(invoiceMerge -> StringUtils.equals((CharSequence)invoiceMerge.getString("keyserialno"), (CharSequence)serialNo)).map(invoiceMerge -> invoiceMerge.getString("serialno_merge")).collect(Collectors.toSet());
                serialNos.addAll(serialNosFromInvoiceMergeEntry);
                this.showInvoiceList(serialNos);
            }
        }
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        serialNos.removeIf(serialNo -> StringUtils.isBlank((CharSequence)serialNo));
        String taxRegNum = this.getTaxRegNum();
        if (StringUtils.isBlank((CharSequence)taxRegNum)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u3002", (String)"ImportInvoiceForPoolPCInOneExpenseItem_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        ShowInvoiceCloudPageUtil.viewInvoiceLst_pc((AbstractFormPlugin)this, this.getModel(), serialNos, ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)"costcompany")) {
            ChangeData changeData = e.getChangeSet()[0];
            Object newCostCompanyDO = changeData.getNewValue();
            if (newCostCompanyDO != null) {
                this.updateImportInvoiceAfterEnableOrDisable();
                InvoiceUtils.refresh((IDataModel)this.getModel(), (Long)((Long)((DynamicObject)newCostCompanyDO).getPkValue()));
            }
        } else if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)"currency")) {
            this.updateInvoiceLabel();
        }
    }

    private void updateImportInvoiceAfterEnableOrDisable() {
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        if (config != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"selectinvoiceallinone", "invoice_entry_container"});
            this.updateInvoiceValidateInfo(ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"selectinvoiceallinone", "invoice_entry_container"});
            int invoiceCount = this.getModel().getEntryRowCount("invoiceentry");
            if (invoiceCount > 0) {
                this.getModel().deleteEntryRows("invoiceentry", IntStream.range(0, invoiceCount).toArray());
            }
        }
    }

    protected void updateInvoiceValidateInfo(Long companyId) {
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud()) {
            return;
        }
        String result = ErStdConfig.get((String)"invoicecloud.configpattern");
        InvoiceCloudCfgBO cfgbo = KingdeeInvoiceCloudConfig.getConfig((Long)companyId);
        if (cfgbo == null) {
            return;
        }
        String companyName = KingdeeInvoiceCloudConfig.getCompanyNameBy((Long)companyId);
        String taxRegNum = KingdeeInvoiceCloudConfig.getTaxRegNum((long)companyId);
        List<Object> companyNames = Lists.newArrayList();
        List<Object> taxRegNums = Lists.newArrayList();
        if (companyName != null && companyName.contains("=")) {
            companyNames = Arrays.asList(companyName.split("=")).stream().map(v -> InvoiceUtils.removeSign((String)v)).collect(Collectors.toList());
            taxRegNums = Arrays.asList(taxRegNum.split("="));
        }
        IDataModel model = this.getModel();
        int invoiceCount = model.getEntryRowCount("invoiceentry");
        Set vatInvoice = InvoiceTypeUtils.loadVatInvoiceTypes();
        for (int rowIndex = 0; rowIndex < invoiceCount; ++rowIndex) {
            String invoiceType = (String)model.getValue("invoicetype", rowIndex);
            if (!vatInvoice.contains(invoiceType)) continue;
            if (StringUtils.isNotEmpty((CharSequence)result) && StringUtils.equals((CharSequence)result.trim(), (CharSequence)"2") && companyNames.size() > 1) {
                this.groupValidate(model, rowIndex, companyNames, taxRegNums);
                continue;
            }
            this.orgValidate(model, rowIndex, companyName, taxRegNum);
        }
    }

    private void groupValidate(IDataModel model, int rowIndex, List<String> companyNames, List<String> taxRegNums) {
        String buyerCompanyName = (String)model.getValue("buyerorgname", rowIndex);
        String buyerTaxNo = (String)model.getValue("buyertaxno", rowIndex);
        String personalInvoice = (String)model.getValue("personalinvoice", rowIndex);
        String passVerifyBuyerName = " ";
        String passVerifyBuyerTaxNo = " ";
        StringBuilder validateMsg = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)buyerCompanyName)) {
            buyerCompanyName = InvoiceUtils.removeSign((String)buyerCompanyName);
            for (int i = 0; i < companyNames.size(); ++i) {
                String companyName = companyNames.get(i);
                if (!StringUtils.equals((CharSequence)companyName, (CharSequence)buyerCompanyName)) continue;
                passVerifyBuyerName = "1";
                if (!StringUtils.equals((CharSequence)taxRegNums.get(i), (CharSequence)buyerTaxNo)) continue;
                passVerifyBuyerTaxNo = "1";
                break;
            }
            if (!StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
                if (!StringUtils.equals((CharSequence)passVerifyBuyerName, (CharSequence)"1")) {
                    passVerifyBuyerName = "0";
                    passVerifyBuyerTaxNo = "0";
                    validateMsg.append(ResManager.loadKDString((String)"\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u62ac\u5934\u4e0d\u4e00\u81f4\uff1b\u53d1\u7968\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"ImportInvoiceForPoolPCInOneExpenseItem_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
                if (StringUtils.equals((CharSequence)passVerifyBuyerName, (CharSequence)"1") && !StringUtils.equals((CharSequence)passVerifyBuyerTaxNo, (CharSequence)"1")) {
                    passVerifyBuyerTaxNo = "0";
                    validateMsg.append(ResManager.loadKDString((String)"\u53d1\u7968\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"ImportInvoiceForPoolPCInOneExpenseItem_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                }
            } else {
                passVerifyBuyerName = " ";
                passVerifyBuyerTaxNo = " ";
            }
        }
        model.setValue("validatemessage", (Object)validateMsg, rowIndex);
        model.setValue("passverifybuyername", (Object)passVerifyBuyerName, rowIndex);
        model.setValue("passverifybuyertaxno", (Object)passVerifyBuyerTaxNo, rowIndex);
    }

    private void orgValidate(IDataModel model, int rowIndex, String companyName, String taxRegNum) {
        String buyerCompanyName = (String)model.getValue("buyerorgname", rowIndex);
        String buyerTaxNo = (String)model.getValue("buyertaxno", rowIndex);
        String personalInvoice = (String)model.getValue("personalinvoice", rowIndex);
        String passVerifyBuyerName = " ";
        String passVerifyBuyerTaxNo = " ";
        StringBuilder validateMsg = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)buyerCompanyName)) {
            buyerCompanyName = InvoiceUtils.removeSign((String)buyerCompanyName);
            if (StringUtils.isNotBlank((CharSequence)(companyName = InvoiceUtils.removeSign((String)companyName))) && companyName.contains(buyerCompanyName)) {
                passVerifyBuyerName = "1";
            } else if (!StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
                passVerifyBuyerName = "0";
                validateMsg.append(ResManager.loadKDString((String)"\u53d1\u7968\u62ac\u5934\u4e0e\u4f01\u4e1a\u62ac\u5934\u4e0d\u4e00\u81f4\u3002", (String)"ImportInvoiceForPoolPCInOneExpenseItem_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)taxRegNum) && taxRegNum.contains(buyerTaxNo)) {
            passVerifyBuyerTaxNo = "1";
        } else if (!StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
            passVerifyBuyerTaxNo = "0";
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{validateMsg})) {
                validateMsg.append('\uff0c');
            }
            validateMsg.append(ResManager.loadKDString((String)"\u53d1\u7968\u7a0e\u53f7\u4e0e\u4f01\u4e1a\u7a0e\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"ImportInvoiceForPoolPCInOneExpenseItem_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        if (StringUtils.equals((CharSequence)personalInvoice, (CharSequence)"1")) {
            passVerifyBuyerName = " ";
            passVerifyBuyerTaxNo = " ";
        }
        model.setValue("validatemessage", (Object)validateMsg, rowIndex);
        model.setValue("passverifybuyername", (Object)passVerifyBuyerName, rowIndex);
        model.setValue("passverifybuyertaxno", (Object)passVerifyBuyerTaxNo, rowIndex);
    }

    @Override
    protected boolean isUseExpenseDate() {
        return true;
    }
}

