/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.mob;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteEntryEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.cache.model.InvoiceCloudCfgBO;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.TripRemoveSameItemServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.createEntryService.CreateTripItemEntryServiceImpl;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.log.InvoiceLogUtils;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.model.invoice.xh.SimpleXhInvoiceVO;
import kd.fi.er.formplugin.invoicecloud.usecase.ShowInvoiceCloudPageUtil;
import kd.fi.er.formplugin.invoicecloud.v2.AbstractImportInvoiceForReimMobPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.service.model.InvoiceEvent;
import kd.fi.er.formplugin.invoicecloud.v2.service.utils.InvoicePluginUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForTripReimGridMobPlugin
extends AbstractImportInvoiceForReimMobPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceForTripReimGridMobPlugin.class);
    private static final String TRIP_ITEM_ENTRY = "entryentity";
    private static final String TRIP_ENTRY = "tripentry";
    private static final String LAB_ENTRY_DELETE = "lab_entry_delete";
    private static final String LAB_ENTRY_DONE = "lab_entry_done";

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.TripItem;
    }

    @Override
    protected void loadAfterProcessUpdateData(InvoiceContext context) {
        super.loadAfterProcessUpdateData(context);
        AmountChangeUtil.recalcReimburseAmountField((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false);
        AmountChangeUtil.refreshPayAmount((IFormView)this.getView(), (IDataModel)this.getModel(), (String)((String)this.getModel().getValue("loanchecktype")));
    }

    @Override
    protected void loadAfterProcessUpdateView() {
        super.loadAfterProcessUpdateView();
        InvoiceUtils.updateInvoiceLabel((IFormView)this.getView());
        this.entryPageRule();
    }

    protected void entryPageRule() {
        int index = this.getModel().getEntryRowCount(TRIP_ITEM_ENTRY);
        if (index == 0) {
            this.getModel().setValue("editentry", (Object)"0");
            this.getView().setVisible(Boolean.FALSE, new String[]{LAB_ENTRY_DELETE, LAB_ENTRY_DONE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{LAB_ENTRY_DELETE, LAB_ENTRY_DONE});
        }
    }

    @Override
    public IInvoiceService getCreateExpenseOrTripItemService(InvoiceContext invoiceContext) {
        CreateTripItemEntryServiceImpl createTripItemEntryServiceImpl = new CreateTripItemEntryServiceImpl(invoiceContext, this.getModel(), this.isOrgOffset());
        return createTripItemEntryServiceImpl;
    }

    @Override
    public IInvoiceService getBeforeCreateItemServiceImpl(InvoiceContext invoiceContext) {
        return new TripRemoveSameItemServiceImpl(invoiceContext, this.getModel());
    }

    @Override
    public boolean isPc() {
        return false;
    }

    @Override
    public String getCustomeEventName() {
        return "alreadyBackFromInvoiceCloud";
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            InvoiceUtils.updateInvoiceLabel((IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)this.getItemEntryEntityKey())) {
            int rowIndex;
            int size = this.getModel().getEntryRowCount(this.getItemEntryEntityKey());
            for (int i = rowIndex = e.getRowIndexs()[0]; i < size; ++i) {
                this.getView().updateView(this.getItemEntryEntityKey(), i);
            }
        }
    }

    public void afterDeleteEntry(AfterDeleteEntryEventArgs e) {
        super.afterDeleteEntry(e);
        String name = e.getEntryProp().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"invoiceentry")) {
            InvoiceUtils.updateInvoiceLabel((IFormView)this.getView());
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        InvoiceUtils.updateInvoiceLabel((IFormView)this.getView());
        ShowInvoiceCloudPageUtil.registCheckback((AbstractFormPlugin)this);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"image_invoice", "lbl_invoicecount", "btn_add_invoice"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Control) {
            Control ctl = (Control)source;
            String key = ctl.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"image_invoice")) {
                IDataModel model = this.getModel();
                DynamicObject dataEntity = model.getDataEntity(true);
                DynamicObjectCollection tripEntryEntities = dataEntity.getDynamicObjectCollection(TRIP_ENTRY);
                int tripIndex = this.getModel().getEntryCurrentRowIndex(TRIP_ENTRY);
                int rowIndex = this.getModel().getEntryCurrentRowIndex(TRIP_ITEM_ENTRY);
                DynamicObject expenseEntryDO = (DynamicObject)((DynamicObject)tripEntryEntities.get(tripIndex)).getDynamicObjectCollection(TRIP_ITEM_ENTRY).get(rowIndex);
                Long itemEntryID = (Long)expenseEntryDO.getPkValue();
                ArrayList<String> serialNos = new ArrayList<String>();
                serialNos.addAll(this.getSerialNosByItemEntryId(itemEntryID));
                String rawInvoiceNo = expenseEntryDO.getString("invoiceno_entry");
                String rawInvoiceCode = expenseEntryDO.getString("invoicelink");
                if (StringUtils.isNotEmpty((CharSequence)rawInvoiceNo) && StringUtils.isNotEmpty((CharSequence)rawInvoiceCode)) {
                    Set<String> invoiceNos = Arrays.stream(rawInvoiceNo.split(",")).collect(Collectors.toSet());
                    Set<String> invoiceCodes = Arrays.stream(rawInvoiceCode.split(",")).collect(Collectors.toSet());
                    invoiceNos.add(rawInvoiceNo);
                    invoiceCodes.add(rawInvoiceCode);
                    List<String> serialNosFromInvoiceMergeEntry = this.getSerialNosByInvoiceNoAndCode(invoiceNos, invoiceCodes);
                    serialNos.addAll(serialNosFromInvoiceMergeEntry);
                }
                Set invoiceEntryIds = dataEntity.getDynamicObjectCollection("invoiceandexpense").stream().filter(entry -> Objects.equals(entry.getLong("expenseentryid"), itemEntryID)).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
                List mapSerialNos = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("serialno")).collect(Collectors.toList());
                serialNos.addAll(mapSerialNos);
                this.showInvoiceList(serialNos);
            } else if (StringUtils.equals((CharSequence)key, (CharSequence)"lbl_invoicecount")) {
                List<String> serialNos = this.getAllSerialNos();
                ShowInvoiceCloudPageUtil.showAllInvoiceList((AbstractFormPlugin)this, KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO())), serialNos);
            } else if ("btn_add_invoice".equalsIgnoreCase(key)) {
                this.importInvoiceMob(key);
            }
        }
    }

    @Override
    protected String getItemEntryEntityKey() {
        return TRIP_ITEM_ENTRY;
    }

    @Override
    public void showInvoiceList(List<String> serialNos) {
        if (serialNos == null || serialNos.isEmpty()) {
            log.info("\u53d1\u7968\u5e8f\u5217\u53f7\u4e3a\u7a7a, \u4e0d\u9700\u8981\u67e5\u770b\u53d1\u7968");
            return;
        }
        InvoiceCloudCfgBO config = KingdeeInvoiceCloudConfig.getConfig((Long)ErCommonUtils.getPk((Object)this.getCostCompanyDO()));
        ShowInvoiceCloudPageUtil.showAllInvoiceListInMiniProgram((AbstractFormPlugin)this, config, serialNos);
    }

    @Override
    protected void processWhenInvoiceIsEnable() {
        if (KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud() && !KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloudInMob()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_importinvoice"});
        }
    }

    @Override
    protected void processWhenInvoiceIsDisable() {
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (Objects.equals(actionId, "IMPORT_INVOICE_IN_MOB")) {
            Object returnData = event.getReturnData();
            if (returnData instanceof JSONObject) {
                JSONObject importInvoiceReturnData = (JSONObject)returnData;
                log.info("\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:" + importInvoiceReturnData.toJSONString());
                InvoiceLogUtils.insertLog((InvoiceLogUtils.InvoiceOpType)InvoiceLogUtils.InvoiceOpType.WEB_REQUEST, (String)"", (String)ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de", (String)"ImportInvoice_2", (String)"fi-er-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u3010\u53d1\u7968\u4e91\u3011\u53d1\u7968\u4e91\u79fb\u52a8\u7aef\u8fd4\u56de\u8fc7\u6765\u7684\u6570\u636e\u4e3a:%s", (String)"ImportInvoice_3", (String)"fi-er-formplugin", (Object[])new Object[0]), importInvoiceReturnData.toJSONString()));
                SimpleXhInvoiceVO simpleXhInvoiceVO = (SimpleXhInvoiceVO)JSONObject.parseObject((String)importInvoiceReturnData.toJSONString(), SimpleXhInvoiceVO.class);
                if (simpleXhInvoiceVO.getInvoiceData() != null && !simpleXhInvoiceVO.getInvoiceData().isEmpty() && !this.handleXhInvoice(this, simpleXhInvoiceVO, this.getModel())) {
                    this.invoiceDeletePageRule(this.isDeleting());
                    return;
                }
                InvoicePluginUtils.saveAttachment(this, this.getView(), simpleXhInvoiceVO.getAttachData());
            } else if (ErStdConfig.getBoolean((String)"intranet") && ErStdConfig.getShowImportInvoiceDataSimulatorMOB()) {
                InvoicePluginUtils.mobTest(this, returnData);
            }
            this.invoiceDeletePageRule(this.isDeleting());
        }
        InvoicePluginUtils.handleDeleteAttachment(this, new InvoiceEvent<ClosedCallBackEvent>(event));
    }

    @Override
    protected String getClickKey() {
        return "btn_add_invoice";
    }
}

