/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.pubreim;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.er.business.invoicecloud.v2.InvoiceContext;
import kd.fi.er.business.invoicecloud.v2.InvoiceFrom;
import kd.fi.er.business.invoicecloud.v2.service.IInvoiceService;
import kd.fi.er.business.invoicecloud.v2.service.impl.component.ImportInvoiceForPubWithoutItemService;
import kd.fi.er.business.invoicecloud.v2.service.impl.mappingItemService.MappingItemWithOrgInvoiceServiceImp;
import kd.fi.er.business.pool.reim.util.ReimBotpUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ImageUtils;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.exception.invoice.InvoiceCloudException;
import kd.fi.er.common.model.invoice.InvoiceVO;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.invoicecloud.v2.ImportInvoiceForDailyReimPCPlugin;
import kd.fi.er.formplugin.invoicecloud.v2.util.RelateExpenseOrTripItemAndInvoiceUtil;
import org.apache.commons.lang3.StringUtils;

public class ImportInvoiceForPubReimPCPlugin
extends ImportInvoiceForDailyReimPCPlugin {
    private static final Log log = LogFactory.getLog(ImportInvoiceForPubReimPCPlugin.class);
    private static final String CALLBACK_SAVE = "CALLBACK_SAVE";

    @Override
    public MappingItemWithOrgInvoiceServiceImp.BillType getBillType() {
        return MappingItemWithOrgInvoiceServiceImp.BillType.ExpenseItem;
    }

    @Override
    public void afterBindData(EventObject e) {
        try {
            super.afterBindData(e);
            IFormView view = this.getView();
            DynamicObject dataEntity = view.getModel().getDataEntity();
            String sourceFormId = CommonServiceHelper.getParentViewFormId((IFormView)view);
            boolean fromPurReceipt = StringUtils.equals((CharSequence)"pur_invoice", (CharSequence)sourceFormId);
            if (fromPurReceipt) {
                boolean isPush = ReimBotpUtils.isPush((Long)((Long)dataEntity.getPkValue()), (String)"T_ER_PUBREIMBILL_TC");
                String billStatus = (String)this.getModel().getValue("billstatus");
                if (isPush && ErBillStatusEnum.A.toString().equals(billStatus)) {
                    this.handleBillFromPurReceipt();
                    this.getView().addClientCallBack(CALLBACK_SAVE);
                }
            }
        }
        catch (Exception invoiceCloudException) {
            this.getView().showErrorNotification(invoiceCloudException.getMessage());
            log.error((Throwable)invoiceCloudException);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "fetchdatabtn": {
                try {
                    this.handleBillFromPurReceipt();
                    break;
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    private void handleBillFromPurReceipt() throws InvoiceCloudException {
        List<InvoiceVO> invoiceVOS = this.fetchInvoiceData();
        if (CollectionUtils.isEmpty(invoiceVOS)) {
            log.info("\u53d1\u7968\u7b7e\u6536\u5355\u4e0b\u63a8\u540e\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u53d1\u7968\u6570\u636e");
            return;
        }
        IInvoiceService service = this.getImportInvoiceWithoutItemService(invoiceVOS);
        service.process();
        BillOfInvoice bill = BillOfInvoice.DailyReimburseBill;
        List<Long> expenseEntryIds = this.getEntryIds(bill.getExpenseEntryEntityName());
        List<Long> invoiceEntryIds = this.getEntryIds("invoiceentry");
        RelateExpenseOrTripItemAndInvoiceUtil.mapExpenseEntryAndInvoiceEntryBy((IFormView)this.getView(), (BillOfInvoice)bill, expenseEntryIds, invoiceEntryIds);
        this.updateInvoiceValidateSummary(this.getView());
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e.getName().equals(CALLBACK_SAVE)) {
            this.getView().invokeOperation("save");
        }
    }

    private List<Long> getEntryIds(String entry) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(entry);
        List<Long> entryIds = entries.stream().filter(expenseEntry -> !Objects.equals(expenseEntry.getPkValue(), 0L)).map(e -> (Long)e.getPkValue()).collect(Collectors.toList());
        return entryIds;
    }

    private List<InvoiceVO> fetchInvoiceData() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        Set serialNos = invoiceEntryDOs.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getString("serialno"))).map(e -> e.getString("serialno")).collect(Collectors.toSet());
        log.info(String.format("\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u4e0a\u83b7\u53d6\u5230\u7684\u5e8f\u5217\u53f7\uff1a%s", String.join((CharSequence)",", serialNos)));
        if (CollectionUtils.isEmpty(serialNos)) {
            Set urls = invoiceEntryDOs.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getString("invaddr"))).map(e -> e.getString("invaddr")).collect(Collectors.toSet());
            log.info("\u53d1\u7968\u4fe1\u606f\u5206\u5f55\u4e0a\u6ca1\u6709\u5e8f\u5217\u53f7\uff0c\u628a url \u4f20\u7ed9\u53d1\u7968\u4e91\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\uff1a" + urls);
            boolean xh = KingdeeInvoiceCloudConfig.isEnableXhInvoiceCloud();
            Long costCompanyId = ErCommonUtils.getPk((Object)this.getCompany());
            serialNos = xh ? ImageUtils.fetchXhInvoiceData(urls, (Long)costCompanyId) : ImageUtils.fetchInvoiceData(urls, (Long)costCompanyId, (String)("er_publicreimbursebill_" + dataEntity.getPkValue()), (String)dataEntity.getString("billno"));
        }
        if (CollectionUtils.isEmpty(serialNos)) {
            return Collections.emptyList();
        }
        List invoiceVOs = InvoiceService.getInstanceService().queryInvoicesBySerialNos((AbstractFormPlugin)this, serialNos, this.getCostCompanyDO());
        return invoiceVOs;
    }

    private IInvoiceService getImportInvoiceWithoutItemService(List<InvoiceVO> invoiceVOs) {
        InvoiceContext invoiceContext = new InvoiceContext();
        this.buildInvoiceConfig(invoiceContext);
        invoiceContext.setInvoiceVOs(invoiceVOs);
        invoiceContext.setView(this.getView());
        invoiceContext.setExtView(this.getExtView());
        invoiceContext.setImportInvoiceClass(this.getClass());
        return new ImportInvoiceForPubWithoutItemService(invoiceContext, this.getView(), this.getModel(), this.getInvoiceCurrency());
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    @Override
    public void hyperLinkClick(HyperLinkClickEvent hlcEvent) {
        super.hyperLinkClick(hlcEvent);
        String filedName = hlcEvent.getFieldName();
        int rowIndex = hlcEvent.getRowIndex();
        if ("invoiceno".equals(filedName) || "invaddr".equals(filedName)) {
            String invoiceFrom = this.getModel().getValue("invoicefrom", rowIndex).toString();
            if (InvoiceFrom.PurReceipt.getValue().equals(invoiceFrom)) {
                Object url = this.getModel().getValue("invaddr", rowIndex);
                if (url != null && StringUtils.isNotBlank((CharSequence)url.toString())) {
                    this.getView().openUrl(url.toString());
                } else {
                    String tips = ResManager.loadKDString((String)"\u53d1\u7968\u4e0b\u8f7d\u5730\u5740\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4e0b\u8f7d\u3002", (String)"ImportInvoiceForPubReimPCPlugin_3", (String)"fi-er-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                }
            }
        }
    }
}

